/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadCommandSerializer;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public abstract class ReadCommand {
    public static final String DO_REPAIR = "READ-REPAIR";
    public static final byte CMD_TYPE_GET_SLICE_BY_NAMES = 1;
    public static final byte CMD_TYPE_GET_SLICE = 2;
    private static ReadCommandSerializer serializer = new ReadCommandSerializer();
    public final QueryPath queryPath;
    public final String table;
    public final ByteBuffer key;
    private boolean isDigestQuery = false;
    protected final byte commandType;

    public static ReadCommandSerializer serializer() {
        return serializer;
    }

    public Message makeReadMessage() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ReadCommand.serializer().serialize(this, dos);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.READ, bos.toByteArray());
    }

    protected ReadCommand(String table, ByteBuffer key, QueryPath queryPath, byte cmdType) {
        this.table = table;
        this.key = key;
        this.queryPath = queryPath;
        this.commandType = cmdType;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public void setDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery = isDigestQuery;
    }

    public String getColumnFamilyName() {
        return this.queryPath.columnFamilyName;
    }

    public abstract ReadCommand copy();

    public abstract Row getRow(Table var1) throws IOException;

    protected AbstractType getComparator() {
        return ColumnFamily.getComparatorFor(this.table, this.getColumnFamilyName(), this.queryPath.superColumnName);
    }
}

