/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIterator;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.IteratorUtils;

public class RowIteratorFactory {
    private static final int RANGE_FILE_BUFFER_SIZE = 262144;
    private static final Comparator<IColumnIterator> COMPARE_BY_KEY = new Comparator<IColumnIterator>(){

        @Override
        public int compare(IColumnIterator o1, IColumnIterator o2) {
            return DecoratedKey.comparator.compare(o1.getKey(), o2.getKey());
        }
    };

    public static RowIterator getIterator(Collection<Memtable> memtables, Collection<SSTableReader> sstables, final DecoratedKey startWith, final DecoratedKey stopAt, final QueryFilter filter, final AbstractType comparator, final ColumnFamilyStore cfs) {
        ArrayList<Iterator<IColumnIterator>> iterators = new ArrayList<Iterator<IColumnIterator>>();
        Predicate<IColumnIterator> p = new Predicate<IColumnIterator>(){

            public boolean apply(IColumnIterator row) {
                return startWith.compareTo(row.getKey()) <= 0 && (stopAt.isEmpty() || row.getKey().compareTo(stopAt) <= 0);
            }
        };
        for (Memtable memtable : memtables) {
            iterators.add((Iterator<IColumnIterator>)Iterators.filter((Iterator)Iterators.transform(memtable.getEntryIterator(startWith), (Function)new ConvertToColumnIterator(filter, comparator)), (Predicate)p));
        }
        for (SSTableReader sstable : sstables) {
            SSTableScanner scanner = sstable.getScanner(262144, filter);
            scanner.seekTo(startWith);
            assert (scanner instanceof Closeable);
            iterators.add(scanner);
        }
        Iterator collated = IteratorUtils.collatedIterator(COMPARE_BY_KEY, iterators);
        final Memtable firstMemtable = memtables.iterator().next();
        ReducingIterator<IColumnIterator, Row> reduced = new ReducingIterator<IColumnIterator, Row>(collated){
            private final int gcBefore;
            private final List<IColumnIterator> colIters;
            private DecoratedKey key;
            {
                super(x0);
                this.gcBefore = (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
                this.colIters = new ArrayList<IColumnIterator>();
            }

            @Override
            public void reduce(IColumnIterator current) {
                this.colIters.add(current);
                this.key = current.getKey();
            }

            @Override
            protected boolean isEqual(IColumnIterator o1, IColumnIterator o2) {
                return COMPARE_BY_KEY.compare(o1, o2) == 0;
            }

            @Override
            protected Row getReduced() {
                Comparator<IColumn> colComparator = filter.filter.getColumnComparator(comparator);
                Iterator colCollated = IteratorUtils.collatedIterator(colComparator, this.colIters);
                ColumnFamily returnCF = null;
                ColumnFamily cached = cfs.getRawCachedRow(this.key);
                if (cached != null) {
                    QueryFilter keyFilter = new QueryFilter(this.key, filter.path, filter.filter);
                    returnCF = cfs.filterColumnFamily(cached, keyFilter, this.gcBefore);
                } else {
                    returnCF = firstMemtable.getColumnFamily(this.key);
                    ColumnFamily columnFamily = returnCF = returnCF == null ? ColumnFamily.create(firstMemtable.getTableName(), filter.getColumnFamilyName()) : returnCF.cloneMeShallow();
                    if (colCollated.hasNext()) {
                        filter.collectCollatedColumns(returnCF, colCollated, this.gcBefore);
                    } else {
                        returnCF = null;
                    }
                }
                Row rv = new Row(this.key, returnCF);
                this.colIters.clear();
                this.key = null;
                return rv;
            }
        };
        return new RowIterator(reduced, iterators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<Map.Entry<DecoratedKey, ColumnFamily>> memtableEntryIterator(Memtable memtable, DecoratedKey startWith) {
        Table.flusherLock.readLock().lock();
        try {
            Iterator<Map.Entry<DecoratedKey, ColumnFamily>> iterator = memtable.getEntryIterator(startWith);
            return iterator;
        }
        finally {
            Table.flusherLock.readLock().unlock();
        }
    }

    private static class ConvertToColumnIterator
    implements Function<Map.Entry<DecoratedKey, ColumnFamily>, IColumnIterator> {
        private QueryFilter filter;
        private AbstractType comparator;

        public ConvertToColumnIterator(QueryFilter filter, AbstractType comparator) {
            this.filter = filter;
            this.comparator = comparator;
        }

        public IColumnIterator apply(Map.Entry<DecoratedKey, ColumnFamily> entry) {
            return this.filter.getMemtableColumnIterator(entry.getValue(), entry.getKey(), this.comparator);
        }
    }
}

