/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.db.IColumn;

public abstract class AbstractType
implements Comparator<ByteBuffer> {
    public abstract String getString(ByteBuffer var1);

    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    public void validate(ByteBuffer bytes) {
        this.getString(bytes);
    }

    public Comparator<ByteBuffer> getReverseComparator() {
        return new Comparator<ByteBuffer>(){

            @Override
            public int compare(ByteBuffer o1, ByteBuffer o2) {
                if (o1.remaining() == 0) {
                    return o2.remaining() == 0 ? 0 : -1;
                }
                if (o2.remaining() == 0) {
                    return 1;
                }
                return -AbstractType.this.compare(o1, o2);
            }
        };
    }

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public String getColumnsString(Collection<IColumn> columns) {
        StringBuilder builder = new StringBuilder();
        for (IColumn column : columns) {
            builder.append(column.getString(this)).append(",");
        }
        return builder.toString();
    }
}

