/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.thrift.TBaseHelper;

public final class IntegerType
extends AbstractType {
    public static final IntegerType instance = new IntegerType();

    private static int findMostSignificantByte(ByteBuffer bytes) {
        byte b0;
        int i;
        int len = bytes.remaining() - 1;
        for (i = 0; i < len && ((b0 = bytes.array()[bytes.position() + bytes.arrayOffset() + i]) == 0 || b0 == -1); ++i) {
            byte b1 = bytes.array()[bytes.position() + bytes.arrayOffset() + i + 1];
            if (b0 == 0 && b1 != 0) {
                if (b1 <= 0) break;
                ++i;
                break;
            }
            if (b0 != -1 || b1 == -1) continue;
            if (b1 >= 0) break;
            ++i;
            break;
        }
        return i;
    }

    IntegerType() {
    }

    @Override
    public int compare(ByteBuffer lhs, ByteBuffer rhs) {
        int lhsLen = lhs.remaining();
        int rhsLen = rhs.remaining();
        if (lhsLen == 0) {
            return rhsLen == 0 ? 0 : -1;
        }
        if (rhsLen == 0) {
            return 1;
        }
        int lhsMsbIdx = IntegerType.findMostSignificantByte(lhs);
        int rhsMsbIdx = IntegerType.findMostSignificantByte(rhs);
        int lhsLenDiff = lhsLen - lhsMsbIdx;
        int rhsLenDiff = rhsLen - rhsMsbIdx;
        byte lhsMsb = lhs.array()[lhs.position() + lhs.arrayOffset() + lhsMsbIdx];
        byte rhsMsb = rhs.array()[rhs.position() + rhs.arrayOffset() + rhsMsbIdx];
        if (lhsLenDiff != rhsLenDiff) {
            if (lhsMsb < 0) {
                return rhsMsb < 0 ? rhsLenDiff - lhsLenDiff : -1;
            }
            if (rhsMsb < 0) {
                return 1;
            }
            return lhsLenDiff - rhsLenDiff;
        }
        if (lhsMsb != rhsMsb) {
            return lhsMsb - rhsMsb;
        }
        ++lhsMsbIdx;
        ++rhsMsbIdx;
        while (lhsMsbIdx < lhsLen) {
            lhsMsb = lhs.array()[lhs.position() + lhs.arrayOffset() + lhsMsbIdx++];
            if (lhsMsb == (rhsMsb = rhs.array()[rhs.position() + rhs.arrayOffset() + rhsMsbIdx++])) continue;
            return (lhsMsb & 0xFF) - (rhsMsb & 0xFF);
        }
        return 0;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.remaining() == 0) {
            return "empty";
        }
        return new BigInteger(TBaseHelper.byteBufferToByteArray((ByteBuffer)bytes)).toString(10);
    }

    @Override
    public ByteBuffer fromString(String source) {
        BigInteger integerType;
        try {
            integerType = new BigInteger(source);
        }
        catch (Exception e) {
            throw new RuntimeException("'" + source + "' could not be translated into an IntegerType.");
        }
        return ByteBuffer.wrap(integerType.toByteArray());
    }
}

