/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.FBUtilities;

public class UTF8Type
extends BytesType {
    public static final UTF8Type instance = new UTF8Type();

    UTF8Type() {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return FBUtilities.decodeToUTF8(bytes);
        }
        catch (CharacterCodingException e) {
            throw new MarshalException("invalid UTF8 bytes " + Arrays.toString(bytes.array()));
        }
    }

    @Override
    public ByteBuffer fromString(String source) {
        return ByteBuffer.wrap(source.getBytes(Charsets.UTF_8));
    }
}

