/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.avro.CfDef;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class UpdateColumnFamily
extends Migration {
    private CFMetaData metadata;

    protected UpdateColumnFamily() {
    }

    public UpdateColumnFamily(CfDef cf_def) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(((Object)cf_def.keyspace).toString());
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not already exist.");
        }
        CFMetaData oldCfm = DatabaseDescriptor.getCFMetaData(CFMetaData.getId(((Object)cf_def.keyspace).toString(), ((Object)cf_def.name).toString()));
        oldCfm.apply(cf_def);
        this.metadata = oldCfm;
        this.rm = Migration.makeDefinitionMutation(ksm, null, this.newVersion);
    }

    @Override
    public void beforeApplyModels() {
        if (this.clientMode) {
            return;
        }
        ColumnFamilyStore cfs = Table.open(this.metadata.tableName).getColumnFamilyStore(this.metadata.cfName);
        cfs.snapshot(Table.getTimestampedSnapshotName(null));
    }

    @Override
    void applyModels() throws IOException {
        logger.debug("Updating " + this.metadata + " to " + this.metadata);
        DatabaseDescriptor.setTableDefinition(null, this.newVersion);
        if (!this.clientMode) {
            Table table = Table.open(this.metadata.tableName);
            ColumnFamilyStore oldCfs = table.getColumnFamilyStore(this.metadata.cfName);
            oldCfs.reload();
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = new org.apache.cassandra.db.migration.avro.UpdateColumnFamily();
        update.metadata = this.metadata.deflate();
        mi.migration = update;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = (org.apache.cassandra.db.migration.avro.UpdateColumnFamily)((Object)mi.migration);
        this.metadata = CFMetaData.inflate(update.metadata);
    }
}

