/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.locator.AdaptiveLatencyTracker;
import org.apache.cassandra.locator.DynamicEndpointSnitchMBean;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.ILatencyPublisher;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class DynamicEndpointSnitch
extends AbstractEndpointSnitch
implements ILatencySubscriber,
DynamicEndpointSnitchMBean {
    private static int UPDATES_PER_INTERVAL = 10000;
    private static int UPDATE_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicUpdateInterval();
    private static int RESET_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicResetInterval();
    private static double BADNESS_THRESHOLD = DatabaseDescriptor.getDynamicBadnessThreshold();
    private static int WINDOW_SIZE = 100;
    private boolean registered = false;
    private ConcurrentHashMap<InetAddress, Double> scores = new ConcurrentHashMap();
    private ConcurrentHashMap<InetAddress, AdaptiveLatencyTracker> windows = new ConcurrentHashMap();
    private AtomicInteger intervalupdates = new AtomicInteger(0);
    public IEndpointSnitch subsnitch;

    public DynamicEndpointSnitch(IEndpointSnitch snitch) {
        this.subsnitch = snitch;
        Runnable update = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.updateScores();
            }
        };
        Runnable reset = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.reset();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(update, UPDATE_INTERVAL_IN_MS, UPDATE_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        StorageService.scheduledTasks.scheduleWithFixedDelay(reset, RESET_INTERVAL_IN_MS, RESET_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.db:type=DynamicEndpointSnitch,instance=" + this.hashCode()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRack(InetAddress endpoint) {
        return this.subsnitch.getRack(endpoint);
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        return this.subsnitch.getDatacenter(endpoint);
    }

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(addresses);
        this.sortByProximity(address, list);
        return list;
    }

    @Override
    public void sortByProximity(InetAddress address, List<InetAddress> addresses) {
        assert (address.equals(FBUtilities.getLocalAddress()));
        if (BADNESS_THRESHOLD == 0.0) {
            this.sortByProximityWithScore(address, addresses);
        } else {
            this.sortByProximityWithBadness(address, addresses);
        }
    }

    private void sortByProximityWithScore(final InetAddress address, List<InetAddress> addresses) {
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                return DynamicEndpointSnitch.this.compareEndpoints(address, a1, a2);
            }
        });
    }

    private void sortByProximityWithBadness(InetAddress address, List<InetAddress> addresses) {
        if (addresses.size() < 2) {
            return;
        }
        this.subsnitch.sortByProximity(address, addresses);
        Double first = this.scores.get(addresses.get(0));
        if (first == null) {
            return;
        }
        for (InetAddress addr : addresses) {
            Double next = this.scores.get(addr);
            if (next == null) {
                return;
            }
            if (!((first - next) / first > BADNESS_THRESHOLD)) continue;
            this.sortByProximityWithScore(address, addresses);
            return;
        }
    }

    @Override
    public int compareEndpoints(InetAddress target, InetAddress a1, InetAddress a2) {
        Double scored1 = this.scores.get(a1);
        Double scored2 = this.scores.get(a2);
        if (scored1 == null || scored2 == null || scored1.equals(scored2)) {
            return this.subsnitch.compareEndpoints(target, a1, a2);
        }
        if (scored1 < scored2) {
            return -1;
        }
        return 1;
    }

    @Override
    public void receiveTiming(InetAddress host, Double latency) {
        AdaptiveLatencyTracker alt;
        if (this.intervalupdates.intValue() >= UPDATES_PER_INTERVAL) {
            return;
        }
        AdaptiveLatencyTracker tracker = this.windows.get(host);
        if (tracker == null && (tracker = this.windows.putIfAbsent(host, alt = new AdaptiveLatencyTracker(WINDOW_SIZE))) == null) {
            tracker = alt;
        }
        tracker.add(latency);
        this.intervalupdates.getAndIncrement();
    }

    private void updateScores() {
        ILatencyPublisher handler;
        if (!StorageService.instance.isInitialized()) {
            return;
        }
        if (!this.registered && (handler = (ILatencyPublisher)((Object)MessagingService.instance.getVerbHandler(StorageService.Verb.REQUEST_RESPONSE))) != null) {
            handler.register(this);
            this.registered = true;
        }
        for (Map.Entry<InetAddress, AdaptiveLatencyTracker> entry : this.windows.entrySet()) {
            this.scores.put(entry.getKey(), entry.getValue().score());
        }
        this.intervalupdates.set(0);
    }

    private void reset() {
        for (AdaptiveLatencyTracker tracker : this.windows.values()) {
            tracker.clear();
        }
    }

    @Override
    public Map<InetAddress, Double> getScores() {
        return this.scores;
    }
}

