/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.MessageSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Message {
    private static MessageSerializer serializer_ = new MessageSerializer();
    final Header header_;
    private final byte[] body_;

    public static MessageSerializer serializer() {
        return serializer_;
    }

    Message(Header header, byte[] body) {
        assert (header != null);
        assert (body != null);
        this.header_ = header;
        this.body_ = body;
    }

    public Message(InetAddress from, StorageService.Verb verb, byte[] body) {
        this(new Header(from, verb), body);
    }

    public byte[] getHeader(Object key) {
        return this.header_.getDetail(key);
    }

    public void setHeader(String key, byte[] value) {
        this.header_.setDetail(key, value);
    }

    public byte[] getMessageBody() {
        return this.body_;
    }

    public InetAddress getFrom() {
        return this.header_.getFrom();
    }

    public Stage getMessageType() {
        return StorageService.verbStages.get((Object)this.getVerb());
    }

    public StorageService.Verb getVerb() {
        return this.header_.getVerb();
    }

    public String getMessageId() {
        return this.header_.getMessageId();
    }

    void setMessageId(String id) {
        this.header_.setMessageId(id);
    }

    public Message getReply(InetAddress from, byte[] args) {
        Header header = new Header(this.getMessageId(), from, StorageService.Verb.REQUEST_RESPONSE);
        return new Message(header, args);
    }

    public Message getInternalReply(byte[] body) {
        Header header = new Header(this.getMessageId(), FBUtilities.getLocalAddress(), StorageService.Verb.INTERNAL_RESPONSE);
        return new Message(header, body);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("");
        String separator = System.getProperty("line.separator");
        sbuf.append("ID:" + this.getMessageId()).append(separator).append("FROM:" + this.getFrom()).append(separator).append("TYPE:" + (Object)((Object)this.getMessageType())).append(separator).append("VERB:" + (Object)((Object)this.getVerb())).append(separator);
        return sbuf.toString();
    }
}

