/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.locator.ILatencyPublisher;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseVerbHandler
implements IVerbHandler,
ILatencyPublisher {
    private static final Logger logger_ = LoggerFactory.getLogger(ResponseVerbHandler.class);
    private List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();

    @Override
    public void doVerb(Message message) {
        String messageId = message.getMessageId();
        IAsyncCallback cb = MessagingService.getRegisteredCallback(messageId);
        double age = 0.0;
        if (cb != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("Processing response on a callback from " + message.getMessageId() + "@" + message.getFrom());
            }
            age = System.currentTimeMillis() - MessagingService.getRegisteredCallbackAge(messageId);
            cb.response(message);
        } else {
            IAsyncResult ar = MessagingService.getAsyncResult(messageId);
            if (ar != null) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug("Processing response on an async result from " + message.getMessageId() + "@" + message.getFrom());
                }
                age = System.currentTimeMillis() - MessagingService.getAsyncResultAge(messageId);
                ar.result(message);
            }
        }
        this.notifySubscribers(message.getFrom(), age);
    }

    private void notifySubscribers(InetAddress host, double latency) {
        for (ILatencySubscriber subscriber : this.subscribers) {
            subscriber.receiveTiming(host, latency);
        }
    }

    @Override
    public void register(ILatencySubscriber subscriber) {
        this.subscribers.add(subscriber);
    }
}

