/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexScanCommand;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.QuorumResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    private static final Random random = new Random();
    private static final LatencyTracker readStats = new LatencyTracker();
    private static final LatencyTracker rangeStats = new LatencyTracker();
    private static final LatencyTracker writeStats = new LatencyTracker();
    private static boolean hintedHandoffEnabled = DatabaseDescriptor.hintedHandoffEnabled();
    private static final String UNREACHABLE = "UNREACHABLE";

    private StorageProxy() {
    }

    public static void mutate(List<RowMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, TimeoutException {
        long startTime = System.nanoTime();
        ArrayList<IWriteResponseHandler> responseHandlers = new ArrayList<IWriteResponseHandler>();
        RowMutation mostRecentRowMutation = null;
        StorageService ss = StorageService.instance;
        try {
            Iterator<RowMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                RowMutation rm;
                mostRecentRowMutation = rm = i$.next();
                String table = rm.getTable();
                AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
                List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, rm.key());
                Collection<InetAddress> writeEndpoints = ss.getTokenMetadata().getWriteEndpoints((Token)StorageService.getPartitioner().getToken(rm.key()), table, (Collection<InetAddress>)naturalEndpoints);
                Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(writeEndpoints);
                IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, hintedEndpoints, consistency_level);
                responseHandler.assureSufficientLiveNodes();
                responseHandlers.add(responseHandler);
                Message unhintedMessage = null;
                for (Map.Entry entry : hintedEndpoints.asMap().entrySet()) {
                    InetAddress destination = (InetAddress)entry.getKey();
                    Collection targets = (Collection)entry.getValue();
                    if (targets.size() == 1 && ((InetAddress)targets.iterator().next()).equals(destination)) {
                        if (destination.equals(FBUtilities.getLocalAddress())) {
                            StorageProxy.insertLocalMessage(rm, responseHandler);
                            continue;
                        }
                        if (unhintedMessage == null) {
                            unhintedMessage = rm.makeRowMutationMessage();
                            MessagingService.instance.addCallback(responseHandler, unhintedMessage.getMessageId());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("insert writing key " + FBUtilities.bytesToHex(rm.key()) + " to " + unhintedMessage.getMessageId() + "@" + destination);
                        }
                        MessagingService.instance.sendOneWay(unhintedMessage, destination);
                        continue;
                    }
                    Message hintedMessage = rm.makeRowMutationMessage();
                    for (InetAddress target : targets) {
                        if (target.equals(destination)) continue;
                        StorageProxy.addHintHeader(hintedMessage, target);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("insert writing key " + FBUtilities.bytesToHex(rm.key()) + " to " + hintedMessage.getMessageId() + "@" + destination + " for " + target);
                    }
                    responseHandler.addHintCallback(hintedMessage, destination);
                    MessagingService.instance.sendOneWay(hintedMessage, destination);
                }
            }
            for (IWriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (IOException e) {
            if (mostRecentRowMutation == null) {
                throw new RuntimeException("no mutations were seen but found an error during write anyway", e);
            }
            throw new RuntimeException("error writing key " + FBUtilities.bytesToHex(mostRecentRowMutation.key()), e);
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    private static void addHintHeader(Message message, InetAddress target) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] previousHints = message.getHeader("HINT");
        if (previousHints != null) {
            dos.write(previousHints);
        }
        FBUtilities.writeShortByteArray(ByteBuffer.wrap(target.getHostAddress().getBytes(Charsets.UTF_8)), dos);
        message.setHeader("HINT", bos.toByteArray());
    }

    private static void insertLocalMessage(final RowMutation rm, final IWriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug("insert writing local " + rm.toString(true));
        }
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws IOException {
                rm.deepCopy().apply();
                responseHandler.response(null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    public static List<Row> readProtocol(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException, InvalidRequestException {
        List<Row> rows;
        if (StorageService.instance.isBootstrapMode()) {
            throw new InvalidRequestException("This node cannot accept reads until it has bootstrapped");
        }
        long startTime = System.nanoTime();
        if (consistency_level == ConsistencyLevel.ONE) {
            rows = StorageProxy.weakRead(commands);
        } else {
            assert (consistency_level.getValue() >= ConsistencyLevel.QUORUM.getValue());
            rows = StorageProxy.strongRead(commands, consistency_level);
        }
        readStats.addNano(System.nanoTime() - startTime);
        return rows;
    }

    private static List<Row> weakRead(List<ReadCommand> commands) throws IOException, UnavailableException, TimeoutException {
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<Future<Object>> localFutures = null;
        ArrayList<IAsyncResult> remoteResults = null;
        for (ReadCommand readCommand : commands) {
            InetAddress endPoint = StorageService.instance.findSuitableEndpoint(readCommand.table, readCommand.key);
            if (endPoint.equals(FBUtilities.getLocalAddress())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("weakread reading " + readCommand + " locally");
                }
                if (localFutures == null) {
                    localFutures = new ArrayList<Future<Object>>();
                }
                weakReadLocalCallable callable = new weakReadLocalCallable(readCommand);
                localFutures.add(StageManager.getStage(Stage.READ).submit(callable));
                continue;
            }
            if (remoteResults == null) {
                remoteResults = new ArrayList<IAsyncResult>();
            }
            Message message = readCommand.makeReadMessage();
            if (logger.isDebugEnabled()) {
                logger.debug("weakread reading " + readCommand + " from " + message.getMessageId() + "@" + endPoint);
            }
            if (StorageProxy.randomlyReadRepair(readCommand)) {
                message.setHeader("READ-REPAIR", "READ-REPAIR".getBytes());
            }
            remoteResults.add(MessagingService.instance.sendRR(message, endPoint));
        }
        if (localFutures != null) {
            for (Future future : localFutures) {
                Row row;
                try {
                    row = (Row)future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                rows.add(row);
            }
        }
        if (remoteResults != null) {
            for (IAsyncResult iAsyncResult : remoteResults) {
                byte[] body = iAsyncResult.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
                ReadResponse response = ReadResponse.serializer().deserialize(new DataInputStream(bufIn));
                if (response.row() == null) continue;
                rows.add(response.row());
            }
        }
        return rows;
    }

    private static List<Row> strongRead(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        Row row;
        ArrayList<QuorumResponseHandler> quorumResponseHandlers = new ArrayList<QuorumResponseHandler>();
        ArrayList<List<InetAddress>> commandEndpoints = new ArrayList<List<InetAddress>>();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (ReadCommand command : commands) {
            assert (!command.isDigestQuery());
            ReadCommand readMessageDigestOnly = command.copy();
            readMessageDigestOnly.setDigestQuery(true);
            Message message = command.makeReadMessage();
            Message messageDigestOnly = readMessageDigestOnly.makeReadMessage();
            InetAddress dataPoint = StorageService.instance.findSuitableEndpoint(command.table, command.key);
            List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(command.table, command.key);
            AbstractReplicationStrategy rs = Table.open(command.table).getReplicationStrategy();
            QuorumResponseHandler handler = rs.getQuorumResponseHandler(new ReadResponseResolver(command.table), consistency_level);
            handler.assureSufficientLiveNodes(endpoints);
            Message[] messages = new Message[endpoints.size()];
            int n = 0;
            for (InetAddress endpoint : endpoints) {
                Message m = endpoint.equals(dataPoint) ? message : messageDigestOnly;
                messages[n++] = m;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("strongread reading " + (m == message ? "data" : "digest") + " for " + command + " from " + m.getMessageId() + "@" + endpoint);
            }
            MessagingService.instance.sendRR(messages, endpoints, (IAsyncCallback)handler);
            quorumResponseHandlers.add(handler);
            commandEndpoints.add(endpoints);
        }
        ArrayList<QuorumResponseHandler> repairResponseHandlers = null;
        for (int i = 0; i < commands.size(); ++i) {
            QuorumResponseHandler quorumResponseHandler = (QuorumResponseHandler)quorumResponseHandlers.get(i);
            ReadCommand command = commands.get(i);
            try {
                long startTime2 = System.currentTimeMillis();
                row = (Row)quorumResponseHandler.get();
                if (row != null) {
                    rows.add(row);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("quorumResponseHandler: " + (System.currentTimeMillis() - startTime2) + " ms.");
                continue;
            }
            catch (DigestMismatchException ex) {
                AbstractReplicationStrategy rs = Table.open(command.table).getReplicationStrategy();
                QuorumResponseHandler handler = rs.getQuorumResponseHandler(new ReadResponseResolver(command.table), consistency_level);
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)ex);
                }
                Message messageRepair = command.makeReadMessage();
                MessagingService.instance.sendRR(messageRepair, (Collection)commandEndpoints.get(i), (IAsyncCallback)handler);
                if (repairResponseHandlers == null) {
                    repairResponseHandlers = new ArrayList<QuorumResponseHandler>();
                }
                repairResponseHandlers.add(handler);
            }
        }
        if (repairResponseHandlers != null) {
            for (QuorumResponseHandler handler : repairResponseHandlers) {
                try {
                    row = (Row)handler.get();
                    if (row == null) continue;
                    rows.add(row);
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return rows;
    }

    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        if (logger.isDebugEnabled()) {
            logger.debug(command.toString());
        }
        long startTime = System.nanoTime();
        List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(command.range);
        ArrayList<Row> rows = new ArrayList<Row>(command.max_keys);
        for (AbstractBounds range : ranges) {
            List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(command.keyspace, range.right);
            if (consistency_level == ConsistencyLevel.ONE && liveEndpoints.contains(FBUtilities.getLocalAddress())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("local range slice");
                }
                ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
                try {
                    rows.addAll(cfs.getRangeSlice(command.super_column, range, command.max_keys, QueryFilter.getFilter(command.predicate, cfs.getComparator())));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
            RangeSliceCommand c2 = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.max_keys);
            Message message = c2.getMessage();
            RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(command.keyspace, liveEndpoints);
            AbstractReplicationStrategy rs = Table.open(command.keyspace).getReplicationStrategy();
            QuorumResponseHandler handler = rs.getQuorumResponseHandler(resolver, consistency_level);
            for (InetAddress endpoint : liveEndpoints) {
                MessagingService.instance.sendRR(message, endpoint, (IAsyncCallback)handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("reading " + c2 + " from " + message.getMessageId() + "@" + endpoint);
            }
            try {
                if (logger.isDebugEnabled()) {
                    for (Row row : (List)handler.get()) {
                        logger.debug("range slices read " + row.key);
                    }
                }
                rows.addAll((Collection)handler.get());
            }
            catch (DigestMismatchException e) {
                throw new AssertionError((Object)e);
            }
            if (rows.size() < command.max_keys) continue;
            break;
        }
        rangeStats.addNano(System.nanoTime() - startTime);
        return rows.size() > command.max_keys ? rows.subList(0, command.max_keys) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = DatabaseDescriptor.getDefsVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        Message msg = new Message(FBUtilities.getLocalAddress(), StorageService.Verb.SCHEMA_CHECK, ArrayUtils.EMPTY_BYTE_ARRAY);
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        MessagingService.instance.sendRR(msg, liveHosts, new IAsyncCallback(){

            @Override
            public void response(Message msg) {
                logger.debug("Received schema check response from " + msg.getFrom().getHostAddress());
                UUID theirVersion = UUID.fromString(new String(msg.getMessageBody()));
                versions.put(msg.getFrom(), theirVersion);
                latch.countDown();
            }
        });
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        logger.debug("My version is " + myVersion);
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        HashSet<InetAddress> allHosts = new HashSet<InetAddress>();
        allHosts.addAll(Gossiper.instance.getLiveMembers());
        allHosts.addAll(Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: " + StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("%s disagrees (%s)", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static List<AbstractBounds> getRestrictedRanges(AbstractBounds queryRange) {
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.equals(StorageService.getPartitioner().getMinimumToken())) {
            if (logger.isDebugEnabled()) {
                logger.debug("restricted single token match for query " + queryRange);
            }
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds> ranges = new ArrayList<AbstractBounds>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left, true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext()) {
            Token token = ringIter.next();
            if (remainder == null || !remainder.left.equals(token) && !remainder.contains(token)) break;
            Pair<AbstractBounds, AbstractBounds> splits = remainder.split(token);
            if (splits.left != null) {
                ranges.add((AbstractBounds)splits.left);
            }
            remainder = (AbstractBounds)splits.right;
        }
        if (remainder != null) {
            ranges.add(remainder);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("restricted ranges for query " + queryRange + " are " + ranges);
        }
        return ranges;
    }

    private static boolean randomlyReadRepair(ReadCommand command) {
        CFMetaData cfmd = DatabaseDescriptor.getTableMetaData(command.table).get(command.getColumnFamilyName());
        return cfmd.getReadRepairChance() > random.nextDouble();
    }

    @Override
    public long getReadOperations() {
        return readStats.getOpCount();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return readStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readStats.getRecentLatencyMicros();
    }

    @Override
    public long getRangeOperations() {
        return rangeStats.getOpCount();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return rangeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeStats.getRecentLatencyMicros();
    }

    @Override
    public long getWriteOperations() {
        return writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeStats.getRecentLatencyMicros();
    }

    public static List<Row> scan(String keyspace, String column_family, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws IOException, TimeoutException, UnavailableException {
        IPartitioner p = StorageService.getPartitioner();
        Object leftToken = index_clause.start_key == null ? p.getMinimumToken() : p.getToken(index_clause.start_key);
        List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(new Bounds((Token)leftToken, (Token)p.getMinimumToken()));
        logger.debug("scan ranges are " + StringUtils.join(ranges, (String)","));
        ArrayList<Row> rows = new ArrayList<Row>(index_clause.count);
        for (AbstractBounds range : ranges) {
            List theseRows;
            List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, range.right);
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
            RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(keyspace, liveEndpoints);
            AbstractReplicationStrategy rs = Table.open(keyspace).getReplicationStrategy();
            QuorumResponseHandler handler = rs.getQuorumResponseHandler(resolver, consistency_level);
            if (handler.blockfor > liveEndpoints.size()) {
                throw new UnavailableException();
            }
            IndexScanCommand command = new IndexScanCommand(keyspace, column_family, index_clause, column_predicate, range);
            Message message = command.getMessage();
            for (InetAddress endpoint : liveEndpoints) {
                MessagingService.instance.sendRR(message, endpoint, (IAsyncCallback)handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("reading " + command + " from " + message.getMessageId() + "@" + endpoint);
            }
            try {
                theseRows = (List)handler.get();
            }
            catch (DigestMismatchException e) {
                throw new RuntimeException(e);
            }
            rows.addAll(theseRows);
            if (logger.isDebugEnabled()) {
                for (Row row : theseRows) {
                    logger.debug("read " + row);
                }
            }
            if (rows.size() < index_clause.count) continue;
            return rows.subList(0, index_clause.count);
        }
        return rows;
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        hintedHandoffEnabled = b;
    }

    public static boolean isHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF ", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            throw new UnavailableException();
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        logger.debug("Starting to send truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        Message message = truncation.makeTruncationMessage();
        MessagingService.instance.sendRR(message, allEndpoints, (IAsyncCallback)responseHandler);
        logger.debug("Sent all truncate messages, now waiting for {} responses", (Object)blockFor);
        responseHandler.get();
        logger.debug("truncate done");
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName("org.apache.cassandra.db:type=StorageProxy"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class weakReadLocalCallable
    implements Callable<Object> {
        private ReadCommand command;

        weakReadLocalCallable(ReadCommand command) {
            this.command = command;
        }

        @Override
        public Object call() throws IOException {
            List<InetAddress> endpoints;
            if (logger.isDebugEnabled()) {
                logger.debug("weakreadlocal reading " + this.command);
            }
            Table table = Table.open(this.command.table);
            Row row = this.command.getRow(table);
            if (StorageProxy.randomlyReadRepair(this.command) && (endpoints = StorageService.instance.getLiveNaturalEndpoints(this.command.table, this.command.key)).size() > 1) {
                StorageService.instance.doConsistencyCheck(row, endpoints, this.command);
            }
            return row;
        }
    }
}

