/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class SSTableExport {
    private static int INPUT_FILE_BUFFER_SIZE = 0x800000;
    private static final String KEY_OPTION = "k";
    private static final String EXCLUDEKEY_OPTION = "x";
    private static final String ENUMERATEKEYS_OPTION = "e";
    private static Options options = new Options();
    private static CommandLine cmd;

    private static String quote(String val) {
        return String.format("\"%s\"", val);
    }

    private static String asKey(String val) {
        return String.format("%s: ", SSTableExport.quote(val));
    }

    private static String serializeColumns(Collection<IColumn> cols, AbstractType comp) {
        StringBuilder json = new StringBuilder("[");
        Iterator<IColumn> iter = cols.iterator();
        while (iter.hasNext()) {
            json.append("[");
            IColumn column = iter.next();
            json.append(SSTableExport.quote(FBUtilities.bytesToHex(column.name())));
            json.append(", ");
            json.append(SSTableExport.quote(FBUtilities.bytesToHex(column.value())));
            json.append(", ");
            json.append(column.timestamp());
            json.append(", ");
            json.append(column.isMarkedForDelete());
            if (column instanceof ExpiringColumn) {
                json.append(", ");
                json.append(((ExpiringColumn)column).getTimeToLive());
                json.append(", ");
                json.append(((ExpiringColumn)column).getLocalDeletionTime());
            }
            json.append("]");
            if (!iter.hasNext()) continue;
            json.append(", ");
        }
        json.append("]");
        return json.toString();
    }

    private static String serializeRow(SSTableIdentityIterator row) throws IOException {
        ColumnFamily cf = row.getColumnFamilyWithColumns();
        AbstractType comparator = cf.getComparator();
        StringBuilder json = new StringBuilder(SSTableExport.asKey(FBUtilities.bytesToHex(row.getKey().key)));
        if (cf.isSuper()) {
            json.append("{ ");
            Iterator<IColumn> iter = cf.getSortedColumns().iterator();
            while (iter.hasNext()) {
                IColumn column = iter.next();
                json.append(SSTableExport.asKey(FBUtilities.bytesToHex(column.name())));
                json.append("{");
                json.append(SSTableExport.asKey("deletedAt"));
                json.append(column.getMarkedForDeleteAt());
                json.append(", ");
                json.append(SSTableExport.asKey("subColumns"));
                json.append(SSTableExport.serializeColumns(column.getSubColumns(), comparator));
                json.append("}");
                if (!iter.hasNext()) continue;
                json.append(", ");
            }
            json.append("}");
        } else {
            json.append(SSTableExport.serializeColumns(cf.getSortedColumns(), comparator));
        }
        return json.toString();
    }

    public static void enumeratekeys(String ssTableFile, PrintStream outs) throws IOException {
        Descriptor desc = Descriptor.fromFilename(ssTableFile);
        KeyIterator iter = new KeyIterator(desc);
        while (iter.hasNext()) {
            DecoratedKey key = (DecoratedKey)iter.next();
            outs.println(FBUtilities.bytesToHex(key.key));
        }
        iter.close();
        outs.flush();
    }

    public static void enumeratekeys(String ssTableFile, String outFile) throws IOException {
        PrintStream outs = new PrintStream(outFile);
        SSTableExport.enumeratekeys(ssTableFile, outs);
    }

    public static void export(String ssTableFile, PrintStream outs, String[] keys, String[] excludes) throws IOException {
        SSTableReader reader = SSTableReader.open(Descriptor.fromFilename(ssTableFile));
        SSTableScanner scanner = reader.getScanner(INPUT_FILE_BUFFER_SIZE);
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        HashSet<Object> excludeSet = new HashSet();
        int i = 0;
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        outs.println("{");
        for (String key : keys) {
            if (excludeSet.contains(key)) continue;
            DecoratedKey dk = partitioner.decorateKey(ByteBuffer.wrap(FBUtilities.hexToBytes(key)));
            scanner.seekTo(dk);
            ++i;
            if (!scanner.hasNext()) continue;
            SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
            try {
                String jsonOut = SSTableExport.serializeRow(row);
                if (i != 1) {
                    outs.println(",");
                }
                outs.print("  " + jsonOut);
            }
            catch (IOException ioexc) {
                System.err.println("WARNING: Corrupt row " + key + " (skipping).");
            }
            catch (OutOfMemoryError oom) {
                System.err.println("ERROR: Out of memory deserializing row " + key);
            }
        }
        outs.println("\n}");
        outs.flush();
    }

    public static void export(String ssTableFile, String outFile, String[] keys, String[] excludes) throws IOException {
        PrintStream outs = new PrintStream(outFile);
        SSTableExport.export(ssTableFile, outs, keys, excludes);
    }

    static void export(SSTableReader reader, PrintStream outs, String[] excludes) throws IOException {
        SSTableScanner scanner = reader.getScanner(INPUT_FILE_BUFFER_SIZE);
        HashSet<Object> excludeSet = new HashSet();
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        outs.println("{");
        while (scanner.hasNext()) {
            SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
            if (excludeSet.contains(FBUtilities.bytesToHex(row.getKey().key))) continue;
            try {
                String jsonOut = SSTableExport.serializeRow(row);
                outs.print("  " + jsonOut);
                if (scanner.hasNext()) {
                    outs.println(",");
                    continue;
                }
                outs.println();
            }
            catch (IOException ioexcep) {
                System.err.println("WARNING: Corrupt row " + FBUtilities.bytesToHex(row.getKey().key) + " (skipping).");
            }
            catch (OutOfMemoryError oom) {
                System.err.println("ERROR: Out of memory deserializing row " + FBUtilities.bytesToHex(row.getKey().key));
            }
        }
        outs.println("}");
        outs.flush();
    }

    public static void export(String ssTableFile, PrintStream outs, String[] excludes) throws IOException {
        SSTableReader reader = SSTableReader.open(Descriptor.fromFilename(ssTableFile));
        SSTableExport.export(reader, outs, excludes);
    }

    public static void export(String ssTableFile, String outFile, String[] excludes) throws IOException {
        PrintStream outs = new PrintStream(outFile);
        SSTableExport.export(ssTableFile, outs, excludes);
    }

    public static void export(String ssTableFile, String[] excludes) throws IOException {
        SSTableExport.export(ssTableFile, System.out, excludes);
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        String usage = String.format("Usage: %s <sstable> [-k key [-k key [...]] -x key [-x key [...]]]%n", SSTableExport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 1) {
            System.err.println("You must supply exactly one sstable");
            System.err.println(usage);
            System.exit(1);
        }
        String[] keys = cmd.getOptionValues(KEY_OPTION);
        String[] excludes = cmd.getOptionValues(EXCLUDEKEY_OPTION);
        String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
        DatabaseDescriptor.loadSchemas();
        if (DatabaseDescriptor.getNonSystemTables().size() < 1) {
            String msg = "no non-system tables are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        if (cmd.hasOption(ENUMERATEKEYS_OPTION)) {
            SSTableExport.enumeratekeys(ssTableFileName, System.out);
        } else if (keys != null && keys.length > 0) {
            SSTableExport.export(ssTableFileName, System.out, keys, excludes);
        } else {
            SSTableExport.export(ssTableFileName, excludes);
        }
        System.exit(0);
    }

    static {
        Option optKey = new Option(KEY_OPTION, true, "Row key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDEKEY_OPTION, true, "Excluded row key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATEKEYS_OPTION, false, "enumerate keys only");
        options.addOption(optEnumerate);
    }
}

