/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.cassandra.utils.FBUtilities;

public class ByteBufferUtil {
    public static int compareUnsigned(ByteBuffer o1, ByteBuffer o2) {
        return FBUtilities.compareUnsigned(o1.array(), o2.array(), o1.arrayOffset() + o1.position(), o2.arrayOffset() + o2.position(), o1.limit() + o1.arrayOffset(), o2.limit() + o2.arrayOffset());
    }

    public static int compare(byte[] o1, ByteBuffer o2) {
        return FBUtilities.compareUnsigned(o1, o2.array(), 0, o2.arrayOffset() + o2.position(), o1.length, o2.limit() + o2.arrayOffset());
    }

    public static int compare(ByteBuffer o1, byte[] o2) {
        return FBUtilities.compareUnsigned(o1.array(), o2, o1.arrayOffset() + o1.position(), 0, o1.limit() + o1.arrayOffset(), o2.length);
    }

    public static String string(ByteBuffer b, Charset charset) {
        return new String(b.array(), b.arrayOffset() + b.position(), b.remaining(), charset);
    }

    public static String string(ByteBuffer b) {
        return new String(b.array(), b.arrayOffset() + b.position(), b.remaining());
    }

    public static ByteBuffer bytes(String s) {
        try {
            return ByteBuffer.wrap(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer clone(ByteBuffer o) {
        ByteBuffer clone = ByteBuffer.allocate(o.remaining());
        o.mark();
        clone.put(o);
        o.reset();
        clone.flip();
        return clone;
    }
}

