/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.cassandra.io.ICompactSerializer;

public class EstimatedHistogram {
    private long[] bucketOffsets;
    private int numBuckets;
    final AtomicLongArray buckets;
    public static EstimatedHistogramSerializer serializer = new EstimatedHistogramSerializer();

    public EstimatedHistogram() {
        this(90);
    }

    public EstimatedHistogram(int bucketCount) {
        this.makeOffsets(bucketCount);
        this.buckets = new AtomicLongArray(this.numBuckets);
    }

    public EstimatedHistogram(long[] bucketData) {
        this.makeOffsets(bucketData.length - 1);
        this.buckets = new AtomicLongArray(bucketData);
    }

    public EstimatedHistogram(long[] offsets, long[] bucketData) {
        assert (bucketData.length == offsets.length + 1);
        this.bucketOffsets = offsets;
        this.buckets = new AtomicLongArray(bucketData);
        this.numBuckets = bucketData.length;
    }

    private void makeOffsets(int size) {
        long last;
        this.bucketOffsets = new long[size];
        this.bucketOffsets[0] = last = 1L;
        for (int i = 1; i < size; ++i) {
            long next = Math.round((double)last * 1.2);
            if (next == last) {
                // empty if block
            }
            this.bucketOffsets[i] = ++next;
            last = next;
        }
        this.numBuckets = this.bucketOffsets.length + 1;
    }

    public long[] getBucketOffsets() {
        return this.bucketOffsets;
    }

    public void add(long n) {
        int index = Arrays.binarySearch(this.bucketOffsets, n);
        index = index < 0 ? -index - 1 : ++index;
        this.buckets.incrementAndGet(index);
    }

    public long[] get(boolean reset) {
        int i;
        long[] rv = new long[this.numBuckets];
        for (i = 0; i < this.numBuckets; ++i) {
            rv[i] = this.buckets.get(i);
        }
        if (reset) {
            for (i = 0; i < this.numBuckets; ++i) {
                this.buckets.set(i, 0L);
            }
        }
        return rv;
    }

    public long min() {
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.buckets.get(i) <= 0L) continue;
            return this.bucketOffsets[i == 0 ? 0 : i - 1];
        }
        return 0L;
    }

    public long max() {
        int lastBucket = this.numBuckets - 1;
        if (this.buckets.get(lastBucket) > 0L) {
            throw new IllegalStateException("Unable to compute ceiling for max when all buckets are full");
        }
        for (int i = lastBucket - 1; i >= 0; --i) {
            if (this.buckets.get(i) <= 0L) continue;
            return this.bucketOffsets[i];
        }
        return 0L;
    }

    public long median() {
        long max = 0L;
        long median = 0L;
        for (int i = 0; i < this.numBuckets; ++i) {
            if (max >= 1L && this.buckets.get(i) <= max || (max = this.buckets.get(i)) <= 0L) continue;
            median = this.bucketOffsets[i == 0 ? 0 : i - 1];
        }
        return median;
    }

    public static class EstimatedHistogramSerializer
    implements ICompactSerializer<EstimatedHistogram> {
        @Override
        public void serialize(EstimatedHistogram eh, DataOutputStream dos) throws IOException {
            long[] offsets = eh.getBucketOffsets();
            long[] buckets = eh.get(false);
            dos.writeInt(buckets.length);
            for (int i = 0; i < buckets.length; ++i) {
                dos.writeLong(offsets[i == 0 ? 0 : i - 1]);
                dos.writeLong(buckets[i]);
            }
        }

        @Override
        public EstimatedHistogram deserialize(DataInputStream dis) throws IOException {
            int size = dis.readInt();
            long[] offsets = new long[size - 1];
            long[] buckets = new long[size];
            for (int i = 0; i < size; ++i) {
                offsets[i == 0 ? 0 : i - 1] = dis.readLong();
                buckets[i] = dis.readLong();
            }
            return new EstimatedHistogram(offsets, buckets);
        }
    }
}

