/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedCache<K, V> {
    public static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, V> map;
    private final AtomicLong requests = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);
    private volatile boolean capacitySetManually;

    public InstrumentedCache(int capacity) {
        this(capacity, 64);
    }

    public InstrumentedCache(int capacity, int concurency) {
        this.map = new ConcurrentLinkedHashMap.Builder().weigher(Weighers.singleton()).initialCapacity(capacity).maximumWeightedCapacity(capacity).concurrencyLevel(concurency).build();
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V get(K key) {
        Object v = this.map.get(key);
        this.requests.incrementAndGet();
        if (v != null) {
            this.hits.incrementAndGet();
        }
        return (V)v;
    }

    public V getInternal(K key) {
        return (V)this.map.get(key);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public int getCapacity() {
        return this.map.capacity();
    }

    public boolean isCapacitySetManually() {
        return this.capacitySetManually;
    }

    public void updateCapacity(int capacity) {
        this.map.setCapacity(capacity);
    }

    public void setCapacity(int capacity) {
        this.updateCapacity(capacity);
        this.capacitySetManually = true;
    }

    public int getSize() {
        return this.map.size();
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getRequests() {
        return this.requests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRecentHitRate() {
        long r = this.requests.get();
        long h = this.hits.get();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }

    public void clear() {
        this.map.clear();
        this.requests.set(0L);
        this.hits.set(0L);
    }

    public Set<K> getKeySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<K, V>> getEntrySet() {
        return this.map.entrySet();
    }
}

