/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class DropColumnFamily
extends Migration {
    private String tableName;
    private String cfName;

    protected DropColumnFamily() {
    }

    public DropColumnFamily(String tableName, String cfName) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.tableName = tableName;
        this.cfName = cfName;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(tableName);
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not already exist.");
        }
        if (!ksm.cfMetaData().containsKey(cfName)) {
            throw new ConfigurationException("CF is not defined in that keyspace.");
        }
        KSMetaData newKsm = this.makeNewKeyspaceDefinition(ksm);
        this.rm = Migration.makeDefinitionMutation(newKsm, null, this.newVersion);
    }

    private KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm) {
        CFMetaData cfm = ksm.cfMetaData().get(this.cfName);
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.remove(cfm);
        assert (newCfs.size() == ksm.cfMetaData().size() - 1);
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.replicationFactor, newCfs.toArray(new CFMetaData[newCfs.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyModels() throws IOException {
        ColumnFamilyStore cfs = Table.open(this.tableName).getColumnFamilyStore(this.cfName);
        KSMetaData existing = DatabaseDescriptor.getTableDefinition(this.tableName);
        CFMetaData cfm = existing.cfMetaData().get(this.cfName);
        KSMetaData ksm = this.makeNewKeyspaceDefinition(existing);
        CFMetaData.purge(cfm);
        DatabaseDescriptor.setTableDefinition(ksm, this.newVersion);
        if (!this.clientMode) {
            cfs.snapshot(Table.getTimestampedSnapshotName(null));
            CompactionManager.instance.getCompactionLock().lock();
            cfs.flushLock.lock();
            try {
                Table.open(ksm.name).dropCf(cfm.cfId);
            }
            finally {
                cfs.flushLock.unlock();
                CompactionManager.instance.getCompactionLock().unlock();
            }
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropColumnFamily dcf = new org.apache.cassandra.db.migration.avro.DropColumnFamily();
        dcf.ksname = new Utf8(this.tableName);
        dcf.cfname = new Utf8(this.cfName);
        mi.migration = dcf;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropColumnFamily dcf = (org.apache.cassandra.db.migration.avro.DropColumnFamily)((Object)mi.migration);
        this.tableName = ((Object)dcf.ksname).toString();
        this.cfName = ((Object)dcf.cfname).toString();
    }

    public String toString() {
        return String.format("Drop column family: %s.%s", this.tableName, this.cfName);
    }
}

