/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Message {
    private static ICompactSerializer<Message> serializer_ = new MessageSerializer();
    final Header header_;
    private final byte[] body_;

    public static ICompactSerializer<Message> serializer() {
        return serializer_;
    }

    Message(Header header, byte[] body) {
        assert (header != null);
        assert (body != null);
        this.header_ = header;
        this.body_ = body;
    }

    public Message(InetAddress from, StorageService.Verb verb, byte[] body) {
        this(new Header(from, verb), body);
    }

    public byte[] getHeader(String key) {
        return this.header_.getDetail(key);
    }

    public void setHeader(String key, byte[] value) {
        this.header_.setDetail(key, value);
    }

    public void removeHeader(String key) {
        this.header_.removeDetail(key);
    }

    public byte[] getMessageBody() {
        return this.body_;
    }

    public InetAddress getFrom() {
        return this.header_.getFrom();
    }

    public Stage getMessageType() {
        return StorageService.verbStages.get((Object)this.getVerb());
    }

    public StorageService.Verb getVerb() {
        return this.header_.getVerb();
    }

    public Message getReply(InetAddress from, byte[] args) {
        Header header = new Header(from, StorageService.Verb.REQUEST_RESPONSE);
        return new Message(header, args);
    }

    public Message getInternalReply(byte[] body) {
        Header header = new Header(FBUtilities.getLocalAddress(), StorageService.Verb.INTERNAL_RESPONSE);
        return new Message(header, body);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("");
        String separator = System.getProperty("line.separator");
        sbuf.append("FROM:" + this.getFrom()).append(separator).append("TYPE:" + (Object)((Object)this.getMessageType())).append(separator).append("VERB:" + (Object)((Object)this.getVerb())).append(separator);
        return sbuf.toString();
    }

    private static class MessageSerializer
    implements ICompactSerializer<Message> {
        private MessageSerializer() {
        }

        @Override
        public void serialize(Message t, DataOutputStream dos) throws IOException {
            Header.serializer().serialize(t.header_, dos);
            byte[] bytes = t.getMessageBody();
            dos.writeInt(bytes.length);
            dos.write(bytes);
        }

        @Override
        public Message deserialize(DataInputStream dis) throws IOException {
            Header header = Header.serializer().deserialize(dis);
            int size = dis.readInt();
            byte[] bytes = new byte[size];
            dis.readFully(bytes);
            return new Message(header, bytes);
        }
    }
}

