/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Joiner;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(FBUtilities.class);
    public static final BigInteger TWO = new BigInteger("2");
    private static volatile InetAddress localInetAddress_;
    private static final ThreadLocal<MessageDigest> localMD5Digest;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public static MessageDigest threadLocalMD5Digest() {
        return localMD5Digest.get();
    }

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static double parseDoubleOrPercent(String value) {
        if (value.endsWith("%")) {
            return Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0;
        }
        return Double.parseDouble(value);
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress_ == null) {
            try {
                localInetAddress_ = DatabaseDescriptor.getListenAddress() == null ? InetAddress.getLocalHost() : DatabaseDescriptor.getListenAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress_;
    }

    public static long absoluteFromFraction(double fractOrAbs, long total) {
        if (fractOrAbs < 0.0) {
            throw new UnsupportedOperationException("unexpected negative value " + fractOrAbs);
        }
        if (0.0 < fractOrAbs && fractOrAbs <= 1.0) {
            return Math.max(1L, (long)(fractOrAbs * (double)total));
        }
        assert (fractOrAbs >= 1.0 || fractOrAbs == 0.0);
        return (long)fractOrAbs;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return new Pair<BigInteger, Boolean>(midpoint, remainder);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2, int offset1, int offset2, int len1, int len2) {
        if (bytes1 == null) {
            return bytes2 == null ? 0 : -1;
        }
        if (bytes2 == null) {
            return 1;
        }
        int minLength = Math.min(len1 - offset1, len2 - offset2);
        int x = 0;
        int i = offset1;
        int j = offset2;
        while (x < minLength) {
            if (bytes1[i] != bytes2[j]) {
                return (bytes1[i] & 0xFF) < (bytes2[j] & 0xFF) ? -1 : 1;
            }
            ++x;
            ++i;
            ++j;
        }
        if (len1 - offset1 == len2 - offset2) {
            return 0;
        }
        return len1 - offset1 < len2 - offset2 ? -1 : 1;
    }

    public static byte[] xor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.length > right.length) {
            byte[] swap = left;
            left = right;
            right = swap;
        }
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    public static BigInteger hashToBigInteger(ByteBuffer data) {
        byte[] result = FBUtilities.hash(data);
        BigInteger hash = new BigInteger(result);
        return hash.abs();
    }

    public static byte[] hash(ByteBuffer ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (ByteBuffer block : data) {
            messageDigest.update(block.duplicate());
        }
        return messageDigest.digest();
    }

    public static byte[] hexToBytes(String str) {
        if (str.length() % 2 == 1) {
            str = "0" + str;
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    public static String bytesToHex(byte ... bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int bint = b & 0xFF;
            if (bint <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(bint));
        }
        return sb.toString();
    }

    public static void renameWithConfirm(String tmpFilename, String filename) throws IOException {
        if (!new File(tmpFilename).renameTo(new File(filename))) {
            throw new IOException("rename failed of " + filename);
        }
    }

    public static CollatingIterator getCollatingIterator() {
        return new CollatingIterator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        });
    }

    public static void atomicSetMax(AtomicInteger atomic, int i) {
        int j;
        while ((j = atomic.get()) < i && !atomic.compareAndSet(j, i)) {
        }
    }

    public static void atomicSetMax(AtomicLong atomic, long i) {
        long j;
        while ((j = atomic.get()) < i && !atomic.compareAndSet(j, i)) {
        }
    }

    public static void serialize(TSerializer serializer, TBase struct, DataOutput out) throws IOException {
        byte[] bytes;
        assert (serializer != null);
        assert (struct != null);
        assert (out != null);
        try {
            bytes = serializer.serialize(struct);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static void deserialize(TDeserializer deserializer, TBase struct, DataInput in) throws IOException {
        assert (deserializer != null);
        assert (struct != null);
        assert (in != null);
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        try {
            deserializer.deserialize(struct, bytes);
        }
        catch (TException ex) {
            throw new IOException(ex);
        }
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range range) {
        if (range.left.compareTo(range.right) >= 0) {
            final Token right = range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.token) < 0 && right.compareTo(o2.token) < 0 || right.compareTo(o1.token) > 0 && right.compareTo(o2.token) > 0) {
                        return o1.compareTo(o2);
                    }
                    return -o1.compareTo(o2);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static ByteBuffer toByteBuffer(long n) {
        byte[] bytes = new byte[8];
        return ByteBuffer.wrap(bytes).putLong(0, n);
    }

    public static String resourceToFile(String filename) throws ConfigurationException {
        ClassLoader loader = PropertyFileSnitch.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new ConfigurationException("unable to locate " + filename);
        }
        return scpurl.getFile();
    }

    public static String getReleaseVersionString() {
        try {
            InputStream in = FBUtilities.class.getClassLoader().getResourceAsStream("org/apache/cassandra/config/version.properties");
            Properties props = new Properties();
            props.load(in);
            return props.getProperty("CassandraVersion");
        }
        catch (Exception e) {
            logger_.warn("Unable to load version.properties", (Throwable)e);
            return "debug version";
        }
    }

    public static long timestampMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static void waitOnFutures(Iterable<Future<?>> futures) {
        for (Future<?> f : futures) {
            try {
                f.get();
            }
            catch (ExecutionException ee) {
                throw new RuntimeException(ee);
            }
            catch (InterruptedException ie) {
                throw new AssertionError((Object)ie);
            }
        }
    }

    public static IPartitioner newPartitioner(String partitionerClassName) throws ConfigurationException {
        if (!partitionerClassName.contains(".")) {
            partitionerClassName = "org.apache.cassandra.dht." + partitionerClassName;
        }
        return (IPartitioner)FBUtilities.construct(partitionerClassName, "partitioner");
    }

    public static AbstractType getComparator(String compareWith) throws ConfigurationException {
        String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
        Class typeClass = FBUtilities.classForName(className, "abstract-type");
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (NoSuchFieldException e) {
            ConfigurationException ex = new ConfigurationException("Invalid comparator " + compareWith + " : must define a public static instance field.");
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            ConfigurationException ex = new ConfigurationException("Invalid comparator " + compareWith + " : must define a public static instance field.");
            ex.initCause(e);
            throw ex;
        }
    }

    public static <T> Class<T> classForName(String classname, String readable) throws ConfigurationException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname));
        }
    }

    public static <T> T construct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(String.format("No default constructor for %s class '%s'.", readable, classname));
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Default constructor for %s class '%s' is inaccessible.", readable, classname));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Cannot use abstract class '%s' as %s.", classname, readable));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException(String.format("Error instantiating %s class '%s'.", readable, classname), e);
        }
    }

    public static <T extends Comparable> SortedSet<T> singleton(T column) {
        return new TreeSet<Comparable>(Arrays.asList(column));
    }

    public static String toString(Map<?, ?> map) {
        Joiner.MapJoiner joiner = Joiner.on((String)", ").withKeyValueSeparator(":");
        return joiner.join(map);
    }

    public static Field getProtectedField(Class klass, String fieldName) {
        Field field;
        try {
            field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return field;
    }

    static {
        localMD5Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                return FBUtilities.newMessageDigest("MD5");
            }

            @Override
            public MessageDigest get() {
                MessageDigest digest = (MessageDigest)super.get();
                digest.reset();
                return digest;
            }
        };
    }
}

