/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.contrib.utils.service;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.FileUtils;

public class CassandraServiceDataCleaner {
    public void prepare() throws IOException {
        this.makeDirsIfNotExist();
        this.cleanupDataDirectories();
    }

    public void cleanupDataDirectories() throws IOException {
        for (String string : this.getDataDirs()) {
            this.cleanDir(string);
        }
    }

    public void makeDirsIfNotExist() throws IOException {
        for (String string : this.getDataDirs()) {
            this.mkdir(string);
        }
    }

    private Set<String> getDataDirs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : DatabaseDescriptor.getAllDataFileLocations()) {
            hashSet.add(string);
        }
        hashSet.add(DatabaseDescriptor.getCommitLogLocation());
        return hashSet;
    }

    private void mkdir(String string) throws IOException {
        FileUtils.createDirectory((String)string);
    }

    private void cleanDir(String string) throws IOException {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            FileUtils.delete((File[])file.listFiles());
        }
    }
}

