/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.basic.BeanTypePropertyInfo;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.jdom.Element;

public class XMLBeanTypeInfo
extends BeanTypeInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLBeanTypeInfo.class);
    private List mappings;
    private Map<QName, BeanTypePropertyInfo> name2PropertyInfo = new HashMap<QName, BeanTypePropertyInfo>();

    public XMLBeanTypeInfo(Class typeClass, List mappings, String defaultNS) {
        super(typeClass, defaultNS);
        this.mappings = mappings;
    }

    protected boolean registerType(PropertyDescriptor desc) {
        Element e = this.getPropertyElement(desc.getName());
        if (e != null && e.getAttributeValue("type") != null) {
            return false;
        }
        return super.registerType(desc);
    }

    protected void mapProperty(PropertyDescriptor pd) {
        block20: {
            boolean element;
            Element e = this.getPropertyElement(pd.getName());
            String style = null;
            QName mappedName = null;
            if (e != null) {
                String ignore = e.getAttributeValue("ignore");
                if (ignore != null && ignore.equals("true")) {
                    return;
                }
                LOG.finest("Found mapping for property " + pd.getName());
                style = e.getAttributeValue("style");
            }
            if (style == null) {
                style = "element";
            }
            boolean qualify = (element = "element".equals(style)) ? this.isQualifyElements() : this.isQualifyAttributes();
            String namespace = null;
            if (qualify) {
                namespace = this.getDefaultNamespace();
            }
            if (e != null) {
                mappedName = NamespaceHelper.createQName(e, e.getAttributeValue("mappedName"), namespace);
            }
            if (mappedName == null) {
                mappedName = this.createMappedName(pd, qualify);
            }
            if (e != null) {
                String minOccurs;
                String nillableVal;
                String explicitTypeName;
                QName mappedType = NamespaceHelper.createQName(e, e.getAttributeValue("typeName"), this.getDefaultNamespace());
                if (mappedType != null) {
                    this.mapTypeName(mappedName, mappedType);
                }
                if ((explicitTypeName = e.getAttributeValue("type")) != null) {
                    try {
                        Class typeClass = ClassLoaderUtils.loadClass((String)explicitTypeName, XMLBeanTypeInfo.class);
                        Type customTypeObject = (Type)typeClass.newInstance();
                        this.mapType(mappedName, customTypeObject);
                        QName schemaType = mappedType;
                        if (schemaType == null) {
                            schemaType = this.getTypeMapping().getTypeQName(pd.getPropertyType());
                        }
                        customTypeObject.setSchemaType(schemaType);
                    }
                    catch (ClassNotFoundException e1) {
                    }
                    catch (InstantiationException e2) {
                    }
                    catch (IllegalAccessException e3) {
                        // empty catch block
                    }
                }
                if ((nillableVal = e.getAttributeValue("nillable")) != null && nillableVal.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setNillable(Boolean.valueOf(nillableVal));
                }
                if ((minOccurs = e.getAttributeValue("minOccurs")) != null && minOccurs.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setMinOccurs(Integer.parseInt(minOccurs));
                }
            }
            try {
                if ("element".equals(style)) {
                    this.mapElement(pd.getName(), mappedName);
                    break block20;
                }
                if ("attribute".equals(style)) {
                    this.mapAttribute(pd.getName(), mappedName);
                    break block20;
                }
                throw new DatabindingException("Invalid style: " + style);
            }
            catch (DatabindingException ex) {
                ex.prepend("Couldn't create type for property " + pd.getName() + " on " + this.getTypeClass());
                throw ex;
            }
        }
    }

    private Element getPropertyElement(String name2) {
        for (Element mapping2 : this.mappings) {
            List elements = mapping2.getChildren("property");
            for (int i = 0; i < elements.size(); ++i) {
                Element e = (Element)elements.get(i);
                String name = e.getAttributeValue("name");
                if (name == null || !name.equals(name2)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isNillable(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.isNillable();
        }
        return super.isNillable(name);
    }

    public int getMinOccurs(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.getMinOccurs();
        }
        return super.getMinOccurs(name);
    }

    private BeanTypePropertyInfo getPropertyInfo(QName name) {
        return this.name2PropertyInfo.get(name);
    }

    private BeanTypePropertyInfo ensurePropertyInfo(QName name) {
        BeanTypePropertyInfo result = this.getPropertyInfo(name);
        if (result == null) {
            result = new BeanTypePropertyInfo();
            this.name2PropertyInfo.put(name, result);
        }
        return result;
    }
}

