/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxb.JAXBWrapperHelper;
import org.apache.cxf.jaxb.WrapperHelperCompiler;
import org.apache.cxf.jaxb.io.DataReaderImpl;
import org.apache.cxf.jaxb.io.DataWriterImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDataBinding
extends AbstractDataBinding
implements WrapperCapableDatabinding {
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    public static final String MTOM_THRESHOLD = "org.apache.cxf.jaxb.mtomThreshold";
    public static final String UNWRAP_JAXB_ELEMENT = "unwrap.jaxb.element";
    public static final String USE_JAXB_BRIDGE = "use.jaxb.bridge";
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{Node.class, XMLEventReader.class, XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{OutputStream.class, Node.class, XMLEventWriter.class, XMLStreamWriter.class};
    private static final Map<Set<Class<?>>, CachedContextAndSchemas> JAXBCONTEXT_CACHE = new CacheMap();
    private static final Map<Package, CachedClassOrNull> OBJECT_FACTORY_CACHE = new CacheMap();
    Class[] extraClass;
    JAXBContext context;
    Set<Class<?>> contextClasses;
    Class<?> cls;
    private Map<String, Object> contextProperties = Collections.emptyMap();
    private Map<String, Object> marshallerProperties = Collections.emptyMap();
    private Map<String, Object> unmarshallerProperties = Collections.emptyMap();
    private Unmarshaller.Listener unmarshallerListener;
    private Marshaller.Listener marshallerListener;
    private ValidationEventHandler validationEventHandler;
    private boolean qualifiedSchemas;
    private Service service;

    public JAXBDataBinding() {
    }

    public JAXBDataBinding(boolean q) {
        this.qualifiedSchemas = q;
    }

    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        this.contextClasses = new LinkedHashSet();
        this.contextClasses.addAll(Arrays.asList(classes));
        this.setContext(this.createJAXBContext(this.contextClasses));
    }

    public JAXBDataBinding(JAXBContext context) {
        this();
        this.setContext(context);
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public final void setContext(JAXBContext ctx) {
        this.context = ctx;
    }

    public <T> DataWriter<T> createWriter(Class<T> c) {
        Integer mtomThresholdInt = new Integer(this.getMtomThreshold());
        if (c == XMLStreamWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            return r;
        }
        if (c == OutputStream.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            return r;
        }
        if (c == XMLEventWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            return r;
        }
        if (c == Node.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            return r;
        }
        return null;
    }

    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this);
        } else if (c == XMLEventReader.class) {
            dr = new DataReaderImpl(this);
        } else if (c == Node.class) {
            dr = new DataReaderImpl(this);
        }
        return dr;
    }

    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Service aservice) {
        this.service = aservice;
        if (this.context != null) {
            return;
        }
        this.contextClasses = new LinkedHashSet();
        for (ServiceInfo serviceInfo : this.service.getServiceInfos()) {
            JAXBContextInitializer initializer = new JAXBContextInitializer(serviceInfo, this.contextClasses);
            initializer.walk();
            if (serviceInfo.getProperty("extra.class") == null) continue;
            Set exClasses = (Set)serviceInfo.getProperty("extra.class", Set.class);
            this.contextClasses.addAll(exClasses);
        }
        String tns = this.service.getName().getNamespaceURI();
        CachedContextAndSchemas cachedContextAndSchemas = null;
        JAXBContext ctx = null;
        try {
            if (this.service.getServiceInfos().size() > 0) {
                tns = ((ServiceInfo)this.service.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI();
            }
            cachedContextAndSchemas = this.createJAXBContextAndSchemas(this.contextClasses, tns);
        }
        catch (JAXBException e1) {
            boolean added = this.addJaxbObjectFactory(e1);
            while (cachedContextAndSchemas == null && added) {
                try {
                    ctx = JAXBContext.newInstance((Class[])this.contextClasses.toArray(new Class[this.contextClasses.size()]), null);
                    cachedContextAndSchemas = new CachedContextAndSchemas(ctx);
                }
                catch (JAXBException e) {
                    e1 = e;
                    added = this.addJaxbObjectFactory(e1);
                }
            }
            if (ctx == null) {
                throw new ServiceConstructionException((Throwable)e1);
            }
            Map<Set<Class<?>>, CachedContextAndSchemas> e = JAXBCONTEXT_CACHE;
            synchronized (e) {
                JAXBCONTEXT_CACHE.put(this.contextClasses, cachedContextAndSchemas);
            }
        }
        ctx = cachedContextAndSchemas.getContext();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "CREATED_JAXB_CONTEXT", new Object[]{ctx, this.contextClasses});
        }
        this.setContext(ctx);
        for (ServiceInfo serviceInfo : this.service.getServiceInfos()) {
            JAXBContext riContext;
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) continue;
            boolean schemasFromCache = false;
            Collection<DOMSource> schemas = this.getSchemas();
            if (schemas == null) {
                schemas = cachedContextAndSchemas.getSchemas();
                if (schemas != null) {
                    schemasFromCache = true;
                }
            } else {
                schemasFromCache = true;
            }
            if (schemas == null) {
                schemas = new HashSet<DOMSource>();
                try {
                    for (DOMResult dOMResult : this.generateJaxbSchemas()) {
                        schemas.add(new DOMSource(dOMResult.getNode(), dOMResult.getSystemId()));
                    }
                }
                catch (IOException e) {
                    throw new ServiceConstructionException(new Message("SCHEMA_GEN_EXC", LOG, new Object[0]), (Throwable)e);
                }
            }
            for (DOMSource dOMSource : schemas) {
                this.addSchemaDocument(serviceInfo, col, (Document)dOMSource.getNode(), dOMSource.getSystemId());
            }
            if (this.context.getClass().getName().contains("com.sun.xml.")) {
                riContext = this.context;
            } else {
                try {
                    riContext = JAXBUtils.createRIContext((Class[])this.contextClasses.toArray(new Class[this.contextClasses.size()]), (String)tns);
                }
                catch (JAXBException jAXBException) {
                    throw new ServiceConstructionException((Throwable)jAXBException);
                }
            }
            JAXBSchemaInitializer jAXBSchemaInitializer = new JAXBSchemaInitializer(serviceInfo, col, riContext, this.qualifiedSchemas);
            jAXBSchemaInitializer.walk();
            if (cachedContextAndSchemas == null || schemasFromCache) continue;
            cachedContextAndSchemas.setSchemas(schemas);
        }
    }

    public void setExtraClass(Class[] userExtraClass) {
        this.extraClass = userExtraClass;
    }

    public Class[] getExtraClass() {
        return this.extraClass;
    }

    List<DOMResult> generateJaxbSchemas() throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        this.context.generateSchema(new SchemaOutputResolver(){
            private Map<String, String> builtIns = new HashMap<String, String>();
            {
                this.builtIns.put("http://www.w3.org/2005/02/addressing/wsdl", "classpath:/schemas/wsdl/ws-addr-wsdl.xsd");
                this.builtIns.put("http://www.w3.org/2005/08/addressing", "classpath:/schemas/wsdl/ws-addr.xsd");
                this.builtIns.put("http://schemas.xmlsoap.org/ws/2005/02/rm", "classpath:/schemas/wsdl/wsrm.xsd");
                this.builtIns.put("http://www.w3.org/2005/05/xmlmime", "classpath:/schemas/wsdl/ws-addr.xsd");
            }

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                if (this.builtIns.containsKey(ns)) {
                    result.setSystemId(this.builtIns.get(ns));
                    return result;
                }
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        return results;
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        return this.createJAXBContext(classes, null);
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        return this.createJAXBContextAndSchemas(classes, defaultNs).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedContextAndSchemas createJAXBContextAndSchemas(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        if (this.extraClass != null && this.extraClass.length > 0) {
            for (Class clz : this.extraClass) {
                classes.add(clz);
            }
        }
        this.scanPackages(classes);
        this.addWsAddressingTypes(classes);
        for (Class<?> clz : classes) {
            if (!clz.getName().endsWith("ObjectFactory") || !this.checkObjectFactoryNamespaces(clz)) continue;
            defaultNs = null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (defaultNs != null) {
            map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        if (this.contextProperties != null) {
            map.putAll(this.contextProperties);
        }
        CachedContextAndSchemas cachedContextAndSchemas = null;
        Map<Set<Class<?>>, CachedContextAndSchemas> i$ = JAXBCONTEXT_CACHE;
        synchronized (i$) {
            cachedContextAndSchemas = JAXBCONTEXT_CACHE.get(classes);
        }
        if (cachedContextAndSchemas == null) {
            JAXBContext ctx;
            try {
                ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
            }
            catch (JAXBException ex) {
                if (map.containsKey("com.sun.xml.bind.defaultNamespaceRemap") && ex.getMessage().contains("com.sun.xml.bind.defaultNamespaceRemap")) {
                    map.put("com.sun.xml.internal.bind.defaultNamespaceRemap", map.remove("com.sun.xml.bind.defaultNamespaceRemap"));
                    ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
                }
                throw ex;
            }
            cachedContextAndSchemas = new CachedContextAndSchemas(ctx);
            Map<Set<Class<?>>, CachedContextAndSchemas> map2 = JAXBCONTEXT_CACHE;
            synchronized (map2) {
                JAXBCONTEXT_CACHE.put(classes, cachedContextAndSchemas);
            }
        }
        return cachedContextAndSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanPackages(Set<Class<?>> classes) {
        Object pkg;
        HashMap<String, InputStream> packages = new HashMap<String, InputStream>();
        HashMap<String, ClassLoader> packageLoaders = new HashMap<String, ClassLoader>();
        HashSet objectFactories = new HashSet();
        for (Class<?> clazz : classes) {
            String pkgName = PackageUtils.getPackageName(clazz);
            if (packages.containsKey(pkgName)) continue;
            pkg = clazz.getPackage();
            packages.put(pkgName, clazz.getResourceAsStream("jaxb.index"));
            packageLoaders.put(pkgName, clazz.getClassLoader());
            String objectFactoryClassName = pkgName + "." + "ObjectFactory";
            Class<?> ofactory = null;
            CachedClassOrNull cachedFactory = null;
            if (pkg != null) {
                Map<Package, CachedClassOrNull> map = OBJECT_FACTORY_CACHE;
                synchronized (map) {
                    cachedFactory = OBJECT_FACTORY_CACHE.get(pkg);
                }
            }
            if (cachedFactory != null) {
                ofactory = cachedFactory.getCachedClass();
            }
            if (ofactory == null) {
                try {
                    ofactory = Class.forName(objectFactoryClassName, false, clazz.getClassLoader());
                    objectFactories.add(ofactory);
                    this.addToObjectFactoryCache((Package)pkg, ofactory);
                }
                catch (ClassNotFoundException e) {
                    this.addToObjectFactoryCache((Package)pkg, null);
                }
                continue;
            }
            objectFactories.add(ofactory);
        }
        for (Map.Entry entry : packages.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)entry.getValue(), "UTF-8"));
                pkg = (String)entry.getKey();
                ClassLoader loader = (ClassLoader)packageLoaders.get(pkg);
                if (!StringUtils.isEmpty((String)pkg)) {
                    pkg = (String)pkg + ".";
                }
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).indexOf("#") != -1) {
                        line = line.substring(0, line.indexOf("#"));
                    }
                    if (!StringUtils.isEmpty((String)line)) {
                        try {
                            Class<?> ncls = Class.forName((String)pkg + line, false, loader);
                            classes.add(ncls);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    ((InputStream)entry.getValue()).close();
                }
                catch (Exception e) {}
            }
        }
        classes.addAll(objectFactories);
    }

    private boolean checkObjectFactoryNamespaces(Class<?> clz) {
        for (Method meth : clz.getMethods()) {
            XmlElementDecl decl = meth.getAnnotation(XmlElementDecl.class);
            if (decl == null || !XmlElementDecl.GLOBAL.class.equals((Object)decl.scope()) || !StringUtils.isEmpty((String)decl.namespace())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToObjectFactoryCache(Package objectFactoryPkg, Class<?> ofactory) {
        if (objectFactoryPkg == null) {
            return;
        }
        Map<Package, CachedClassOrNull> map = OBJECT_FACTORY_CACHE;
        synchronized (map) {
            OBJECT_FACTORY_CACHE.put(objectFactoryPkg, new CachedClassOrNull(ofactory));
        }
    }

    private void addWsAddressingTypes(Set<Class<?>> classes) {
        if (classes.contains(ObjectFactory.class)) {
            try {
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Set<Class<?>> getContextClasses() {
        return Collections.unmodifiableSet(this.contextClasses);
    }

    public boolean addJaxbObjectFactory(JAXBException e1) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage((String)matcher.group());
            try {
                Class<?> clz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(pkgName + "." + "ObjectFactory");
                if (this.contextClasses.contains(clz)) continue;
                this.contextClasses.add(clz);
                added = true;
            }
            catch (ClassNotFoundException e) {}
        }
        return added;
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
    }

    public Map<String, Object> getMarshallerProperties() {
        return this.marshallerProperties;
    }

    public void setMarshallerProperties(Map<String, Object> marshallerProperties) {
        this.marshallerProperties = marshallerProperties;
    }

    public Map<String, Object> getUnmarshallerProperties() {
        return this.unmarshallerProperties;
    }

    public void setUnmarshallerProperties(Map<String, Object> unmarshallerProperties) {
        this.unmarshallerProperties = unmarshallerProperties;
    }

    public Unmarshaller.Listener getUnmarshallerListener() {
        return this.unmarshallerListener;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public Marshaller.Listener getMarshallerListener() {
        return this.marshallerListener;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map = JAXBCONTEXT_CACHE;
        synchronized (map) {
            JAXBCONTEXT_CACHE.clear();
        }
        map = OBJECT_FACTORY_CACHE;
        synchronized (map) {
            OBJECT_FACTORY_CACHE.clear();
        }
    }

    public WrapperHelper createWrapperHelper(Class<?> wrapperType, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> jaxbMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Field> fields = new ArrayList<Field>(partNames.size());
        Method[] allMethods = wrapperType.getMethods();
        String packageName = PackageUtils.getPackageName(wrapperType);
        if (wrapperType.getPackage() != null) {
            packageName = wrapperType.getPackage().getName();
        }
        String objectFactoryClassName = packageName + ".ObjectFactory";
        Object objectFactory = null;
        try {
            objectFactory = wrapperType.getClassLoader().loadClass(objectFactoryClassName).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        Method[] allOFMethods = objectFactory != null ? objectFactory.getClass().getMethods() : new Method[]{};
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                jaxbMethods.add(null);
                continue;
            }
            String elementType = elTypeNames.get(x);
            String getAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            Class<?> valueClass = wrapperType;
            try {
                getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            Field elField = JAXBDataBinding.getElField(partName, valueClass);
            if (getMethod == null && elementType != null && "boolean".equals(elementType.toLowerCase()) && (elField == null || !Collection.class.isAssignableFrom(elField.getType()) && !elField.getType().isArray())) {
                try {
                    String newAcc = getAccessor.replaceFirst("get", "is");
                    getMethod = wrapperType.getMethod(newAcc, AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            if (getMethod == null && "return".equals(partName)) {
                try {
                    getMethod = valueClass.getMethod("get_return", AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        getMethod = valueClass.getMethod("is_return", new Class[0]);
                    }
                    catch (NoSuchMethodException ex2) {
                        // empty catch block
                    }
                }
            }
            String setAccessor2 = setAccessor;
            if ("return".equals(partName)) {
                setAccessor2 = "set_return";
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName()) && !setAccessor2.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            if (setMethod != null && JAXBElement.class.isAssignableFrom(setMethod.getParameterTypes()[0])) {
                String methodName = "create" + wrapperType.getSimpleName() + setMethod.getName().substring(3);
                for (Method m : allOFMethods) {
                    if (!m.getName().equals(methodName)) continue;
                    jaxbMethods.add(m);
                }
            } else {
                jaxbMethods.add(null);
            }
            if (elField != null) {
                XmlElement el = elField.getAnnotation(XmlElement.class);
                if (el != null && partName.equals(el.name())) {
                    elField.setAccessible(true);
                    fields.add(elField);
                    continue;
                }
                fields.add(null);
                continue;
            }
            fields.add(null);
        }
        return JAXBDataBinding.createWrapperHelper(wrapperType, setMethods.toArray(new Method[setMethods.size()]), getMethods.toArray(new Method[getMethods.size()]), jaxbMethods.toArray(new Method[jaxbMethods.size()]), fields.toArray(new Field[fields.size()]), objectFactory);
    }

    private static Field getElField(String partName, Class<?> wrapperType) {
        String fieldName = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.VARIABLE);
        for (Field field : wrapperType.getDeclaredFields()) {
            XmlElement el = field.getAnnotation(XmlElement.class);
            if (el != null && partName.equals(el.name())) {
                return field;
            }
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private static WrapperHelper createWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        Object wh = JAXBDataBinding.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        if (wh == null) {
            wh = new JAXBWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        return wh;
    }

    private static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        try {
            Class.forName("org.objectweb.asm.ClassWriter");
            return WrapperHelperCompiler.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedClassOrNull {
        private WeakReference<Class<?>> cachedClass;

        public CachedClassOrNull(Class<?> cachedClass) {
            this.cachedClass = new WeakReference(cachedClass);
        }

        public Class<?> getCachedClass() {
            return this.cachedClass == null ? null : (Class)this.cachedClass.get();
        }

        public void setCachedClass(Class<?> cachedClass) {
            this.cachedClass = new WeakReference(cachedClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedContextAndSchemas {
        private JAXBContext context;
        private Collection<DOMSource> schemas;

        CachedContextAndSchemas(JAXBContext context) {
            this.context = context;
        }

        public JAXBContext getContext() {
            return this.context;
        }

        public Collection<DOMSource> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            this.schemas = schemas;
        }
    }
}

