/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResourceInfoComparator
implements Comparator<OperationResourceInfo> {
    @Override
    public int compare(OperationResourceInfo e1, OperationResourceInfo e2) {
        int g2;
        String l2;
        if (e1.getHttpMethod() != null && e2.getHttpMethod() == null || e1.getHttpMethod() == null && e2.getHttpMethod() != null) {
            return e1.getHttpMethod() != null ? -1 : 1;
        }
        String l1 = e1.getURITemplate().getLiteralChars();
        if (!l1.equals(l2 = e2.getURITemplate().getLiteralChars())) {
            return l1.length() < l2.length() ? 1 : -1;
        }
        int g1 = e1.getURITemplate().getNumberOfGroups();
        if (g1 != (g2 = e2.getURITemplate().getNumberOfGroups())) {
            return g1 < g2 ? 1 : -1;
        }
        List<MediaType> mimeType1 = e1.getConsumeTypes();
        List<MediaType> mimeType2 = e2.getConsumeTypes();
        int result = JAXRSUtils.compareMediaTypes(mimeType1.get(0), mimeType2.get(0));
        if (result == 0) {
            List<MediaType> mimeTypeP1 = e1.getProduceTypes();
            List<MediaType> mimeTypeP2 = e2.getProduceTypes();
            result = JAXRSUtils.compareMediaTypes(mimeTypeP1.get(0), mimeTypeP2.get(0));
        }
        return result;
    }
}

