/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(WebApplicationExceptionMapper.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WebApplicationExceptionMapper.class);

    public Response toResponse(WebApplicationException ex) {
        Response r;
        if (LOG.isLoggable(Level.WARNING)) {
            String message;
            String string = message = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
            if (message == null) {
                message = ex.getCause() != null ? "cause is " + ex.getCause().getClass().getName() : "no cause is available";
            }
            Message errorMsg = new Message("WEB_APP_EXCEPTION", BUNDLE, new Object[]{message});
            LOG.warning(errorMsg.toString());
        }
        if ((r = ex.getResponse()) == null) {
            String message = null;
            if (ex.getCause() == null) {
                message = new Message("DEFAULT_EXCEPTION_MESSAGE", BUNDLE, new Object[0]).toString();
            } else {
                message = ex.getCause().getMessage();
                if (message == null) {
                    message = ex.getCause().getClass().getName();
                }
            }
            r = Response.status((int)500).type("text/plain").entity((Object)message).build();
        }
        return r;
    }
}

