/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.impl.MetadataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment {
    private DataHandler handler;
    private MultivaluedMap<String, String> headers = new MetadataMap<String, String>();
    private String contentId;

    public Attachment(org.apache.cxf.message.Attachment a) {
        this.handler = a.getDataHandler();
        this.contentId = a.getId();
        Iterator i = a.getHeaderNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.headers.add((Object)name, (Object)a.getHeader(name));
        }
    }

    public Attachment(String id, DataHandler dh, MultivaluedMap<String, String> headers) {
        this.handler = dh;
        this.contentId = id;
        this.headers = new MetadataMap<String, String>((Map<String, List<String>>)headers);
    }

    public Attachment(String id, DataSource ds, MultivaluedMap<String, String> headers) {
        this(id, new DataHandler(ds), headers);
    }

    public Attachment(InputStream is, MultivaluedMap<String, String> headers) {
        this((String)headers.getFirst((Object)"Content-ID"), new DataHandler((DataSource)new InputStreamDataSource(is, (String)headers.getFirst((Object)"Content-Type"))), headers);
    }

    public ContentDisposition getContentDisposition() {
        String header = this.getHeader("Content-Disposition");
        return header == null ? null : new ContentDisposition(header);
    }

    public String getContentId() {
        return this.contentId;
    }

    public MediaType getContentType() {
        String value = this.handler.getContentType();
        return value == null ? MediaType.TEXT_PLAIN_TYPE : MediaType.valueOf((String)value);
    }

    public DataHandler getDataHandler() {
        return this.handler;
    }

    public String getHeader(String name) {
        String header = (String)this.headers.getFirst((Object)name);
        return header == null ? (String)this.headers.getFirst((Object)name.toLowerCase()) : header;
    }

    public List<String> getHeaderAsList(String name) {
        List header = (List)this.headers.get((Object)name);
        return header == null ? (List)this.headers.get((Object)name.toLowerCase()) : header;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return new MetadataMap<String, String>((Map<String, List<String>>)this.headers);
    }

    public int hashCode() {
        return this.contentId.hashCode() + 37 * this.headers.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        return this.contentId.equals(other.contentId) && this.headers.equals(other.headers);
    }
}

