/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionInfo;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

public final class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static final String[] UNSUPPORTED = new String[]{"SessionCaching", "SessionCacheKey", "MaxChainLength", "CertValidator", "ProxyHost", "ProxyPort"};
    private static final String[] DERIVATIVE = new String[]{"CiphersuiteFilters"};
    HTTPConduit conduit;
    TLSClientParameters tlsClientParameters;
    SSLSocketFactory socketFactory;

    public HttpsURLConnectionFactory(TLSClientParameters params) {
        this.tlsClientParameters = params;
        assert (this.tlsClientParameters != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpURLConnection createConnection(Proxy proxy, URL url) throws IOException {
        if (!url.getProtocol().equals(HTTPS_URL_PROTOCOL_ID)) {
            throw new IOException("Illegal Protocol " + url.getProtocol() + " for HTTPS URLConnection Factory.");
        }
        HttpsURLConnection connection = (HttpsURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
        if (this.tlsClientParameters != null) {
            Exception ex = null;
            try {
                this.decorateWithTLS(connection);
                return connection;
            }
            catch (Exception e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) return connection;
                if (!(ex instanceof IOException)) throw new IIOException("Error while initializing secure socket", ex);
                throw (IOException)ex;
            }
        } else {
            assert (false);
            return connection;
        }
    }

    protected synchronized void decorateWithTLS(HttpsURLConnection connection) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        SSLSocketFactory preSetFactory;
        if (this.socketFactory == null && (preSetFactory = this.tlsClientParameters.getSSLSocketFactory()) != null) {
            this.socketFactory = preSetFactory;
        }
        if (this.socketFactory == null) {
            String provider = this.tlsClientParameters.getJsseProvider();
            String protocol = this.tlsClientParameters.getSecureSocketProtocol() != null ? this.tlsClientParameters.getSecureSocketProtocol() : "TLS";
            SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            ctx.init(this.tlsClientParameters.getKeyManagers(), this.tlsClientParameters.getTrustManagers(), this.tlsClientParameters.getSecureRandom());
            String[] cipherSuites = SSLUtils.getCiphersuites(this.tlsClientParameters.getCipherSuites(), SSLUtils.getSupportedCipherSuites(ctx), this.tlsClientParameters.getCipherSuitesFilter(), LOG, false);
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, this.tlsClientParameters.getSecureSocketProtocol());
        }
        if (this.tlsClientParameters.isDisableCNCheck()) {
            connection.setHostnameVerifier(CertificateHostnameVerifier.ALLOW_ALL);
        } else {
            connection.setHostnameVerifier(CertificateHostnameVerifier.DEFAULT);
        }
        connection.setSSLSocketFactory(this.socketFactory);
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }

    protected String[] getUnSupported() {
        return UNSUPPORTED;
    }

    protected String[] getDerivative() {
        return DERIVATIVE;
    }

    public HttpURLConnectionInfo getConnectionInfo(HttpURLConnection connection) throws IOException {
        return new HttpsURLConnectionInfo((HttpsURLConnection)connection);
    }

    public String getProtocol() {
        return HTTPS_URL_PROTOCOL_ID;
    }
}

