/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotParams;
import org.apache.solr.handler.clustering.carrot2.LuceneLanguageModelFactory;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerFactory;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarrotClusteringEngine
extends SearchClusteringEngine {
    private static transient Logger log = LoggerFactory.getLogger(CarrotClusteringEngine.class);
    private Controller controller = ControllerFactory.createPooling();
    private Class<? extends IClusteringAlgorithm> clusteringAlgorithmClass;
    private String idFieldName;

    @Override
    @Deprecated
    public Object cluster(Query query, DocList docList, SolrQueryRequest sreq) {
        SolrIndexSearcher searcher = sreq.getSearcher();
        try {
            HashMap<SolrDocument, Integer> docIds = new HashMap<SolrDocument, Integer>(docList.size());
            SolrDocumentList solrDocList = SolrPluginUtils.docListToSolrDocumentList((DocList)docList, (SolrIndexSearcher)searcher, this.getFieldsToLoad(sreq), docIds);
            return this.cluster(query, solrDocList, docIds, sreq);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public Object cluster(Query query, SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, SolrQueryRequest sreq) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            List<Document> documents = this.getDocuments(solrDocList, docIds, query, sreq);
            attributes.put("documents", documents);
            attributes.put("query", query.toString());
            this.extractCarrotAttributes(sreq.getParams(), attributes);
            return this.clustersToNamedList(this.controller.process(attributes, new Class[]{this.clusteringAlgorithmClass}).getClusters(), sreq.getParams());
        }
        catch (Exception e) {
            log.error("Carrot2 clustering failed", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Carrot2 clustering failed", (Throwable)e);
        }
    }

    @Override
    public String init(NamedList config, SolrCore core) {
        String result = super.init(config, core);
        SolrParams initParams = SolrParams.toSolrParams((NamedList)config);
        HashMap<String, Object> initAttributes = new HashMap<String, Object>();
        this.extractCarrotAttributes(initParams, initAttributes);
        initAttributes.put("PreprocessingPipeline.languageModelFactory", LuceneLanguageModelFactory.class);
        this.controller.init(initAttributes);
        this.idFieldName = core.getSchema().getUniqueKeyField().getName();
        String carrotAlgorithmClassName = initParams.get("carrot.algorithm");
        Class algorithmClass = core.getResourceLoader().findClass(carrotAlgorithmClassName, new String[0]);
        if (!IClusteringAlgorithm.class.isAssignableFrom(algorithmClass)) {
            throw new IllegalArgumentException("Class provided as carrot.algorithm must implement " + IClusteringAlgorithm.class.getName());
        }
        this.clusteringAlgorithmClass = algorithmClass;
        return result;
    }

    @Override
    protected Set<String> getFieldsToLoad(SolrQueryRequest sreq) {
        SolrParams solrParams = sreq.getParams();
        String urlField = solrParams.get("carrot.url", "url");
        String titleField = solrParams.get("carrot.title", "title");
        String snippetField = solrParams.get("carrot.snippet", titleField);
        if (StringUtils.isBlank((String)snippetField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "carrot.snippet must not be blank.");
        }
        return Sets.newHashSet((Object[])new String[]{urlField, titleField, snippetField, this.idFieldName});
    }

    private List<Document> getDocuments(SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, Query query, final SolrQueryRequest sreq) throws IOException {
        SolrHighlighter highlighter = null;
        SolrParams solrParams = sreq.getParams();
        SolrCore core = sreq.getCore();
        String urlField = solrParams.get("carrot.url", "url");
        String titleField = solrParams.get("carrot.title", "title");
        String snippetField = solrParams.get("carrot.snippet", titleField);
        boolean produceSummary = solrParams.getBool("carrot.produceSummary", false);
        LocalSolrQueryRequest req = null;
        String[] snippetFieldAry = null;
        if (produceSummary) {
            highlighter = core.getHighlighter();
            if (highlighter != null) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                snippetFieldAry = new String[]{snippetField};
                args.put("hl.fl", snippetFieldAry);
                args.put("hl", "true");
                args.put("hl.simple.pre", "");
                args.put("hl.simple.post", "");
                args.put("hl.fragsize", solrParams.getInt("carrot.fragzise", solrParams.getInt("hl.fragsize", 100)));
                req = new LocalSolrQueryRequest(core, query.toString(), "", 0, 1, args){

                    public SolrIndexSearcher getSearcher() {
                        return sreq.getSearcher();
                    }
                };
            } else {
                log.warn("No highlighter configured, cannot produce summary");
                produceSummary = false;
            }
        }
        Iterator docsIter = solrDocList.iterator();
        ArrayList<Document> result = new ArrayList<Document>(solrDocList.size());
        float[] scores = new float[]{1.0f};
        int[] docsHolder = new int[1];
        Query theQuery = query;
        while (docsIter.hasNext()) {
            SolrDocument sdoc = (SolrDocument)docsIter.next();
            String snippet = this.getValue(sdoc, snippetField);
            if (produceSummary && docIds != null) {
                NamedList tmp;
                String[] highlt;
                docsHolder[0] = docIds.get(sdoc);
                DocSlice docAsList = new DocSlice(0, 1, docsHolder, scores, 1, 1.0f);
                NamedList highlights = highlighter.doHighlighting((DocList)docAsList, theQuery, (SolrQueryRequest)req, snippetFieldAry);
                if (highlights != null && highlights.size() == 1 && (highlt = (String[])(tmp = (NamedList)highlights.getVal(0)).get(snippetField)) != null && highlt.length == 1) {
                    snippet = highlt[0];
                }
            }
            Document carrotDocument = new Document(this.getValue(sdoc, titleField), snippet, (String)sdoc.getFieldValue(urlField));
            carrotDocument.setField("solrId", sdoc.getFieldValue(this.idFieldName));
            result.add(carrotDocument);
        }
        return result;
    }

    @Deprecated
    protected String getValue(org.apache.lucene.document.Document doc, String field) {
        StringBuilder result = new StringBuilder();
        String[] vals = doc.getValues(field);
        for (int i = 0; i < vals.length; ++i) {
            result.append(vals[i]).append(" . ");
        }
        return result.toString().trim();
    }

    protected String getValue(SolrDocument sdoc, String field) {
        StringBuilder result = new StringBuilder();
        Collection vals = sdoc.getFieldValues(field);
        if (vals == null) {
            return "";
        }
        Iterator ite = vals.iterator();
        while (ite.hasNext()) {
            result.append((String)ite.next()).append(" . ");
        }
        return result.toString().trim();
    }

    private List clustersToNamedList(List<Cluster> carrotClusters, SolrParams solrParams) {
        ArrayList result = new ArrayList();
        this.clustersToNamedList(carrotClusters, result, solrParams.getBool("carrot.outputSubClusters", true), solrParams.getInt("carrot.numDescriptions", Integer.MAX_VALUE));
        return result;
    }

    private void clustersToNamedList(List<Cluster> outputClusters, List parent, boolean outputSubClusters, int maxLabels) {
        for (Cluster outCluster : outputClusters) {
            SimpleOrderedMap cluster = new SimpleOrderedMap();
            parent.add(cluster);
            List labels = outCluster.getPhrases();
            if (labels.size() > maxLabels) {
                labels = labels.subList(0, maxLabels);
            }
            cluster.add("labels", (Object)labels);
            List docs = outputSubClusters ? outCluster.getDocuments() : outCluster.getAllDocuments();
            ArrayList<Object> docList = new ArrayList<Object>();
            cluster.add("docs", docList);
            for (Document doc : docs) {
                docList.add(doc.getField("solrId"));
            }
            if (!outputSubClusters) continue;
            ArrayList subclusters = new ArrayList();
            cluster.add("clusters", subclusters);
            this.clustersToNamedList(outCluster.getSubclusters(), subclusters, outputSubClusters, maxLabels);
        }
    }

    private void extractCarrotAttributes(SolrParams solrParams, Map<String, Object> attributes) {
        Iterator paramNames = solrParams.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (CarrotParams.CARROT_PARAM_NAMES.contains(paramName)) continue;
            attributes.put(paramName, solrParams.get(paramName));
        }
    }
}

