/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.solr.common.util.XMLErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathRecordReader {
    private static final Logger LOG = LoggerFactory.getLogger(XPathRecordReader.class);
    private static final XMLErrorLogger XMLLOG = new XMLErrorLogger(LOG);
    private Node rootNode = new Node("/", null);
    public static final int FLATTEN = 1;
    static XMLInputFactory factory = XMLInputFactory.newInstance();
    private static final Pattern ATTRIB_PRESENT_WITHVAL;

    public XPathRecordReader(String forEachXpath) {
        String[] splits;
        for (String split : splits = forEachXpath.split("\\|")) {
            if ((split = split.trim()).startsWith("//")) {
                throw new RuntimeException("forEach cannot start with '//': " + split);
            }
            if (split.length() == 0) continue;
            this.addField0(split, split, false, true, 0);
        }
    }

    public synchronized XPathRecordReader addField(String name, String xpath, boolean multiValued) {
        this.addField0(xpath, name, multiValued, false, 0);
        return this;
    }

    public synchronized XPathRecordReader addField(String name, String xpath, boolean multiValued, int flags) {
        this.addField0(xpath, name, multiValued, false, flags);
        return this;
    }

    private void addField0(String xpath, String name, boolean multiValued, boolean isRecord, int flags) {
        if (!xpath.startsWith("/")) {
            throw new RuntimeException("xpath must start with '/' : " + xpath);
        }
        List<String> paths = XPathRecordReader.splitEscapeQuote(xpath);
        if ("".equals(paths.get(0).trim())) {
            paths.remove(0);
        }
        this.rootNode.build(paths, name, multiValued, isRecord, flags);
        this.rootNode.buildOptimise(null);
    }

    public List<Map<String, Object>> getAllRecords(Reader r) {
        final ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        this.streamRecords(r, new Handler(){

            @Override
            public void handle(Map<String, Object> record, String s) {
                results.add(record);
            }
        });
        return results;
    }

    public void streamRecords(Reader r, Handler handler) {
        try {
            XMLStreamReader parser = factory.createXMLStreamReader(r);
            this.rootNode.parse(parser, handler, new HashMap(), new Stack(), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> splitEscapeQuote(String str) {
        LinkedList<String> result = new LinkedList<String>();
        String[] ss = str.split("/");
        for (int i = 0; i < ss.length; ++i) {
            StringBuilder sb = new StringBuilder();
            int quoteCount = 0;
            while (true) {
                sb.append(ss[i]);
                for (int j = 0; j < ss[i].length(); ++j) {
                    if (ss[i].charAt(j) != '\'') continue;
                    ++quoteCount;
                }
                if (quoteCount % 2 == 0) break;
                ++i;
                sb.append("/");
            }
            result.add(sb.toString());
        }
        return result;
    }

    static {
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setXMLReporter((XMLReporter)XMLLOG);
        ATTRIB_PRESENT_WITHVAL = Pattern.compile("(\\S*?)?(\\[@)(\\S*?)(='(.*?)')?(\\])");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler {
        public void handle(Map<String, Object> var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        String name;
        String fieldName;
        String xpathName;
        String forEachPath;
        List<Node> attributes;
        List<Node> childNodes;
        List<Node> wildCardNodes;
        List<Map.Entry<String, String>> attribAndValues;
        Node wildAncestor;
        Node parent;
        boolean hasText = false;
        boolean multiValued = false;
        boolean isRecord = false;
        private boolean flatten;

        public Node(String name, Node p) {
            this.xpathName = this.name = name;
            this.parent = p;
        }

        public Node(String name, String fieldName, boolean multiValued) {
            this.name = name;
            this.fieldName = fieldName;
            this.multiValued = multiValued;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(XMLStreamReader parser, Handler handler, Map<String, Object> values, Stack<Set<String>> stack, boolean recordStarted) throws IOException, XMLStreamException {
            Set<Object> valuesAddedinThisFrame = null;
            if (this.isRecord) {
                recordStarted = true;
                valuesAddedinThisFrame = new HashSet();
                stack.push(valuesAddedinThisFrame);
            } else if (recordStarted) {
                valuesAddedinThisFrame = stack.peek();
            }
            try {
                if (this.attributes != null) {
                    for (Node node : this.attributes) {
                        String value = parser.getAttributeValue(null, node.name);
                        if (value == null && (!recordStarted || this.isRecord)) continue;
                        this.putText(values, value, node.fieldName, node.multiValued);
                        valuesAddedinThisFrame.add(node.fieldName);
                    }
                }
                HashSet<Node> childrenFound = new HashSet<Node>();
                int event = -1;
                int flattenedStarts = 0;
                StringBuilder text = new StringBuilder();
                while (true) {
                    if ((event = parser.next()) == 2) {
                        if (flattenedStarts > 0) {
                            --flattenedStarts;
                            continue;
                        }
                        if (this.hasText && valuesAddedinThisFrame != null) {
                            valuesAddedinThisFrame.add(this.fieldName);
                            this.putText(values, text.toString(), this.fieldName, this.multiValued);
                        }
                        if (this.isRecord) {
                            handler.handle(Node.getDeepCopy(values), this.forEachPath);
                        }
                        if (this.childNodes != null && recordStarted && !this.isRecord && !childrenFound.containsAll(this.childNodes)) {
                            for (Node n : this.childNodes) {
                                if (childrenFound.contains(n)) continue;
                                n.putNulls(values);
                            }
                        }
                        return;
                    }
                    if (this.hasText && (event == 12 || event == 4 || event == 6)) {
                        text.append(parser.getText());
                        continue;
                    }
                    if (event == 1) {
                        if (this.flatten) {
                            ++flattenedStarts;
                            continue;
                        }
                        this.handleStartElement(parser, childrenFound, handler, values, stack, recordStarted);
                        continue;
                    }
                    if (event == 8) break;
                }
                return;
            }
            finally {
                Set<String> cleanThis;
                if (!(!this.isRecord && recordStarted || stack.empty() || (cleanThis = stack.pop()) == null)) {
                    for (String fld : cleanThis) {
                        values.remove(fld);
                    }
                }
            }
        }

        private void handleStartElement(XMLStreamReader parser, Set<Node> childrenFound, Handler handler, Map<String, Object> values, Stack<Set<String>> stack, boolean recordStarted) throws IOException, XMLStreamException {
            Node n = this.getMatchingNode(parser, this.childNodes);
            HashMap<String, Node> decends = new HashMap<String, Node>();
            if (n != null) {
                childrenFound.add(n);
                n.parse(parser, handler, values, stack, recordStarted);
                return;
            }
            Node dn = this;
            do {
                if (dn.wildCardNodes == null) continue;
                n = this.getMatchingNode(parser, dn.wildCardNodes);
                if (n != null) {
                    childrenFound.add(n);
                    n.parse(parser, handler, values, stack, recordStarted);
                    break;
                }
                for (Node nn : dn.wildCardNodes) {
                    decends.put(nn.name, nn);
                }
            } while ((dn = dn.wildAncestor) != null);
            if (n == null) {
                int count = 1;
                while (count != 0) {
                    int token = parser.next();
                    if (token == 1) {
                        Node nn = (Node)decends.get(parser.getLocalName());
                        if (nn != null) {
                            childrenFound.add(nn);
                            nn.parse(parser, handler, values, stack, recordStarted);
                            continue;
                        }
                        ++count;
                        continue;
                    }
                    if (token != 2) continue;
                    --count;
                }
            }
        }

        private Node getMatchingNode(XMLStreamReader parser, List<Node> searchL) {
            if (searchL == null) {
                return null;
            }
            String localName = parser.getLocalName();
            for (Node n : searchL) {
                if (!n.name.equals(localName)) continue;
                if (n.attribAndValues == null) {
                    return n;
                }
                if (!this.checkForAttributes(parser, n.attribAndValues)) continue;
                return n;
            }
            return null;
        }

        private boolean checkForAttributes(XMLStreamReader parser, List<Map.Entry<String, String>> attrs) {
            for (Map.Entry<String, String> e : attrs) {
                String val = parser.getAttributeValue(null, e.getKey());
                if (val == null) {
                    return false;
                }
                if (e.getValue() == null || e.getValue().equals(val)) continue;
                return false;
            }
            return true;
        }

        private void putNulls(Map<String, Object> values) {
            if (this.attributes != null) {
                for (Node n : this.attributes) {
                    if (!n.multiValued) continue;
                    this.putText(values, null, n.fieldName, true);
                }
            }
            if (this.hasText && this.multiValued) {
                this.putText(values, null, this.fieldName, true);
            }
            if (this.childNodes != null) {
                for (Node childNode : this.childNodes) {
                    childNode.putNulls(values);
                }
            }
        }

        private void putText(Map<String, Object> values, String value, String fieldName, boolean multiValued) {
            if (multiValued) {
                ArrayList<String> v = (ArrayList<String>)values.get(fieldName);
                if (v == null) {
                    v = new ArrayList<String>();
                    values.put(fieldName, v);
                }
                v.add(value);
            } else {
                values.put(fieldName, value);
            }
        }

        private void buildOptimise(Node wa) {
            this.wildAncestor = wa;
            if (this.wildCardNodes != null) {
                wa = this;
            }
            if (this.childNodes != null) {
                for (Node n : this.childNodes) {
                    n.buildOptimise(wa);
                }
            }
        }

        private void build(List<String> paths, String fieldName, boolean multiValued, boolean record, int flags) {
            String xpseg = paths.remove(0);
            if (paths.isEmpty() && xpseg.startsWith("@")) {
                if (this.attributes == null) {
                    this.attributes = new ArrayList<Node>();
                }
                xpseg = xpseg.substring(1);
                this.attributes.add(new Node(xpseg, fieldName, multiValued));
            } else if (xpseg.length() == 0) {
                xpseg = paths.remove(0);
                if (this.wildCardNodes == null) {
                    this.wildCardNodes = new ArrayList<Node>();
                }
                Node n = this.getOrAddNode(xpseg, this.wildCardNodes);
                if (paths.isEmpty()) {
                    n.hasText = true;
                    n.fieldName = fieldName;
                    n.multiValued = multiValued;
                    n.flatten = flags == 1;
                } else {
                    n.build(paths, fieldName, multiValued, record, flags);
                }
            } else {
                if (this.childNodes == null) {
                    this.childNodes = new ArrayList<Node>();
                }
                Node n = this.getOrAddNode(xpseg, this.childNodes);
                if (paths.isEmpty()) {
                    if (record) {
                        n.isRecord = true;
                        n.forEachPath = fieldName;
                    } else {
                        n.hasText = true;
                        n.fieldName = fieldName;
                        n.multiValued = multiValued;
                        n.flatten = flags == 1;
                    }
                } else {
                    n.build(paths, fieldName, multiValued, record, flags);
                }
            }
        }

        private Node getOrAddNode(String xpathName, List<Node> searchList) {
            for (Node n : searchList) {
                if (!n.xpathName.equals(xpathName)) continue;
                return n;
            }
            Node n = new Node(xpathName, this);
            Matcher m = ATTRIB_PRESENT_WITHVAL.matcher(xpathName);
            if (m.find()) {
                n.name = m.group(1);
                int start = m.start(2);
                while (true) {
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    if (!m.find(start)) break;
                    attribs.put(m.group(3), m.group(5));
                    start = m.end(6);
                    if (n.attribAndValues == null) {
                        n.attribAndValues = new ArrayList<Map.Entry<String, String>>();
                    }
                    n.attribAndValues.addAll(attribs.entrySet());
                }
            }
            searchList.add(n);
            return n;
        }

        private static Map<String, Object> getDeepCopy(Map<String, Object> values) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                if (entry.getValue() instanceof List) {
                    result.put(entry.getKey(), new ArrayList((List)entry.getValue()));
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

