/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrUIMAConfigurationReader {
    private static final String AE_RUNTIME_PARAMETERS_NODE_PATH = "/config/uimaConfig/runtimeParameters";
    private static final String FIELD_MAPPING_NODE_PATH = "/config/uimaConfig/fieldMapping";
    private static final String ANALYZE_FIELDS_NODE_PATH = "/config/uimaConfig/analyzeFields";
    private static final String ANALYSIS_ENGINE_NODE_PATH = "/config/uimaConfig/analysisEngine";
    private SolrConfig solrConfig;

    public SolrUIMAConfigurationReader(SolrConfig solrConfig) {
        this.solrConfig = solrConfig;
    }

    public SolrUIMAConfiguration readSolrUIMAConfiguration() {
        return new SolrUIMAConfiguration(this.readAEPath(), this.readFieldsToAnalyze(), this.readFieldsMerging(), this.readTypesFeaturesFieldsMapping(), this.readAEOverridingParameters());
    }

    private String readAEPath() {
        return this.solrConfig.getNode(ANALYSIS_ENGINE_NODE_PATH, true).getTextContent();
    }

    private String[] readFieldsToAnalyze() {
        Node analyzeFieldsNode = this.solrConfig.getNode(ANALYZE_FIELDS_NODE_PATH, true);
        return analyzeFieldsNode.getTextContent().split(",");
    }

    private boolean readFieldsMerging() {
        Node analyzeFieldsNode = this.solrConfig.getNode(ANALYZE_FIELDS_NODE_PATH, true);
        Node mergeNode = analyzeFieldsNode.getAttributes().getNamedItem("merge");
        return Boolean.valueOf(mergeNode.getNodeValue());
    }

    private Map<String, Map<String, String>> readTypesFeaturesFieldsMapping() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        Node fieldMappingNode = this.solrConfig.getNode(FIELD_MAPPING_NODE_PATH, true);
        if (fieldMappingNode.hasChildNodes()) {
            NodeList typeNodes = fieldMappingNode.getChildNodes();
            for (int i = 0; i < typeNodes.getLength(); ++i) {
                Node typeNode = typeNodes.item(i);
                if (typeNode.getNodeType() == 3) continue;
                Node typeNameAttribute = typeNode.getAttributes().getNamedItem("name");
                String typeName = typeNameAttribute.getNodeValue();
                map.put(typeName, new HashMap());
                if (!typeNode.hasChildNodes()) continue;
                NodeList featuresNodeList = typeNode.getChildNodes();
                for (int j = 0; j < featuresNodeList.getLength(); ++j) {
                    Node mappingNode = featuresNodeList.item(j);
                    if (mappingNode.getNodeType() == 3) continue;
                    Node fieldNameNode = mappingNode.getAttributes().getNamedItem("field");
                    String mappedFieldName = fieldNameNode.getNodeValue();
                    Node featureNameNode = mappingNode.getAttributes().getNamedItem("feature");
                    String featureName = featureNameNode.getNodeValue();
                    ((Map)map.get(typeName)).put(featureName, mappedFieldName);
                }
            }
        }
        return map;
    }

    private Map<String, String> readAEOverridingParameters() {
        HashMap<String, String> runtimeParameters = new HashMap<String, String>();
        Node uimaConfigNode = this.solrConfig.getNode(AE_RUNTIME_PARAMETERS_NODE_PATH, true);
        if (uimaConfigNode.hasChildNodes()) {
            NodeList overridingNodes = uimaConfigNode.getChildNodes();
            for (int i = 0; i < overridingNodes.getLength(); ++i) {
                Node overridingNode = overridingNodes.item(i);
                if (overridingNode.getNodeType() == 3) continue;
                runtimeParameters.put(overridingNode.getNodeName(), overridingNode.getTextContent());
            }
        }
        return runtimeParameters;
    }
}

