/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMAToSolrMapper {
    private final Logger log = LoggerFactory.getLogger(UIMAToSolrMapper.class);
    private SolrInputDocument document;
    private JCas cas;

    public UIMAToSolrMapper(SolrInputDocument document, JCas cas) {
        this.document = document;
        this.cas = cas;
    }

    public void map(String typeName, Map<String, String> featureFieldsmapping) {
        try {
            FeatureStructure fsMock = (FeatureStructure)Class.forName(typeName).getConstructor(JCas.class).newInstance(this.cas);
            Type type = fsMock.getType();
            FSIterator iterator = this.cas.getFSIndexRepository().getAllIndexedFS(type);
            while (iterator.hasNext()) {
                FeatureStructure fs = (FeatureStructure)iterator.next();
                for (String featureName : featureFieldsmapping.keySet()) {
                    String fieldName = featureFieldsmapping.get(featureName);
                    this.log.info(new StringBuffer("mapping ").append(typeName).append("@").append(featureName).append(" to ").append(fieldName).toString());
                    String featureValue = null;
                    featureValue = fs instanceof Annotation && "coveredText".equals(featureName) ? ((Annotation)fs).getCoveredText() : fs.getFeatureValueAsString(type.getFeatureByBaseName(featureName));
                    this.log.info(new StringBuffer("writing ").append(featureValue).append(" in ").append(fieldName).toString());
                    this.document.addField(fieldName, (Object)featureValue, 1.0f);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage());
        }
    }
}

