/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.apache.solr.uima.processor.SolrUIMAConfigurationReader;
import org.apache.solr.uima.processor.UIMAToSolrMapper;
import org.apache.solr.uima.processor.ae.AEProvider;
import org.apache.solr.uima.processor.ae.AEProviderFactory;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class UIMAUpdateRequestProcessor
extends UpdateRequestProcessor {
    private SolrUIMAConfiguration solrUIMAConfiguration;
    private AEProvider aeProvider;

    public UIMAUpdateRequestProcessor(UpdateRequestProcessor next, SolrCore solrCore) {
        super(next);
        this.initialize(solrCore);
    }

    private void initialize(SolrCore solrCore) {
        SolrUIMAConfigurationReader uimaConfigurationReader = new SolrUIMAConfigurationReader(solrCore.getSolrConfig());
        this.solrUIMAConfiguration = uimaConfigurationReader.readSolrUIMAConfiguration();
        this.aeProvider = AEProviderFactory.getInstance().getAEProvider(solrCore.getName(), this.solrUIMAConfiguration.getAePath(), this.solrUIMAConfiguration.getRuntimeParameters());
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        try {
            SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
            for (String text : this.getTextsToAnalyze(solrInputDocument)) {
                if (text == null || "".equals(text)) continue;
                JCas jcas = this.processText(text);
                UIMAToSolrMapper uimaToSolrMapper = new UIMAToSolrMapper(solrInputDocument, jcas);
                Map<String, Map<String, String>> typesAndFeaturesFieldsMap = this.solrUIMAConfiguration.getTypesFeaturesFieldsMapping();
                for (String typeFQN : typesAndFeaturesFieldsMap.keySet()) {
                    uimaToSolrMapper.map(typeFQN, typesAndFeaturesFieldsMap.get(typeFQN));
                }
            }
        }
        catch (UIMAException e) {
            throw new RuntimeException(e);
        }
        super.processAdd(cmd);
    }

    private String[] getTextsToAnalyze(SolrInputDocument solrInputDocument) {
        String[] fieldsToAnalyze = this.solrUIMAConfiguration.getFieldsToAnalyze();
        boolean merge = this.solrUIMAConfiguration.isFieldsMerging();
        String[] textVals = null;
        if (merge) {
            StringBuilder unifiedText = new StringBuilder("");
            for (int i = 0; i < fieldsToAnalyze.length; ++i) {
                unifiedText.append(String.valueOf(solrInputDocument.getFieldValue(fieldsToAnalyze[i])));
            }
            textVals = new String[]{unifiedText.toString()};
        } else {
            textVals = new String[fieldsToAnalyze.length];
            for (int i = 0; i < fieldsToAnalyze.length; ++i) {
                textVals[i] = String.valueOf(solrInputDocument.getFieldValue(fieldsToAnalyze[i]));
            }
        }
        return textVals;
    }

    private JCas processText(String textFieldValue) throws ResourceInitializationException, AnalysisEngineProcessException {
        log.info(new StringBuffer("Analazying text").toString());
        AnalysisEngine ae = this.aeProvider.getAE();
        JCas jcas = ae.newJCas();
        jcas.setDocumentText(textFieldValue);
        ae.process(jcas);
        log.info("Text processing completed");
        return jcas;
    }
}

