/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.TestRelation;
import org.apache.spark.sql.catalyst.analysis.TestRelationAcceptAnySchema;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y4Q\u0001E\t\u0002\u0002yAQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-Bq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001J\u0011\u0019y\u0005\u0001)A\u0005\u0015\"9\u0001\u000b\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0003S\u0001\u0019\u00051\u000bC\u0003[\u0001\u0019\u00051\fC\u0003_\u0001\u0011\u0005q\fC\u0003g\u0001\u0011\u0005q\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003t\u0001\u0011EA\u000fC\u0003v\u0001\u0011EAO\u0001\rWe]\u0013\u0018\u000e^3B]\u0006d\u0017p]5t'VLG/\u001a\"bg\u0016T!AE\n\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001F\u000b\u0002\u0011\r\fG/\u00197zgRT!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010$!\t\u0001\u0013%D\u0001\u0018\u0013\t\u0011sCA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003I\u0015j\u0011!E\u0005\u0003ME\u0011A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005\u0011\u0002\u0011!F3yi\u0016tG-\u001a3B]\u0006d\u0017p]5t%VdWm]\u000b\u0002YA\u0019Qf\u000e\u001e\u000f\u00059\"dBA\u00183\u001b\u0005\u0001$BA\u0019\u001e\u0003\u0019a$o\\8u}%\t1'A\u0003tG\u0006d\u0017-\u0003\u00026m\u00059\u0001/Y2lC\u001e,'\"A\u001a\n\u0005aJ$aA*fc*\u0011QG\u000e\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0005u\u001a\u0012!\u0002:vY\u0016\u001c\u0018BA =\u0005\u0011\u0011V\u000f\\3\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000bN\tQ\u0001\u001d7b]NL!a\u0012\"\u0003\u00171{w-[2bYBc\u0017M\\\u0001\u0006i\u0006\u0014G.Z\u000b\u0002\u0015B\u0011AeS\u0005\u0003\u0019F\u0011A\u0002V3tiJ+G.\u0019;j_:\fa\u0001^1cY\u0016\u0004\u0013!\u0004:fcVL'/\u001a3UC\ndW-\u0001\bsKF,\u0018N]3e)\u0006\u0014G.\u001a\u0011\u0002\u0015]LG-\u001a:UC\ndW-A\u0006xS\u0012,'\u000fV1cY\u0016\u0004\u0013A\u00022z\u001d\u0006lW\rF\u0002A)bCQ\u0001S\u0005A\u0002U\u0003\"\u0001\n,\n\u0005]\u000b\"!\u0004(b[\u0016$'+\u001a7bi&|g\u000eC\u0003Z\u0013\u0001\u0007\u0001)A\u0003rk\u0016\u0014\u00180\u0001\u0006csB{7/\u001b;j_:$2\u0001\u0011/^\u0011\u0015A%\u00021\u0001V\u0011\u0015I&\u00021\u0001A\u0003E\t7o]3si:{GOU3t_24X\r\u001a\u000b\u0003A\u0012\u0004\"!\u00192\u000e\u0003YJ!a\u0019\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006K.\u0001\r\u0001Q\u0001\fY><\u0017nY1m!2\fg.\u0001\bbgN,'\u000f\u001e*fg>dg/\u001a3\u0015\u0005\u0001D\u0007\"B3\r\u0001\u0004\u0001\u0015a\u0002;p\u0019><XM\u001d\u000b\u0003WF\u0004\"\u0001\\8\u000e\u00035T!A\\\n\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003a6\u0014!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\")!/\u0004a\u0001W\u0006!\u0011\r\u001e;s\u0003\u0005\"Xm\u001d;SKN|GN^3e\u001fZ,'o\u001e:ji\u0016\u0014\u00150\u0012=qe\u0016\u001c8/[8o)\u0005\u0001\u0017\u0001\n;fgRtu\u000e\u001e*fg>dg/\u001a3Pm\u0016\u0014xO]5uK\nKX\t\u001f9sKN\u001c\u0018n\u001c8")
public abstract class V2WriteAnalysisSuiteBase
extends SparkFunSuite
implements AnalysisTest {
    private final TestRelation table;
    private final TestRelation requiredTable;
    private final TestRelation widerTable;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public /* synthetic */ Option org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$3() {
        return super.checkError$default$3();
    }

    @Override
    public /* synthetic */ boolean org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$5() {
        return super.checkError$default$5();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError(SparkThrowable exception, String errorClass, Option sqlState, Map parameters, boolean matchPVals, QueryContext[] queryContext) {
        super.checkError(exception, errorClass, sqlState, parameters, matchPVals, queryContext);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, Map<String, String> expectedMessageParameters, QueryContext[] queryContext, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, queryContext, caseSensitive);
    }

    @Override
    public QueryContext[] assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$5() {
        return AnalysisTest.assertAnalysisErrorClass$default$5$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public ParseException parseException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.parseException$(this, parser, sqlText);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        V2WriteAnalysisSuiteBase v2WriteAnalysisSuiteBase = this;
        synchronized (v2WriteAnalysisSuiteBase) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return (Seq)new .colon.colon((Object)EliminateSubqueryAliases$.MODULE$, (List)Nil$.MODULE$);
    }

    public TestRelation table() {
        return this.table;
    }

    public TestRelation requiredTable() {
        return this.requiredTable;
    }

    public TestRelation widerTable() {
        return this.widerTable;
    }

    public abstract LogicalPlan byName(NamedRelation var1, LogicalPlan var2);

    public abstract LogicalPlan byPosition(NamedRelation var1, LogicalPlan var2);

    public void assertNotResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Plan should not be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
    }

    public void assertResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(25).append("Plan should be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
    }

    public AttributeReference toLower(AttributeReference attr) {
        String x$1 = attr.name().toLowerCase(Locale.ROOT);
        DataType x$2 = attr.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = attr.exprId();
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public void testResolvedOverwriteByExpression() {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
        AttributeReference a = (AttributeReference)query.output().head();
        AttributeReference b = (AttributeReference)query.output().last();
        AttributeReference x = (AttributeReference)table.output().head();
        OverwriteByExpression parsedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        Cast x$1 = new Cast((Expression)a, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
        String x$2 = "x";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
        Cast x$7 = new Cast((Expression)b, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
        String x$8 = "y";
        ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
        Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
        Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
        Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
        OverwriteByExpression expectedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6), (List)new .colon.colon((Object)new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12), (List)Nil$.MODULE$)), (LogicalPlan)query), (Expression)new LessThanOrEqual((Expression)x, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan);
        this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
        this.assertResolved((LogicalPlan)expectedPlan);
    }

    public void testNotResolvedOverwriteByExpression() {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
        OverwriteByExpression parsedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan);
        this.assertAnalysisErrorClass((LogicalPlan)parsedPlan, "UNRESOLVED_COLUMN.WITH_SUGGESTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`a`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`x`, `y`")}))), this.assertAnalysisErrorClass$default$4(), this.assertAnalysisErrorClass$default$5());
        TestRelationAcceptAnySchema tableAcceptAnySchema = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
        OverwriteByExpression parsedPlan2 = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)tableAcceptAnySchema, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan2);
        this.assertAnalysisErrorClass((LogicalPlan)parsedPlan2, "UNRESOLVED_COLUMN.WITH_SUGGESTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`a`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`x`, `y`")}))), this.assertAnalysisErrorClass$default$4(), this.assertAnalysisErrorClass$default$5());
    }

    private final void assertTypeCompatibility$1(String name, DataType fromType, DataType toType) {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", toType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", fromType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
        LogicalPlan parsedPlan = this.byName(table, query);
        this.assertResolved(parsedPlan);
        this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
    }

    public V2WriteAnalysisSuiteBase() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).float(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).float(), (List)Nil$.MODULE$))));
        this.requiredTable = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).float()).notNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).float()).notNull(), (List)Nil$.MODULE$))));
        this.widerTable = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).double(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).double(), (List)Nil$.MODULE$))));
        this.test("SPARK-33136: output resolved on complex types for V2 write commands", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType fromStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("i_nonnull", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("st", (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("l", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("s_nonnull", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            StructType toStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("i_nonnull", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("st", (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("l", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("s_nonnull", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.assertTypeCompatibility$1("struct", (DataType)fromStructType, (DataType)toStructType);
            this.assertTypeCompatibility$1("array", (DataType)new ArrayType((DataType)LongType$.MODULE$, false), (DataType)new ArrayType((DataType)LongType$.MODULE$, true));
            ArrayType fromArrayWithStructType = new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), false);
            ArrayType toArrayWithStructType = new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), true);
            this.assertTypeCompatibility$1("array_struct", (DataType)fromArrayWithStructType, (DataType)toArrayWithStructType);
            this.assertTypeCompatibility$1("map", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
            MapType fromMapWithStructType = new MapType((DataType)IntegerType$.MODULE$, (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), false);
            MapType toMapWithStructType = new MapType((DataType)IntegerType$.MODULE$, (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), true);
            this.assertTypeCompatibility$1("map_struct", (DataType)fromMapWithStructType, (DataType)toMapWithStructType);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("skipSchemaResolution should still require query to be resolved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelationAcceptAnySchema table = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            UnresolvedRelation query = new UnresolvedRelation((Seq)new .colon.colon((Object)"t", (List)Nil$.MODULE$), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3());
            LogicalPlan parsedPlan = this.byName(table, (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        this.test("byName: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)this.table().schema().toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            this.assertResolved(parsedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("byName: does not match by position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot find data for output column", (List)new .colon.colon((Object)"'x'", (List)new .colon.colon((Object)"'y'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("byName: case sensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot find data for output column", (List)new .colon.colon((Object)"'x'", (List)Nil$.MODULE$))))), true);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("byName: case insensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            AttributeReference X = (AttributeReference)query.output().head();
            AttributeReference y = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            LogicalPlan expectedPlan = this.byName(this.table(), (LogicalPlan)new Project((Seq)new .colon.colon((Object)X.withName("x"), (List)new .colon.colon((Object)y, (List)Nil$.MODULE$)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, false);
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("byName: data columns are reordered by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            LogicalPlan expectedPlan = this.byName(this.table(), (LogicalPlan)new Project((Seq)new .colon.colon((Object)x, (List)new .colon.colon((Object)y, (List)Nil$.MODULE$)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("byName: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byName(this.requiredTable(), this.table());
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot write nullable values to non-null column", (List)new .colon.colon((Object)"'x'", (List)new .colon.colon((Object)"'y'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        this.test("byName: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byName(this.table(), this.requiredTable());
            this.assertResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("byName: missing required columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.requiredTable(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot find data for output column", (List)new .colon.colon((Object)"'x'", (List)Nil$.MODULE$))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("byName: missing optional columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot find data for output column", (List)new .colon.colon((Object)"'x'", (List)Nil$.MODULE$))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        this.test("byName: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            LogicalPlan parsedPlan = this.byName(this.widerTable(), this.table());
            Cast x$1 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$2 = "x";
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            Cast x$7 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$8 = "y";
            ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
            Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
            Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
            Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
            LogicalPlan expectedPlan = this.byName(this.widerTable(), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6), (List)new .colon.colon((Object)new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12), (List)Nil$.MODULE$)), (LogicalPlan)this.table()));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("byName: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"too many data columns", (List)new .colon.colon((Object)"Table columns: 'x', 'y'", (List)new .colon.colon((Object)"Data columns: 'x', 'y', 'z'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("byName: fail extra data fields in struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int()})), (List)Nil$.MODULE$))));
            TestRelation query = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"z"}))).$((Seq)Nil$.MODULE$)).int()})), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))));
            LogicalPlan writePlan = this.byName(table, query);
            this.assertAnalysisError(writePlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot write extra fields to struct 'b': 'z'", (List)Nil$.MODULE$)))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("byPosition: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            AttributeReference a = (AttributeReference)query.output().head();
            AttributeReference b = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byPosition(this.table(), query);
            Cast x$13 = new Cast((Expression)a, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$14 = "x";
            ExprId x$15 = Alias$.MODULE$.apply$default$3((Expression)x$13, x$14);
            Seq x$16 = Alias$.MODULE$.apply$default$4((Expression)x$13, x$14);
            Option x$17 = Alias$.MODULE$.apply$default$5((Expression)x$13, x$14);
            Seq x$18 = Alias$.MODULE$.apply$default$6((Expression)x$13, x$14);
            Cast x$19 = new Cast((Expression)b, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$20 = "y";
            ExprId x$21 = Alias$.MODULE$.apply$default$3((Expression)x$19, x$20);
            Seq x$22 = Alias$.MODULE$.apply$default$4((Expression)x$19, x$20);
            Option x$23 = Alias$.MODULE$.apply$default$5((Expression)x$19, x$20);
            Seq x$24 = Alias$.MODULE$.apply$default$6((Expression)x$19, x$20);
            LogicalPlan expectedPlan = this.byPosition(this.table(), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$13, x$14, x$15, x$16, x$17, x$18), (List)new .colon.colon((Object)new Alias((Expression)x$19, x$20, x$21, x$22, x$23, x$24), (List)Nil$.MODULE$)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, false);
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("byPosition: data columns are not reordered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byPosition(this.table(), query);
            Cast x$25 = new Cast((Expression)y, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$26 = "x";
            ExprId x$27 = Alias$.MODULE$.apply$default$3((Expression)x$25, x$26);
            Seq x$28 = Alias$.MODULE$.apply$default$4((Expression)x$25, x$26);
            Option x$29 = Alias$.MODULE$.apply$default$5((Expression)x$25, x$26);
            Seq x$30 = Alias$.MODULE$.apply$default$6((Expression)x$25, x$26);
            Cast x$31 = new Cast((Expression)x, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$32 = "y";
            ExprId x$33 = Alias$.MODULE$.apply$default$3((Expression)x$31, x$32);
            Seq x$34 = Alias$.MODULE$.apply$default$4((Expression)x$31, x$32);
            Option x$35 = Alias$.MODULE$.apply$default$5((Expression)x$31, x$32);
            Seq x$36 = Alias$.MODULE$.apply$default$6((Expression)x$31, x$32);
            LogicalPlan expectedPlan = this.byPosition(this.table(), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$25, x$26, x$27, x$28, x$29, x$30), (List)new .colon.colon((Object)new Alias((Expression)x$31, x$32, x$33, x$34, x$35, x$36), (List)Nil$.MODULE$)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        this.test("byPosition: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byPosition(this.requiredTable(), this.table());
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot write nullable values to non-null column", (List)new .colon.colon((Object)"'x'", (List)new .colon.colon((Object)"'y'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("byPosition: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byPosition(this.table(), this.requiredTable());
            this.assertResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("byPosition: missing required columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
            LogicalPlan parsedPlan = this.byPosition(this.requiredTable(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"not enough data columns", (List)new .colon.colon((Object)"Table columns: 'x', 'y'", (List)new .colon.colon((Object)"Data columns: 'y'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("byPosition: missing optional columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
            LogicalPlan parsedPlan = this.byPosition(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"not enough data columns", (List)new .colon.colon((Object)"Table columns: 'x', 'y'", (List)new .colon.colon((Object)"Data columns: 'y'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.test("byPosition: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            LogicalPlan parsedPlan = this.byPosition(widerTable, this.table());
            Cast x$37 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$38 = "a";
            ExprId x$39 = Alias$.MODULE$.apply$default$3((Expression)x$37, x$38);
            Seq x$40 = Alias$.MODULE$.apply$default$4((Expression)x$37, x$38);
            Option x$41 = Alias$.MODULE$.apply$default$5((Expression)x$37, x$38);
            Seq x$42 = Alias$.MODULE$.apply$default$6((Expression)x$37, x$38);
            Cast x$43 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
            String x$44 = "b";
            ExprId x$45 = Alias$.MODULE$.apply$default$3((Expression)x$43, x$44);
            Seq x$46 = Alias$.MODULE$.apply$default$4((Expression)x$43, x$44);
            Option x$47 = Alias$.MODULE$.apply$default$5((Expression)x$43, x$44);
            Seq x$48 = Alias$.MODULE$.apply$default$6((Expression)x$43, x$44);
            LogicalPlan expectedPlan = this.byPosition(widerTable, (LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$37, x$38, x$39, x$40, x$41, x$42), (List)new .colon.colon((Object)new Alias((Expression)x$43, x$44, x$45, x$46, x$47, x$48), (List)Nil$.MODULE$)), (LogicalPlan)this.table()));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("byPosition: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"too many data columns", (List)new .colon.colon((Object)"Table columns: 'x', 'y'", (List)new .colon.colon((Object)"Data columns: 'a', 'b', 'c'", (List)Nil$.MODULE$)))))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("bypass output column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelationAcceptAnySchema table = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)).toAttributes());
            this.withClue("byName", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byName(table, query);
                this.assertResolved(parsedPlan);
                this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            });
            this.withClue("byPosition", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byPosition(table, query);
                this.assertResolved(parsedPlan);
                this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            });
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        this.test("check fields of struct type column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation tableWithStructCol = new TestRelation((Seq<AttributeReference>)new StructType().add("col", (DataType)new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$)).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)new StructType().add("col", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$)).toAttributes());
            this.withClue("byName", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byName(tableWithStructCol, query);
                this.assertNotResolved(parsedPlan);
                this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot find data for output column 'col.a'", (List)new .colon.colon((Object)"Cannot find data for output column 'col.b'", (List)Nil$.MODULE$))))), this.assertAnalysisError$default$3());
            });
            this.withClue("byPosition", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byPosition(tableWithStructCol, query);
                this.assertNotResolved(parsedPlan);
                Cast x$49 = new Cast((Expression)query.output().head(), (DataType)new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$), (Option)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
                String x$50 = "col";
                ExprId x$51 = Alias$.MODULE$.apply$default$3((Expression)x$49, x$50);
                Seq x$52 = Alias$.MODULE$.apply$default$4((Expression)x$49, x$50);
                Option x$53 = Alias$.MODULE$.apply$default$5((Expression)x$49, x$50);
                Seq x$54 = Alias$.MODULE$.apply$default$6((Expression)x$49, x$50);
                Project expectedQuery = new Project((Seq)new .colon.colon((Object)new Alias((Expression)x$49, x$50, x$51, x$52, x$53, x$54), (List)Nil$.MODULE$), (LogicalPlan)query);
                this.checkAnalysis(parsedPlan, this.byPosition(tableWithStructCol, (LogicalPlan)expectedQuery), this.checkAnalysis$default$3());
            });
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
        this.test("SPARK-36498: reorder inner fields with byName mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestRelation table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int()})), (List)Nil$.MODULE$))));
            TestRelation query = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).byte()})), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))));
            LogicalPlan writePlan = package.plans$.MODULE$.DslLogicalPlan(this.byName(table, query)).analyze();
            StructType $org_scalatest_assert_macro_left = ((QueryPlan)writePlan.children().head()).schema();
            StructType $org_scalatest_assert_macro_right = table.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        this.test("SPARK-36498: reorder inner fields in array of struct with byName mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestRelation table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"arr"}))).$((Seq)Nil$.MODULE$)).array((DataType)new StructType().add("x", "int").add("y", "int")), (List)Nil$.MODULE$))));
            TestRelation query = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"arr"}))).$((Seq)Nil$.MODULE$)).array((DataType)new StructType().add("y", "int").add("x", "byte")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))));
            LogicalPlan writePlan = package.plans$.MODULE$.DslLogicalPlan(this.byName(table, query)).analyze();
            StructType $org_scalatest_assert_macro_left = ((QueryPlan)writePlan.children().head()).schema();
            StructType $org_scalatest_assert_macro_right = table.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        this.test("SPARK-36498: reorder inner fields in map of struct with byName mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestRelation table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "m")).map((DataType)new StructType().add("x", "int").add("y", "int"), (DataType)new StructType().add("x", "int").add("y", "int")), (List)Nil$.MODULE$))));
            TestRelation query = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "m")).map((DataType)new StructType().add("y", "int").add("x", "byte"), (DataType)new StructType().add("y", "int").add("x", "byte")), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))));
            LogicalPlan writePlan = package.plans$.MODULE$.DslLogicalPlan(this.byName(table, query)).analyze();
            StructType $org_scalatest_assert_macro_left = ((QueryPlan)writePlan.children().head()).schema();
            StructType $org_scalatest_assert_macro_right = table.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        this.test("SPARK-42608: use full column names for inner fields in resolution errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation table = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).int()).notNull(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int()})), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int()})), (List)Nil$.MODULE$)))));
            TestRelation query = new TestRelation((Seq<AttributeReference>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).byte()})), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).byte()})), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)))));
            LogicalPlan parsedPlan = this.byName(table, query);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)new .colon.colon((Object)"Cannot write incompatible data to table", (List)new .colon.colon((Object)"'table-name'", (List)new .colon.colon((Object)"Cannot write nullable values to non-null column 'b.x'", (List)Nil$.MODULE$)))), this.assertAnalysisError$default$3());
        }, new Position("V2WriteAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
    }
}

