/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.statsEstimation;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.statsEstimation.JoinEstimationSuite;
import org.apache.spark.sql.catalyst.statsEstimation.JoinEstimationSuite$MyStatsTestPlan$2$;
import org.apache.spark.sql.catalyst.statsEstimation.StatsEstimationTestBase;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan$;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\t\u0013\u0001}AQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004<\u0001\u0001\u0006I!\f\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019\t\u0006\u0001)A\u0005}!9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB-\u0001A\u0003%A\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r}\u0003\u0001\u0015!\u0003]\u0011\u001d\u0001\u0007A1A\u0005\nmCa!\u0019\u0001!\u0002\u0013a\u0006b\u00022\u0001\u0005\u0004%Ia\u0017\u0005\u0007G\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0011\u0004A\u0011B3\t\u000by\u0004A\u0011B@\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\t\u0019\"j\\5o\u000bN$\u0018.\\1uS>t7+^5uK*\u00111\u0003F\u0001\u0010gR\fGo]#ti&l\u0017\r^5p]*\u0011QCF\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0003G\u0001\u0004gFd'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0013\u0011\u0005\u0005\u0012S\"\u0001\r\n\u0005\rB\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002&M5\t!#\u0003\u0002(%\t92\u000b^1ug\u0016\u001bH/[7bi&|g\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"!\n\u0001\u0002\u0015\r|G.^7o\u0013:4w.F\u0001.!\rq\u0013gM\u0007\u0002_)\u0011\u0001\u0007F\u0001\fKb\u0004(/Z:tS>t7/\u0003\u00023_\ta\u0011\t\u001e;sS\n,H/Z'baB\u0011A'O\u0007\u0002k)\u0011agN\u0001\bY><\u0017nY1m\u0015\tAD#A\u0003qY\u0006t7/\u0003\u0002;k\tQ1i\u001c7v[:\u001cF/\u0019;\u0002\u0017\r|G.^7o\u0013:4w\u000eI\u0001\u000b]\u0006lW\rV8BiR\u0014X#\u0001 \u0011\t}B5J\u0014\b\u0003\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0004\u001b\u0006\u0004(BA$E!\tyD*\u0003\u0002N\u0015\n11\u000b\u001e:j]\u001e\u0004\"AL(\n\u0005A{#!C!uiJL'-\u001e;f\u0003-q\u0017-\\3U_\u0006#HO\u001d\u0011\u0002\u001b9\fW.\u001a+p\u0007>d\u0017J\u001c4p+\u0005!\u0006\u0003B I\u0017V\u0003BAV,Og5\tA)\u0003\u0002Y\t\n1A+\u001e9mKJ\naB\\1nKR{7i\u001c7J]\u001a|\u0007%\u0001\u0004uC\ndW-M\u000b\u00029B\u0011Q%X\u0005\u0003=J\u0011Qb\u0015;biN$Vm\u001d;QY\u0006t\u0017a\u0002;bE2,\u0017\u0007I\u0001\u0007i\u0006\u0014G.\u001a\u001a\u0002\u000fQ\f'\r\\33A\u00051A/\u00192mKN\nq\u0001^1cY\u0016\u001c\u0004%A\nfgRLW.\u0019;f\u0005fD\u0015n\u001d;pOJ\fW\u000eF\u0004gS:\u0004Xo\u001e?\u0011\u0005Y;\u0017B\u00015E\u0005\u0011)f.\u001b;\t\u000b)t\u0001\u0019A6\u0002\u001b1,g\r\u001e%jgR|wM]1n!\t!D.\u0003\u0002nk\tI\u0001*[:u_\u001e\u0014\u0018-\u001c\u0005\u0006_:\u0001\ra[\u0001\u000fe&<\u0007\u000e\u001e%jgR|wM]1n\u0011\u0015\th\u00021\u0001s\u0003-)\u0007\u0010]3di\u0016$W*\u001b8\u0011\u0005Y\u001b\u0018B\u0001;E\u0005\r\te.\u001f\u0005\u0006m:\u0001\rA]\u0001\fKb\u0004Xm\u0019;fI6\u000b\u0007\u0010C\u0003y\u001d\u0001\u0007\u00110A\u0006fqB,7\r^3e\u001d\u00124\bC\u0001,{\u0013\tYHI\u0001\u0003M_:<\u0007\"B?\u000f\u0001\u0004I\u0018\u0001D3ya\u0016\u001cG/\u001a3S_^\u001c\u0018!E4f]\u0016\u0014\u0018\r^3K_&t7\t[5mIRQ\u0011\u0011AA\u0004\u0003\u0017\ty!!\u0005\u0011\u0007Q\n\u0019!C\u0002\u0002\u0006U\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"1\u0011\u0011B\bA\u00029\u000b1aY8m\u0011\u0019\tia\u0004a\u0001W\u0006I\u0001.[:u_\u001e\u0014\u0018-\u001c\u0005\u0006c>\u0001\rA\u001d\u0005\u0006m>\u0001\rA]\u0001\u0010S:4WM]\"pYVlgn\u0015;biR91'a\u0006\u0002\u001a\u0005m\u0001BBA\u0007!\u0001\u00071\u000eC\u0003r!\u0001\u0007!\u000fC\u0003w!\u0001\u0007!\u000f")
public class JoinEstimationSuite
extends SparkFunSuite
implements StatsEstimationTestBase {
    private final AttributeMap<ColumnStat> columnInfo;
    private final Map<String, Attribute> nameToAttr;
    private final Map<String, Tuple2<Attribute, ColumnStat>> nameToColInfo;
    private final StatsTestPlan table1;
    private final StatsTestPlan table2;
    private final StatsTestPlan table3;
    private boolean originalCBOValue;
    private boolean originalPlanStatsValue;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        StatsEstimationTestBase.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        StatsEstimationTestBase.afterAll$(this);
    }

    @Override
    public long getColSize(Attribute attribute, ColumnStat colStat) {
        return StatsEstimationTestBase.getColSize$(this, attribute, colStat);
    }

    @Override
    public AttributeReference attr(String colName) {
        return StatsEstimationTestBase.attr$(this, colName);
    }

    @Override
    public AttributeMap<ColumnStat> toAttributeMap(Seq<Tuple2<String, ColumnStat>> colStats, LogicalPlan plan) {
        return StatsEstimationTestBase.toAttributeMap$(this, colStats, plan);
    }

    @Override
    public ColumnStat rangeColumnStat(int distinctCount, int nullCount) {
        return StatsEstimationTestBase.rangeColumnStat$(this, distinctCount, nullCount);
    }

    @Override
    public boolean originalCBOValue() {
        return this.originalCBOValue;
    }

    @Override
    public void originalCBOValue_$eq(boolean x$1) {
        this.originalCBOValue = x$1;
    }

    @Override
    public boolean originalPlanStatsValue() {
        return this.originalPlanStatsValue;
    }

    @Override
    public void originalPlanStatsValue_$eq(boolean x$1) {
        this.originalPlanStatsValue = x$1;
    }

    private AttributeMap<ColumnStat> columnInfo() {
        return this.columnInfo;
    }

    private Map<String, Attribute> nameToAttr() {
        return this.nameToAttr;
    }

    private Map<String, Tuple2<Attribute, ColumnStat>> nameToColInfo() {
        return this.nameToColInfo;
    }

    private StatsTestPlan table1() {
        return this.table1;
    }

    private StatsTestPlan table2() {
        return this.table2;
    }

    private StatsTestPlan table3() {
        return this.table3;
    }

    private void estimateByHistogram(Histogram leftHistogram, Histogram rightHistogram, Object expectedMin, Object expectedMax, long expectedNdv, long expectedRows) {
        AttributeReference col1 = this.attr("key1");
        AttributeReference col2 = this.attr("key2");
        LogicalPlan c1 = this.generateJoinChild((Attribute)col1, leftHistogram, expectedMin, expectedMax);
        LogicalPlan c2 = this.generateJoinChild((Attribute)col2, rightHistogram, expectedMin, expectedMax);
        Join c1JoinC2 = new Join(c1, c2, (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)col1, (Expression)col2)), JoinHint$.MODULE$.NONE());
        Join c2JoinC1 = new Join(c2, c1, (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)col2, (Expression)col1)), JoinHint$.MODULE$.NONE());
        ColumnStat qual$1 = (ColumnStat)c1.stats().attributeStats().apply((Object)col1);
        Some x$1 = new Some((Object)BigInt$.MODULE$.long2bigInt(expectedNdv));
        Some x$2 = new Some(expectedMin);
        Some x$3 = new Some(expectedMax);
        Option x$4 = qual$1.copy$default$4();
        Option x$5 = qual$1.copy$default$5();
        Option x$6 = qual$1.copy$default$6();
        Option x$7 = qual$1.copy$default$7();
        int x$8 = qual$1.copy$default$8();
        ColumnStat qual$2 = (ColumnStat)c2.stats().attributeStats().apply((Object)col2);
        Some x$9 = new Some((Object)BigInt$.MODULE$.long2bigInt(expectedNdv));
        Some x$10 = new Some(expectedMin);
        Some x$11 = new Some(expectedMax);
        Option x$12 = qual$2.copy$default$4();
        Option x$13 = qual$2.copy$default$5();
        Option x$14 = qual$2.copy$default$6();
        Option x$15 = qual$2.copy$default$7();
        int x$16 = qual$2.copy$default$8();
        Statistics expectedStatsAfterJoin = new Statistics(BigInt$.MODULE$.long2bigInt(expectedRows * 16L), (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(expectedRows)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)col1), (Object)qual$1.copy((Option)x$1, (Option)x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)col2), (Object)qual$2.copy((Option)x$9, (Option)x$10, (Option)x$11, x$12, x$13, x$14, x$15, x$16)), (List)Nil$.MODULE$))), Statistics$.MODULE$.apply$default$4());
        ((IterableLike)new .colon.colon((Object)c1JoinC2, (List)new .colon.colon((Object)c2JoinC1, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)join -> {
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStatsAfterJoin;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        });
    }

    private LogicalPlan generateJoinChild(Attribute col, Histogram histogram, Object expectedMin, Object expectedMax) {
        ColumnStat colStat = this.inferColumnStat(histogram, expectedMin, expectedMax);
        return new StatsTestPlan((Seq<Attribute>)((Seq)new .colon.colon((Object)col, (List)Nil$.MODULE$)), BigInt$.MODULE$.long2bigInt((long)(histogram.height() * (double)histogram.bins().length)), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)col), (Object)colStat), (List)Nil$.MODULE$)), StatsTestPlan$.MODULE$.apply$default$4());
    }

    private ColumnStat inferColumnStat(Histogram histogram, Object expectedMin, Object expectedMax) {
        LongRef ndv = LongRef.create((long)0L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])histogram.bins())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            HistogramBin bin = histogram.bins()[i];
            if (i == 0 || bin.hi() != histogram.bins()[i - 1].hi()) {
                ndv$1.elem += bin.ndv();
                return;
            }
        });
        return new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.long2bigInt(ndv.elem)), (Option)new Some(expectedMin), (Option)new Some(expectedMax), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)histogram), ColumnStat$.MODULE$.apply$default$8());
    }

    private static final LinkedHashMap genColumnData$1() {
        Decimal dec = Decimal$.MODULE$.apply("1.000000000000000000");
        int date = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-05-08"));
        long timestamp = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2016-05-08 00:00:01"));
        Tuple2[] tuple2Array = new Tuple2[12];
        String x$1 = "cbool";
        BooleanType$ x$2 = BooleanType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$7 = "cbyte";
        ByteType$ x$8 = ByteType$.MODULE$;
        boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)1))), (Option)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)1))), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$13 = "cshort";
        ShortType$ x$14 = ShortType$.MODULE$;
        boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
        Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)1))), (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)1))), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)2L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$19 = "cint";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
        Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
        tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$25 = "clong";
        LongType$ x$26 = LongType$.MODULE$;
        boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$29 = AttributeReference$.MODULE$.apply$default$5(x$25, (DataType)x$26, x$27, x$28);
        Seq x$30 = AttributeReference$.MODULE$.apply$default$6(x$25, (DataType)x$26, x$27, x$28);
        tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$25, (DataType)x$26, x$27, x$28, x$29, x$30)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$31 = "cdouble";
        DoubleType$ x$32 = DoubleType$.MODULE$;
        boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$35 = AttributeReference$.MODULE$.apply$default$5(x$31, (DataType)x$32, x$33, x$34);
        Seq x$36 = AttributeReference$.MODULE$.apply$default$6(x$31, (DataType)x$32, x$33, x$34);
        tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$31, (DataType)x$32, x$33, x$34, x$35, x$36)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$37 = "cfloat";
        FloatType$ x$38 = FloatType$.MODULE$;
        boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$40 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$41 = AttributeReference$.MODULE$.apply$default$5(x$37, (DataType)x$38, x$39, x$40);
        Seq x$42 = AttributeReference$.MODULE$.apply$default$6(x$37, (DataType)x$38, x$39, x$40);
        tuple2Array[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$37, (DataType)x$38, x$39, x$40, x$41, x$42)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToFloat((float)1.0f)), (Option)new Some((Object)BoxesRunTime.boxToFloat((float)1.0f)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$43 = "cdec";
        DecimalType x$44 = DecimalType$.MODULE$.SYSTEM_DEFAULT();
        boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$46 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$47 = AttributeReference$.MODULE$.apply$default$5(x$43, (DataType)x$44, x$45, x$46);
        Seq x$48 = AttributeReference$.MODULE$.apply$default$6(x$43, (DataType)x$44, x$45, x$46);
        tuple2Array[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$43, (DataType)x$44, x$45, x$46, x$47, x$48)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)dec), (Option)new Some((Object)dec), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)16L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$49 = "cstring";
        StringType$ x$50 = StringType$.MODULE$;
        boolean x$51 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$52 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$53 = AttributeReference$.MODULE$.apply$default$5(x$49, (DataType)x$50, x$51, x$52);
        Seq x$54 = AttributeReference$.MODULE$.apply$default$6(x$49, (DataType)x$50, x$51, x$52);
        tuple2Array[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$49, (DataType)x$50, x$51, x$52, x$53, x$54)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$55 = "cbinary";
        BinaryType$ x$56 = BinaryType$.MODULE$;
        boolean x$57 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$58 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$59 = AttributeReference$.MODULE$.apply$default$5(x$55, (DataType)x$56, x$57, x$58);
        Seq x$60 = AttributeReference$.MODULE$.apply$default$6(x$55, (DataType)x$56, x$57, x$58);
        tuple2Array[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$55, (DataType)x$56, x$57, x$58, x$59, x$60)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$61 = "cdate";
        DateType$ x$62 = DateType$.MODULE$;
        boolean x$63 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$64 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$65 = AttributeReference$.MODULE$.apply$default$5(x$61, (DataType)x$62, x$63, x$64);
        Seq x$66 = AttributeReference$.MODULE$.apply$default$6(x$61, (DataType)x$62, x$63, x$64);
        tuple2Array[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$61, (DataType)x$62, x$63, x$64, x$65, x$66)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)date)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)date)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        String x$67 = "ctimestamp";
        TimestampType$ x$68 = TimestampType$.MODULE$;
        boolean x$69 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$70 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$71 = AttributeReference$.MODULE$.apply$default$5(x$67, (DataType)x$68, x$69, x$70);
        Seq x$72 = AttributeReference$.MODULE$.apply$default$6(x$67, (DataType)x$68, x$69, x$70);
        tuple2Array[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$67, (DataType)x$68, x$69, x$70, x$71, x$72)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
        return (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    private final /* synthetic */ JoinEstimationSuite$MyStatsTestPlan$2$ MyStatsTestPlan$lzycompute$1(LazyRef MyStatsTestPlan$module$1) {
        JoinEstimationSuite$MyStatsTestPlan$2$ joinEstimationSuite$MyStatsTestPlan$2$;
        LazyRef lazyRef = MyStatsTestPlan$module$1;
        synchronized (lazyRef) {
            joinEstimationSuite$MyStatsTestPlan$2$ = MyStatsTestPlan$module$1.initialized() ? (JoinEstimationSuite$MyStatsTestPlan$2$)((Object)MyStatsTestPlan$module$1.value()) : (JoinEstimationSuite$MyStatsTestPlan$2$)((Object)MyStatsTestPlan$module$1.initialize((Object)new JoinEstimationSuite$MyStatsTestPlan$2$(this)));
        }
        return joinEstimationSuite$MyStatsTestPlan$2$;
    }

    private final JoinEstimationSuite$MyStatsTestPlan$2$ MyStatsTestPlan$3(LazyRef MyStatsTestPlan$module$1) {
        if (MyStatsTestPlan$module$1.initialized()) {
            return (JoinEstimationSuite$MyStatsTestPlan$2$)((Object)MyStatsTestPlan$module$1.value());
        }
        return this.MyStatsTestPlan$lzycompute$1(MyStatsTestPlan$module$1);
    }

    public JoinEstimationSuite() {
        StatsEstimationTestBase.$init$(this);
        this.columnInfo = AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key-1-5")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key-5-9")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key-1-2")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key-2-4")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key-2-3")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), (List)Nil$.MODULE$))))));
        this.nameToAttr = (Map)this.columnInfo().map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((NamedExpression)kv._1()).name()), kv._1()), Map$.MODULE$.canBuildFrom());
        this.nameToColInfo = (Map)this.columnInfo().map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((NamedExpression)kv._1()).name()), kv), Map$.MODULE$.canBuildFrom());
        this.table1 = new StatsTestPlan((Seq<Attribute>)((Seq)((TraversableLike)new .colon.colon((Object)"key-1-5", (List)new .colon.colon((Object)"key-5-9", (List)Nil$.MODULE$))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), BigInt$.MODULE$.int2bigInt(5), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)((TraversableLike)new .colon.colon((Object)"key-1-5", (List)new .colon.colon((Object)"key-5-9", (List)Nil$.MODULE$))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())), StatsTestPlan$.MODULE$.apply$default$4());
        this.table2 = new StatsTestPlan((Seq<Attribute>)((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-4", (List)Nil$.MODULE$))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), BigInt$.MODULE$.int2bigInt(3), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-4", (List)Nil$.MODULE$))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())), StatsTestPlan$.MODULE$.apply$default$4());
        this.table3 = new StatsTestPlan((Seq<Attribute>)((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-3", (List)Nil$.MODULE$))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), BigInt$.MODULE$.int2bigInt(2), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-3", (List)Nil$.MODULE$))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())), StatsTestPlan$.MODULE$.apply$default$4());
        this.test("equi-height histograms: a bin is contained by another one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Histogram histogram1 = new Histogram(300.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(10.0, 30.0, 10L), new HistogramBin(30.0, 60.0, 30L)}));
            Histogram histogram2 = new Histogram(100.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(0.0, 50.0, 50L), new HistogramBin(50.0, 100.0, 40L)}));
            Tuple2 tuple2 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[0], 100.0, 10.0, 60.0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin t0 = (HistogramBin)tuple2._1();
            double h0 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)t0, (Object)BoxesRunTime.boxToDouble((double)h0));
            HistogramBin t02 = (HistogramBin)tuple22._1();
            double h02 = tuple22._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left = t02;
            HistogramBin $org_scalatest_assert_macro_right = new HistogramBin(10.0, 50.0, 40L);
            HistogramBin histogramBin = $org_scalatest_assert_macro_left;
            HistogramBin histogramBin2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(histogramBin != null ? !histogramBin.equals(histogramBin2) : histogramBin2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = h02;
                int $org_scalatest_assert_macro_right2 = 80;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            Tuple2 tuple23 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[1], 100.0, 10.0, 60.0);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            HistogramBin t1 = (HistogramBin)tuple23._1();
            double h1 = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)t1, (Object)BoxesRunTime.boxToDouble((double)h1));
            HistogramBin t12 = (HistogramBin)tuple24._1();
            double h12 = tuple24._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left4 = t12;
            HistogramBin $org_scalatest_assert_macro_right4 = new HistogramBin(50.0, 60.0, 8L);
            HistogramBin histogramBin3 = $org_scalatest_assert_macro_left4;
            HistogramBin histogramBin4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(histogramBin3 != null ? !histogramBin3.equals(histogramBin4) : histogramBin4 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = h12;
                int $org_scalatest_assert_macro_right5 = 20;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Seq expectedRanges = (Seq)new .colon.colon((Object)new EstimationUtils.OverlappedRange(10.0, 30.0, 10.0, 20.0, 300.0, 40.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 50.0, 20.0, 20.0, 200.0, 40.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(50.0, 60.0, 10.0, 8.0, 100.0, 20.0), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedRanges.equals((Object)EstimationUtils$.MODULE$.getOverlappedRanges(histogram1, histogram2, 10.0, 60.0)), "expectedRanges.equals(org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils.getOverlappedRanges(histogram1, histogram2, 10.0, 60.0))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            this.estimateByHistogram(histogram1, histogram2, BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)60), 38L, 1200L);
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("equi-height histograms: a bin has only one value after trimming", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Histogram histogram1 = new Histogram(300.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(50.0, 60.0, 10L), new HistogramBin(60.0, 75.0, 3L)}));
            Histogram histogram2 = new Histogram(100.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(0.0, 50.0, 50L), new HistogramBin(50.0, 100.0, 40L)}));
            Tuple2 tuple2 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[0], 100.0, 50.0, 75.0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin t0 = (HistogramBin)tuple2._1();
            double h0 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)t0, (Object)BoxesRunTime.boxToDouble((double)h0));
            HistogramBin t02 = (HistogramBin)tuple22._1();
            double h02 = tuple22._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left = t02;
            HistogramBin $org_scalatest_assert_macro_right = new HistogramBin(50.0, 50.0, 1L);
            HistogramBin histogramBin = $org_scalatest_assert_macro_left;
            HistogramBin histogramBin2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(histogramBin != null ? !histogramBin.equals(histogramBin2) : histogramBin2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = h02;
                int $org_scalatest_assert_macro_right2 = 2;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Tuple2 tuple23 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[1], 100.0, 50.0, 75.0);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            HistogramBin t1 = (HistogramBin)tuple23._1();
            double h1 = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)t1, (Object)BoxesRunTime.boxToDouble((double)h1));
            HistogramBin t12 = (HistogramBin)tuple24._1();
            double h12 = tuple24._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left4 = t12;
            HistogramBin $org_scalatest_assert_macro_right4 = new HistogramBin(50.0, 75.0, 20L);
            HistogramBin histogramBin3 = $org_scalatest_assert_macro_left4;
            HistogramBin histogramBin4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(histogramBin3 != null ? !histogramBin3.equals(histogramBin4) : histogramBin4 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = h12;
                int $org_scalatest_assert_macro_right5 = 50;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Seq expectedRanges = (Seq)new .colon.colon((Object)new EstimationUtils.OverlappedRange(50.0, 50.0, 1.0, 1.0, 30.0, 2.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(50.0, 60.0, 10.0, 8.0, 300.0, 20.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(60.0, 75.0, 3.0, 12.0, 300.0, 30.0), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedRanges.equals((Object)EstimationUtils$.MODULE$.getOverlappedRanges(histogram1, histogram2, 50.0, 75.0)), "expectedRanges.equals(org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils.getOverlappedRanges(histogram1, histogram2, 50.0, 75.0))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            this.estimateByHistogram(histogram1, histogram2, BoxesRunTime.boxToInteger((int)50), BoxesRunTime.boxToInteger((int)75), 12L, 1410L);
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("equi-height histograms: skew distribution (some bins have only one value)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Histogram histogram1 = new Histogram(300.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(30.0, 30.0, 1L), new HistogramBin(30.0, 30.0, 1L), new HistogramBin(30.0, 60.0, 30L)}));
            Histogram histogram2 = new Histogram(100.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(0.0, 50.0, 50L), new HistogramBin(50.0, 100.0, 40L)}));
            Tuple2 tuple2 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[0], 100.0, 30.0, 60.0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin t0 = (HistogramBin)tuple2._1();
            double h0 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)t0, (Object)BoxesRunTime.boxToDouble((double)h0));
            HistogramBin t02 = (HistogramBin)tuple22._1();
            double h02 = tuple22._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left = t02;
            HistogramBin $org_scalatest_assert_macro_right = new HistogramBin(30.0, 50.0, 20L);
            HistogramBin histogramBin = $org_scalatest_assert_macro_left;
            HistogramBin histogramBin2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(histogramBin != null ? !histogramBin.equals(histogramBin2) : histogramBin2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = h02;
                int $org_scalatest_assert_macro_right2 = 40;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            Tuple2 tuple23 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[1], 100.0, 30.0, 60.0);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            HistogramBin t1 = (HistogramBin)tuple23._1();
            double h1 = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)t1, (Object)BoxesRunTime.boxToDouble((double)h1));
            HistogramBin t12 = (HistogramBin)tuple24._1();
            double h12 = tuple24._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left4 = t12;
            HistogramBin $org_scalatest_assert_macro_right4 = new HistogramBin(50.0, 60.0, 8L);
            HistogramBin histogramBin3 = $org_scalatest_assert_macro_left4;
            HistogramBin histogramBin4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(histogramBin3 != null ? !histogramBin3.equals(histogramBin4) : histogramBin4 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = h12;
                int $org_scalatest_assert_macro_right5 = 20;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            Seq expectedRanges = (Seq)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 300.0, 2.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 300.0, 2.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 50.0, 20.0, 20.0, 200.0, 40.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(50.0, 60.0, 10.0, 8.0, 100.0, 20.0), (List)Nil$.MODULE$))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedRanges.equals((Object)EstimationUtils$.MODULE$.getOverlappedRanges(histogram1, histogram2, 30.0, 60.0)), "expectedRanges.equals(org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils.getOverlappedRanges(histogram1, histogram2, 30.0, 60.0))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            this.estimateByHistogram(histogram1, histogram2, BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)60), 29L, 1800L);
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("equi-height histograms: skew distribution (histograms have different skewed values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Histogram histogram1 = new Histogram(300.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(30.0, 30.0, 1L), new HistogramBin(30.0, 60.0, 30L)}));
            Histogram histogram2 = new Histogram(100.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(0.0, 50.0, 50L), new HistogramBin(50.0, 50.0, 1L)}));
            Tuple2 tuple2 = EstimationUtils$.MODULE$.trimBin(histogram1.bins()[1], 300.0, 30.0, 50.0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin t0 = (HistogramBin)tuple2._1();
            double h0 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)t0, (Object)BoxesRunTime.boxToDouble((double)h0));
            HistogramBin t02 = (HistogramBin)tuple22._1();
            double h02 = tuple22._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left = t02;
            HistogramBin $org_scalatest_assert_macro_right = new HistogramBin(30.0, 50.0, 20L);
            HistogramBin histogramBin = $org_scalatest_assert_macro_left;
            HistogramBin histogramBin2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(histogramBin != null ? !histogramBin.equals(histogramBin2) : histogramBin2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = h02;
                int $org_scalatest_assert_macro_right2 = 200;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            Tuple2 tuple23 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[0], 100.0, 30.0, 50.0);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            HistogramBin t1 = (HistogramBin)tuple23._1();
            double h1 = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)t1, (Object)BoxesRunTime.boxToDouble((double)h1));
            HistogramBin t12 = (HistogramBin)tuple24._1();
            double h12 = tuple24._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left4 = t12;
            HistogramBin $org_scalatest_assert_macro_right4 = new HistogramBin(30.0, 50.0, 20L);
            HistogramBin histogramBin3 = $org_scalatest_assert_macro_left4;
            HistogramBin histogramBin4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(histogramBin3 != null ? !histogramBin3.equals(histogramBin4) : histogramBin4 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = h12;
                int $org_scalatest_assert_macro_right5 = 40;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Seq expectedRanges = (Seq)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 300.0, 2.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 50.0, 20.0, 20.0, 200.0, 40.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(50.0, 50.0, 1.0, 1.0, 10.0, 100.0), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedRanges.equals((Object)EstimationUtils$.MODULE$.getOverlappedRanges(histogram1, histogram2, 30.0, 50.0)), "expectedRanges.equals(org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils.getOverlappedRanges(histogram1, histogram2, 30.0, 50.0))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            this.estimateByHistogram(histogram1, histogram2, BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)50), 21L, 2000L);
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("equi-height histograms: skew distribution (both histograms have the same skewed value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Histogram histogram1 = new Histogram(300.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(30.0, 30.0, 1L), new HistogramBin(30.0, 60.0, 30L)}));
            Histogram histogram2 = new Histogram(150.0, (HistogramBin[])((Object[])new HistogramBin[]{new HistogramBin(0.0, 30.0, 30L), new HistogramBin(30.0, 30.0, 1L)}));
            Tuple2 tuple2 = EstimationUtils$.MODULE$.trimBin(histogram1.bins()[1], 300.0, 30.0, 30.0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin t0 = (HistogramBin)tuple2._1();
            double h0 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)t0, (Object)BoxesRunTime.boxToDouble((double)h0));
            HistogramBin t02 = (HistogramBin)tuple22._1();
            double h02 = tuple22._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left = t02;
            HistogramBin $org_scalatest_assert_macro_right = new HistogramBin(30.0, 30.0, 1L);
            HistogramBin histogramBin = $org_scalatest_assert_macro_left;
            HistogramBin histogramBin2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(histogramBin != null ? !histogramBin.equals(histogramBin2) : histogramBin2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = h02;
                int $org_scalatest_assert_macro_right2 = 10;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            Tuple2 tuple23 = EstimationUtils$.MODULE$.trimBin(histogram2.bins()[0], 150.0, 30.0, 30.0);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            HistogramBin t1 = (HistogramBin)tuple23._1();
            double h1 = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)t1, (Object)BoxesRunTime.boxToDouble((double)h1));
            HistogramBin t12 = (HistogramBin)tuple24._1();
            double h12 = tuple24._2$mcD$sp();
            HistogramBin $org_scalatest_assert_macro_left4 = t12;
            HistogramBin $org_scalatest_assert_macro_right4 = new HistogramBin(30.0, 30.0, 1L);
            HistogramBin histogramBin3 = $org_scalatest_assert_macro_left4;
            HistogramBin histogramBin4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(histogramBin3 != null ? !histogramBin3.equals(histogramBin4) : histogramBin4 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = h12;
                int $org_scalatest_assert_macro_right5 = 5;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            Seq expectedRanges = (Seq)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 300.0, 5.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 300.0, 150.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 10.0, 5.0), (List)new .colon.colon((Object)new EstimationUtils.OverlappedRange(30.0, 30.0, 1.0, 1.0, 10.0, 150.0), (List)Nil$.MODULE$))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedRanges.equals((Object)EstimationUtils$.MODULE$.getOverlappedRanges(histogram1, histogram2, 30.0, 30.0)), "expectedRanges.equals(org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils.getOverlappedRanges(histogram1, histogram2, 30.0, 30.0))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            this.estimateByHistogram(histogram1, histogram2, BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)30), 1L, 48050L);
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("cross join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)Cross$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(360), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(15)), AttributeMap$.MODULE$.apply((Seq)((TraversableLike)new .colon.colon((Object)"key-1-5", (List)new .colon.colon((Object)"key-5-9", (List)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-4", (List)Nil$.MODULE$))))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("disjoint inner join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-5-9"), (Expression)this.nameToAttr().apply((Object)"key-2-4"))), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(1), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("disjoint left outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-5-9"), (Expression)this.nameToAttr().apply((Object)"key-2-4"))), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(120), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), AttributeMap$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"key-1-5", (List)new .colon.colon((Object)"key-5-9", (List)Nil$.MODULE$))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-2")), (Object)EstimationUtils$.MODULE$.nullColumnStat(((Expression)this.nameToAttr().apply((Object)"key-1-2")).dataType(), BigInt$.MODULE$.int2bigInt(5))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-4")), (Object)EstimationUtils$.MODULE$.nullColumnStat(((Expression)this.nameToAttr().apply((Object)"key-2-4")).dataType(), BigInt$.MODULE$.int2bigInt(5))), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("disjoint right outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-5-9"), (Expression)this.nameToAttr().apply((Object)"key-2-4"))), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(72), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), AttributeMap$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-4", (List)Nil$.MODULE$))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-5")), (Object)EstimationUtils$.MODULE$.nullColumnStat(((Expression)this.nameToAttr().apply((Object)"key-1-5")).dataType(), BigInt$.MODULE$.int2bigInt(3))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-5-9")), (Object)EstimationUtils$.MODULE$.nullColumnStat(((Expression)this.nameToAttr().apply((Object)"key-5-9")).dataType(), BigInt$.MODULE$.int2bigInt(3))), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("disjoint full outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)FullOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-5-9"), (Expression)this.nameToAttr().apply((Object)"key-2-4"))), JoinHint$.MODULE$.NONE());
            ColumnStat qual$1 = (ColumnStat)this.columnInfo().apply(this.nameToAttr().apply((Object)"key-1-5"));
            Some x$1 = new Some((Object)BigInt$.MODULE$.int2bigInt(3));
            Option x$2 = qual$1.copy$default$1();
            Option x$3 = qual$1.copy$default$2();
            Option x$4 = qual$1.copy$default$3();
            Option x$5 = qual$1.copy$default$5();
            Option x$6 = qual$1.copy$default$6();
            Option x$7 = qual$1.copy$default$7();
            int x$8 = qual$1.copy$default$8();
            ColumnStat qual$2 = (ColumnStat)this.columnInfo().apply(this.nameToAttr().apply((Object)"key-5-9"));
            Some x$9 = new Some((Object)BigInt$.MODULE$.int2bigInt(3));
            Option x$10 = qual$2.copy$default$1();
            Option x$11 = qual$2.copy$default$2();
            Option x$12 = qual$2.copy$default$3();
            Option x$13 = qual$2.copy$default$5();
            Option x$14 = qual$2.copy$default$6();
            Option x$15 = qual$2.copy$default$7();
            int x$16 = qual$2.copy$default$8();
            ColumnStat qual$3 = (ColumnStat)this.columnInfo().apply(this.nameToAttr().apply((Object)"key-1-2"));
            Some x$17 = new Some((Object)BigInt$.MODULE$.int2bigInt(5));
            Option x$18 = qual$3.copy$default$1();
            Option x$19 = qual$3.copy$default$2();
            Option x$20 = qual$3.copy$default$3();
            Option x$21 = qual$3.copy$default$5();
            Option x$22 = qual$3.copy$default$6();
            Option x$23 = qual$3.copy$default$7();
            int x$24 = qual$3.copy$default$8();
            ColumnStat qual$4 = (ColumnStat)this.columnInfo().apply(this.nameToAttr().apply((Object)"key-2-4"));
            Some x$25 = new Some((Object)BigInt$.MODULE$.int2bigInt(5));
            Option x$26 = qual$4.copy$default$1();
            Option x$27 = qual$4.copy$default$2();
            Option x$28 = qual$4.copy$default$3();
            Option x$29 = qual$4.copy$default$5();
            Option x$30 = qual$4.copy$default$6();
            Option x$31 = qual$4.copy$default$7();
            int x$32 = qual$4.copy$default$8();
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(192), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(8)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-5")), (Object)qual$1.copy(x$2, x$3, x$4, (Option)x$1, x$5, x$6, x$7, x$8)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-5-9")), (Object)qual$2.copy(x$10, x$11, x$12, (Option)x$9, x$13, x$14, x$15, x$16)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-2")), (Object)qual$3.copy(x$18, x$19, x$20, (Option)x$17, x$21, x$22, x$23, x$24)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-4")), (Object)qual$4.copy(x$26, x$27, x$28, (Option)x$25, x$29, x$30, x$31, x$32)), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("inner join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)this.table2(), (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-1-5"), (Expression)this.nameToAttr().apply((Object)"key-1-2"))), JoinHint$.MODULE$.NONE());
            ColumnStat joinedColStat = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
            ColumnStat qual$5 = (ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key-5-9"))._2();
            Some x$33 = new Some((Object)BigInt$.MODULE$.int2bigInt(3));
            Option x$34 = qual$5.copy$default$2();
            Option x$35 = qual$5.copy$default$3();
            Option x$36 = qual$5.copy$default$4();
            Option x$37 = qual$5.copy$default$5();
            Option x$38 = qual$5.copy$default$6();
            Option x$39 = qual$5.copy$default$7();
            int x$40 = qual$5.copy$default$8();
            ColumnStat colStatForkey59 = qual$5.copy((Option)x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(72), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-5")), (Object)joinedColStat), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-2")), (Object)joinedColStat), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-5-9")), (Object)colStatForkey59), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-4")), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("inner join with multiple equi-join keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table2(), (LogicalPlan)this.table3(), (JoinType)Inner$.MODULE$, (Option)new Some((Object)new And((Expression)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-1-2"), (Expression)this.nameToAttr().apply((Object)"key-1-2")), (Expression)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-4"), (Expression)this.nameToAttr().apply((Object)"key-2-3")))), JoinHint$.MODULE$.NONE());
            ColumnStat joinedColStat1 = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
            ColumnStat joinedColStat2 = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(48), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-2")), (Object)joinedColStat1), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-1-2")), (Object)joinedColStat1), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-4")), (Object)joinedColStat2), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-3")), (Object)joinedColStat2), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        this.test("left outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table3(), (LogicalPlan)this.table2(), (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-3"), (Expression)this.nameToAttr().apply((Object)"key-2-4"))), JoinHint$.MODULE$.NONE());
            ColumnStat joinedColStat = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(48), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-3")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-4")), (Object)joinedColStat), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("right outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table2(), (LogicalPlan)this.table3(), (JoinType)RightOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-4"), (Expression)this.nameToAttr().apply((Object)"key-2-3"))), JoinHint$.MODULE$.NONE());
            ColumnStat joinedColStat = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(48), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameToAttr().apply((Object)"key-2-4")), (Object)joinedColStat), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-3")), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        this.test("full outer join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Join join = new Join((LogicalPlan)this.table2(), (LogicalPlan)this.table3(), (JoinType)FullOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-4"), (Expression)this.nameToAttr().apply((Object)"key-2-3"))), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(72), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-4")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-3")), (List)Nil$.MODULE$))))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("left semi/anti join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)LeftSemi$.MODULE$, (List)new .colon.colon((Object)LeftAnti$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)jt -> {
            Join join = new Join((LogicalPlan)this.table2(), (LogicalPlan)this.table3(), jt, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-4"), (Expression)this.nameToAttr().apply((Object)"key-2-3"))), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(48), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-1-2")), (List)new .colon.colon((Object)((Tuple2)this.nameToColInfo().apply((Object)"key-2-4")), (List)Nil$.MODULE$))), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        }), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        this.test("test join keys of different types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap columnInfo1 = JoinEstimationSuite.genColumnData$1();
            LinkedHashMap columnInfo2 = JoinEstimationSuite.genColumnData$1();
            StatsTestPlan table1 = new StatsTestPlan((Seq<Attribute>)columnInfo1.keys().toSeq(), BigInt$.MODULE$.int2bigInt(1), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply(columnInfo1.toSeq()), StatsTestPlan$.MODULE$.apply$default$4());
            StatsTestPlan table2 = new StatsTestPlan((Seq<Attribute>)columnInfo2.keys().toSeq(), BigInt$.MODULE$.int2bigInt(1), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply(columnInfo2.toSeq()), StatsTestPlan$.MODULE$.apply$default$4());
            Seq joinKeys = (Seq)table1.output().zip(table2.output(), Seq$.MODULE$.canBuildFrom());
            joinKeys.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Attribute key1 = (Attribute)tuple2._1();
                    Attribute key2 = (Attribute)tuple2._2();
                    return (Assertion)this.withClue(new StringBuilder(14).append("For data type ").append(key1.dataType()).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                        Join join = new Join((LogicalPlan)new Project((Seq)new .colon.colon((Object)key1, (List)Nil$.MODULE$), (LogicalPlan)table1), (LogicalPlan)new Project((Seq)new .colon.colon((Object)key2, (List)Nil$.MODULE$), (LogicalPlan)table2), (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)key1, (Expression)key2)), JoinHint$.MODULE$.NONE());
                        Statistics expectedStats = new Statistics(BigInt$.MODULE$.long2bigInt(1L * (8L + 2L * this.getColSize(key1, (ColumnStat)columnInfo1.apply((Object)key1)))), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key1), columnInfo1.apply((Object)key1)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key2), columnInfo1.apply((Object)key1)), (List)Nil$.MODULE$))), Statistics$.MODULE$.apply$default$4());
                        Statistics $org_scalatest_assert_macro_left = join.stats();
                        Statistics $org_scalatest_assert_macro_right = expectedStats;
                        Statistics statistics = $org_scalatest_assert_macro_left;
                        Statistics statistics2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("join with null column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)this.attr("cnull"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AttributeReference nullColumn = (AttributeReference)tuple2._1();
            ColumnStat nullColStat = (ColumnStat)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nullColumn, (Object)nullColStat);
            AttributeReference nullColumn2 = (AttributeReference)tuple22._1();
            ColumnStat nullColStat2 = (ColumnStat)tuple22._2();
            StatsTestPlan nullTable = new StatsTestPlan((Seq<Attribute>)((Seq)new .colon.colon((Object)nullColumn2, (List)Nil$.MODULE$)), BigInt$.MODULE$.int2bigInt(1), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nullColumn2), (Object)nullColStat2), (List)Nil$.MODULE$)), StatsTestPlan$.MODULE$.apply$default$4());
            Join join = new Join((LogicalPlan)this.table1(), (LogicalPlan)nullTable, (JoinType)Inner$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-1-5"), (Expression)nullColumn2)), JoinHint$.MODULE$.NONE());
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(1), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$), Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("SPARK-33018 Fix estimate statistics issue if child has 0 bytes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LazyRef MyStatsTestPlan$module = new LazyRef();
            public class Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1
            extends LogicalPlan
            implements LeafNode,
            scala.Serializable {
                private final Seq<Attribute> outputList;
                private final BigInt sizeInBytes;
                private final /* synthetic */ JoinEstimationSuite $outer;

                public AttributeSet producedAttributes() {
                    return LeafNode.producedAttributes$((LeafNode)this);
                }

                public final Seq<LogicalPlan> children() {
                    return LeafLike.children$((LeafLike)this);
                }

                public final TreeNode mapChildren(Function1 f) {
                    return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
                }

                public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
                    return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
                }

                public Seq<Attribute> outputList() {
                    return this.outputList;
                }

                public BigInt sizeInBytes() {
                    return this.sizeInBytes;
                }

                public Seq<Attribute> output() {
                    return this.outputList();
                }

                public Statistics computeStats() {
                    return new Statistics(this.sizeInBytes(), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
                }

                public Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1 copy(Seq<Attribute> outputList, BigInt sizeInBytes) {
                    return new Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1(this.$outer, outputList, sizeInBytes);
                }

                public Seq<Attribute> copy$default$1() {
                    return this.outputList();
                }

                public BigInt copy$default$2() {
                    return this.sizeInBytes();
                }

                public String productPrefix() {
                    return "MyStatsTestPlan";
                }

                public int productArity() {
                    return 2;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.outputList();
                        }
                        case 1: {
                            return this.sizeInBytes();
                        }
                    }
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1 var4_3 = (Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1)((Object)x$1);
                    Seq<Attribute> seq = this.outputList();
                    Seq<Attribute> seq2 = var4_3.outputList();
                    if (seq == null) {
                        if (seq2 != null) {
                            return false;
                        }
                    } else if (!seq.equals(seq2)) return false;
                    BigInt bigInt = this.sizeInBytes();
                    BigInt bigInt2 = var4_3.sizeInBytes();
                    if (bigInt == null) {
                        if (bigInt2 != null) {
                            return false;
                        }
                    } else if (!bigInt.equals(bigInt2)) return false;
                    if (!var4_3.canEqual((Object)((Object)this))) return false;
                    return true;
                }

                public Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1(JoinEstimationSuite $outer, Seq<Attribute> outputList, BigInt sizeInBytes) {
                    this.outputList = outputList;
                    this.sizeInBytes = sizeInBytes;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    LeafLike.$init$((LeafLike)this);
                    LeafNode.$init$((LeafNode)this);
                }
            }
            Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1 left = this.MyStatsTestPlan$3(MyStatsTestPlan$module).apply((Seq<Attribute>)((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-4", (List)Nil$.MODULE$))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), package$.MODULE$.BigInt().apply(100));
            Org_apache_spark_sql_catalyst_statsEstimation_JoinEstimationSuite$MyStatsTestPlan$1 right = this.MyStatsTestPlan$3(MyStatsTestPlan$module).apply((Seq<Attribute>)((Seq)((TraversableLike)new .colon.colon((Object)"key-1-2", (List)new .colon.colon((Object)"key-2-3", (List)Nil$.MODULE$))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), package$.MODULE$.BigInt().apply(0));
            Join join = new Join((LogicalPlan)left, (LogicalPlan)right, (JoinType)LeftOuter$.MODULE$, (Option)new Some((Object)new EqualTo((Expression)this.nameToAttr().apply((Object)"key-2-4"), (Expression)this.nameToAttr().apply((Object)"key-2-3"))), JoinHint$.MODULE$.NONE());
            Statistics $org_scalatest_assert_macro_left = join.stats();
            Statistics $org_scalatest_assert_macro_right = new Statistics(BigInt$.MODULE$.int2bigInt(100), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
        }, new Position("JoinEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
    }
}

