/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0005I!)!\t\u0001C\u0005\u0007\")q\t\u0001C\u0005\u0011\")\u0001\u000b\u0001C\u0005#\n\u0011\u0012J\u001c;feZ\fG.\u0016;jYN\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0003vi&d'B\u0001\u0006\f\u0003!\u0019\u0017\r^1msN$(B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00163A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005iiR\"A\u000e\u000b\u0005qI\u0011!\u00029mC:\u001c\u0018B\u0001\u0010\u001c\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u000f\u0005y1\r[3dW\u001a\u0013x.\\*ue&tw\rF\u0002&Wa\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012A!\u00168ji\")AF\u0001a\u0001[\u0005)\u0011N\u001c9viB\u0011a&\u000e\b\u0003_M\u0002\"\u0001M\u0014\u000e\u0003ER!AM\n\u0002\rq\u0012xn\u001c;?\u0013\t!t%\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b(\u0011\u0015I$\u00011\u0001;\u0003!)\u0007\u0010]3di\u0016$\u0007CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015!\u0018\u0010]3t\u0015\tyT\"\u0001\u0004v]N\fg-Z\u0005\u0003\u0003r\u0012\u0001cQ1mK:$\u0017M]%oi\u0016\u0014h/\u00197\u0002-\rDWmY6Ge>l\u0017J\u001c<bY&$7\u000b\u001e:j]\u001e$2!\n#F\u0011\u0015a3\u00011\u0001.\u0011\u001515\u00011\u0001.\u0003!)'O]8s\u001bN<\u0017\u0001\u00074bS24UO\\2XSRD\u0017J\u001c<bY&$\u0017J\u001c9viR!Q%\u0013&L\u0011\u0015aC\u00011\u0001.\u0011\u00151E\u00011\u0001.\u0011\u0015aE\u00011\u0001N\u0003%\u0019wN\u001c<feR,'\u000f\u0005\u0003'\u001d6R\u0014BA((\u0005%1UO\\2uS>t\u0017'\u0001\buKN$8+\u001b8hY\u0016,f.\u001b;\u0015\r\u0015\u0012F+W.^\u0011\u0015\u0019V\u00011\u0001.\u0003\u0011)h.\u001b;\t\u000bU+\u0001\u0019\u0001,\u0002\r9,XNY3s!\t1s+\u0003\u0002YO\t\u0019\u0011J\u001c;\t\u000bi+\u0001\u0019\u0001,\u0002\r5|g\u000e\u001e5t\u0011\u0015aV\u00011\u0001W\u0003\u0011!\u0017-_:\t\u000by+\u0001\u0019A0\u0002\u00195L7M]8tK\u000e|g\u000eZ:\u0011\u0005\u0019\u0002\u0017BA1(\u0005\u0011auN\\4")
public class IntervalUtilsSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        IntervalUtilsSuite intervalUtilsSuite = this;
        synchronized (intervalUtilsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void checkFromString(String input, CalendarInterval expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)));
        CalendarInterval $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        CalendarInterval $org_scalatest_assert_macro_right2 = expected;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    private void checkFromInvalidString(String input, String errorMsg) {
        this.failFuncWithInvalidInput(input, errorMsg, (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)s -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)s)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }

    private void failFuncWithInvalidInput(String input, String errorMsg, Function1<String, CalendarInterval> converter) {
        this.withClue("Expected to throw an exception for the invalid input", (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (CalendarInterval)converter.apply((Object)input), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = errorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        });
    }

    private void testSingleUnit(String unit, int number, int months, int days, long microseconds) {
        ((IterableLike)new .colon.colon((Object)"interval ", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            IntervalUtilsSuite.$anonfun$testSingleUnit$1(this, number, unit, months, days, microseconds, prefix);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testSingleUnit$1(IntervalUtilsSuite $this, int number$1, String unit$1, int months$1, int days$1, long microseconds$1, String prefix) {
        String input1 = new StringBuilder(1).append(prefix).append(number$1).append(" ").append(unit$1).toString();
        String input2 = new StringBuilder(2).append(prefix).append(number$1).append(" ").append(unit$1).append("s").toString();
        CalendarInterval result = new CalendarInterval(months$1, days$1, microseconds$1);
        $this.checkFromString(input1, result);
        $this.checkFromString(input2, result);
    }

    public static final /* synthetic */ void $anonfun$new$5(IntervalUtilsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String input = (String)tuple2._1();
            CalendarInterval expected = (CalendarInterval)tuple2._2();
            $this.checkFromString(input, expected);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final long duration$1(String s, TimeUnit unit, int daysPerMonth) {
        return IntervalUtils$.MODULE$.getDuration(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)s)), unit, daysPerMonth);
    }

    private static final boolean isNegative$1(String s, int daysPerMonth) {
        return IntervalUtils$.MODULE$.isNegative(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)s)), daysPerMonth);
    }

    private final void check$1(String input, byte from, byte to, String expected) {
        this.withClue(new StringBuilder(14).append("from = ").append(from).append(", to = ").append(to).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            UTF8String expectedUtf8 = UTF8String.fromString((String)expected);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString(input, from, to));
            CalendarInterval $org_scalatest_assert_macro_right = IntervalUtils$.MODULE$.safeStringToInterval(expectedUtf8);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        });
    }

    private final void checkFail$1(String input, byte from, byte to, String errMsg) {
        this.failFuncWithInvalidInput(input, errMsg, (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s, from, to));
    }

    public static final /* synthetic */ Assertion $anonfun$new$63(IntervalUtilsSuite $this, long micros) {
        Duration duration = IntervalUtils$.MODULE$.microsToDuration(micros);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(duration)));
        long $org_scalatest_assert_macro_right = micros;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
    }

    public static final /* synthetic */ Assertion $anonfun$new$65(IntervalUtilsSuite $this, int months) {
        Period period = IntervalUtils$.MODULE$.monthsToPeriod(months);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(period)));
        int $org_scalatest_assert_macro_right = months;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
    }

    public IntervalUtilsSuite() {
        SQLHelper.$init$(this);
        this.test("string to interval: basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testSingleUnit("YEAR", 3, 36, 0, 0L);
            this.testSingleUnit("Month", 3, 3, 0, 0L);
            this.testSingleUnit("Week", 3, 0, 21, 0L);
            this.testSingleUnit("DAY", 3, 0, 3, 0L);
            this.testSingleUnit("HouR", 3, 0, 0, 10800000000L);
            this.testSingleUnit("MiNuTe", 3, 0, 0, 180000000L);
            this.testSingleUnit("Second", 3, 0, 0, 3000000L);
            this.testSingleUnit("MilliSecond", 3, 0, 0, DateTimeUtils$.MODULE$.millisToMicros(3L));
            this.testSingleUnit("MicroSecond", 3, 0, 0, 3L);
            this.checkFromInvalidString(null, "cannot be null");
            ((IterableLike)new .colon.colon((Object)"", (List)new .colon.colon((Object)"interval", (List)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"foo 1 day", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)input -> {
                this.checkFromInvalidString(input, "Error parsing");
                return BoxedUnit.UNIT;
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("string to interval: interval with dangling parts should not results null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFromInvalidString("+", "expect a number after '+' but hit EOL");
            this.checkFromInvalidString("-", "expect a number after '-' but hit EOL");
            this.checkFromInvalidString("+ 2", "expect a unit name after '2' but hit EOL");
            this.checkFromInvalidString("- 1", "expect a unit name after '1' but hit EOL");
            this.checkFromInvalidString("1", "expect a unit name after '1' but hit EOL");
            this.checkFromInvalidString("1.2", "expect a unit name after '1.2' but hit EOL");
            this.checkFromInvalidString("1 day 2", "expect a unit name after '2' but hit EOL");
            this.checkFromInvalidString("1 day 2.2", "expect a unit name after '2.2' but hit EOL");
            this.checkFromInvalidString("1 day -", "expect a number after '-' but hit EOL");
            this.checkFromInvalidString("-.", "expect a unit name after '-.' but hit EOL");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("string to interval: multiple units", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-1 MONTH 1 day -1 microseconds"), (Object)new CalendarInterval(-1, 1, -1L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)" 123 MONTHS        123 DAYS  123 Microsecond    "), (Object)new CalendarInterval(123, 123, 123L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval -1 day +3 Microseconds"), (Object)new CalendarInterval(0, -1, 3L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval -   1 day +     3 Microseconds"), (Object)new CalendarInterval(0, -1, 3L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  interval  8  years -11 months 123  weeks   -1 day 23 hours -22 minutes 1 second  -123  millisecond    567 microseconds "), (Object)new CalendarInterval(85, 860, 81480877567L)), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IntervalUtilsSuite.$anonfun$new$5(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("string to interval: special cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFromString("1 day 1 year", new CalendarInterval(12, 1, 0L));
            this.checkFromString("1 day 10 day", new CalendarInterval(0, 11, 0L));
            this.checkFromInvalidString("1.5 days", "'days' cannot have fractional part");
            this.checkFromInvalidString("1. hour", "'hour' cannot have fractional part");
            this.checkFromInvalidString("1 hourX", "invalid unit 'hourx'");
            this.checkFromInvalidString("~1 hour", "unrecognized number '~1'");
            this.checkFromInvalidString("1 Mour", "invalid unit 'mour'");
            this.checkFromInvalidString("1 aour", "invalid unit 'aour'");
            this.checkFromInvalidString("1a1 hour", "invalid value '1a1'");
            this.checkFromInvalidString("1.1a1 seconds", "invalid value '1.1a1'");
            this.checkFromInvalidString("2234567890 days", "integer overflow");
            this.checkFromInvalidString(". seconds", "invalid value '.'");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("string to interval: whitespaces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFromInvalidString(" ", "Error parsing ' ' to interval");
            this.checkFromInvalidString("\n", "Error parsing '\n' to interval");
            this.checkFromInvalidString("\t", "Error parsing '\t' to interval");
            this.checkFromString("1 \t day \n 2 \r hour", new CalendarInterval(0, 1, 7200000000L));
            this.checkFromInvalidString("interval1 \t day \n 2 \r hour", "invalid interval prefix interval1");
            this.checkFromString("interval\r1\tday", new CalendarInterval(0, 1, 0L));
            this.checkFromInvalidString("\u4e2d\u56fd interval 1 day", "unrecognized number '\u4e2d\u56fd'");
            this.checkFromInvalidString("interval\u6d59\u6c5f 1 day", "invalid interval prefix interval\u6d59\u6c5f");
            this.checkFromInvalidString("interval 1\u676d\u5dde day", "invalid value '1\u676d\u5dde'");
            this.checkFromInvalidString("interval 1 \u6ee8\u6c5fday", "invalid unit '\u6ee8\u6c5fday'");
            this.checkFromInvalidString("interval 1 day\u957f\u6cb3", "invalid unit 'day\u957f\u6cb3'");
            this.checkFromInvalidString("interval 1 day \u7f51\u5546\u8def", "unrecognized number '\u7f51\u5546\u8def'");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("string to interval: seconds with fractional part", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFromString("0.1 seconds", new CalendarInterval(0, 0, 100000L));
            this.checkFromString("1. seconds", new CalendarInterval(0, 0, 1000000L));
            this.checkFromString("123.001 seconds", new CalendarInterval(0, 0, 123001000L));
            this.checkFromString("1.001001 seconds", new CalendarInterval(0, 0, 1001001L));
            this.checkFromString("1 minute 1.001001 seconds", new CalendarInterval(0, 0, 61001001L));
            this.checkFromString("-1.5 seconds", new CalendarInterval(0, 0, -1500000L));
            this.checkFromString("0.999999999 seconds", new CalendarInterval(0, 0, 999999L));
            this.checkFromString(".999999999 seconds", new CalendarInterval(0, 0, 999999L));
            this.checkFromInvalidString("0.123456789123 seconds", "'0.123456789123' is out of range");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("from year-month string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e2;
            String e1;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("99-10"));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("+99-10"));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("-8-10"));
            CalendarInterval $org_scalatest_assert_macro_right3 = new CalendarInterval(-106, 0, 0L);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.failFuncWithInvalidInput("99-15", "month 15 outside range", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            this.failFuncWithInvalidInput("9a9-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("99-10 "));
            CalendarInterval $org_scalatest_assert_macro_right4 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("+99-10\t"));
            CalendarInterval $org_scalatest_assert_macro_right5 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("\t\t-8-10\t"));
            CalendarInterval $org_scalatest_assert_macro_right6 = new CalendarInterval(-106, 0, 0L);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            this.failFuncWithInvalidInput("99\t-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            this.failFuncWithInvalidInput("-\t99-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            CalendarInterval $org_scalatest_assert_macro_left7 = IntervalUtils$.MODULE$.fromYearMonthString("178956970-6");
            CalendarInterval $org_scalatest_assert_macro_right7 = new CalendarInterval(0x7FFFFFFE, 0, 0L);
            CalendarInterval calendarInterval = $org_scalatest_assert_macro_left7;
            CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            CalendarInterval $org_scalatest_assert_macro_left8 = IntervalUtils$.MODULE$.fromYearMonthString("178956970-7");
            CalendarInterval $org_scalatest_assert_macro_right8 = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            CalendarInterval calendarInterval3 = $org_scalatest_assert_macro_left8;
            CalendarInterval calendarInterval4 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(calendarInterval3 != null ? !calendarInterval3.equals(calendarInterval4) : calendarInterval4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            String $org_scalatest_assert_macro_left9 = e1 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                CalendarInterval $org_scalatest_assert_macro_left = IntervalUtils$.MODULE$.fromYearMonthString("178956970-8");
                CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176))).getMessage();
            String $org_scalatest_assert_macro_right9 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            CalendarInterval $org_scalatest_assert_macro_left10 = IntervalUtils$.MODULE$.fromYearMonthString("-178956970-8");
            CalendarInterval $org_scalatest_assert_macro_right10 = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
            CalendarInterval calendarInterval5 = $org_scalatest_assert_macro_left10;
            CalendarInterval calendarInterval6 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(calendarInterval5 != null ? !calendarInterval5.equals(calendarInterval6) : calendarInterval6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            String $org_scalatest_assert_macro_left11 = e2 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                CalendarInterval $org_scalatest_assert_macro_left = IntervalUtils$.MODULE$.fromYearMonthString("-178956970-9");
                CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181))).getMessage();
            String $org_scalatest_assert_macro_right11 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.contains($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("from day-time string - legacy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("5 12:40:30.999999999"));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(0, 5, 45630999999L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("10 0:12:0.888"));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(0, 10, 720000000L + DateTimeUtils$.MODULE$.millisToMicros(888L));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("-3 0:0:0"));
            CalendarInterval $org_scalatest_assert_macro_right3 = new CalendarInterval(0, -3, 0L);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            this.failFuncWithInvalidInput("5 30:12:20", "hour 30 outside range", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s));
            this.failFuncWithInvalidInput("5 30-12", "must match day-time format", (Function1<String, CalendarInterval>)(Function1 & Serializable & scala.Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s));
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("interval duration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("0 seconds", TimeUnit.MILLISECONDS, 31)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 month", TimeUnit.DAYS, 31)));
            int $org_scalatest_assert_macro_right2 = 31;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 microsecond", TimeUnit.MICROSECONDS, 30)));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 month -30 days", TimeUnit.DAYS, 31)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            ArithmeticException e = (ArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> IntervalUtilsSuite.duration$1(new StringBuilder(26).append(Integer.MAX_VALUE).append(" month").toString(), TimeUnit.SECONDS, 31), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            String $org_scalatest_assert_macro_left5 = e.getMessage();
            String $org_scalatest_assert_macro_right5 = "overflow";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("negative interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 months", 28), "isNegative(\"-1 months\", 28)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 microsecond", 30), "isNegative(\"-1 microsecond\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 month 30 days", 31), "isNegative(\"-1 month 30 days\", 31)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("2 months -61 days", 30), "isNegative(\"2 months -61 days\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 year -2 seconds", 30), "isNegative(\"-1 year -2 seconds\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("0 months", 28), "isNegative(\"0 months\", 28)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("1 year -360 days", 31), "isNegative(\"1 year -360 days\", 31)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 year 380 days", 31), "isNegative(\"-1 year 380 days\", 31)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("negate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.negateExact(new CalendarInterval(1, 2, 3L)));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(-1, -2, -3L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.negate(new CalendarInterval(1, 2, 3L)));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(-1, -2, -3L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("subtract one interval by another", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CalendarInterval input1 = new CalendarInterval(3, 1, 3600000000L);
            CalendarInterval input2 = new CalendarInterval(2, 4, 360000000000L);
            CalendarInterval input3 = new CalendarInterval(-10, -30, -291600000000L);
            CalendarInterval input4 = new CalendarInterval(75, 150, 720000000000L);
            ((IterableLike)new .colon.colon((Function2 & Serializable & scala.Serializable)(left, right) -> IntervalUtils$.MODULE$.subtractExact(left, right), (List)new .colon.colon((Function2 & Serializable & scala.Serializable)(left, right) -> IntervalUtils$.MODULE$.subtract(left, right), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)func -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new CalendarInterval(1, -3, -356400000000L));
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)input1, (Object)input2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(-85, -180, -1011600000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)input3, (Object)input4);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("add two intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CalendarInterval input1 = new CalendarInterval(3, 1, 3600000000L);
            CalendarInterval input2 = new CalendarInterval(2, 4, 360000000000L);
            CalendarInterval input3 = new CalendarInterval(-10, -30, -291600000000L);
            CalendarInterval input4 = new CalendarInterval(75, 150, 720000000000L);
            ((IterableLike)new .colon.colon((Function2 & Serializable & scala.Serializable)(left, right) -> IntervalUtils$.MODULE$.addExact(left, right), (List)new .colon.colon((Function2 & Serializable & scala.Serializable)(left, right) -> IntervalUtils$.MODULE$.add(left, right), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)func -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new CalendarInterval(5, 5, 363600000000L));
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)input1, (Object)input2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(65, 120, 428400000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)input3, (Object)input4);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("multiply by num", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Function2 & Serializable & scala.Serializable)(interval, num) -> IntervalUtils$.MODULE$.multiply(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)new .colon.colon((Function2 & Serializable & scala.Serializable)(interval, num) -> IntervalUtils$.MODULE$.multiplyExact(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)func -> {
                CalendarInterval interval = new CalendarInterval(0, 0, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(interval);
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
                interval = new CalendarInterval(123, 456, 789L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(5166, 19152, 33138L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)42.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
                interval = new CalendarInterval(-123, -456, -789L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new CalendarInterval(-5166, -19152, -33138L));
                CalendarInterval $org_scalatest_assert_macro_right3 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)42.0));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                interval = new CalendarInterval(1, 5, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new CalendarInterval(1, 7, 43200000000L));
                CalendarInterval $org_scalatest_assert_macro_right4 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)1.5));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
                interval = new CalendarInterval(2, 2, 7200000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new CalendarInterval(2, 2, 43200000000L));
                CalendarInterval $org_scalatest_assert_macro_right5 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            });
            CalendarInterval interval2 = new CalendarInterval(2, 0, 0L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.multiply(interval2, 2.147483647E9));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            ArithmeticException e = (ArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.multiplyExact(interval2, 2.147483647E9), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "overflow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("divide by num", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Function2 & Serializable & scala.Serializable)(interval, num) -> IntervalUtils$.MODULE$.divide(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)new .colon.colon((Function2 & Serializable & scala.Serializable)(interval, num) -> IntervalUtils$.MODULE$.divideExact(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)func -> {
                CalendarInterval interval = new CalendarInterval(0, 0, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(interval);
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)10.0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                interval = new CalendarInterval(1, 3, 30000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(0, 1, 43215000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)2.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new CalendarInterval(2, 6, 60000000L));
                CalendarInterval $org_scalatest_assert_macro_right3 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.5));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                interval = new CalendarInterval(-1, 0, -30000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new CalendarInterval(0, 0, -15000000L));
                CalendarInterval $org_scalatest_assert_macro_right4 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)2.0));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new CalendarInterval(-2, 0, -60000000L));
                CalendarInterval $org_scalatest_assert_macro_right5 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.5));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            });
            ObjectRef interval2 = ObjectRef.create((Object)new CalendarInterval(Integer.MAX_VALUE, Integer.MAX_VALUE, 0L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.divide((CalendarInterval)interval2.elem, 0.9));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MAX_VALUE, Integer.MAX_VALUE, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(2.06158430112E19)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            ArithmeticException e1 = (ArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.divideExact((CalendarInterval)interval$2.elem, 0.9), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            String $org_scalatest_assert_macro_left2 = e1.getMessage();
            String $org_scalatest_assert_macro_right2 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            interval2.elem = new CalendarInterval(123, 456, 789L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.divide((CalendarInterval)interval2.elem, 0.0));
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            ArithmeticException e2 = (ArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.divideExact((CalendarInterval)interval$2.elem, 0.0), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            String $org_scalatest_assert_macro_left4 = e2.getMessage();
            String $org_scalatest_assert_macro_right4 = "Division by zero";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("from day-time string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1("12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "12 hours 40 minutes");
            this.check$1("+12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "12 hours 40 minutes");
            this.check$1("-12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "-12 hours -40 minutes");
            this.checkFail$1("5 12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
            this.check$1("12:40:30.999999999", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "12 hours 40 minutes 30.999999 seconds");
            this.check$1("+12:40:30.123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "12 hours 40 minutes 30.123456 seconds");
            this.check$1("-12:40:30.123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "-12 hours -40 minutes -30.123456 seconds");
            this.checkFail$1("5 12:40:30", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.checkFail$1("12:40:30.0123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "40 minutes 30.123456 seconds");
            this.check$1("+40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "40 minutes 30.123456 seconds");
            this.check$1("-40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "-40 minutes -30.123456 seconds");
            this.checkFail$1("12:40:30", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "5 days 12 hours");
            this.check$1("+5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "5 days 12 hours");
            this.check$1("-5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "-5 days -12 hours");
            this.checkFail$1("5 12:30", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "Interval string does not match day-time format");
            this.check$1("5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.check$1("+5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.check$1("-5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "-5 days -12 hours -40 minutes");
            this.checkFail$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
            this.check$1("5 12:40:30.123", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "5 days 12 hours 40 minutes 30.123 seconds");
            this.check$1("+5 12:40:30.123456", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "5 days 12 hours 40 minutes 30.123456 seconds");
            this.check$1("-5 12:40:30.123456789", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "-5 days -12 hours -40 minutes -30.123456 seconds");
            this.checkFail$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.checkFail$1("5 30:12:20", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "hour 30 outside range");
            this.checkFail$1("5 30-12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("\t +5 12:40\t ", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.checkFail$1("+5\t 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("interval overflow check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CalendarInterval maxMonth = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            CalendarInterval minMonth = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
            CalendarInterval oneMonth = new CalendarInterval(1, 0, 0L);
            CalendarInterval maxDay = new CalendarInterval(0, Integer.MAX_VALUE, 0L);
            CalendarInterval minDay = new CalendarInterval(0, Integer.MIN_VALUE, 0L);
            CalendarInterval oneDay = new CalendarInterval(0, 1, 0L);
            CalendarInterval maxMicros = new CalendarInterval(0, 0, Long.MAX_VALUE);
            CalendarInterval minMicros = new CalendarInterval(0, 0, Long.MIN_VALUE);
            CalendarInterval oneMicros = new CalendarInterval(0, 0, 1L);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.negateExact(minMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.negate(minMonth));
            CalendarInterval $org_scalatest_assert_macro_right = minMonth;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.addExact(maxMonth, oneMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.addExact(maxDay, oneDay), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.addExact(maxMicros, oneMicros), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxMonth, oneMonth));
            CalendarInterval $org_scalatest_assert_macro_right2 = minMonth;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxDay, oneDay));
            CalendarInterval $org_scalatest_assert_macro_right3 = minDay;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxMicros, oneMicros));
            CalendarInterval $org_scalatest_assert_macro_right4 = minMicros;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minDay, oneDay), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minMonth, oneMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minMicros, oneMicros), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minMonth, oneMonth));
            CalendarInterval $org_scalatest_assert_macro_right5 = maxMonth;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minDay, oneDay));
            CalendarInterval $org_scalatest_assert_macro_right6 = maxDay;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minMicros, oneMicros));
            CalendarInterval $org_scalatest_assert_macro_right7 = maxMicros;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.multiplyExact(maxMonth, 2.0), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            return (ArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.divideExact(maxDay, 0.5), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("SPARK-34605: microseconds to duration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntervalUtils$.MODULE$.microsToDuration(0L).isZero(), "org.apache.spark.sql.catalyst.util.IntervalUtils.microsToDuration(0L).isZero()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(-1L).toNanos()));
            int $org_scalatest_assert_macro_right = -1000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(1L).toNanos()));
            int $org_scalatest_assert_macro_right2 = 1000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(Long.MAX_VALUE).toDays()));
            int $org_scalatest_assert_macro_right3 = 106751991;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(Long.MIN_VALUE).toDays()));
            int $org_scalatest_assert_macro_right4 = -106751991;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("SPARK-34605: duration to microseconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ZERO)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofSeconds(-1L))));
            int $org_scalatest_assert_macro_right2 = -1000000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofNanos(123456L))));
            int $org_scalatest_assert_macro_right3 = 123;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofDays(106751991L))));
            long $org_scalatest_assert_macro_right4 = 9223372022400000000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            String $org_scalatest_assert_macro_left5 = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.durationToMicros(Duration.ofDays(106751992L)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412))).getMessage();
            String $org_scalatest_assert_macro_right5 = "long overflow";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("SPARK-34615: period to months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.ZERO)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -1, 0))));
            int $org_scalatest_assert_macro_right2 = -1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(-1, 0, 10))));
            int $org_scalatest_assert_macro_right3 = -12;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0xAAAAAAA, 7, 0))));
            int $org_scalatest_assert_macro_right4 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(-178956970, -8, 123))));
            int $org_scalatest_assert_macro_right5 = Integer.MIN_VALUE;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, Integer.MAX_VALUE, Integer.MAX_VALUE))));
            int $org_scalatest_assert_macro_right6 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            String $org_scalatest_assert_macro_left7 = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> IntervalUtils$.MODULE$.periodToMonths(Period.of(Integer.MAX_VALUE, 0, 0)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426))).getMessage();
            String $org_scalatest_assert_macro_right7 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("SPARK-34615: months to period", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(0));
            Period $org_scalatest_assert_macro_right = Period.ZERO;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(-11));
            Period $org_scalatest_assert_macro_right2 = Period.of(0, -11, 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(11));
            Period $org_scalatest_assert_macro_right3 = Period.of(0, 11, 0);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(27));
            Period $org_scalatest_assert_macro_right4 = Period.of(2, 3, 0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(-13));
            Period $org_scalatest_assert_macro_right5 = Period.of(-1, -1, 0);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(Integer.MAX_VALUE));
            Period $org_scalatest_assert_macro_right6 = Period.ofYears(0xAAAAAAA).withMonths(7);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(Integer.MIN_VALUE));
            Period $org_scalatest_assert_macro_right7 = Period.ofYears(-178956970).withMonths(-8);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("SPARK-34695: round trip conversion of micros -> duration -> micros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 999999L, -1000000L + 1L, 1000000L, -1000000L, 9223372036853775807L, -9223372036853775808L, Long.MAX_VALUE, Long.MIN_VALUE}))).foreach((Function1 & Serializable & scala.Serializable)micros -> IntervalUtilsSuite.$anonfun$new$63(this, BoxesRunTime.unboxToLong((Object)micros))), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        this.test("SPARK-34715: Add round trip tests for period <-> month and duration <-> micros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 11, 13, 12, -12, 0x7FFFFFF3, -2147483636, Integer.MAX_VALUE, Integer.MIN_VALUE}))).foreach((Function1 & Serializable & scala.Serializable)months -> IntervalUtilsSuite.$anonfun$new$65(this, BoxesRunTime.unboxToInt((Object)months)));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Period[]{IntervalUtils$.MODULE$.monthsToPeriod(0), IntervalUtils$.MODULE$.monthsToPeriod(11), IntervalUtils$.MODULE$.monthsToPeriod(13), IntervalUtils$.MODULE$.monthsToPeriod(12), IntervalUtils$.MODULE$.monthsToPeriod(-12), IntervalUtils$.MODULE$.monthsToPeriod(0x7FFFFFF3), IntervalUtils$.MODULE$.monthsToPeriod(-2147483636), IntervalUtils$.MODULE$.monthsToPeriod(Integer.MAX_VALUE), IntervalUtils$.MODULE$.monthsToPeriod(Integer.MIN_VALUE)}))).foreach((Function1 & Serializable & scala.Serializable)period -> {
                int months = IntervalUtils$.MODULE$.periodToMonths(period);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(months));
                Period $org_scalatest_assert_macro_right = period;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Duration[]{IntervalUtils$.MODULE$.microsToDuration(0L), IntervalUtils$.MODULE$.microsToDuration(999999L), IntervalUtils$.MODULE$.microsToDuration(-1000000L + 1L), IntervalUtils$.MODULE$.microsToDuration(1000000L), IntervalUtils$.MODULE$.microsToDuration(-1000000L), IntervalUtils$.MODULE$.microsToDuration(9223372036853775807L), IntervalUtils$.MODULE$.microsToDuration(-9223372036853775808L), IntervalUtils$.MODULE$.microsToDuration(Long.MAX_VALUE), IntervalUtils$.MODULE$.microsToDuration(Long.MIN_VALUE)}))).foreach((Function1 & Serializable & scala.Serializable)duration -> {
                long micros = IntervalUtils$.MODULE$.durationToMicros(duration);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.microsToDuration(micros));
                Duration $org_scalatest_assert_macro_right = duration;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        this.test("SPARK-35016: format year-month intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple2((Object)"0-0", (Object)"INTERVAL '0-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple2((Object)"-0-11", (Object)"INTERVAL '-0-11' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple2((Object)"0-11", (Object)"INTERVAL '0-11' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple2((Object)"-1-1", (Object)"INTERVAL '-1-1' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple2((Object)"1-1", (Object)"INTERVAL '1-1' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-24)), (Object)new Tuple2((Object)"-2-0", (Object)"INTERVAL '-2-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)24)), (Object)new Tuple2((Object)"2-0", (Object)"INTERVAL '2-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)), (Object)new Tuple2((Object)"-178956970-8", (Object)"INTERVAL '-178956970-8' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)new Tuple2((Object)"178956970-7", (Object)"INTERVAL '178956970-7' YEAR TO MONTH"))}))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.HIVE_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.test("SPARK-35016: format day-time intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new Tuple2((Object)"0 00:00:00.000000000", (Object)"INTERVAL '0 00:00:00' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)new Tuple2((Object)"-0 00:00:00.000001000", (Object)"INTERVAL '-0 00:00:00.000001' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)10000L)), (Object)new Tuple2((Object)"0 00:00:00.010000000", (Object)"INTERVAL '0 00:00:00.01' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-10627203000000L)), (Object)new Tuple2((Object)"-123 00:00:03.000000000", (Object)"INTERVAL '-123 00:00:03' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)new Tuple2((Object)"-106751991 04:00:54.775808000", (Object)"INTERVAL '-106751991 04:00:54.775808' DAY TO SECOND")), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                long micros = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.HIVE_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        this.test("SPARK-35734: Format day-time intervals using type fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new Tuple10((Object)"INTERVAL '0 00:00:00' DAY TO SECOND", (Object)"INTERVAL '0 00:00' DAY TO MINUTE", (Object)"INTERVAL '0 00' DAY TO HOUR", (Object)"INTERVAL '00:00:00' HOUR TO SECOND", (Object)"INTERVAL '00:00' HOUR TO MINUTE", (Object)"INTERVAL '00:00' MINUTE TO SECOND", (Object)"INTERVAL '0' DAY", (Object)"INTERVAL '00' HOUR", (Object)"INTERVAL '00' MINUTE", (Object)"INTERVAL '00' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)new Tuple10((Object)"INTERVAL '-0 00:00:00.000001' DAY TO SECOND", (Object)"INTERVAL '-0 00:00' DAY TO MINUTE", (Object)"INTERVAL '-0 00' DAY TO HOUR", (Object)"INTERVAL '-00:00:00.000001' HOUR TO SECOND", (Object)"INTERVAL '-00:00' HOUR TO MINUTE", (Object)"INTERVAL '-00:00.000001' MINUTE TO SECOND", (Object)"INTERVAL '-0' DAY", (Object)"INTERVAL '-00' HOUR", (Object)"INTERVAL '-00' MINUTE", (Object)"INTERVAL '-00.000001' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)10000L)), (Object)new Tuple10((Object)"INTERVAL '0 00:00:00.01' DAY TO SECOND", (Object)"INTERVAL '0 00:00' DAY TO MINUTE", (Object)"INTERVAL '0 00' DAY TO HOUR", (Object)"INTERVAL '00:00:00.01' HOUR TO SECOND", (Object)"INTERVAL '00:00' HOUR TO MINUTE", (Object)"INTERVAL '00:00.01' MINUTE TO SECOND", (Object)"INTERVAL '0' DAY", (Object)"INTERVAL '00' HOUR", (Object)"INTERVAL '00' MINUTE", (Object)"INTERVAL '00.01' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-10627203000000L)), (Object)new Tuple10((Object)"INTERVAL '-123 00:00:03' DAY TO SECOND", (Object)"INTERVAL '-123 00:00' DAY TO MINUTE", (Object)"INTERVAL '-123 00' DAY TO HOUR", (Object)"INTERVAL '-2952:00:03' HOUR TO SECOND", (Object)"INTERVAL '-2952:00' HOUR TO MINUTE", (Object)"INTERVAL '-177120:03' MINUTE TO SECOND", (Object)"INTERVAL '-123' DAY", (Object)"INTERVAL '-2952' HOUR", (Object)"INTERVAL '-177120' MINUTE", (Object)"INTERVAL '-10627203' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)new Tuple10((Object)"INTERVAL '-106751991 04:00:54.775808' DAY TO SECOND", (Object)"INTERVAL '-106751991 04:00' DAY TO MINUTE", (Object)"INTERVAL '-106751991 04' DAY TO HOUR", (Object)"INTERVAL '-2562047788:00:54.775808' HOUR TO SECOND", (Object)"INTERVAL '-2562047788:00' HOUR TO MINUTE", (Object)"INTERVAL '-153722867280:54.775808' MINUTE TO SECOND", (Object)"INTERVAL '-106751991' DAY", (Object)"INTERVAL '-2562047788' HOUR", (Object)"INTERVAL '-153722867280' MINUTE", (Object)"INTERVAL '-9223372036854.775808' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)69159782123456L)), (Object)new Tuple10((Object)"INTERVAL '800 11:03:02.123456' DAY TO SECOND", (Object)"INTERVAL '800 11:03' DAY TO MINUTE", (Object)"INTERVAL '800 11' DAY TO HOUR", (Object)"INTERVAL '19211:03:02.123456' HOUR TO SECOND", (Object)"INTERVAL '19211:03' HOUR TO MINUTE", (Object)"INTERVAL '1152663:02.123456' MINUTE TO SECOND", (Object)"INTERVAL '800' DAY", (Object)"INTERVAL '19211' HOUR", (Object)"INTERVAL '1152663' MINUTE", (Object)"INTERVAL '69159782.123456' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-69159782123456L)), (Object)new Tuple10((Object)"INTERVAL '-800 11:03:02.123456' DAY TO SECOND", (Object)"INTERVAL '-800 11:03' DAY TO MINUTE", (Object)"INTERVAL '-800 11' DAY TO HOUR", (Object)"INTERVAL '-19211:03:02.123456' HOUR TO SECOND", (Object)"INTERVAL '-19211:03' HOUR TO MINUTE", (Object)"INTERVAL '-1152663:02.123456' MINUTE TO SECOND", (Object)"INTERVAL '-800' DAY", (Object)"INTERVAL '-19211' HOUR", (Object)"INTERVAL '-1152663' MINUTE", (Object)"INTERVAL '-69159782.123456' SECOND")), (List)Nil$.MODULE$)))))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                long micros = tuple2._1$mcJ$sp();
                Tuple10 tuple10 = (Tuple10)tuple2._2();
                if (tuple10 != null) {
                    String dayToSec = (String)tuple10._1();
                    String dayToMinute = (String)tuple10._2();
                    String dayToHour = (String)tuple10._3();
                    String hourToSec = (String)tuple10._4();
                    String hourToMinute = (String)tuple10._5();
                    String minuteToSec = (String)tuple10._6();
                    String day = (String)tuple10._7();
                    String hour = (String)tuple10._8();
                    String minute = (String)tuple10._9();
                    String sec = (String)tuple10._10();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right = dayToSec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right2 = dayToMinute;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()));
                    String $org_scalatest_assert_macro_right3 = dayToHour;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right4 = hourToSec;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right5 = hourToMinute;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right6 = minuteToSec;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.DAY()));
                    String $org_scalatest_assert_macro_right7 = day;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.HOUR()));
                    String $org_scalatest_assert_macro_right8 = hour;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right9 = minute;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.SECOND(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right10 = sec;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("SPARK-35771: Format year-month intervals using type fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple3((Object)"INTERVAL '0-0' YEAR TO MONTH", (Object)"INTERVAL '0' YEAR", (Object)"INTERVAL '0' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple3((Object)"INTERVAL '-0-11' YEAR TO MONTH", (Object)"INTERVAL '-0' YEAR", (Object)"INTERVAL '-11' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple3((Object)"INTERVAL '0-11' YEAR TO MONTH", (Object)"INTERVAL '0' YEAR", (Object)"INTERVAL '11' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple3((Object)"INTERVAL '-1-1' YEAR TO MONTH", (Object)"INTERVAL '-1' YEAR", (Object)"INTERVAL '-13' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple3((Object)"INTERVAL '1-1' YEAR TO MONTH", (Object)"INTERVAL '1' YEAR", (Object)"INTERVAL '13' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-24)), (Object)new Tuple3((Object)"INTERVAL '-2-0' YEAR TO MONTH", (Object)"INTERVAL '-2' YEAR", (Object)"INTERVAL '-24' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)24)), (Object)new Tuple3((Object)"INTERVAL '2-0' YEAR TO MONTH", (Object)"INTERVAL '2' YEAR", (Object)"INTERVAL '24' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)), (Object)new Tuple3((Object)"INTERVAL '-178956970-8' YEAR TO MONTH", (Object)"INTERVAL '-178956970' YEAR", (Object)"INTERVAL '-2147483648' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)new Tuple3((Object)"INTERVAL '178956970-7' YEAR TO MONTH", (Object)"INTERVAL '178956970' YEAR", (Object)"INTERVAL '2147483647' MONTH"))}))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    String yearToMonth = (String)tuple3._1();
                    String year = (String)tuple3._2();
                    String month = (String)tuple3._3();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = yearToMonth;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.YEAR()));
                    String $org_scalatest_assert_macro_right2 = year;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right3 = month;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
    }
}

