/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0006\f\u0001G!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\"\u0001A\u0003%a\u0006C\u0004E\u0001\t\u0007I\u0011B#\t\rA\u0003\u0001\u0015!\u0003G\u0011\u001d\t\u0006A1A\u0005\nICa!\u0017\u0001!\u0002\u0013\u0019\u0006\"\u0002.\u0001\t\u0013Y\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000e\u0001Q\u0001\n)DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004q\u0001\u0001\u0006IA\u000e\u0005\bc\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0011\b\u0001)A\u0005U\"91\u000f\u0001b\u0001\n\u0013y\u0007B\u0002;\u0001A\u0003%a\u0007C\u0004v\u0001\t\u0007I\u0011\u0001<\t\ru\u0004\u0001\u0015!\u0003x\u00051\u0019\u0015\r^1m_\u001e\u001cV/\u001b;f\u0015\t9\u0002$A\u0004dCR\fGn\\4\u000b\u0005eQ\u0012!C2p]:,7\r^8s\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0005\u0005\u0002&M5\tA$\u0003\u0002(9\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\f\u0002\u0015\u0015l\u0007\u000f^=Qe>\u00048/F\u0001/!\u0011yCG\u000e\u001c\u000e\u0003AR!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004GA\u0002NCB\u0004\"a\u000e!\u000f\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e#\u0003\u0019a$o\\8u})\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyD(A\u0006f[B$\u0018\u0010\u0015:paN\u0004\u0013AC3naRLHK]1ogV\ta\tE\u0002H\u0011*k\u0011\u0001P\u0005\u0003\u0013r\u0012Q!\u0011:sCf\u0004\"a\u0013(\u000e\u00031S!!\u0014\r\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001f2\u0013\u0011\u0002\u0016:b]N4wN]7\u0002\u0017\u0015l\u0007\u000f^=Ue\u0006t7\u000fI\u0001\u0007g\u000eDW-\\1\u0016\u0003M\u0003\"\u0001V,\u000e\u0003US!A\u0016\u000e\u0002\u000bQL\b/Z:\n\u0005a+&AC*ueV\u001cG\u000fV=qK\u000691o\u00195f[\u0006\u0004\u0013A\u00038fo\u000e\u000bG/\u00197pOR\tA\f\u0005\u0002,;&\u0011aL\u0006\u0002\u0010\u0013:lU-\\8ss\u000e\u000bG/\u00197pO\u00061A/Z:u\u001dN,\u0012!\u0019\t\u0004\u000f\"\u0013\u0007CA2g\u001b\u0005!'BA33\u0003\u0011a\u0017M\\4\n\u0005\u0005#\u0017a\u0002;fgRt5\u000fI\u0001\ni\u0016\u001cH/\u00133f]R,\u0012A\u001b\t\u0003W-L!\u0001\u001c\f\u0003\u0015%#WM\u001c;jM&,'/\u0001\u0006uKN$\u0018\nZ3oi\u0002\nq\u0002^3ti&#WM\u001c;Rk>$X\rZ\u000b\u0002m\u0005\u0001B/Z:u\u0013\u0012,g\u000e^)v_R,G\rI\u0001\ri\u0016\u001cH/\u00133f]RtUm^\u0001\u000ei\u0016\u001cH/\u00133f]RtUm\u001e\u0011\u0002%Q,7\u000f^%eK:$h*Z<Rk>$X\rZ\u0001\u0014i\u0016\u001cH/\u00133f]RtUm^)v_R,G\rI\u0001\tMVt7\r^5p]V\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{-\u0005Ia-\u001e8di&|gn]\u0005\u0003yf\u0014q\"\u00168c_VtGMR;oGRLwN\\\u0001\nMVt7\r^5p]\u0002\u0002")
public class CatalogSuite
extends SparkFunSuite {
    private final java.util.Map<String, String> emptyProps = Collections.emptyMap();
    private final Transform[] emptyTrans = (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class));
    private final StructType schema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
    private final String[] testNs = (String[])((Object[])new String[]{"`", "."});
    private final Identifier testIdent = Identifier.of((String[])this.testNs(), (String)"test_table");
    private final String testIdentQuoted = ((TraversableOnce)CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asMultipartIdentifier().map((Function1 & Serializable & scala.Serializable)part -> package$.MODULE$.quoteIdentifier(part), Seq$.MODULE$.canBuildFrom())).mkString(".");
    private final Identifier testIdentNew = Identifier.of((String[])this.testNs(), (String)"test_table_new");
    private final String testIdentNewQuoted = ((TraversableOnce)CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdentNew()).asMultipartIdentifier().map((Function1 & Serializable & scala.Serializable)part -> package$.MODULE$.quoteIdentifier(part), Seq$.MODULE$.canBuildFrom())).mkString(".");
    private final UnboundFunction function;

    private java.util.Map<String, String> emptyProps() {
        return this.emptyProps;
    }

    private Transform[] emptyTrans() {
        return this.emptyTrans;
    }

    private StructType schema() {
        return this.schema;
    }

    private InMemoryCatalog newCatalog() {
        InMemoryCatalog newCatalog = new InMemoryCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        return newCatalog;
    }

    private String[] testNs() {
        return this.testNs;
    }

    private Identifier testIdent() {
        return this.testIdent;
    }

    private String testIdentQuoted() {
        return this.testIdentQuoted;
    }

    private Identifier testIdentNew() {
        return this.testIdentNew;
    }

    private String testIdentNewQuoted() {
        return this.testIdentNewQuoted;
    }

    public UnboundFunction function() {
        return this.function;
    }

    public CatalogSuite() {
        this.test("Catalogs can load the catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            SQLConf conf = new SQLConf();
            conf.setConfString("spark.sql.catalog.test", catalog.getClass().getName());
            CatalogPlugin loaded = Catalogs$.MODULE$.load("test", conf);
            Class<?> $org_scalatest_assert_macro_left = loaded.getClass();
            Class<?> $org_scalatest_assert_macro_right = catalog.getClass();
            Class<?> clazz = $org_scalatest_assert_macro_left;
            Class<?> clazz2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("listTables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns2"})), (String)"test_table_1");
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            catalog.createTable(ident1, this.schema(), this.emptyTrans(), this.emptyProps());
            Set $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            catalog.createTable(ident3, this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.schema(), this.emptyTrans(), this.emptyProps());
            Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Set $org_scalatest_assert_macro_left3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            catalog.dropTable(ident1);
            Set $org_scalatest_assert_macro_left4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident2}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            catalog.dropTable(ident2);
            Object[] $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left5), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left5).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Set $org_scalatest_assert_macro_left6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})))).toSet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set9 = $org_scalatest_assert_macro_left6;
            Set set10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("createTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("createTable: with properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("property", "value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), properties);
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            HashMap<String, String> $org_scalatest_assert_macro_right3 = properties;
            java.util.Map map = $org_scalatest_assert_macro_left3;
            HashMap<String, String> hashMap = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(hashMap) : hashMap != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("createTable: table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            this.checkErrorTableAlreadyExists((SparkThrowable)exc, this.testIdentQuoted());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("tableExists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("loadTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("loadTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadTable(this.testIdent()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("invalidateTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.invalidateTable(this.testIdent());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("invalidateTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.tableExists(this.testIdent())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            catalog.invalidateTable(this.testIdent());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("alterTable: add property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-1", (String)"1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("alterTable: add property to existing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-2", (String)"2")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("alterTable: remove existing property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("alterTable: remove missing property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("alterTable: add top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("alterTable: add required column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$, false);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("alterTable: add column with comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text")}));
            StructField field = new StructField("ts", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("comment text");
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add(field);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("alterTable: add nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (DataType)DoubleType$.MODULE$)}));
            StructType expectedSchema = this.schema().add("point", (DataType)pointStruct.add("z", (DataType)DoubleType$.MODULE$));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("alterTable: add column to primitive field fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"data", "ts"})), (DataType)TimestampType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "Not a struct";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "data";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            StructType $org_scalatest_assert_macro_left4 = catalog.loadTable(this.testIdent()).schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("alterTable: add field to missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"missing_col", "new_field"})), (DataType)StringType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("alterTable: update column data type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"id"})), (DataType)LongType$.MODULE$)}));
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        this.test("alterTable: update column nullability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType originalSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            Table table = catalog.createTable(this.testIdent(), originalSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = originalSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{"id"})), (boolean)true)}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("alterTable: update missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"missing_col"})), (DataType)LongType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("alterTable: add comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "comment text").add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("alterTable: replace comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "replacement comment").add("data", (DataType)StringType$.MODULE$);
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"replacement comment")}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("alterTable: add comment to missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"comment")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        this.test("alterTable: rename top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"id"})), (String)"some_id")}));
            StructType expectedSchema = new StructType().add("some_id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("alterTable: rename nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
        this.test("alterTable: rename struct column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point"})), (String)"p")}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("p", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
        this.test("alterTable: rename missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"new_name")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("alterTable: multiple changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first"), TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (String)"second")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("second", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.test("alterTable: delete top-level column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"id"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType expectedSchema = new StructType().add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("alterTable: delete nested column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("alterTable: delete missing column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        this.test("alterTable: delete missing nested column fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, this.emptyTrans(), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "z";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right4 = tableSchema;
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
        this.test("alterTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop", (String)"val")})), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        this.test("dropTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        this.test("dropTable: table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
        this.test("purgeTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            return (UnsupportedOperationException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> catalog.purgeTable(this.testIdent()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
        this.test("renameTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
            catalog.renameTable(this.testIdent(), this.testIdentNew());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        this.test("renameTable: fail if table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
        this.test("renameTable: fail if new table name already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(this.testIdentNew(), this.schema(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            this.checkErrorTableAlreadyExists((SparkThrowable)exc, this.testIdentNewQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        this.test("listNamespaces: list namespaces from metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            Object[] $org_scalatest_assert_macro_right3 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        this.test("listNamespaces: list namespaces from tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createTable(ident1, this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.schema(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        this.test("listNamespaces: list namespaces from metadata and tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(ident1, this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.schema(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
        this.test("loadNamespaceMetadata: fail if no metadata or tables exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadNamespaceMetadata(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("loadNamespaceMetadata: no metadata, table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        this.test("loadNamespaceMetadata: metadata exists, no tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        this.test("loadNamespaceMetadata: metadata and table exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        this.test("createNamespace: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        this.test("createNamespace: fail if metadata already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
        this.test("createNamespace: fail if namespace already exists from table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = true;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("dropNamespace: drop missing namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
            boolean ret = catalog.dropNamespace(this.testNs(), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        this.test("dropNamespace: drop empty namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
            boolean ret = catalog.dropNamespace(this.testNs(), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        this.test("dropNamespace: drop even if it's not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.dropNamespace(this.testNs(), true), "catalog.dropNamespace(CatalogSuite.this.testNs, true)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.namespaceExists(this.testNs()), "catalog.namespaceExists(CatalogSuite.this.testNs)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listTables(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
        this.test("alterNamespace: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property2", (String)"value2")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property2"), (Object)"value2")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property2"), NamespaceChange.setProperty((String)"property3", (String)"value3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property3"), (Object)"value3")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
        this.test("alterNamespace: create metadata if missing and table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        this.test("alterNamespace: fail if no metadata or table exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
        this.test("truncate non-partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            InMemoryTable table = (InMemoryTable)catalog.createTable(this.testIdent(), this.schema(), this.emptyTrans(), this.emptyProps());
            table.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("3")).withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc", "3"}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("4")).withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "def", "4"})))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(table.truncateTable(), "table.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
            Seq<InternalRow> $org_scalatest_assert_macro_left = table.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        this.test("truncate partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryPartitionTableCatalog partCatalog = new InMemoryPartitionTableCatalog();
            partCatalog.initialize("test", CaseInsensitiveStringMap.empty());
            Table table = partCatalog.createTable(this.testIdent(), new StructType().add("col0", (DataType)IntegerType$.MODULE$).add("part0", (DataType)IntegerType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(LogicalExpressions$.MODULE$.parseReference("part0"))}), Collections.emptyMap());
            InMemoryPartitionTable partTable = (InMemoryPartitionTable)table;
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}));
            InternalRow partIdent1 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            partTable.createPartition(partIdent1, new HashMap<String, String>());
            partTable.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("0")).withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("1")).withRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})))}));
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            Seq<InternalRow> $org_scalatest_assert_macro_left2 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.truncateTable(), "partTable.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
            InternalRow[] $org_scalatest_assert_macro_left3 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
            Seq<InternalRow> $org_scalatest_assert_macro_left4 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
        this.function = new UnboundFunction(null){

            public BoundFunction bind(StructType inputType) {
                return new ScalarFunction<Object>(null){

                    public Object produceResult(InternalRow x$1) {
                        return super.produceResult(x$1);
                    }

                    public DataType[] inputTypes() {
                        return (DataType[])((Object[])new DataType[]{IntegerType$.MODULE$});
                    }

                    public DataType resultType() {
                        return IntegerType$.MODULE$;
                    }

                    public String name() {
                        return "my_bound_function";
                    }
                };
            }

            public String description() {
                return "my_function";
            }

            public String name() {
                return "my_function";
            }
        };
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns3"})), (String)"func3");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns2"}), this.emptyProps());
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns3"}), this.emptyProps());
            catalog.createFunction(ident1, this.function());
            catalog.createFunction(ident2, this.function());
            catalog.createFunction(ident3, this.function());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns2"})))).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns3"})))).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
            Set $org_scalatest_assert_macro_left3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1"})))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.listFunctions((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 952));
        this.test("lookup function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func");
            catalog.createNamespace((String[])((Object[])new String[]{"ns"}), this.emptyProps());
            catalog.createFunction(ident, this.function());
            UnboundFunction $org_scalatest_assert_macro_left = catalog.loadFunction(ident);
            UnboundFunction $org_scalatest_assert_macro_right = this.function();
            UnboundFunction unboundFunction = $org_scalatest_assert_macro_left;
            UnboundFunction unboundFunction2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(unboundFunction != null ? !unboundFunction.equals(unboundFunction2) : unboundFunction2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func1")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
            return (NoSuchFunctionException)this.intercept((Function0 & Serializable & scala.Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns1"})), (String)"func")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
    }
}

