/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayCompact$;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Removes null values from the array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null));\n       [1,2,3]\n      > SELECT _FUNC_(array(\"a\", \"b\", \"c\"));\n       [\"a\",\"b\",\"c\"]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005S!)Q\t\u0001C\u0001\r\"A\u0011\n\u0001EC\u0002\u0013\u0005!\n\u0003\u0005O\u0001!\u0015\r\u0011\"\u0001P\u0011!\u0019\u0006\u0001#b\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0011\u000b\u0007I\u0011I\"\t\u000be\u0003A\u0011\t.\t\u000b5\u0004A\u0011\t8\t\u000b]\u0004A\u0011\u000b=\t\u000fm\u0004\u0011\u0011!C\u0001y\"9a\u0010AI\u0001\n\u0003y\b\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0011%\t9\u0003AA\u0001\n\u0003\tI\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\b\u0013\u0005\u00055$!A\t\u0002\u0005\re\u0001\u0003\u000e\u001c\u0003\u0003E\t!!\"\t\r\u0015#B\u0011AAJ\u0011%\t)\nFA\u0001\n\u000b\n9\nC\u0005\u0002\u001aR\t\t\u0011\"!\u0002\u001c\"I\u0011q\u0014\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003[#\u0012\u0011!C\u0005\u0003_\u0013A\"\u0011:sCf\u001cu.\u001c9bGRT!\u0001H\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=}\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\b\u0001%j\u0003GN\u001d@!\tQ3&D\u0001\u001c\u0013\ta3D\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\u000b\u0018\n\u0005=Z\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u00042!\r\u001b*\u001b\u0005\u0011$BA\u001a\u001e\u0003\u0015!(/Z3t\u0013\t)$GA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u0011!fN\u0005\u0003qm\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b!J|G-^2u!\tQ\u0004)\u0003\u0002Bw\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t\u0011&\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dC\u0005C\u0001\u0016\u0001\u0011\u0015\u00115\u00011\u0001*\u0003%I7OT8u\u001dVdG.F\u0001L!\u0011QD*K\u0015\n\u00055[$!\u0003$v]\u000e$\u0018n\u001c82\u0003\tag/F\u0001Q!\tQ\u0013+\u0003\u0002S7\t\u0019b*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\u00061A.Y7cI\u0006,\u0012!\u0016\t\u0003UYK!aV\u000e\u0003\u001d1\u000bWN\u00193b\rVt7\r^5p]\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00027B\u0019A\fZ4\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011(\u0003\u0019a$o\\8u}%\tA(\u0003\u0002dw\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003Gn\u0002\"\u0001[6\u000e\u0003%T!A[\u0010\u0002\u000bQL\b/Z:\n\u00051L'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002_B\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"AX\u001e\n\u0005M\\\u0014A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a]\u001e\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t9\u0015\u0010C\u0003{\u0015\u0001\u0007\u0011&\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0005\u001dk\bb\u0002\"\f!\u0003\u0005\r!K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tAK\u0002*\u0003\u0007Y#!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fY\u0014AC1o]>$\u0018\r^5p]&!\u00111CA\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\r)\u0018QD\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00012AOA\u0017\u0013\r\tyc\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\tY\u0004E\u0002;\u0003oI1!!\u000f<\u0005\r\te.\u001f\u0005\n\u0003{y\u0011\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\"!\u0019\t)%a\u0013\u000265\u0011\u0011q\t\u0006\u0004\u0003\u0013Z\u0014AC2pY2,7\r^5p]&!\u0011QJA$\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0013\u0011\f\t\u0004u\u0005U\u0013bAA,w\t9!i\\8mK\u0006t\u0007\"CA\u001f#\u0005\u0005\t\u0019AA\u001b\u0003\u0019)\u0017/^1mgR!\u00111KA0\u0011%\tiDEA\u0001\u0002\u0004\t)\u0004K\n\u0001\u0003G\nI'a\u001b\u0002p\u0005E\u0014QOA<\u0003w\ni\bE\u0002+\u0003KJ1!a\u001a\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001c\u0002g}3UKT\"`Q\u0005\u0014(/Y=*A5\u0002#+Z7pm\u0016\u001c\bE\\;mY\u00022\u0018\r\\;fg\u00022'o\\7!i\",\u0007%\u0019:sCft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0014!a\b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001rW\u000f\u001c7*SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173YMj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bFI1#Y\u0001\u0012#M\t\u0017!E\r\u0014\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n'\u0005\f\u0012cE1\u00123MI/\u000bA\u0001\nQa\u001a:pkB\f#!!\u001f\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u007f\nQa\r\u00185]A\nA\"\u0011:sCf\u001cu.\u001c9bGR\u0004\"A\u000b\u000b\u0014\tQ\t9i\u0010\t\u0007\u0003\u0013\u000by)K$\u000e\u0005\u0005-%bAAGw\u00059!/\u001e8uS6,\u0017\u0002BAI\u0003\u0017\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\t\u0019)\u0001\u0005u_N#(/\u001b8h)\t\tI\"A\u0003baBd\u0017\u0010F\u0002H\u0003;CQAQ\fA\u0002%\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002$\u0006%\u0006\u0003\u0002\u001e\u0002&&J1!a*<\u0005\u0019y\u0005\u000f^5p]\"A\u00111\u0016\r\u0002\u0002\u0003\u0007q)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0017\t\u0005\u00037\t\u0019,\u0003\u0003\u00026\u0006u!AB(cU\u0016\u001cG\u000f")
public class ArrayCompact
extends Expression
implements RuntimeReplaceable,
UnaryLike<Expression>,
ImplicitCastInputTypes,
scala.Serializable {
    private Function1<Expression, Expression> isNotNull;
    private NamedLambdaVariable lv;
    private LambdaFunction lambda;
    private Expression replacement;
    private final Expression child;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(ArrayCompact arrayCompact) {
        return ArrayCompact$.MODULE$.unapply(arrayCompact);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArrayCompact, A> function1) {
        return ArrayCompact$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArrayCompact> compose(Function1<A, Expression> function1) {
        return ArrayCompact$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private Function1<Expression, Expression> isNotNull$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.isNotNull = (Function1 & Serializable & scala.Serializable)x -> new IsNotNull((Expression)x);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isNotNull;
    }

    public Function1<Expression, Expression> isNotNull() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isNotNull$lzycompute();
        }
        return this.isNotNull;
    }

    private NamedLambdaVariable lv$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lv = new NamedLambdaVariable("arg", ((ArrayType)this.child().dataType()).elementType(), true, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lv;
    }

    public NamedLambdaVariable lv() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.lv$lzycompute();
        }
        return this.lv;
    }

    private LambdaFunction lambda$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lambda = new LambdaFunction((Expression)this.isNotNull().apply((Object)this.lv()), (Seq<NamedExpression>)((Seq)new .colon.colon((Object)this.lv(), (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lambda;
    }

    public LambdaFunction lambda() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.lambda$lzycompute();
        }
        return this.lambda;
    }

    private Expression replacement$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.replacement = new ArrayFilter(this.child(), this.lambda());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "array_compact";
    }

    @Override
    public ArrayCompact withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ArrayCompact copy(Expression child) {
        return new ArrayCompact(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArrayCompact";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayCompact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayCompact)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayCompact arrayCompact = (ArrayCompact)x$1;
        Expression expression = this.child();
        Expression expression2 = arrayCompact.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arrayCompact.canEqual(this)) return false;
        return true;
    }

    public ArrayCompact(Expression child) {
        this.child = child;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

