/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted. The result data type is consistent with the value of\n      configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001\u0002\u0017.\u0001jB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t'\u0002\u0011\t\u0012)A\u0005w!AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003W\u0011!Q\u0006A!f\u0001\n\u0003Z\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u0011\r\u0004!Q3A\u0005\u0002\u0011D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I!\u001a\u0005\te\u0002\u0011)\u001a!C\u0001g\"Aq\u000f\u0001B\tB\u0003%A\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0005\u0002\u0002\u0001A)\u0019!C!%\"1\u0001\u0010\u0001C\u0001\u0003\u0007Aa\u0001\u001f\u0001\u0005\u0002\u0005%\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005%\u0004\u0001\"\u0015\u0002l!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0001\u0003\u000fC\u0011\"!(\u0001#\u0003%\t!a(\t\u0013\u0005\r\u0006!%A\u0005\u0002\u0005\u0015\u0006\"CAU\u0001E\u0005I\u0011AAV\u0011%\ty\u000bAI\u0001\n\u0003\t\t\fC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\"I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003#\u0004\u0011\u0011!C\u0001\u0003'D\u0011\"a8\u0001\u0003\u0003%\t%!9\t\u0013\u0005=\b!!A\u0005\u0002\u0005E\b\"CA{\u0001\u0005\u0005I\u0011IA|\u000f%\u0011\t#LA\u0001\u0012\u0003\u0011\u0019C\u0002\u0005-[\u0005\u0005\t\u0012\u0001B\u0013\u0011\u0019A(\u0005\"\u0001\u00034!I!Q\u0007\u0012\u0002\u0002\u0013\u0015#q\u0007\u0005\n\u0005s\u0011\u0013\u0011!CA\u0005wA\u0011Ba\u0012##\u0003%\t!a+\t\u0013\t%#%%A\u0005\u0002\u0005E\u0006\"\u0003B&E\u0005\u0005I\u0011\u0011B'\u0011%\u0011YFII\u0001\n\u0003\tY\u000bC\u0005\u0003^\t\n\n\u0011\"\u0001\u00022\"I!q\f\u0012\u0002\u0002\u0013%!\u0011\r\u0002\u0011!\u0006\u00148/\u001a+p)&lWm\u001d;b[BT!AL\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003aE\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003eM\n1a]9m\u0015\t!T'A\u0003ta\u0006\u00148N\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<7\u0001A\n\b\u0001mz$)\u0012%O!\taT(D\u0001.\u0013\tqTF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001\u0010!\n\u0005\u0005k#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001P\"\n\u0005\u0011k#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005q2\u0015BA$.\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%JA\u0004Qe>$Wo\u0019;\u0011\u0005%{\u0015B\u0001)K\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003m\nQ\u0001\\3gi\u0002\naAZ8s[\u0006$X#\u0001,\u0011\u0007%;6(\u0003\u0002Y\u0015\n1q\n\u001d;j_:\fqAZ8s[\u0006$\b%\u0001\u0005eCR\fG+\u001f9f+\u0005a\u0006CA/a\u001b\u0005q&BA02\u0003\u0015!\u0018\u0010]3t\u0013\t\tgL\u0001\u0005ECR\fG+\u001f9f\u0003%!\u0017\r^1UsB,\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012!\u001a\t\u0004\u0013^3\u0007CA4o\u001d\tAG\u000e\u0005\u0002j\u00156\t!N\u0003\u0002ls\u00051AH]8pizJ!!\u001c&\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[*\u000b1\u0002^5nKj{g.Z%eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005!\bCA%v\u0013\t1(JA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\u0019Q8\u0010`?\u007f\u007fB\u0011A\b\u0001\u0005\u0006#.\u0001\ra\u000f\u0005\u0006).\u0001\rA\u0016\u0005\u00065.\u0001\r\u0001\u0018\u0005\bG.\u0001\n\u00111\u0001f\u0011\u001d\u00118\u0002%AA\u0002Q\f1B]3qY\u0006\u001cW-\\3oiR)!0!\u0002\u0002\b!)\u0011+\u0004a\u0001w!)A+\u0004a\u0001wQ\u0019!0a\u0003\t\u000bEs\u0001\u0019A\u001e\u0002\u00119|G-\u001a(b[\u0016,\u0012AZ\u0001\u0015]>$W\rU1ui\u0016\u0014hn]%oi\u0016\u0014h.\u00197\u0015\u0005\u0005U\u0001CBA\f\u0003C\t9C\u0004\u0003\u0002\u001a\u0005uabA5\u0002\u001c%\t1*C\u0002\u0002 )\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"aA*fc*\u0019\u0011q\u0004&\u0011\t\u0005%\u00121\n\b\u0005\u0003W\t)E\u0004\u0003\u0002.\u0005\u0005c\u0002BA\u0018\u0003\u007fqA!!\r\u0002>9!\u00111GA\u001e\u001d\u0011\t)$!\u000f\u000f\u0007%\f9$C\u00019\u0013\t1t'\u0003\u00025k%\u0011!gM\u0005\u0003aEJ1!a\u00110\u0003\u0015!(/Z3t\u0013\u0011\t9%!\u0013\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u0003\u0007z\u0013\u0002BA'\u0003\u001f\u00121\u0002\u0016:fKB\u000bG\u000f^3s]*!\u0011qIA%\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r)\u0015Q\u000b\u0005\u0006GF\u0001\rAZ\u0001\tG\"LG\u000e\u001a:f]V\u0011\u00111\f\t\u0006\u0003/\t\tcO\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA1!\u0019\t9\"!\t\u0002dA\u0019Q,!\u001a\n\u0007\u0005\u001ddL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004w\u00055\u0004bBA8)\u0001\u0007\u0011\u0011O\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0003\u0002\u0018\u0005M4(\u0003\u0003\u0002v\u0005\u0015\"AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)-Q\u00181PA?\u0003\u007f\n\t)a!\t\u000fE+\u0002\u0013!a\u0001w!9A+\u0006I\u0001\u0002\u00041\u0006b\u0002.\u0016!\u0003\u0005\r\u0001\u0018\u0005\bGV\u0001\n\u00111\u0001f\u0011\u001d\u0011X\u0003%AA\u0002Q\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n*\u001a1(a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&K\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\"*\u001aa+a#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0015\u0016\u00049\u0006-\u0015AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[S3!ZAF\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a-+\u0007Q\fY)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-\u0001\u0003mC:<'BAAb\u0003\u0011Q\u0017M^1\n\u0007=\fi,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002LB\u0019\u0011*!4\n\u0007\u0005='JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002V\u0006m\u0007cA%\u0002X&\u0019\u0011\u0011\u001c&\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002^v\t\t\u00111\u0001\u0002L\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a9\u0011\r\u0005\u0015\u00181^Ak\u001b\t\t9OC\u0002\u0002j*\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti/a:\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004i\u0006M\b\"CAo?\u0005\u0005\t\u0019AAk\u0003\u0019)\u0017/^1mgR\u0019A/!?\t\u0013\u0005u\u0007%!AA\u0002\u0005U\u0007f\u0006\u0001\u0002~\n\r!Q\u0001B\u0005\u0005\u0017\u0011yA!\u0005\u0003\u0016\t]!1\u0004B\u000f!\ra\u0014q`\u0005\u0004\u0005\u0003i#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005\u000f\t!\u0011\u0016\u0006!A\u0001\u0002sLR+O\u0007~CC/[7fgR\fW\u000e]0tiJ\\F\u0006\t4nivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003\r^5nKN$\u0018-\u001c9`gR\u0014\b\rI3yaJ,7o]5p]\u0002:\u0018\u000e\u001e5!i\",\u0007\u0005\u00194ni\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011u_\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9/AI+G/\u001e:og\u0002rW\u000f\u001c7!o&$\b\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,HO\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t;j[\u0016\u001cH/Y7qA%4\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$g\u0006\t+iK\u0002\u0012Xm];mi\u0002\"\u0017\r^1!if\u0004X\rI5tA\r|gn]5ti\u0016tG\u000fI<ji\"\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM*\u0001\u0003\u0005\t\u0011!A\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHN\f;j[\u0016\u001cH/Y7q)f\u0004X\r\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\t5\u0011A!\u0010\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007oX:ue\u0002j\u0003%\u0011\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\r\t9beN,G\r\t;pAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t+j[\u0016\u001cH/Y7qA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t\u0004EZ8sAY\fG.\u001b3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1C\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e2ei\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012!\u0011D\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011y\"A\u00033]Ir\u0003'\u0001\tQCJ\u001cX\rV8US6,7\u000f^1naB\u0011AHI\n\u0005E\t\u001db\n\u0005\u0006\u0003*\t=2H\u0016/fijl!Aa\u000b\u000b\u0007\t5\"*A\u0004sk:$\u0018.\\3\n\t\tE\"1\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,DC\u0001B\u0012\u0003!!xn\u0015;sS:<GCAA]\u0003\u0015\t\u0007\u000f\u001d7z)-Q(Q\bB \u0005\u0003\u0012\u0019E!\u0012\t\u000bE+\u0003\u0019A\u001e\t\u000bQ+\u0003\u0019\u0001,\t\u000bi+\u0003\u0019\u0001/\t\u000f\r,\u0003\u0013!a\u0001K\"9!/\nI\u0001\u0002\u0004!\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003P\t]\u0003\u0003B%X\u0005#\u0002\u0002\"\u0013B*wYcV\r^\u0005\u0004\u0005+R%A\u0002+va2,W\u0007\u0003\u0005\u0003Z!\n\t\u00111\u0001{\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0004\u0003BA^\u0005KJAAa\u001a\u0002>\n1qJ\u00196fGR\u0004")
public class ParseToTimestamp
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
scala.Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final DataType dataType;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$5() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Option<Expression>, DataType, Option<String>, Object>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static boolean apply$default$5() {
        return ParseToTimestamp$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return ParseToTimestamp$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Option<Expression>, DataType, Option<String>, Object>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<DataType, Function1<Option<String>, Function1<Object, ParseToTimestamp>>>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression replacement$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable & scala.Serializable)f -> new GetTimestamp(this.left(), (Expression)f, this.dataType(), this.timeZoneId(), this.failOnError())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Cast$.MODULE$.apply(this.left(), this.dataType(), this.timeZoneId(), this.failOnError()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String nodeName() {
        return "to_timestamp";
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        DataType x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq types = (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$))));
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)(this.dataType() instanceof TimestampType ? (Seq)types.$colon$plus((Object)NumericType$.MODULE$, Seq$.MODULE$.canBuildFrom()) : types));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable & scala.Serializable)x$10 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId, boolean failOnError) {
        return new ParseToTimestamp(left, format, dataType, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public DataType copy$default$3() {
        return this.dataType();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public boolean copy$default$5() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.dataType();
            }
            case 3: {
                return this.timeZoneId();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = parseToTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.failOnError() != parseToTimestamp.failOnError()) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId, boolean failOnError) {
        this.left = left;
        this.format = format;
        this.dataType = dataType;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$5());
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$5());
    }
}

