/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n      > SELECT _FUNC_(2, 'a', 1);\n       1\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\u0012$\u0001BB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u00151\u0006\u0001\"\u0001\\\u0011!i\u0006\u0001#b\u0001\n\u0013q\u0006\u0002C0\u0001\u0011\u000b\u0007I\u0011\u00021\t\u000b\u0011\u0004A\u0011I)\t\u000b\u0015\u0004A\u0011\t4\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0013\u0001#\u0003%\t!!\u0014\t\u0013\u0005\r\u0004!%A\u0005\u0002\u0005\u0015\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\b\u0002\t\t\u0011\"\u0001\u0002\n\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003?\u0003\u0011\u0011!C\u0001\u0003CC\u0011\"!*\u0001\u0003\u0003%\t%a*\b\u0013\u0005-7%!A\t\u0002\u00055g\u0001\u0003\u0012$\u0003\u0003E\t!a4\t\rYSB\u0011AAo\u0011%\tyNGA\u0001\n\u000b\n\t\u000fC\u0005\u0002dj\t\t\u0011\"!\u0002f\"I\u00111\u001e\u000e\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003[T\u0012\u0011!CA\u0003_D\u0011\"!@\u001b#\u0003%\t!!\u001a\t\u0013\u0005}($!A\u0005\n\t\u0005!aA#mi*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001cUBd\b\u0005\u00023g5\t1%\u0003\u00025G\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I2\u0014BA\u001c$\u0005M\u0019V\u000f\u001d9peR\fV/\u001a:z\u0007>tG/\u001a=u!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u001d\u0001&o\u001c3vGR\u0004\"!O \n\u0005\u0001S$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C2iS2$'/\u001a8\u0016\u0003\r\u00032\u0001\u0012'2\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I_\u00051AH]8pizJ\u0011aO\u0005\u0003\u0017j\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-S\u0014!C2iS2$'/\u001a8!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003I\u0003\"!O*\n\u0005QS$a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aK&\f\u0005\u00023\u0001!)\u0011)\u0002a\u0001\u0007\"9\u0001+\u0002I\u0001\u0002\u0004\u0011FC\u0001-]\u0011\u0015\te\u00011\u0001D\u0003%Ig\u000eZ3y\u000bb\u0004(/F\u00012\u0003)Ig\u000e];u\u000bb\u0004(o]\u000b\u0002CB\u0019\u0011HY\u0019\n\u0005\rT$!B!se\u0006L\u0018\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001e\nQ\u0001^=qKNL!\u0001\\5\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0016\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003iF\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0005KZ\fG\u000e\u0006\u0002xuB\u0011\u0011\b_\u0005\u0003sj\u00121!\u00118z\u0011\u001dYH\u0002%AA\u0002q\fQ!\u001b8qkR\u0004\"! @\u000e\u0003\u0015J!a`\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$b!!\u0002\u0002\u0012\u0005m\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-1%A\u0004d_\u0012,w-\u001a8\n\t\u0005=\u0011\u0011\u0002\u0002\t\u000bb\u0004(oQ8eK\"9\u00111C\u0007A\u0002\u0005U\u0011aA2uqB!\u0011qAA\f\u0013\u0011\tI\"!\u0003\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QD\u0007A\u0002\u0005\u0015\u0011AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002Y\u0003GAq!!\n\u000f\u0001\u0004\t9#A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003\u0002#\u0002*EJ1!a\u000bO\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!!\r\u0011\u000be\n\u0019$a\u000e\n\u0007\u0005U\"H\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH\u0013\u0002\u000bQ\u0014X-Z:\n\t\u0005\u0005\u00131\b\u0002\u0010'Fc\u0015+^3ss\u000e{g\u000e^3yi\u0006!1m\u001c9z)\u0015A\u0016qIA%\u0011\u001d\t\u0005\u0003%AA\u0002\rCq\u0001\u0015\t\u0011\u0002\u0003\u0007!+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=#fA\"\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^i\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d$f\u0001*\u0002R\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!A.\u00198h\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA>\u0003c\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAA!\rI\u00141Q\u0005\u0004\u0003\u000bS$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA<\u0002\f\"I\u0011QR\u000b\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0005#BAK\u00037;XBAAL\u0015\r\tIJO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAO\u0003/\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!+a)\t\u0011\u00055u#!AA\u0002]\fa!Z9vC2\u001cHc\u0001*\u0002*\"A\u0011Q\u0012\r\u0002\u0002\u0003\u0007q\u000fK\n\u0001\u0003[\u000b\u0019,!.\u0002:\u0006m\u0016qXAa\u0003\u000b\f9\rE\u00023\u0003_K1!!-$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a.\u0002\u0005OS\u0001\u0005\t\u0011!?\u001a+fjQ0)]2\u0002\u0013N\u001c9viFb\u0003%\u001b8qkR\u0014D\u0006\t\u0018/]%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003M\u001c1.i\"\u0004\u0013N\u001c9vi2\u0002SML4/Y\u0001\u0012X\r^;s]N\u0004\u0003-\u001b8qkR\u0014\u0004\rI<iK:\u0004\u0003M\u001c1!SN\u0004#G\f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA%tG-\u001a=!Kb\u001cW-\u001a3tAQDW\r\t7f]\u001e$\b\u000eI8gAQDW\rI1se\u0006L(\u0002\t\u0011!A\u0005tG\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t4bYN,g\u0006I%gA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0017\u000bA\u0001\u0002\u0003%\u001b;!i\"\u0014xn^:!\u0003J\u0014\u0018-_%oI\u0016Dx*\u001e;PM\n{WO\u001c3t\u000bb\u001cW\r\u001d;j_:\u0004cm\u001c:!S:4\u0018\r\\5eA%tG-[2fg:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QX\u0001u\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nD\u0006I\u0014tG\u0006d\u0017m\n\u0017!O)\fg/Y\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a8-\u00197b\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012D\u0006I\u0014bO1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002D\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011\u0011Z\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u0004\u000b2$\bC\u0001\u001a\u001b'\u0011Q\u0012\u0011\u001b \u0011\u000f\u0005M\u0017\u0011\\\"S16\u0011\u0011Q\u001b\u0006\u0004\u0003/T\u0014a\u0002:v]RLW.Z\u0005\u0005\u00037\f)NA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000ba\u000b9/!;\t\u000b\u0005k\u0002\u0019A\"\t\u000fAk\u0002\u0013!a\u0001%\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005E\u0018\u0011 \t\u0006s\u0005M\u00121\u001f\t\u0006s\u0005U8IU\u0005\u0004\u0003oT$A\u0002+va2,'\u0007\u0003\u0005\u0002|~\t\t\u00111\u0001Y\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u0001B!a\u001c\u0003\u0006%!!qAA9\u0005\u0019y%M[3di\u0002")
public class Elt
extends Expression
implements SupportQueryContext {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private Option<SQLQueryContext> queryContext;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt elt) {
        return Elt$.MODULE$.unapply(elt);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.indexExpr$lzycompute();
        }
        return this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((TraversableOnce)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.inputExprs$lzycompute();
        }
        return this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)new .colon.colon((Object)"> 1", (List)Nil$.MODULE$)), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType indexType = (DataType)tuple2._1();
        DataType[] inputTypes = (DataType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
        DataType indexType2 = (DataType)tuple22._1();
        DataType[] inputTypes2 = (DataType[])tuple22._2();
        DataType dataType = indexType2;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.indexExpr())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(indexType2))}))));
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).exists((Function1 & Serializable & scala.Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2..."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)new StringBuilder(4).append(Cast$.MODULE$.toSQLType(StringType$.MODULE$)).append(" or ").append(Cast$.MODULE$.toSQLType(BinaryType$.MODULE$)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$23 -> Cast$.MODULE$.toSQLExpr((Expression)x$23), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).map((Function1 & Serializable & scala.Serializable)x$24 -> Cast$.MODULE$.toSQLType((AbstractDataType)x$24), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","))}))));
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Predef$.MODULE$.wrapRefArray((Object[])inputTypes2), this.prettyName());
    }

    @Override
    public Object eval(InternalRow input) {
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            return null;
        }
        int index = BoxesRunTime.unboxToInt((Object)indexObj);
        if (index <= 0 || index > this.inputExprs().length) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, this.inputExprs().length, this.getContextOrNull());
            }
            return null;
        }
        return this.inputExprs()[index - 1].eval(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.genCode(ctx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExprCode.class)));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ExprCode eval = (ExprCode)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n         |if (").append(indexVal).append(" == ").append(index + 1).append(") {\n         |  ").append(eval.code()).append("\n         |  ").append(inputVal).append(" = ").append(eval.isNull()).append(" ? null : ").append(eval.value()).append(";\n         |  ").append(indexMatched).append(" = true;\n         |  continue;\n         |}\n      ").toString())).stripMargin();
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])assignInputValue), "eltFunc", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |").append("boolean").append(" ").append(indexMatched).append(" = false;\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(indexMatched).append(";\n         ").toString())).stripMargin(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)x$27 -> ((TraversableOnce)x$27.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n           |").append(indexMatched).append(" = ").append((String)funcCall).append(";\n           |if (").append(indexMatched).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString());
        if (this.failOnError()) {
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n         |if (!").append(indexMatched).append(") {\n         |  throw QueryExecutionErrors.invalidArrayIndexError(").append(index.value()).append(", ").append(this.inputExprs().length).append(", ").append(errorContext).append(");\n         |}\n       ").toString())).stripMargin();
        } else {
            string = "";
        }
        String indexOutOfBoundBranch = string;
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = ", ";\n         |", " ", " = null;\n         |if (!", ") {\n         |  final int ", " = ", ";\n         |  ", " ", " = false;\n         |  ", " = null;\n         |  do {\n         |    ", "\n         |  } while (false);\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", " == null;\n         |}\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), ev.isNull(), index.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), index.isNull(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Elt withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        if (this.failOnError()) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != elt.failOnError()) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        return !((SeqLike)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$))).contains((Object)tpe);
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        SupportQueryContext.$init$(this);
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

