/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpInStr$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Searches a string for a regular expression and returns an integer that indicates the beginning position of the matched substring. Positions are 1-based, not 0-based. If no match is found, returns 0.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('user@spark.apache.org', '@[^.]*');\n       5\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0010!\u00016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011!\u0019\u0005A!f\u0001\n\u0003a\u0004\u0002\u0003#\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b\u0015\u0003A\u0011A&\t\u000bA\u0003A\u0011I)\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\t2\t\u000b9\u0004A\u0011K8\t\u000bu\u0004A\u0011\u000b@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\u000b\u0001E\u0005I\u0011AA\f\u0011%\ti\u0003AI\u0001\n\u0003\t9\u0002C\u0005\u00020\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\t\t\bAA\u0001\n\u0003\n\u0019hB\u0005\u0002\u001e\u0002\n\t\u0011#\u0001\u0002 \u001aAq\u0004IA\u0001\u0012\u0003\t\t\u000b\u0003\u0004F3\u0011\u0005\u0011q\u0016\u0005\n\u0003cK\u0012\u0011!C#\u0003gC\u0011\"!.\u001a\u0003\u0003%\t)a.\t\u0013\u0005}\u0016$!A\u0005\u0002\u0006\u0005\u0007\"CAj3\u0005\u0005I\u0011BAk\u0005-\u0011VmZ#ya&s7\u000b\u001e:\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u00183qA\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0012%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;CCN,\u0007CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002)s_\u0012,8\r\u001e\t\u0003geJ!A\u000f\u001b\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fM,(M[3diV\tQ\b\u0005\u00020}%\u0011q\b\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:vE*,7\r\u001e\u0011\u0002\rI,w-\u001a=q\u0003\u001d\u0011XmZ3ya\u0002\n1!\u001b3y\u0003\u0011IG\r\u001f\u0011\u0002\rqJg.\u001b;?)\u00119\u0005*\u0013&\u0011\u0005=\u0002\u0001\"B\u001e\b\u0001\u0004i\u0004\"B!\b\u0001\u0004i\u0004\"B\"\b\u0001\u0004iDcA$M\u001d\")Q\n\u0003a\u0001{\u0005\t1\u000fC\u0003P\u0011\u0001\u0007Q(A\u0001s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\u0011VKV,\u0011\u0005M\u001a\u0016B\u0001+5\u0005\r\te.\u001f\u0005\u0006\u001b&\u0001\rA\u0015\u0005\u0006\u001f&\u0001\rA\u0015\u0005\u00061&\u0001\rAU\u0001\u0002S\u0006AA-\u0019;b)f\u0004X-F\u0001\\!\tav,D\u0001^\u0015\tqF%A\u0003usB,7/\u0003\u0002a;\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u0019\t\u0003I.t!!Z5\u0011\u0005\u0019$T\"A4\u000b\u0005!d\u0013A\u0002\u001fs_>$h(\u0003\u0002ki\u00051\u0001K]3eK\u001aL!\u0001\\7\u0003\rM#(/\u001b8h\u0015\tQG'A\u0005e_\u001e+gnQ8eKR\u0019\u0001O^>\u0011\u0005E$X\"\u0001:\u000b\u0005M\u0004\u0013aB2pI\u0016<WM\\\u0005\u0003kJ\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006o2\u0001\r\u0001_\u0001\u0004GRD\bCA9z\u0013\tQ(O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bqd\u0001\u0019\u00019\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u00199u0a\u0001\u0002\b!1\u0011\u0011A\u0007A\u0002u\n\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0003\u000bi\u0001\u0019A\u001f\u0002\u00139,woU3d_:$\u0007BBA\u0005\u001b\u0001\u0007Q(\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000f\u001d\u000by!!\u0005\u0002\u0014!91H\u0004I\u0001\u0002\u0004i\u0004bB!\u000f!\u0003\u0005\r!\u0010\u0005\b\u0007:\u0001\n\u00111\u0001>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0007+\u0007u\nYb\u000b\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!C;oG\",7m[3e\u0015\r\t9\u0003N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0016\u0003C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003mC:<'BAA \u0003\u0011Q\u0017M^1\n\u00071\fI$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002HA\u00191'!\u0013\n\u0007\u0005-CGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002S\u0003#B\u0011\"a\u0015\u0015\u0003\u0003\u0005\r!a\u0012\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0006E\u0003\u0002\\\u0005\u0005$+\u0004\u0002\u0002^)\u0019\u0011q\f\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002d\u0005u#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001b\u0002pA\u00191'a\u001b\n\u0007\u00055DGA\u0004C_>dW-\u00198\t\u0011\u0005Mc#!AA\u0002I\u000ba!Z9vC2\u001cH\u0003BA5\u0003kB\u0001\"a\u0015\u0018\u0003\u0003\u0005\rA\u0015\u0015\u0018\u0001\u0005e\u0014qPAA\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151SAL\u00033\u00032aLA>\u0013\r\ti\b\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019)AAe\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u0002#/Z4fqBL\u0003%\f\u0011TK\u0006\u00148\r[3tA\u0005\u00043\u000f\u001e:j]\u001e\u0004cm\u001c:!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!C:$\u0007E]3ukJt7\u000fI1oA%tG/Z4fe\u0002\"\b.\u0019;!S:$\u0017nY1uKN\u0004C\u000f[3!E\u0016<\u0017N\u001c8j]\u001e\u0004\u0003o\\:ji&|g\u000eI8gAQDW\rI7bi\u000eDW\r\u001a\u0011tk\n\u001cHO]5oO:\u0002\u0003k\\:ji&|gn\u001d\u0011be\u0016\u0004\u0013'\f2bg\u0016$G\u0006\t8pi\u0002\u0002TFY1tK\u0012t\u0003%\u00134!]>\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$G\u0006\t:fiV\u0014hn\u001d\u00111])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011R\u0001\u0006:)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3hKb\u0004\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t&bm\u0006\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]q\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011TS:\u001cW\rI*qCJ\\\u0007E\r\u00181Y\u0001\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u001c\b\u0005K5oG2,H-\u001b8hAI,w-\u001a=!a\u0006$H/\u001a:og&\u0002\u0013M]3!k:,7oY1qK\u0012\u0004\u0013N\u001c\u0011pkJ\u00043+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:tKJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002Co\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005\f\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011g_J\u0004\u0003M]3hKb\u0004\b\rI2b]\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\trF\fX1cG\u0012\u0012c\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a:fA%\u001c\b%\u0019\u0011T#2\u00033m\u001c8gS\u001e\u0004se\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197tO\u0001\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\r\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ1mY\n\f7m\u001b\u0011u_\u0002\"\b.\u001a\u0011Ta\u0006\u00148\u000eI\u0019/m\u0001\u0012W\r[1wS>\u0014\bE]3hCJ$\u0017N\\4!gR\u0014\u0018N\\4!Y&$XM]1mAA\f'o]5oO:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5gAQDW\rI2p]\u001aLw\rI5tA\u0015t\u0017M\u00197fI2\u0002C\u000f[3!AJ,w-\u001a=qA\u0002\"\b.\u0019;!G\u0006t\u0007%\\1uG\"\u0004#\u0005X1cG\n\u0002\u0013n\u001d\u0011#=r\u000b'm\u0019\u0013#])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty)\u0001+\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d*8/\u001a:AgB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e<C\u0006I\u0014A7zsSLK\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0015!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAAN\u00031\u0019HO]5oO~3WO\\2t\u0003-\u0011VmZ#ya&s7\u000b\u001e:\u0011\u0005=J2\u0003B\r\u0002$b\u0002\u0002\"!*\u0002,vjThR\u0007\u0003\u0003OS1!!+5\u0003\u001d\u0011XO\u001c;j[\u0016LA!!,\u0002(\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005}\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005U\u0012!B1qa2LHcB$\u0002:\u0006m\u0016Q\u0018\u0005\u0006wq\u0001\r!\u0010\u0005\u0006\u0003r\u0001\r!\u0010\u0005\u0006\u0007r\u0001\r!P\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019-a4\u0011\u000bM\n)-!3\n\u0007\u0005\u001dGG\u0001\u0004PaRLwN\u001c\t\u0007g\u0005-W(P\u001f\n\u0007\u00055GG\u0001\u0004UkBdWm\r\u0005\t\u0003#l\u0012\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003/\u0004B!a\u000e\u0002Z&!\u00111\\A\u001d\u0005\u0019y%M[3di\u0002")
public class RegExpInStr
extends RegExpExtractBase
implements scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpInStr regExpInStr) {
        return RegExpInStr$.MODULE$.unapply(regExpInStr);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpInStr> tupled() {
        return RegExpInStr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpInStr>>> curried() {
        return RegExpInStr$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object r, Object i) {
        Integer n;
        block3: {
            try {
                Matcher m = this.getLastMatcher(s, r);
                if (m.find()) {
                    n = BoxesRunTime.boxToInteger((int)(m.toMatchResult().start() + 1));
                    break block3;
                }
                n = BoxesRunTime.boxToInteger((int)0);
            }
            catch (IllegalStateException illegalStateException) {
                n = BoxesRunTime.boxToInteger((int)0);
            }
        }
        return n;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_instr";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String matcher = ctx.freshName("matcher");
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, x$5) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n         |try {\n         |  ").append(setEvNotNull).append("\n         |  ").append(this.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher)).append("\n         |  if (").append(matcher).append(".find()) {\n         |    ").append(ev.value()).append(" = ").append(matcher).append(".toMatchResult().start() + 1;\n         |  } else {\n         |    ").append(ev.value()).append(" = 0;\n         |  }\n         |} catch (IllegalStateException e) {\n         |  ").append(ev.value()).append(" = 0;\n         |}\n         |").toString())).stripMargin());
    }

    @Override
    public RegExpInStr withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpInStr copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpInStr(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpInStr";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.subject();
            }
            case 1: {
                return this.regexp();
            }
            case 2: {
                return this.idx();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpInStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpInStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpInStr regExpInStr = (RegExpInStr)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpInStr.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpInStr.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpInStr.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpInStr.canEqual(this)) return false;
        return true;
    }

    public RegExpInStr(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpInStr(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

