/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.GeneratedColumnAnalyzer$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeneratedColumn$ {
    public static GeneratedColumn$ MODULE$;
    private CatalystSqlParser parser;
    private final String GENERATION_EXPRESSION_METADATA_KEY;
    private volatile boolean bitmap$0;

    static {
        new GeneratedColumn$();
    }

    public String GENERATION_EXPRESSION_METADATA_KEY() {
        return this.GENERATION_EXPRESSION_METADATA_KEY;
    }

    private CatalystSqlParser parser$lzycompute() {
        GeneratedColumn$ generatedColumn$ = this;
        synchronized (generatedColumn$) {
            if (!this.bitmap$0) {
                this.parser = new CatalystSqlParser();
                this.bitmap$0 = true;
            }
        }
        return this.parser;
    }

    private CatalystSqlParser parser() {
        if (!this.bitmap$0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    public boolean isGeneratedColumn(StructField field) {
        return field.metadata().contains(this.GENERATION_EXPRESSION_METADATA_KEY());
    }

    public Option<String> getGenerationExpression(StructField field) {
        if (this.isGeneratedColumn(field)) {
            return new Some((Object)field.metadata().getString(this.GENERATION_EXPRESSION_METADATA_KEY()));
        }
        return None$.MODULE$;
    }

    public boolean hasGeneratedColumns(StructType schema) {
        return schema.exists((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
    }

    private void analyzeAndVerifyExpression(String expressionStr, String fieldName, DataType dataType, StructType schema, String statementType) {
        LogicalPlan logicalPlan;
        Expression expression;
        try {
            expression = this.parser().parseExpression(expressionStr);
        }
        catch (ParseException ex) {
            throw SparkException$.MODULE$.internalError(new StringBuilder(118).append("Failed to execute ").append(statementType).append(" command because the column ").append(fieldName).append(" has ").append("generation expression ").append(expressionStr).append(" which fails to parse as a valid expression:").append("\n").append(ex.getMessage()).toString());
        }
        Expression parsed = expression;
        if (parsed.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw GeneratedColumn$.unsupportedExpressionError$1("subquery expressions are not allowed for generated columns", fieldName, expressionStr);
        }
        Seq allowedBaseColumns = (Seq)((TraversableLike)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.$anonfun$analyzeAndVerifyExpression$1(fieldName, x$1)))).filterNot((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
        LocalRelation relation = new LocalRelation(CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(StructType$.MODULE$.apply((Seq<StructField>)allowedBaseColumns)).toAttributes(), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3());
        try {
            GeneratedColumnAnalyzer$ analyzer = GeneratedColumnAnalyzer$.MODULE$;
            Expression x$12 = parsed;
            String x$2 = fieldName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$12, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$12, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$12, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$12, x$2);
            LogicalPlan analyzed = analyzer.execute(new Project((Seq<NamedExpression>)((Seq)new .colon.colon((Object)new Alias(x$12, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)), relation));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = analyzed;
        }
        catch (AnalysisException ex) {
            String string = ex.getErrorClass();
            String string2 = "UNRESOLVED_COLUMN.WITH_SUGGESTION";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                ex.messageParameters().get((Object)"objectName").foreach((Function1 & Serializable & scala.Serializable)unresolvedCol -> {
                    GeneratedColumn$.$anonfun$analyzeAndVerifyExpression$3(fieldName, schema, expressionStr, unresolvedCol);
                    return BoxedUnit.UNIT;
                });
            }
            String string3 = ex.getErrorClass();
            String string4 = "UNRESOLVED_ROUTINE";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                ex.messageParameters().get((Object)"routineName").foreach((Function1 & Serializable & scala.Serializable)fnName -> {
                    throw GeneratedColumn$.unsupportedExpressionError$1(new StringBuilder(41).append("failed to resolve ").append((String)fnName).append(" to a built-in function").toString(), fieldName, expressionStr);
                });
            }
            throw ex;
        }
        LogicalPlan plan2 = logicalPlan;
        Expression analyzed = (Expression)plan2.collectFirst(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                NamedExpression a;
                Project project;
                Seq<NamedExpression> seq;
                Some some;
                A1 A1 = x1;
                if (A1 instanceof Project && !(some = Seq$.MODULE$.unapplySeq(seq = (project = (Project)A1).projectList())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias) {
                    Alias alias = (Alias)a;
                    if (project.child() instanceof LocalRelation) {
                        return (B1)alias.child();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                NamedExpression a;
                Project project;
                Seq<NamedExpression> seq;
                Some some;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Project && !(some = Seq$.MODULE$.unapplySeq(seq = (project = (Project)logicalPlan).projectList())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias && project.child() instanceof LocalRelation;
            }
        }).get();
        if (!analyzed.deterministic()) {
            throw GeneratedColumn$.unsupportedExpressionError$1("generation expression is not deterministic", fieldName, expressionStr);
        }
        if (!Cast$.MODULE$.canUpCast(analyzed.dataType(), dataType)) {
            throw GeneratedColumn$.unsupportedExpressionError$1(new StringBuilder(71).append("generation expression data type ").append(analyzed.dataType().simpleString()).append(" ").append("is incompatible with column data type ").append(dataType.simpleString()).toString(), fieldName, expressionStr);
        }
    }

    private void verifyGeneratedColumns(StructType schema, String statementType) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            GeneratedColumn$.$anonfun$verifyGeneratedColumns$1(schema, statementType, field);
            return BoxedUnit.UNIT;
        });
    }

    public void validateGeneratedColumns(StructType schema, TableCatalog catalog, Identifier ident, String statementType) {
        if (this.hasGeneratedColumns(schema)) {
            if (!catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORTS_CREATE_TABLE_WITH_GENERATED_COLUMNS)) {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "generated columns");
            }
            this.verifyGeneratedColumns(schema, statementType);
            return;
        }
    }

    private static final AnalysisException unsupportedExpressionError$1(String reason, String fieldName$1, String expressionStr$1) {
        return new AnalysisException("UNSUPPORTED_EXPRESSION_GENERATED_COLUMN", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)fieldName$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressionStr"), (Object)expressionStr$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)}))));
    }

    public static final /* synthetic */ boolean $anonfun$analyzeAndVerifyExpression$1(String fieldName$1, StructField x$1) {
        String string = x$1.name();
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final boolean isUnresolvedCol$1(String col, Function2 resolver$1, String unresolvedCol$1) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)unresolvedCol$1, (Object)QueryCompilationErrors$.MODULE$.toSQLId(col)));
    }

    public static final /* synthetic */ boolean $anonfun$analyzeAndVerifyExpression$4(Function2 resolver$1, String unresolvedCol$1, StructField col) {
        return MODULE$.isGeneratedColumn(col) && GeneratedColumn$.isUnresolvedCol$1(col.name(), resolver$1, unresolvedCol$1);
    }

    public static final /* synthetic */ void $anonfun$analyzeAndVerifyExpression$3(String fieldName$1, StructType schema$1, String expressionStr$1, String unresolvedCol) {
        Function2<String, String, Object> resolver = SQLConf$.MODULE$.get().resolver();
        if (GeneratedColumn$.isUnresolvedCol$1(fieldName$1, resolver, unresolvedCol)) {
            throw GeneratedColumn$.unsupportedExpressionError$1("generation expression cannot reference itself", fieldName$1, expressionStr$1);
        }
        if (schema$1.exists((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.$anonfun$analyzeAndVerifyExpression$4(resolver, unresolvedCol, col)))) {
            throw GeneratedColumn$.unsupportedExpressionError$1("generation expression cannot reference another generated column", fieldName$1, expressionStr$1);
        }
    }

    public static final /* synthetic */ void $anonfun$verifyGeneratedColumns$1(StructType schema$2, String statementType$1, StructField field) {
        MODULE$.getGenerationExpression(field).foreach((Function1 & Serializable & scala.Serializable)expressionStr -> {
            GeneratedColumn$.MODULE$.analyzeAndVerifyExpression(expressionStr, field.name(), field.dataType(), schema$2, statementType$1);
            return BoxedUnit.UNIT;
        });
    }

    private GeneratedColumn$() {
        MODULE$ = this;
        this.GENERATION_EXPRESSION_METADATA_KEY = "GENERATION_EXPRESSION";
    }
}

