/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExamplePluginCommand;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.connect.proto.WriteOperation;
import org.apache.spark.connect.proto.WriteOperationV2;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.CreateTableWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.apache.spark.sql.functions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4Aa\u0004\t\u00013!)\u0001\u0007\u0001C\u0001c!IA\u0007\u0001a\u0001\u0002\u0004%I!\u000e\u0005\n}\u0001\u0001\r\u00111A\u0005\n}B\u0011\u0002\u0013\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001c\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0005\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0003Q\u0011%\u0011\u0006\u00011A\u0001B\u0003&1\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\"I\u0001\f\u0001a\u0001\u0002\u0004%I!\u0017\u0005\n7\u0002\u0001\r\u0011!Q!\nUCQ\u0001\u0018\u0001\u0005\nuCQA\u0018\u0001\u0005\n}CQ\u0001\u0019\u0001\u0005B}CQ!\u0019\u0001\u0005B}\u0013A\u0002R1uCN,GoU;ji\u0016T!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000e#YA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\tMVt7/^5uK*\u0011qDF\u0001\ng\u000e\fG.\u0019;fgRL!!\t\u000f\u0003\u0017\u0005s\u0017PR;o'VLG/\u001a\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\nA!\u001e;jY*\u0011q\u0005K\u0001\u0007G2LWM\u001c;\u000b\u0005%\u0002\u0012aB2p]:,7\r^\u0005\u0003W\u0011\u0012qbQ8o]\u0016\u001cGOR;o'VLG/\u001a\t\u0003[9j\u0011AH\u0005\u0003_y\u0011!CQ3g_J,\u0017I\u001c3BMR,'/R1dQ\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011\u0001E\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t\u001d\u0014\bo\u0019\u0006\u0002w\u0005\u0011\u0011n\\\u0005\u0003{a\u0012aaU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000fC\u0004H\u0007\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u000fM,'O^5dKV\t1\n\u0005\u0002M\u001b6\ta%\u0003\u0002OM\tAB)^7nsN\u0003\u0018M]6D_:tWm\u0019;TKJ4\u0018nY3\u0002\u0017M,'O^5dK~#S-\u001d\u000b\u0003\u0001FCqa\u0012\u0004\u0002\u0002\u0003\u00071*\u0001\u0005tKJ4\u0018nY3!\u0003\t\u00198/F\u0001V!\t\u0019d+\u0003\u0002X!\ta1\u000b]1sWN+7o]5p]\u000611o]0%KF$\"\u0001\u0011.\t\u000f\u001dK\u0011\u0011!a\u0001+\u0006\u00191o\u001d\u0011\u0002\u001f9,wo\u00159be.\u001cVm]:j_:$\u0012!V\u0001\u0011gR\f'\u000f\u001e#v[6L8+\u001a:wKJ$\u0012\u0001Q\u0001\u000bE\u00164wN]3FC\u000eD\u0017!C1gi\u0016\u0014X)Y2i\u0001")
public class DatasetSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private Server server;
    private DummySparkConnectService service;
    private SparkSession ss;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private SparkSession ss() {
        return this.ss;
    }

    private void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    private SparkSession newSparkSession() {
        SparkConnectClient client = new SparkConnectClient(UserContext.newBuilder().build(), InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor(), "test");
        return new SparkSession(client, SparkSession$.MODULE$.cleaner(), new AtomicLong());
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.ss_$eq(this.newSparkSession());
    }

    public void afterEach() {
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "DatasetSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(Relation.Builder x$1) {
    }

    public static final /* synthetic */ void $anonfun$new$4(Relation.Builder x$2) {
    }

    public static final /* synthetic */ void $anonfun$new$6(Relation.Builder x$3) {
    }

    public static final /* synthetic */ void $anonfun$new$8(Relation.Builder x$4) {
    }

    public DatasetSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable & scala.Serializable)x$1 -> {
                DatasetSuite.$anonfun$new$2(x$1);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder();
            builder.setInput(df.plan().getRoot()).setPath("my/test/path").setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("parquet").addSortColumnNames("col1").addPartitioningColumns("col99").setBucketBy(WriteOperation.BucketBy.newBuilder().setNumBuckets(2).addBucketColumnNames("col1").addBucketColumnNames("col2"));
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
            df.write().sortBy("col1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col99"})).bucketBy(2, "col1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col2"})).parquet("my/test/path");
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("write jdbc", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable & scala.Serializable)x$2 -> {
                DatasetSuite.$anonfun$new$4(x$2);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperation.Builder builder = WriteOperation.newBuilder();
            builder.setInput(df.plan().getRoot()).setMode(WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS).setSource("jdbc").putOptions("a", "b").putOptions("1", "2").putOptions("url", "url").putOptions("dbtable", "table");
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperation(builder)).build();
            Properties connectionProperties = new Properties();
            connectionProperties.put("a", "b");
            connectionProperties.put("1", "2");
            df.write().jdbc("url", "table", connectionProperties);
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("write V2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable & scala.Serializable)x$3 -> {
                DatasetSuite.$anonfun$new$6(x$3);
                return BoxedUnit.UNIT;
            }).limit(10);
            WriteOperationV2.Builder builder = WriteOperationV2.newBuilder();
            builder.setInput(df.plan().getRoot()).setTableName("t1").addPartitioningColumns(functions$.MODULE$.col("col99").expr()).setProvider("json").putTableProperties("key", "value").putOptions("key2", "value2").setMode(WriteOperationV2.Mode.MODE_CREATE_OR_REPLACE);
            Plan expectedPlan = Plan.newBuilder().setCommand(Command.newBuilder().setWriteOperationV2(builder)).build();
            ((CreateTableWriter)df.writeTo("t1").partitionedBy(functions$.MODULE$.col("col99"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).using("json").tableProperty("key", "value").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"value2")})))).createOrReplace();
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("Pivot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.ss().newDataFrame((Function1 & Serializable & scala.Serializable)x$4 -> {
                DatasetSuite.$anonfun$new$8(x$4);
                return BoxedUnit.UNIT;
            });
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> df.groupBy((Seq)Nil$.MODULE$).pivot(Column$.MODULE$.apply("c"), (Seq)new .colon.colon((Object)Column$.MODULE$.apply("col"), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("command extension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExamplePluginCommand extension = ExamplePluginCommand.newBuilder().setCustomField("abc").build();
            Command command = Command.newBuilder().setExtension(Any.pack((Message)extension)).build();
            Plan expectedPlan = Plan.newBuilder().setCommand(command).build();
            this.ss().execute(Any.pack((Message)extension));
            Plan actualPlan = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actualPlan.equals((Object)expectedPlan), "actualPlan.equals(expectedPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("DatasetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }
}

