/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.connect.proto.ExamplePluginCommand;
import org.apache.spark.connect.proto.ExamplePluginExpression;
import org.apache.spark.connect.proto.ExamplePluginRelation;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.PlanGenerationTestSuite$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001\u0002\u001c8\u0001\u0001CQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004m\u0001\u0001\u0006IA\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0005o\u0011\u0019I\b\u0001)A\u0005_\"9!\u0010\u0001b\u0001\n#q\u0007BB>\u0001A\u0003%q\u000eC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005=\u0002\u0001)A\u0005}\"I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00026!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005e\u0003\u00011A\u0001B\u0003&\u0011Q\t\u0005\b\u00037\u0002A\u0011KA/\u0011\u001d\ty\u0006\u0001C)\u0003;Bq!!\u0019\u0001\t#\ni\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006\"CAc\u0001\t\u0007I\u0011BAd\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005%\u0007\"CAk\u0001\t\u0007I\u0011BAl\u0011!\t)\u000f\u0001Q\u0001\n\u0005e\u0007\"CAt\u0001\t\u0007I\u0011BAu\u0011!\tY\u000f\u0001Q\u0001\n\u0005U\u0005\"CAw\u0001\t\u0007I\u0011BAl\u0011!\ty\u000f\u0001Q\u0001\n\u0005e\u0007\"CAy\u0001\t\u0007I\u0011BAu\u0011!\t\u0019\u0010\u0001Q\u0001\n\u0005U\u0005\"CA{\u0001\t\u0007I\u0011BAl\u0011!\t9\u0010\u0001Q\u0001\n\u0005e\u0007\"CA}\u0001\t\u0007I\u0011BAu\u0011!\tY\u0010\u0001Q\u0001\n\u0005U\u0005\"CA\u007f\u0001\t\u0007I\u0011BAl\u0011!\ty\u0010\u0001Q\u0001\n\u0005e\u0007\"\u0003B\u0001\u0001\t\u0007I\u0011BAu\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005U\u0005\"\u0003B\u0003\u0001\t\u0007I\u0011BAl\u0011!\u00119\u0001\u0001Q\u0001\n\u0005e\u0007\"\u0003B\u0005\u0001\t\u0007I\u0011BAu\u0011!\u0011Y\u0001\u0001Q\u0001\n\u0005U\u0005b\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u00119\u0003\u0001C\u0005\u0005KAqA!\u000b\u0001\t\u0013\u0011)\u0003C\u0004\u0003,\u0001!IA!\n\t\u000f\t5\u0002\u0001\"\u0003\u0003&!9!q\u0006\u0001\u0005\n\t\u0015\u0002b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fBqAa\u0016\u0001\t\u0013\u0011IFA\fQY\u0006tw)\u001a8fe\u0006$\u0018n\u001c8UKN$8+^5uK*\u0011\u0001(O\u0001\u0004gFd'B\u0001\u001e<\u0003\u0015\u0019\b/\u0019:l\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M1\u0001!Q%T/j\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0011\u0019,hn];ji\u0016T!AR\u001f\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001%D\u0005-\te.\u001f$v]N+\u0018\u000e^3\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015\u0001B;uS2T!AT(\u0002\r\rd\u0017.\u001a8u\u0015\t\u0001v'A\u0004d_:tWm\u0019;\n\u0005I[%aD\"p]:,7\r\u001e$v]N+\u0018\u000e^3\u0011\u0005Q+V\"A#\n\u0005Y+%!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mYB\u0011A\u000bW\u0005\u00033\u0016\u0013!CQ3g_J,\u0017I\u001c3BMR,'/R1dQB\u00111LX\u0007\u00029*\u0011Q,O\u0001\tS:$XM\u001d8bY&\u0011q\f\u0018\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\r\u0005\u0002d\u00015\tq'A\u000bsK\u001e,g.\u001a:bi\u0016<u\u000e\u001c3f]\u001aKG.Z:\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014qAQ8pY\u0016\fg.\u0001\fsK\u001e,g.\u001a:bi\u0016<u\u000e\u001c3f]\u001aKG.Z:!\u00035\tX/\u001a:z\r&dW\rU1uQV\tq\u000e\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006!a-\u001b7f\u0015\t!X/A\u0002oS>T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yc\n!\u0001+\u0019;i\u00039\tX/\u001a:z\r&dW\rU1uQ\u0002\nA\u0002^3ti\u0012\u000bG/\u0019)bi\"\fQ\u0002^3ti\u0012\u000bG/\u0019)bi\"\u0004\u0013\u0001\u0003:fO&\u001cHO]=\u0016\u0003y\u00042a`A\u0015\u001d\u0011\t\t!a\t\u000f\t\u0005\r\u0011q\u0004\b\u0005\u0003\u000b\tIB\u0004\u0003\u0002\b\u0005Ma\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055q(\u0001\u0004=e>|GOP\u0005\u0003\u0003#\t1aY8n\u0013\u0011\t)\"a\u0006\u0002\r\u001d|wn\u001a7f\u0015\t\t\t\"\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00039s_R|'-\u001e4\u000b\t\u0005U\u0011qC\u0005\u0004\u0019\u0006\u0005\"\u0002BA\u000e\u0003;IA!!\n\u0002(\u0005Q!j]8o\r>\u0014X.\u0019;\u000b\u00071\u000b\t#\u0003\u0003\u0002,\u00055\"\u0001\u0004+za\u0016\u0014VmZ5tiJL(\u0002BA\u0013\u0003O\t\u0011B]3hSN$(/\u001f\u0011\u0002\u000fA\u0014\u0018N\u001c;feV\u0011\u0011Q\u0007\t\u0005\u0003o\tYD\u0004\u0003\u0002:\u0005\rRBAA\u0014\u0013\u0011\ti$!\f\u0003\u000fA\u0013\u0018N\u001c;fe\u0006A\u0001O]5oi\u0016\u0014\b%A\u0004tKN\u001c\u0018n\u001c8\u0016\u0005\u0005\u0015\u0003cA2\u0002H%\u0019\u0011\u0011J\u001c\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0017M,7o]5p]~#S-\u001d\u000b\u0005\u0003\u001f\n)\u0006E\u0002h\u0003#J1!a\u0015i\u0005\u0011)f.\u001b;\t\u0013\u0005]S\"!AA\u0002\u0005\u0015\u0013a\u0001=%c\u0005A1/Z:tS>t\u0007%A\u0005cK\u001a|'/Z!mYR\u0011\u0011qJ\u0001\u000bE\u00164wN]3FC\u000eD\u0017\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\tQ,7\u000f\u001e\u000b\u0005\u0003O\n\t\n\u0006\u0003\u0002P\u0005%\u0004\u0002CA6%\u0011\u0005\r!!\u001c\u0002\u0003\u0019\u0004RaZA8\u0003gJ1!!\u001di\u0005!a$-\u001f8b[\u0016t\u0004\u0007BA;\u0003\u007f\u0002RaYA<\u0003wJ1!!\u001f8\u0005\u001d!\u0015\r^1tKR\u0004B!! \u0002\u00001\u0001A\u0001DAA\u0003S\n\t\u0011!A\u0003\u0002\u0005\r%aA0%cE!\u0011QQAF!\r9\u0017qQ\u0005\u0004\u0003\u0013C'a\u0002(pi\"Lgn\u001a\t\u0004O\u00065\u0015bAAHQ\n\u0019\u0011I\\=\t\u000f\u0005M%\u00031\u0001\u0002\u0016\u0006!a.Y7f!\u0011\t9*a(\u000f\t\u0005e\u00151\u0014\t\u0004\u0003\u0013A\u0017bAAOQ\u00061\u0001K]3eK\u001aLA!!)\u0002$\n11\u000b\u001e:j]\u001eT1!!(i\u00031\u0011X-\u00193SK2\fG/[8o)\u0011\tI+a.\u0011\t\u0005-\u00161W\u0007\u0003\u0003[SA!a,\u00022\u0006)\u0001O]8u_*\u0011\u0001+O\u0005\u0005\u0003k\u000biK\u0001\u0005SK2\fG/[8o\u0011\u0019\tIl\u0005a\u0001_\u0006!\u0001/\u0019;i\u0003=9(/\u001b;f\u000f>dG-\u001a8GS2,GCBA(\u0003\u007f\u000b\t\r\u0003\u0004\u0002:R\u0001\ra\u001c\u0005\b\u0003\u0007$\u0002\u0019AAU\u0003!\u0011X\r\\1uS>t\u0017AE;sY^KG\u000f[+tKJ\fe\u000e\u001a)bgN,\"!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4v\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u0016QZ\u0001\u0014kJdw+\u001b;i+N,'/\u00118e!\u0006\u001c8\u000fI\u0001\rg&l\u0007\u000f\\3TG\",W.Y\u000b\u0003\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?<\u0014!\u0002;za\u0016\u001c\u0018\u0002BAr\u0003;\u0014!b\u0015;sk\u000e$H+\u001f9f\u00035\u0019\u0018.\u001c9mKN\u001b\u0007.Z7bA\u0005\u00112/[7qY\u0016\u001c6\r[3nCN#(/\u001b8h+\t\t)*A\ntS6\u0004H.Z*dQ\u0016l\u0017m\u0015;sS:<\u0007%A\u0006pi\",'oU2iK6\f\u0017\u0001D8uQ\u0016\u00148k\u00195f[\u0006\u0004\u0013!E8uQ\u0016\u00148k\u00195f[\u0006\u001cFO]5oO\u0006\u0011r\u000e\u001e5feN\u001b\u0007.Z7b'R\u0014\u0018N\\4!\u00035\u0019w.\u001c9mKb\u001c6\r[3nC\u0006q1m\\7qY\u0016D8k\u00195f[\u0006\u0004\u0013aE2p[BdW\r_*dQ\u0016l\u0017m\u0015;sS:<\u0017\u0001F2p[BdW\r_*dQ\u0016l\u0017m\u0015;sS:<\u0007%\u0001\u0007cS:\f'/_*dQ\u0016l\u0017-A\u0007cS:\f'/_*dQ\u0016l\u0017\rI\u0001\u0013E&t\u0017M]=TG\",W.Y*ue&tw-A\ncS:\f'/_*dQ\u0016l\u0017m\u0015;sS:<\u0007%A\buK6\u0004xN]1mgN\u001b\u0007.Z7b\u0003A!X-\u001c9pe\u0006d7oU2iK6\f\u0007%A\u000buK6\u0004xN]1mgN\u001b\u0007.Z7b'R\u0014\u0018N\\4\u0002-Q,W\u000e]8sC2\u001c8k\u00195f[\u0006\u001cFO]5oO\u0002\n1c\u0019:fCR,Gj\\2bYJ+G.\u0019;j_:$BA!\u0005\u0003 A!!1\u0003B\r\u001d\r\u0019'QC\u0005\u0004\u0005/9\u0014a\u00029bG.\fw-Z\u0005\u0005\u00057\u0011iBA\u0005ECR\fgI]1nK*\u0019!qC\u001c\t\u000f\t\u00052\u00061\u0001\u0002\u0016\u000611o\u00195f[\u0006\faa]5na2,WC\u0001B\t\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u000f\r|W\u000e\u001d7fq\u00061!-\u001b8bef\f\u0011\u0002^3na>\u0014\u0018\r\\:\u0002\u0015\r|G.^7o)\u0016\u001cH\u000f\u0006\u0003\u00036\t\u0005C\u0003BA(\u0005oA\u0001\"a\u001b3\t\u0003\u0007!\u0011\b\t\u0006O\u0006=$1\b\t\u0004G\nu\u0012b\u0001B o\t11i\u001c7v[:Dq!a%3\u0001\u0004\t)*A\bpe\u0012,'oQ8mk6tG+Z:u)\u0011\u00119Ea\u0013\u0015\t\u0005=#\u0011\n\u0005\t\u0003W\u001aD\u00111\u0001\u0003:!9\u00111S\u001aA\u0002\u0005U\u0015\u0001\u00044v]\u000e$\u0018n\u001c8UKN$H\u0003\u0002B)\u0005+\"B!a\u0014\u0003T!A\u00111\u000e\u001b\u0005\u0002\u0004\u0011I\u0004C\u0004\u0002\u0014R\u0002\r!!&\u0002)Q,W\u000e]8sC24UO\\2uS>tG+Z:u)\u0011\u0011YFa\u0018\u0015\t\u0005=#Q\f\u0005\t\u0003W*D\u00111\u0001\u0003:!9\u00111S\u001bA\u0002\u0005U\u0005")
public class PlanGenerationTestSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterAll,
BeforeAndAfterEach,
Logging {
    private final boolean regenerateGoldenFiles;
    private final Path queryFilePath;
    private final Path testDataPath;
    private final JsonFormat.TypeRegistry registry;
    private final JsonFormat.Printer printer;
    private SparkSession session;
    private final String urlWithUserAndPass;
    private final StructType simpleSchema;
    private final String simpleSchemaString;
    private final StructType otherSchema;
    private final String otherSchemaString;
    private final StructType complexSchema;
    private final String complexSchemaString;
    private final StructType binarySchema;
    private final String binarySchemaString;
    private final StructType temporalsSchema;
    private final String temporalsSchemaString;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private boolean regenerateGoldenFiles() {
        return this.regenerateGoldenFiles;
    }

    public Path queryFilePath() {
        return this.queryFilePath;
    }

    public Path testDataPath() {
        return this.testDataPath;
    }

    private JsonFormat.TypeRegistry registry() {
        return this.registry;
    }

    private JsonFormat.Printer printer() {
        return this.printer;
    }

    private SparkSession session() {
        return this.session;
    }

    private void session_$eq(SparkSession x$1) {
        this.session = x$1;
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
        SparkConnectClient client = SparkConnectClient$.MODULE$.apply(UserContext.newBuilder().build(), (ManagedChannelBuilder)InProcessChannelBuilder.forName((String)"/dev/null"));
        this.session_$eq(new SparkSession(client, SparkSession$.MODULE$.cleaner(), new AtomicLong()));
    }

    public void beforeEach() {
        this.session().resetPlanIdGenerator();
    }

    public void afterAll() {
        this.session().close();
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    private void test(String name, Function0<Dataset<?>> f) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Relation actual = ((Dataset)f.apply()).plan().getRoot();
            Path goldenFile = this.queryFilePath().resolve(new StringBuilder(10).append(name.replace(' ', '_')).append(".proto.bin").toString());
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.readRelation(goldenFile));
            if (try_ instanceof Success) {
                Relation expected;
                bl = true;
                success = (Success)try_;
                Relation relation = expected = (Relation)success.value();
                Relation relation2 = actual;
                if (!(relation != null ? !relation.equals(relation2) : relation2 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (bl && this.regenerateGoldenFiles()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Rewriting Golden File");
                this.writeGoldenFile(goldenFile, actual);
                return BoxedUnit.UNIT;
            }
            if (bl) {
                Relation expected = (Relation)success.value();
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n             |Expected and actual plans do not match:\n             |\n             |=== Expected Plan ===\n             |").append(expected).append("\n             |\n             |=== Actual Plan ===\n             |").append(actual).append("\n             |").toString())).stripMargin(), new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            }
            if (try_ instanceof Failure) {
                bl2 = true;
                failure = (Failure)try_;
                if (this.regenerateGoldenFiles()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Golden File");
                    this.writeGoldenFile(goldenFile, actual);
                    return BoxedUnit.UNIT;
                }
            }
            if (bl2) {
                throw this.fail("No golden file found. Please re-run this test with the SPARK_GENERATE_GOLDEN_FILES=1 environment variable set", new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            }
            throw new MatchError((Object)try_);
        }, (Position)new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }

    private Relation readRelation(Path path) {
        Relation relation;
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            relation = Relation.parseFrom((InputStream)input);
        }
        return relation;
    }

    private void writeGoldenFile(Path path, Relation relation) {
        try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
            relation.writeTo(output);
        }
        Path jsonPath = path.getParent().resolve(new StringBuilder(5).append(new StringOps(Predef$.MODULE$.augmentString(((Object)path.getFileName()).toString())).stripSuffix(".proto.bin")).append(".json").toString());
        try (BufferedWriter writer = Files.newBufferedWriter(jsonPath, new OpenOption[0]);){
            writer.write(this.printer().print((MessageOrBuilder)relation));
        }
    }

    private String urlWithUserAndPass() {
        return this.urlWithUserAndPass;
    }

    private StructType simpleSchema() {
        return this.simpleSchema;
    }

    private String simpleSchemaString() {
        return this.simpleSchemaString;
    }

    private StructType otherSchema() {
        return this.otherSchema;
    }

    private String otherSchemaString() {
        return this.otherSchemaString;
    }

    private StructType complexSchema() {
        return this.complexSchema;
    }

    private String complexSchemaString() {
        return this.complexSchemaString;
    }

    private StructType binarySchema() {
        return this.binarySchema;
    }

    private String binarySchemaString() {
        return this.binarySchemaString;
    }

    private StructType temporalsSchema() {
        return this.temporalsSchema;
    }

    private String temporalsSchemaString() {
        return this.temporalsSchemaString;
    }

    private Dataset<Row> createLocalRelation(String schema) {
        return this.session().newDataFrame((Function1 & Serializable & scala.Serializable)builder -> {
            PlanGenerationTestSuite.$anonfun$createLocalRelation$1(schema, builder);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> simple() {
        return this.createLocalRelation(this.simpleSchemaString());
    }

    private Dataset<Row> left() {
        return this.simple();
    }

    private Dataset<Row> right() {
        return this.createLocalRelation(this.otherSchemaString());
    }

    private Dataset<Row> complex() {
        return this.createLocalRelation(this.complexSchemaString());
    }

    private Dataset<Row> binary() {
        return this.createLocalRelation(this.binarySchemaString());
    }

    private Dataset<Row> temporals() {
        return this.createLocalRelation(this.temporalsSchemaString());
    }

    private void columnTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(7).append("column ").append(name).toString(), (Function0 & Serializable & scala.Serializable)() -> this.complex().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void orderColumnTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(7).append("column ").append(name).toString(), (Function0 & Serializable & scala.Serializable)() -> this.complex().orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void functionTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(9).append("function ").append(name).toString(), (Function0 & Serializable & scala.Serializable)() -> this.complex().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void temporalFunctionTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(9).append("function ").append(name).toString(), (Function0 & Serializable & scala.Serializable)() -> this.temporals().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    public static final /* synthetic */ void $anonfun$createLocalRelation$1(String schema$1, Relation.Builder builder) {
        builder.getLocalRelationBuilder().setSchema(schema$1);
    }

    public static final /* synthetic */ byte $anonfun$new$264(int x$6) {
        return (byte)x$6;
    }

    public static final /* synthetic */ byte $anonfun$new$273(int x$7) {
        return (byte)x$7;
    }

    public static final /* synthetic */ char $anonfun$new$433(int i) {
        return (char)(65 + i);
    }

    public static final /* synthetic */ byte $anonfun$new$434(int i) {
        return (byte)(i + 120);
    }

    public static final /* synthetic */ char $anonfun$new$436(int i) {
        return (char)(65 + i);
    }

    public static final /* synthetic */ char $anonfun$new$437(int i) {
        return (char)(66 + i);
    }

    public PlanGenerationTestSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        Logging.$init$((Logging)this);
        String string = System.getenv("SPARK_GENERATE_GOLDEN_FILES");
        String string2 = "1";
        this.regenerateGoldenFiles = !(string != null ? !string.equals(string2) : string2 != null);
        this.queryFilePath = this.commonResourcePath().resolve("queries");
        this.testDataPath = Paths.get("../", "common", "src", "test", "resources", "query-tests", "test-data");
        this.registry = JsonFormat.TypeRegistry.newBuilder().add(ExamplePluginRelation.getDescriptor()).add(ExamplePluginExpression.getDescriptor()).add(ExamplePluginCommand.getDescriptor()).build();
        this.printer = JsonFormat.printer().usingTypeRegistry(this.registry());
        this.urlWithUserAndPass = "jdbc:h2:mem:testdb0;user=testUser;password=testPass";
        this.simpleSchema = new StructType().add("id", "long").add("a", "int").add("b", "double");
        this.simpleSchemaString = this.simpleSchema().catalogString();
        this.otherSchema = new StructType().add("a", "int").add("id", "long").add("payload", "binary");
        this.otherSchemaString = this.otherSchema().catalogString();
        this.complexSchema = this.simpleSchema().add("d", (DataType)this.simpleSchema()).add("e", "array<int>").add("f", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.simpleSchema())).add("g", "string");
        this.complexSchemaString = this.complexSchema().catalogString();
        this.binarySchema = new StructType().add("id", "long").add("bytes", "binary");
        this.binarySchemaString = this.binarySchema().catalogString();
        this.temporalsSchema = new StructType().add("d", "date").add("t", "timestamp").add("s", "string").add("x", "bigint").add("wt", (DataType)new StructType().add("start", "timestamp").add("end", "timestamp"));
        this.temporalsSchemaString = this.temporalsSchema().catalogString();
        this.test("range", (Function0 & Serializable & scala.Serializable)() -> this.session().range(1L, 10L, 1L, 2));
        this.test("read", (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("job", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return this.session().read().format("csv").schema(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField))).option("header", "true").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), (Object)";")}))).load(((Object)this.testDataPath().resolve("people.csv")).toString());
        });
        this.test("read jdbc", (Function0 & Serializable & scala.Serializable)() -> this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()));
        this.test("read jdbc with partition", (Function0 & Serializable & scala.Serializable)() -> this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.EMP", "THEID", 0L, 4L, 3, new Properties()));
        this.test("read jdbc with predicates", (Function0 & Serializable & scala.Serializable)() -> {
            String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
            return this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts, new Properties());
        });
        this.test("read json", (Function0 & Serializable & scala.Serializable)() -> this.session().read().json(((Object)this.testDataPath().resolve("people.json")).toString()));
        this.test("json from dataset", (Function0 & Serializable & scala.Serializable)() -> this.session().read().schema(new StructType().add("c1", (DataType)StringType$.MODULE$).add("c2", (DataType)IntegerType$.MODULE$)).option("allowSingleQuotes", "true").json(this.session().emptyDataset((Encoder)AgnosticEncoders.StringEncoder$.MODULE$)));
        this.test("toJSON", (Function0 & Serializable & scala.Serializable)() -> this.complex().toJSON());
        this.test("read csv", (Function0 & Serializable & scala.Serializable)() -> this.session().read().csv(((Object)this.testDataPath().resolve("people.csv")).toString()));
        this.test("csv from dataset", (Function0 & Serializable & scala.Serializable)() -> this.session().read().schema(new StructType().add("c1", (DataType)StringType$.MODULE$).add("c2", (DataType)IntegerType$.MODULE$)).option("header", "true").csv(this.session().emptyDataset((Encoder)AgnosticEncoders.StringEncoder$.MODULE$)));
        this.test("read parquet", (Function0 & Serializable & scala.Serializable)() -> this.session().read().parquet(((Object)this.testDataPath().resolve("users.parquet")).toString()));
        this.test("read orc", (Function0 & Serializable & scala.Serializable)() -> this.session().read().orc(((Object)this.testDataPath().resolve("users.orc")).toString()));
        this.test("read table", (Function0 & Serializable & scala.Serializable)() -> this.session().read().table("myTable"));
        this.test("table", (Function0 & Serializable & scala.Serializable)() -> this.session().table("myTable"));
        this.test("read text", (Function0 & Serializable & scala.Serializable)() -> this.session().read().text(((Object)this.testDataPath().resolve("people.txt")).toString()));
        this.test("select", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id")})));
        this.test("select typed 1-arg", (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1(null)));
            return this.simple().select(functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")})).as((Encoder)encoder));
        });
        this.test("limit", (Function0 & Serializable & scala.Serializable)() -> this.simple().limit(10));
        this.test("filter", (Function0 & Serializable & scala.Serializable)() -> this.simple().filter(functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)10L)))));
        this.test("toDF", (Function0 & Serializable & scala.Serializable)() -> this.simple().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x1", "x2", "x3"})));
        this.test("to", (Function0 & Serializable & scala.Serializable)() -> this.simple().to(new StructType().add("b", "double").add("id", "int")));
        this.test("join inner_no_condition", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right()));
        this.test("join inner_using_single_col", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), "id"));
        this.test("join inner_using_multiple_col_array", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), (String[])((Object[])new String[]{"id", "a"})));
        this.test("join inner_using_multiple_col_seq", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))));
        this.test("join using_single_col", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), "id", "left_semi"));
        this.test("join using_multiple_col_array", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), (String[])((Object[])new String[]{"id", "a"}), "full_outer"));
        this.test("join using_multiple_col_seq", (Function0 & Serializable & scala.Serializable)() -> this.left().join(this.right(), (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$)), "right_outer"));
        this.test("join inner_condition", (Function0 & Serializable & scala.Serializable)() -> this.left().alias("l").join(this.right().alias("r"), functions$.MODULE$.col("l.a").$eq$eq$eq((Object)functions$.MODULE$.col("r.a"))));
        this.test("join condition", (Function0 & Serializable & scala.Serializable)() -> this.left().as("l").join(this.right().as("r"), functions$.MODULE$.col("l.id").$eq$eq$eq((Object)functions$.MODULE$.col("r.id")), "left_anti"));
        this.test("crossJoin", (Function0 & Serializable & scala.Serializable)() -> this.left().crossJoin(this.right()));
        this.test("sortWithinPartitions strings", (Function0 & Serializable & scala.Serializable)() -> this.simple().sortWithinPartitions("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})));
        this.test("sortWithinPartitions columns", (Function0 & Serializable & scala.Serializable)() -> this.simple().sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("sort strings", (Function0 & Serializable & scala.Serializable)() -> this.simple().sort("b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.test("sort columns", (Function0 & Serializable & scala.Serializable)() -> this.simple().sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("orderBy strings", (Function0 & Serializable & scala.Serializable)() -> this.simple().sort("b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a"})));
        this.test("orderBy columns", (Function0 & Serializable & scala.Serializable)() -> this.simple().sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b"), functions$.MODULE$.col("a")})));
        this.test("apply", (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> stable = this.simple();
            return stable.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{stable.apply("a")}));
        });
        this.test("hint", (Function0 & Serializable & scala.Serializable)() -> this.simple().hint("coalesce", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100)})));
        this.test("col", (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> stable = this.simple();
            return stable.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{stable.col("id"), stable.col("b")}));
        });
        this.test("colRegex", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.simple().colRegex("`a|id`")})));
        this.test("as string", (Function0 & Serializable & scala.Serializable)() -> this.simple().as("foo"));
        this.test("as symbol", (Function0 & Serializable & scala.Serializable)() -> this.simple().as((Symbol)SymbolLiteral.bootstrap("apply", "bar")));
        this.test("alias string", (Function0 & Serializable & scala.Serializable)() -> this.simple().alias("fooz"));
        this.test("alias symbol", (Function0 & Serializable & scala.Serializable)() -> this.simple().alias("bob"));
        this.test("select strings", (Function0 & Serializable & scala.Serializable)() -> this.simple().select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.test("selectExpr", (Function0 & Serializable & scala.Serializable)() -> this.simple().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a + 10 as x", "id % 10 as grp"})));
        this.test("filter expr", (Function0 & Serializable & scala.Serializable)() -> this.simple().filter("exp(a) < 10.0"));
        this.test("where column", (Function0 & Serializable & scala.Serializable)() -> this.simple().where(functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1L)))));
        this.test("where expr", (Function0 & Serializable & scala.Serializable)() -> this.simple().where("a + id < 1000"));
        this.test("unpivot values", (Function0 & Serializable & scala.Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}), (Column[])((Object[])new Column[]{functions$.MODULE$.col("b")}), "name", "value"));
        this.test("unpivot no_values", (Function0 & Serializable & scala.Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("id")}), "name", "value"));
        this.test("melt values", (Function0 & Serializable & scala.Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("a")}), (Column[])((Object[])new Column[]{functions$.MODULE$.col("id")}), "name", "value"));
        this.test("melt no_values", (Function0 & Serializable & scala.Serializable)() -> this.simple().melt((Column[])((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}), "name", "value"));
        this.test("offset", (Function0 & Serializable & scala.Serializable)() -> this.simple().offset(1000));
        this.test("union", (Function0 & Serializable & scala.Serializable)() -> this.simple().union(this.simple()));
        this.test("unionAll", (Function0 & Serializable & scala.Serializable)() -> this.simple().union(this.simple()));
        this.test("unionByName", (Function0 & Serializable & scala.Serializable)() -> this.simple().drop("b").unionByName(this.right().drop("payload")));
        this.test("unionByName allowMissingColumns", (Function0 & Serializable & scala.Serializable)() -> this.simple().unionByName(this.right(), true));
        this.test("intersect", (Function0 & Serializable & scala.Serializable)() -> this.simple().intersect(this.simple()));
        this.test("intersectAll", (Function0 & Serializable & scala.Serializable)() -> this.simple().intersectAll(this.simple()));
        this.test("except", (Function0 & Serializable & scala.Serializable)() -> this.simple().except(this.simple()));
        this.test("exceptAll", (Function0 & Serializable & scala.Serializable)() -> this.simple().exceptAll(this.simple()));
        this.test("sample fraction_seed", (Function0 & Serializable & scala.Serializable)() -> this.simple().sample(0.43, 9890823L));
        this.test("sample withReplacement_fraction_seed", (Function0 & Serializable & scala.Serializable)() -> this.simple().sample(true, 0.23, 898L));
        this.test("withColumn single", (Function0 & Serializable & scala.Serializable)() -> this.simple().withColumn("z", functions$.MODULE$.expr("a + 100")));
        this.test("withColumns scala_map", (Function0 & Serializable & scala.Serializable)() -> this.simple().withColumns((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"b", (Object)functions$.MODULE$.lit((Object)"redacted")), new Tuple2((Object)"z", (Object)functions$.MODULE$.expr("a + 100"))}))));
        this.test("withColumns java_map", (Function0 & Serializable & scala.Serializable)() -> {
            HashMap<String, Column> map = new HashMap<String, Column>();
            map.put("g", functions$.MODULE$.col("id"));
            map.put("a", functions$.MODULE$.lit((Object)"123"));
            return this.simple().withColumns(map);
        });
        this.test("withColumnRenamed single", (Function0 & Serializable & scala.Serializable)() -> this.simple().withColumnRenamed("id", "nid"));
        this.test("withColumnRenamed scala_map", (Function0 & Serializable & scala.Serializable)() -> this.simple().withColumnsRenamed((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"alpha"), new Tuple2((Object)"b", (Object)"beta")}))));
        this.test("withColumnRenamed java_map", (Function0 & Serializable & scala.Serializable)() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "nid");
            map.put("b", "bravo");
            return this.simple().withColumnsRenamed(map);
        });
        this.test("withMetadata", (Function0 & Serializable & scala.Serializable)() -> {
            MetadataBuilder builder = new MetadataBuilder();
            builder.putString("description", "unique identifier");
            return this.simple().withMetadata("id", builder.build());
        });
        this.test("drop single string", (Function0 & Serializable & scala.Serializable)() -> this.simple().drop("a"));
        this.test("drop multiple strings", (Function0 & Serializable & scala.Serializable)() -> this.simple().drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"})));
        this.test("drop single column", (Function0 & Serializable & scala.Serializable)() -> this.simple().drop(functions$.MODULE$.col("b")));
        this.test("drop multiple column", (Function0 & Serializable & scala.Serializable)() -> this.simple().drop(functions$.MODULE$.col("b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id")})));
        this.test("dropDuplicates", (Function0 & Serializable & scala.Serializable)() -> this.simple().dropDuplicates());
        this.test("dropDuplicates names seq", (Function0 & Serializable & scala.Serializable)() -> {
            String string = "a";
            String string2 = "b";
            return this.simple().dropDuplicates((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string));
        });
        this.test("dropDuplicates names array", (Function0 & Serializable & scala.Serializable)() -> this.simple().dropDuplicates((String[])((Object[])new String[]{"a", "id"})));
        this.test("dropDuplicates varargs", (Function0 & Serializable & scala.Serializable)() -> this.simple().dropDuplicates("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "id"})));
        this.test("describe", (Function0 & Serializable & scala.Serializable)() -> this.simple().describe((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "b"})));
        this.test("summary", (Function0 & Serializable & scala.Serializable)() -> this.simple().summary((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "min"})));
        this.test("repartition", (Function0 & Serializable & scala.Serializable)() -> this.simple().repartition(24));
        this.test("repartition num_partitions_expressions", (Function0 & Serializable & scala.Serializable)() -> this.simple().repartition(22, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("id")})));
        this.test("repartition expressions", (Function0 & Serializable & scala.Serializable)() -> this.simple().repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("repartitionByRange num_partitions_expressions", (Function0 & Serializable & scala.Serializable)() -> this.simple().repartitionByRange(33, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.col("id").desc_nulls_first()})));
        this.test("repartitionByRange expressions", (Function0 & Serializable & scala.Serializable)() -> this.simple().repartitionByRange((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a").asc(), functions$.MODULE$.col("id").desc_nulls_first()})));
        this.test("coalesce", (Function0 & Serializable & scala.Serializable)() -> this.simple().coalesce(5));
        this.test("distinct", (Function0 & Serializable & scala.Serializable)() -> this.simple().distinct());
        this.columnTest("apply", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("f").apply((Object)"super_duper_key"));
        this.columnTest("unary minus", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)).unary_$minus());
        this.columnTest("not", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).unary_$bang());
        this.columnTest("equals", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$eq$eq$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("not equals", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$eq$bang$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("gt", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$greater((Object)functions$.MODULE$.col("b")));
        this.columnTest("lt", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$less((Object)functions$.MODULE$.col("b")));
        this.columnTest("geq", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$greater$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("leq", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$less$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("eqNullSafe", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$less$eq$greater((Object)functions$.MODULE$.col("b")));
        this.columnTest("when otherwise", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            return functions$.MODULE$.when(a.$less((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"low").when(a.$less((Object)BoxesRunTime.boxToInteger((int)20)), (Object)"medium").otherwise((Object)"high");
        });
        this.columnTest("between", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").between((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)20)));
        this.columnTest("isNaN", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("b").isNaN());
        this.columnTest("isNull", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").isNull());
        this.columnTest("isNotNull", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").isNotNull());
        this.columnTest("and", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$greater((Object)BoxesRunTime.boxToInteger((int)10)).$amp$amp((Object)functions$.MODULE$.col("b").$less((Object)BoxesRunTime.boxToDouble((double)0.5))));
        this.columnTest("or", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$greater((Object)BoxesRunTime.boxToInteger((int)10)).$bar$bar((Object)functions$.MODULE$.col("b").$less((Object)BoxesRunTime.boxToDouble((double)0.5))));
        this.columnTest("add", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$plus((Object)functions$.MODULE$.col("b")));
        this.columnTest("subtract", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$minus((Object)functions$.MODULE$.col("b")));
        this.columnTest("multiply", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$times((Object)functions$.MODULE$.col("b")));
        this.columnTest("divide", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$div((Object)functions$.MODULE$.col("b")));
        this.columnTest("modulo", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
        this.columnTest("isin", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").isin((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", "world", "foo"})));
        this.columnTest("like", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").like("%bob%"));
        this.columnTest("rlike", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").like("^[0-9]*$"));
        this.columnTest("ilike", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").like("%fOb%"));
        this.columnTest("getItem", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("e").getItem((Object)BoxesRunTime.boxToInteger((int)3)));
        this.columnTest("withField", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("d").withField("x", functions$.MODULE$.lit((Object)"xq")));
        this.columnTest("dropFields", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("d").dropFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})));
        this.columnTest("getField", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("d").getItem((Object)"b"));
        this.columnTest("substr", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").substr(8, 3));
        this.columnTest("contains", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").contains((Object)"baz"));
        this.columnTest("startsWith", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").startsWith("prefix_"));
        this.columnTest("endsWith", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("g").endsWith("suffix_"));
        this.columnTest("alias", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").name("b"));
        this.columnTest("as multi", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.expr("inline(map_values(f))").as((String[])((Object[])new String[]{"v1", "v2", "v3"})));
        this.columnTest("as with metadata", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> {
            MetadataBuilder builder = new MetadataBuilder();
            builder.putString("comment", "modified E field");
            return functions$.MODULE$.col("e").as("e_mod", builder.build());
        });
        this.columnTest("cast", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").cast("long"));
        this.orderColumnTest("desc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("b").desc());
        this.orderColumnTest("desc_nulls_first", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("b").desc_nulls_first());
        this.orderColumnTest("desc_nulls_last", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("b").desc_nulls_last());
        this.orderColumnTest("asc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").asc());
        this.orderColumnTest("asc_nulls_first", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").asc_nulls_first());
        this.orderColumnTest("asc_nulls_last", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").asc_nulls_last());
        this.columnTest("bitwiseOR", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").bitwiseOR((Object)BoxesRunTime.boxToInteger((int)7)));
        this.columnTest("bitwiseAND", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)255)));
        this.columnTest("bitwiseXOR", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").bitwiseXOR((Object)BoxesRunTime.boxToInteger((int)78)));
        this.columnTest("star", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("*"));
        this.columnTest("star with target", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("d.*"));
        this.functionTest("col", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("id"));
        this.functionTest("asc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.asc("a"));
        this.functionTest("asc_nulls_first", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.asc_nulls_first("a"));
        this.functionTest("asc_nulls_last", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.asc_nulls_last("a"));
        this.functionTest("desc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.desc("a"));
        this.functionTest("desc_nulls_first", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.desc_nulls_first("a"));
        this.functionTest("desc_nulls_last", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.desc_nulls_last("a"));
        this.functionTest("approx_count_distinct", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.approx_count_distinct("a"));
        this.functionTest("approx_count_distinct rsd", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.approx_count_distinct("a", 0.1));
        this.functionTest("avg", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.avg("a"));
        this.functionTest("collect_list", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.collect_list("a"));
        this.functionTest("collect_set", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.collect_set("a"));
        this.functionTest("corr", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.corr("a", "b"));
        this.functionTest("count", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.count(functions$.MODULE$.col("a")));
        this.test("function count typed", (Function0 & Serializable & scala.Serializable)() -> this.simple().select(functions$.MODULE$.count("a")));
        this.functionTest("countDistinct", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.countDistinct("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"})));
        this.functionTest("covar_pop", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.covar_pop("a", "b"));
        this.functionTest("covar_samp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.covar_samp("a", "b"));
        this.functionTest("first", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.first("a", true));
        this.functionTest("kurtosis", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.kurtosis("a"));
        this.functionTest("last", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.last("a", false));
        this.functionTest("mode", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.mode(functions$.MODULE$.col("a")));
        this.test("function max", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("id")})));
        this.functionTest("max_by", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.max_by(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("median", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.median(functions$.MODULE$.col("a")));
        this.functionTest("min", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.min("a"));
        this.functionTest("min_by", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.min_by(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("percentile_approx", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.percentile_approx(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.3)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)20))));
        this.functionTest("product", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.product(functions$.MODULE$.col("a")));
        this.functionTest("skewness", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.skewness("a"));
        this.functionTest("stddev", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.stddev("a"));
        this.functionTest("stddev_samp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.stddev_samp("a"));
        this.functionTest("stddev_pop", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.stddev_pop("a"));
        this.functionTest("sum", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sum("a"));
        this.functionTest("sum_distinct", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sum_distinct(functions$.MODULE$.col("a")));
        this.functionTest("variance", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.variance("a"));
        this.functionTest("var_samp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.var_samp("a"));
        this.functionTest("var_pop", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.var_pop("a"));
        this.functionTest("array", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.functionTest("map", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)22)), functions$.MODULE$.lit((Object)"dummy")})));
        this.functionTest("map_from_arrays", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_from_arrays(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))})), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"one"), functions$.MODULE$.lit((Object)"two")}))));
        this.functionTest("coalesce", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3))})));
        this.functionTest("input_file_name", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.input_file_name());
        this.functionTest("isnan", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.isnan(functions$.MODULE$.col("b")));
        this.functionTest("isnull", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.isnull(functions$.MODULE$.col("a")));
        this.functionTest("monotonically_increasing_id", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.monotonically_increasing_id());
        this.functionTest("nanvl", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.nanvl(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), functions$.MODULE$.col("a")));
        this.functionTest("negate", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.negate(functions$.MODULE$.col("a")));
        this.functionTest("rand with seed", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rand(133L));
        this.functionTest("randn with seed", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.randn(133L));
        this.functionTest("spark_partition_id", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.spark_partition_id());
        this.functionTest("sqrt", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sqrt("b"));
        this.functionTest("struct", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.struct("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
        this.functionTest("bitwise_not", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.bitwise_not(functions$.MODULE$.col("a")));
        this.functionTest("expr", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.expr("a + 1"));
        this.functionTest("abs", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.abs(functions$.MODULE$.col("a")));
        this.functionTest("acos", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.acos("b"));
        this.functionTest("acosh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.acosh("b"));
        this.functionTest("asin", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.asin("b"));
        this.functionTest("asinh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.asinh("b"));
        this.functionTest("atan", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.atan("b"));
        this.functionTest("atan2", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.atan2(functions$.MODULE$.col("a").cast("double"), "b"));
        this.functionTest("atanh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.atanh("b"));
        this.functionTest("bin", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.bin("b"));
        this.functionTest("ceil", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ceil("b"));
        this.functionTest("ceil scale", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ceil(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("conv", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.conv(functions$.MODULE$.col("b"), 10, 16));
        this.functionTest("cos", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.cos("b"));
        this.functionTest("cosh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.cosh("b"));
        this.functionTest("cot", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.cot(functions$.MODULE$.col("b")));
        this.functionTest("csc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.csc(functions$.MODULE$.col("b")));
        this.functionTest("exp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.exp("b"));
        this.functionTest("expm1", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.expm1("b"));
        this.functionTest("factorial", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.factorial(functions$.MODULE$.col("a").$percent((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("floor", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.floor("b"));
        this.functionTest("floor scale", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.floor(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("greatest", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.greatest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("d").getItem((Object)"a")})));
        this.functionTest("hex", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.hex(functions$.MODULE$.col("a")));
        this.functionTest("unhex", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.unhex(functions$.MODULE$.col("a")));
        this.functionTest("hypot", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.hypot(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("least", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.least((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("d").getItem((Object)"a")})));
        this.functionTest("log", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.log("b"));
        this.functionTest("log with base", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.log(2.0, "b"));
        this.functionTest("log10", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.log10("b"));
        this.functionTest("log1p", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.log1p("a"));
        this.functionTest("log2", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.log2("a"));
        this.functionTest("pow", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.pow("a", "b"));
        this.functionTest("pmod", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.pmod(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("rint", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rint("b"));
        this.functionTest("round", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.round(functions$.MODULE$.col("b"), 2));
        this.functionTest("bround", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.round(functions$.MODULE$.col("b"), 2));
        this.functionTest("sec", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sec(functions$.MODULE$.col("b")));
        this.functionTest("shiftleft", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.shiftleft(functions$.MODULE$.col("b"), 2));
        this.functionTest("shiftright", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.shiftright(functions$.MODULE$.col("b"), 2));
        this.functionTest("shiftrightunsigned", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.shiftrightunsigned(functions$.MODULE$.col("b"), 2));
        this.functionTest("signum", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.signum("b"));
        this.functionTest("sin", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sin("b"));
        this.functionTest("sinh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sinh("b"));
        this.functionTest("tan", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.tan("b"));
        this.functionTest("tanh", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.tanh("b"));
        this.functionTest("degrees", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.degrees("b"));
        this.functionTest("radians", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.radians("b"));
        this.functionTest("md5", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.md5(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("sha1", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sha1(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("sha2", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sha2(functions$.MODULE$.col("g").cast("binary"), 512));
        this.functionTest("crc32", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.crc32(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("hash", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.col("id")})));
        this.functionTest("xxhash64", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.xxhash64((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a"), functions$.MODULE$.col("d"), functions$.MODULE$.col("g")})));
        this.functionTest("assert_true with message", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.assert_true(functions$.MODULE$.col("id").$greater((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.lit((Object)"id negative!")));
        this.functionTest("raise_error", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"kaboom")));
        this.functionTest("ascii", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ascii(functions$.MODULE$.col("g")));
        this.functionTest("base64", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.base64(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("bit_length", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.bit_length(functions$.MODULE$.col("g")));
        this.functionTest("concat_ws", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.concat_ws("-", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"world"), functions$.MODULE$.col("id")})));
        this.functionTest("decode", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.decode(functions$.MODULE$.col("g").cast("binary"), "UTF-8"));
        this.functionTest("encode", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.encode(functions$.MODULE$.col("g"), "UTF-8"));
        this.functionTest("format_number", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.format_number(functions$.MODULE$.col("b"), 1));
        this.functionTest("initcap", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.initcap(functions$.MODULE$.col("g")));
        this.functionTest("length", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.length(functions$.MODULE$.col("g")));
        this.functionTest("lower", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lower(functions$.MODULE$.col("g")));
        this.functionTest("levenshtein", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.levenshtein(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"bob")));
        this.functionTest("locate", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.locate("jar", functions$.MODULE$.col("g")));
        this.functionTest("locate with pos", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.locate("jar", functions$.MODULE$.col("g"), 10));
        this.functionTest("lpad", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lpad(functions$.MODULE$.col("g"), 10, "-"));
        this.test("function lpad binary", (Function0 & Serializable & scala.Serializable)() -> this.binary().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lpad(functions$.MODULE$.col("bytes"), 5, (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{12, 10, 15, 14})).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$264(BoxesRunTime.unboxToInt((Object)x$6))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))})));
        this.functionTest("ltrim", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ltrim(functions$.MODULE$.col("g")));
        this.functionTest("ltrim with pattern", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ltrim(functions$.MODULE$.col("g"), "xxx"));
        this.functionTest("octet_length", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.octet_length(functions$.MODULE$.col("g")));
        this.functionTest("regexp_extract", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.regexp_extract(functions$.MODULE$.col("g"), "(\\d+)-(\\d+)", 1));
        this.functionTest("regexp_replace", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.regexp_replace(functions$.MODULE$.col("g"), "(\\d+)", "XXX"));
        this.functionTest("unbase64", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.unbase64(functions$.MODULE$.col("g")));
        this.functionTest("rpad", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rpad(functions$.MODULE$.col("g"), 10, "-"));
        this.test("function rpad binary", (Function0 & Serializable & scala.Serializable)() -> this.binary().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.rpad(functions$.MODULE$.col("bytes"), 5, (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{11, 10, 11, 14})).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$273(BoxesRunTime.unboxToInt((Object)x$7))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))})));
        this.functionTest("rtrim", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rtrim(functions$.MODULE$.col("g")));
        this.functionTest("rtrim with pattern", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rtrim(functions$.MODULE$.col("g"), "yyy"));
        this.functionTest("split", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.split(functions$.MODULE$.col("g"), ";"));
        this.functionTest("split with limit", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.split(functions$.MODULE$.col("g"), ";", 10));
        this.functionTest("substring", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.substring(functions$.MODULE$.col("g"), 4, 5));
        this.functionTest("substring_index", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.substring_index(functions$.MODULE$.col("g"), ";", 5));
        this.functionTest("overlay", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.overlay(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))));
        this.functionTest("overlay with len", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.overlay(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4)), functions$.MODULE$.lit((Object)"3")));
        this.functionTest("sentences", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sentences(functions$.MODULE$.col("g")));
        this.functionTest("sentences with locale", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sentences(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"en"), functions$.MODULE$.lit((Object)"US")));
        this.functionTest("translate", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.translate(functions$.MODULE$.col("g"), "foo", "bar"));
        this.functionTest("trim", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.trim(functions$.MODULE$.col("g")));
        this.functionTest("trim with pattern", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.trim(functions$.MODULE$.col("g"), "---"));
        this.functionTest("upper", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.upper(functions$.MODULE$.col("g")));
        this.functionTest("years", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.years(Column$.MODULE$.apply("a")));
        this.functionTest("months", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.months(Column$.MODULE$.apply("a")));
        this.functionTest("days", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.days(Column$.MODULE$.apply("a")));
        this.functionTest("hours", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.hours(Column$.MODULE$.apply("a")));
        this.functionTest("bucket", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.bucket(3, Column$.MODULE$.apply("a")));
        this.functionTest("cume_dist", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.cume_dist().over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("dense_rank", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.dense_rank().over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("lag", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lag(Column$.MODULE$.apply("g"), 1, null, true).over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("lead", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.lead(Column$.MODULE$.apply("g"), 2, (Object)"dv", true).over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("nth_value", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.nth_value(Column$.MODULE$.apply("g"), 3, true).over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("ntile", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.ntile(4).over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("percent_rank", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.percent_rank().over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("rank", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.rank().over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("row_number", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.row_number().over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.temporalFunctionTest("add_months", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.add_months(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("current_date", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.current_date());
        this.temporalFunctionTest("current_timestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.current_timestamp());
        this.temporalFunctionTest("localtimestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.localtimestamp());
        this.temporalFunctionTest("date_format", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.date_format(functions$.MODULE$.col("d"), "yyyy-MM-dd"));
        this.temporalFunctionTest("date_add", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.date_add(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("date_sub", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.date_sub(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("datediff", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.datediff(functions$.MODULE$.col("d"), functions$.MODULE$.make_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2020)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))));
        this.temporalFunctionTest("year", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.year(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("quarter", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.quarter(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("month", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.month(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofweek", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.dayofweek(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofmonth", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.dayofmonth(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofyear", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.dayofyear(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("hour", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.hour(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("last_day", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.last_day(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("minute", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.minute(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("make_date", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.make_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2018)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)5)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)14))));
        this.temporalFunctionTest("months_between", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.months_between(functions$.MODULE$.current_date(), functions$.MODULE$.col("d")));
        this.temporalFunctionTest("months_between with roundoff", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.months_between(functions$.MODULE$.current_date(), functions$.MODULE$.col("d"), true));
        this.temporalFunctionTest("next_day", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.next_day(functions$.MODULE$.col("d"), "Mon"));
        this.temporalFunctionTest("second", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.second(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("weekofyear", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.weekofyear(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("from_unixtime", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.from_unixtime(functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1L))));
        this.temporalFunctionTest("unix_timestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.unix_timestamp());
        this.temporalFunctionTest("unix_timestamp with format", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS"));
        this.temporalFunctionTest("to_timestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s")));
        this.temporalFunctionTest("to_timestamp with format", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS"));
        this.temporalFunctionTest("to_date", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_date(functions$.MODULE$.col("s")));
        this.temporalFunctionTest("to_date with format", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_date(functions$.MODULE$.col("s"), "yyyy-MM-dd"));
        this.temporalFunctionTest("trunc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.trunc(functions$.MODULE$.col("d"), "mm"));
        this.temporalFunctionTest("date_trunc", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.trunc(functions$.MODULE$.col("t"), "minute"));
        this.temporalFunctionTest("from_utc_timestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.from_utc_timestamp(functions$.MODULE$.col("t"), "-08:00"));
        this.temporalFunctionTest("to_utc_timestamp", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_utc_timestamp(functions$.MODULE$.col("t"), "-04:00"));
        this.temporalFunctionTest("window", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.window(functions$.MODULE$.col("t"), "1 second"));
        this.test("function window_time", (Function0 & Serializable & scala.Serializable)() -> {
            Metadata metadata = new MetadataBuilder().putBoolean("spark.timeWindow", true).build();
            return this.temporals().withMetadata("wt", metadata).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window_time(functions$.MODULE$.col("wt"))}));
        });
        this.temporalFunctionTest("session_window", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.session_window(functions$.MODULE$.col("t"), "10 minutes"));
        this.temporalFunctionTest("timestamp_seconds", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.timestamp_seconds(functions$.MODULE$.col("x")));
        this.functionTest("array_contains", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_contains(functions$.MODULE$.col("e"), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("array_append", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_append(functions$.MODULE$.col("e"), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("arrays_overlap", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.arrays_overlap(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))}))));
        this.functionTest("slice", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.slice(functions$.MODULE$.col("e"), 0, 5));
        this.functionTest("array_join", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_join(functions$.MODULE$.col("e"), ";"));
        this.functionTest("array_join with null replacement", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_join(functions$.MODULE$.col("e"), ";", "null"));
        this.functionTest("concat", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))})), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)33)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)40)))})));
        this.functionTest("array_position", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_position(functions$.MODULE$.col("e"), (Object)BoxesRunTime.boxToInteger((int)10)));
        this.functionTest("element_at", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.element_at(functions$.MODULE$.col("f"), (Object)"bob"));
        this.functionTest("get", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.get(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("array_sort", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_sort(functions$.MODULE$.col("e")));
        this.functionTest("array_sort with comparator", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_sort(functions$.MODULE$.col("e"), (Function2 & Serializable & scala.Serializable)(l, r) -> l.$minus(r)));
        this.functionTest("array_remove", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_remove(functions$.MODULE$.col("e"), (Object)BoxesRunTime.boxToInteger((int)314)));
        this.functionTest("array_compact", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_compact(functions$.MODULE$.col("e")));
        this.functionTest("array_distinct", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_distinct(functions$.MODULE$.col("e")));
        this.functionTest("array_intersect", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_intersect(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))}))));
        this.functionTest("array_insert", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_insert(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("array_union", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_union(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3))}))));
        this.functionTest("array_except", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_except(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))}))));
        this.functionTest("transform", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function1 & Serializable & scala.Serializable)x -> x.$plus((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("transform with index", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function2 & Serializable & scala.Serializable)(x, i) -> x.$plus(i)));
        this.functionTest("exists", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.exists(functions$.MODULE$.col("e"), (Function1 & Serializable & scala.Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("forall", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.forall(functions$.MODULE$.col("e"), (Function1 & Serializable & scala.Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("filter", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.filter(functions$.MODULE$.col("e"), (Function1 & Serializable & scala.Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("filter with pair input", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.filter(functions$.MODULE$.col("e"), (Function2 & Serializable & scala.Serializable)(x, i) -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10)).$amp$amp((Object)i.$greater((Object)BoxesRunTime.boxToInteger((int)2)))));
        this.functionTest("aggregate", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.aggregate(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(x, y) -> x.$plus(y)));
        this.functionTest("zip_with", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.zip_with(functions$.MODULE$.col("e"), functions$.MODULE$.col("e"), (Function2 & Serializable & scala.Serializable)(x, y) -> x.$plus(y)));
        this.functionTest("transform_keys", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.transform_keys(functions$.MODULE$.col("f"), (Function2 & Serializable & scala.Serializable)(k, v) -> functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{k, v.getItem((Object)"id")}))));
        this.functionTest("transform_values", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.transform_values(functions$.MODULE$.col("f"), (Function2 & Serializable & scala.Serializable)(k, v) -> v.withField("key", k)));
        this.functionTest("map_filter", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_filter(functions$.MODULE$.col("f"), (Function2 & Serializable & scala.Serializable)(k, x$8) -> k.contains((Object)functions$.MODULE$.lit((Object)"baz"))));
        this.functionTest("map_zip_with", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_zip_with(functions$.MODULE$.col("f"), functions$.MODULE$.col("f"), (Function3 & Serializable & scala.Serializable)(x$9, v1, v2) -> v1.getItem((Object)"id").$plus((Object)v2.getItem((Object)"id"))));
        this.functionTest("explode", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.explode(functions$.MODULE$.col("e")));
        this.functionTest("explode_outer", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.explode_outer(functions$.MODULE$.col("e")));
        this.functionTest("posexplode", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.posexplode(functions$.MODULE$.col("e")));
        this.functionTest("posexplode_outer", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.posexplode_outer(functions$.MODULE$.col("e")));
        this.functionTest("inline", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.inline(functions$.MODULE$.map_values(functions$.MODULE$.col("f"))));
        this.functionTest("inline_outer", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.inline_outer(functions$.MODULE$.map_values(functions$.MODULE$.col("f"))));
        this.functionTest("get_json_object", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.get_json_object(functions$.MODULE$.col("g"), "$.device_type"));
        this.functionTest("json_tuple", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.json_tuple(functions$.MODULE$.col("g"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "id"})));
        this.functionTest("from_json", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.from_json(functions$.MODULE$.col("g"), this.simpleSchema()));
        this.functionTest("schema_of_json", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.schema_of_json(functions$.MODULE$.lit((Object)"[{\"col\":01}]")));
        this.functionTest("schema_of_json with options", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.schema_of_json(functions$.MODULE$.lit((Object)"[{\"col\":01}]"), Collections.singletonMap("allowNumericLeadingZeros", "true")));
        this.functionTest("to_json", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_json(functions$.MODULE$.col("d"), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"timestampFormat", (Object)"dd/MM/yyyy")}))));
        this.functionTest("size", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.size(functions$.MODULE$.col("f")));
        this.functionTest("sort_array", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sort_array(functions$.MODULE$.col("e")));
        this.functionTest("array_min", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_min(functions$.MODULE$.col("e")));
        this.functionTest("array_max", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_max(functions$.MODULE$.col("e")));
        this.functionTest("reverse", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.reverse(functions$.MODULE$.col("e")));
        this.functionTest("flatten", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.flatten(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))}))));
        this.functionTest("sequence", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("array_repeat", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.array_repeat(functions$.MODULE$.col("a"), 10));
        this.functionTest("map_contains_key", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_contains_key(functions$.MODULE$.col("f"), (Object)"xyz"));
        this.functionTest("map_keys", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_keys(functions$.MODULE$.col("f")));
        this.functionTest("map_values", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_values(functions$.MODULE$.col("f")));
        this.functionTest("map_entries", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_entries(functions$.MODULE$.col("f")));
        this.functionTest("map_from_entries", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_from_entries(functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function2 & Serializable & scala.Serializable)(x, i) -> functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{i, x})))));
        this.functionTest("arrays_zip", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)20)))})));
        this.functionTest("map_concat", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.map_concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("f"), functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)12L)).as("id"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)68)).as("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Math.E)).as("b")}))}))})));
        this.functionTest("from_csv", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.from_csv(functions$.MODULE$.col("g"), this.simpleSchema(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mode", (Object)"FAILFAST")}))));
        this.functionTest("schema_of_csv", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.schema_of_csv(functions$.MODULE$.lit((Object)"1|abc"), Collections.singletonMap("sep", "|")));
        this.functionTest("to_csv", (Function0<Column>)(Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.to_csv(functions$.MODULE$.col("d"), Collections.singletonMap("sep", "|")));
        this.test("groupby agg", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"stddev"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"std"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"mean"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"average"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"avg"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"size"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"count")})));
        this.test("groupby agg string", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"count")})));
        this.test("groupby agg columns", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).agg(functions$.MODULE$.max("a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("b")})));
        this.test("groupby max", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).max((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby min", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).min((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby mean", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).mean((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby avg", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).avg((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby sum", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).sum((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby count", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).count());
        this.test("rollup column", (Function0 & Serializable & scala.Serializable)() -> this.simple().rollup((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")})).count());
        this.test("cube column", (Function0 & Serializable & scala.Serializable)() -> this.simple().cube((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")})).count());
        this.test("rollup string", (Function0 & Serializable & scala.Serializable)() -> this.simple().rollup("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).count());
        this.test("cube string", (Function0 & Serializable & scala.Serializable)() -> this.simple().cube("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).count());
        this.test("grouping and grouping_id", (Function0 & Serializable & scala.Serializable)() -> this.simple().cube("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).agg(functions$.MODULE$.grouping("a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.grouping("b"), functions$.MODULE$.grouping_id("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))})));
        this.test("pivot", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).pivot("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).agg(functions$.MODULE$.count(Column$.MODULE$.apply("b")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])));
        this.test("pivot without column values", (Function0 & Serializable & scala.Serializable)() -> this.simple().groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).pivot("a").agg(functions$.MODULE$.count(Column$.MODULE$.apply("b")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])));
        this.test("test broadcast", (Function0 & Serializable & scala.Serializable)() -> this.left().join(functions$.MODULE$.broadcast(this.right()), "id"));
        this.test("function lit", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)functions$.MODULE$.col("id")), functions$.MODULE$.lit((Object)SymbolLiteral.bootstrap("apply", "id")), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)((byte)68))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToShort((short)((short)9872))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-8726532)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)7834609328726532L)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Math.E)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToFloat((float)-0.8f)), functions$.MODULE$.lit((Object)package$.MODULE$.BigDecimal().apply(8997620L, 5)), functions$.MODULE$.lit((Object)package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal()), functions$.MODULE$.lit((Object)"connect!"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'T')), functions$.MODULE$.lit(Array$.MODULE$.tabulate(10, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$433(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Char())), functions$.MODULE$.lit(Array$.MODULE$.tabulate(23, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$434(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Byte())), functions$.MODULE$.lit((Object)WrappedArray$.MODULE$.make(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)8, (byte)6}), ClassTag$.MODULE$.Byte()))), functions$.MODULE$.lit(null), functions$.MODULE$.lit((Object)LocalDate.of(2020, 10, 10)), functions$.MODULE$.lit((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(8997620L, 6))), functions$.MODULE$.lit((Object)Instant.ofEpochMilli(1677155519808L)), functions$.MODULE$.lit((Object)new Timestamp(12345L)), functions$.MODULE$.lit((Object)LocalDateTime.of(2023, 2, 23, 20, 36)), functions$.MODULE$.lit((Object)Date.valueOf("2023-02-23")), functions$.MODULE$.lit((Object)Duration.ofSeconds(200L)), functions$.MODULE$.lit((Object)Period.ofDays(100)), functions$.MODULE$.lit((Object)new CalendarInterval(2, 20, 100L))})));
        this.test("function lit array", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)Array$.MODULE$.emptyDoubleArray()), functions$.MODULE$.lit((Object)((Object[])new int[][]{{1}, {2}, {3}})), functions$.MODULE$.lit((Object)((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1}}), (int[][])((Object[])new int[][]{{2}}), (int[][])((Object[])new int[][]{{3}})})), functions$.MODULE$.lit((Object)new boolean[]{true, false}), functions$.MODULE$.lit((Object)new byte[]{(byte)67, (byte)68, (byte)69}), functions$.MODULE$.lit((Object)new short[]{(short)9872, (short)9873, (short)9874}), functions$.MODULE$.lit((Object)new int[]{-8726532, 8726532, -8726533}), functions$.MODULE$.lit((Object)new long[]{7834609328726531L, 7834609328726532L, 7834609328726533L}), functions$.MODULE$.lit((Object)new double[]{Math.E, 1.0, 2}), functions$.MODULE$.lit((Object)new float[]{-0.8f, -0.7f, -0.9f}), functions$.MODULE$.lit((Object)new scala.math.BigDecimal[]{package$.MODULE$.BigDecimal().apply(8997620L, 5), package$.MODULE$.BigDecimal().apply(8997621L, 5)}), functions$.MODULE$.lit((Object)new BigDecimal[]{package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal(), package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal()}), functions$.MODULE$.lit((Object)new String[]{"connect!", "disconnect!"}), functions$.MODULE$.lit((Object)new char[]{'T', 'F'}), functions$.MODULE$.lit((Object)((Object[])new char[][]{(char[])Array$.MODULE$.tabulate(10, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$436(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Char()), (char[])Array$.MODULE$.tabulate(10, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$437(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Char())})), functions$.MODULE$.lit((Object)new LocalDate[]{LocalDate.of(2020, 10, 10), LocalDate.of(2020, 10, 11)}), functions$.MODULE$.lit((Object)new Instant[]{Instant.ofEpochMilli(1677155519808L), Instant.ofEpochMilli(1677155519809L)}), functions$.MODULE$.lit((Object)new Timestamp[]{new Timestamp(12345L), new Timestamp(23456L)}), functions$.MODULE$.lit((Object)new LocalDateTime[]{LocalDateTime.of(2023, 2, 23, 20, 36), LocalDateTime.of(2023, 2, 23, 21, 36)}), functions$.MODULE$.lit((Object)new Date[]{Date.valueOf("2023-02-23"), Date.valueOf("2023-03-01")}), functions$.MODULE$.lit((Object)new Duration[]{Duration.ofSeconds(100L), Duration.ofSeconds(200L)}), functions$.MODULE$.lit((Object)new Period[]{Period.ofDays(100), Period.ofDays(200)}), functions$.MODULE$.lit((Object)new CalendarInterval[]{new CalendarInterval(2, 20, 100L), new CalendarInterval(2, 21, 200L)})})));
        this.test("window", (Function0 & Serializable & scala.Serializable)() -> this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.min("id").over(Window$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")}))), functions$.MODULE$.min("id").over(Window$.MODULE$.partitionBy("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rowsBetween(2L, 3L)), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rangeBetween(2L, 3L)), functions$.MODULE$.count(Column$.MODULE$.apply("id")).over()})));
        this.test("relation extension", (Function0 & Serializable & scala.Serializable)() -> {
            ExamplePluginRelation input = ExamplePluginRelation.newBuilder().setInput(this.simple().plan().getRoot()).build();
            return this.session().newDataFrame(Any.pack((Message)input));
        });
        this.test("expression extension", (Function0 & Serializable & scala.Serializable)() -> {
            ExamplePluginExpression extension = ExamplePluginExpression.newBuilder().setChild(Expression.newBuilder().setUnresolvedAttribute(Expression.UnresolvedAttribute.newBuilder().setUnparsedIdentifier("id"))).setCustomField("abc").build();
            return this.simple().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply(Any.pack((Message)extension))}));
        });
        this.test("crosstab", (Function0 & Serializable & scala.Serializable)() -> this.simple().stat().crosstab("a", "b"));
        this.test("freqItems", (Function0 & Serializable & scala.Serializable)() -> this.simple().stat().freqItems((String[])((Object[])new String[]{"id", "a"}), 0.1));
        this.test("sampleBy", (Function0 & Serializable & scala.Serializable)() -> this.simple().stat().sampleBy("id", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)0.2))})), 0L));
        this.test("drop", (Function0 & Serializable & scala.Serializable)() -> this.simple().na().drop(5, (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))));
        this.test("fill", (Function0 & Serializable & scala.Serializable)() -> this.simple().na().fill(8L, (Seq)new .colon.colon((Object)"id", (List)Nil$.MODULE$)));
        this.test("replace", (Function0 & Serializable & scala.Serializable)() -> this.simple().na().replace("id", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)8L))}))));
        this.test("table API with options", (Function0 & Serializable & scala.Serializable)() -> this.session().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p1"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p2"), (Object)"v2")}))).table("tempdb.myTable"));
    }
}

