/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.connect.client.ArtifactManager;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u0010 \u00011BQa\u0010\u0001\u0005\u0002\u0001C\u0011\u0002\t\u0001A\u0002\u0003\u0007I\u0011B\"\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0011%\u0011\u0006\u00011AA\u0002\u0013%1\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00051\"I!\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0016\u0005\n7\u0002\u0001\r\u00111A\u0005\nqC\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00024\t\u0013!\u0004\u0001\u0019!A!B\u0013i\u0006\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0003k\u0011%q\u0007\u00011AA\u0002\u0013%q\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u0005W\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\no\u0002\u0001\r\u00111A\u0005\naD\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002;\t\u000bm\u0004A\u0011\u0002?\t\u000bu\u0004A\u0011\u0002?\t\u000by\u0004A\u0011\t?\t\u000b}\u0004A\u0011\t?\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u000f\u00055\u0001\u0001\"\u0005\u0002\u0010!9\u0011Q\u0005\u0001\u0005\u0012\u0005=\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002.\u0002!I!a,\u0003\u001b\u0005\u0013H/\u001b4bGR\u001cV/\u001b;f\u0015\t\u0001\u0013%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003E\r\nqaY8o]\u0016\u001cGO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001[UZ\u0004C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003!1WO\\:vSR,'B\u0001\u001a*\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u00025_\tY\u0011I\\=Gk:\u001cV/\u001b;f!\t1\u0014(D\u00018\u0015\tAt$\u0001\u0003vi&d\u0017B\u0001\u001e8\u0005=\u0019uN\u001c8fGR4UO\\*vSR,\u0007C\u0001\u001f>\u001b\u0005\t\u0014B\u0001 2\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\"\u0001\u001b\u0005yR#\u0001#\u0011\u0005\t+\u0015B\u0001$ \u0005I\u0019\u0006/\u0019:l\u0007>tg.Z2u\u00072LWM\u001c;\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002J\u001fB\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n!QK\\5u\u0011\u001d\u00016!!AA\u0002\u0011\u000b1\u0001\u001f\u00132\u0003\u001d\u0019G.[3oi\u0002\nqa]3sm&\u001cW-F\u0001U!\t\u0011U+\u0003\u0002W?\tAB)^7nsN\u0003\u0018M]6D_:tWm\u0019;TKJ4\u0018nY3\u0002\u0017M,'O^5dK~#S-\u001d\u000b\u0003\u0013fCq\u0001\u0015\u0004\u0002\u0002\u0003\u0007A+\u0001\u0005tKJ4\u0018nY3!\u0003\u0019\u0019XM\u001d<feV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!qM\u001d9d\u0015\u0005\u0011\u0017AA5p\u0013\t!wL\u0001\u0004TKJ4XM]\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHCA%h\u0011\u001d\u0001\u0016\"!AA\u0002u\u000bqa]3sm\u0016\u0014\b%A\bbeRLg-Y2u\u001b\u0006t\u0017mZ3s+\u0005Y\u0007C\u0001\"m\u0013\tiwDA\bBeRLg-Y2u\u001b\u0006t\u0017mZ3s\u0003M\t'\u000f^5gC\u000e$X*\u00198bO\u0016\u0014x\fJ3r)\tI\u0005\u000fC\u0004Q\u0019\u0005\u0005\t\u0019A6\u0002!\u0005\u0014H/\u001b4bGRl\u0015M\\1hKJ\u0004\u0013aB2iC:tW\r\\\u000b\u0002iB\u0011a,^\u0005\u0003m~\u0013a\"T1oC\u001e,Gm\u00115b]:,G.A\u0006dQ\u0006tg.\u001a7`I\u0015\fHCA%z\u0011\u001d\u0001v\"!AA\u0002Q\f\u0001b\u00195b]:,G\u000eI\u0001\u0011gR\f'\u000f\u001e#v[6L8+\u001a:wKJ$\u0012!S\u0001\u0016GJ,\u0017\r^3BeRLg-Y2u\u001b\u0006t\u0017mZ3s\u0003)\u0011WMZ8sK\u0016\u000b7\r[\u0001\nC\u001a$XM]#bG\"\f!b\u0011%V\u001d.{6+\u0013.F+\t\t)\u0001E\u0002K\u0003\u000fI1!!\u0003L\u0005\rIe\u000e^\u0001\f\u0007\"+fjS0T\u0013j+\u0005%\u0001\tbeRLg-Y2u\r&dW\rU1uQV\u0011\u0011\u0011\u0003\t\u0005\u0003'\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u00111\u0017\u000e\\3\u000b\t\u0005m\u0011QD\u0001\u0004]&|'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012Q\u0003\u0002\u0005!\u0006$\b.A\bbeRLg-Y2u\u0007J\u001c\u0007+\u0019;i\u000319W\r^\"sGZ\u000bG.^3t)\u0011\tY#!\u0013\u0011\r\u00055\u0012QHA\"\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e,\u0003\u0019a$o\\8u}%\tA*C\u0002\u0002<-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#aA*fc*\u0019\u00111H&\u0011\u0007)\u000b)%C\u0002\u0002H-\u0013A\u0001T8oO\"9\u00111J\rA\u0002\u0005E\u0011\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0002-\u0005\u001c8/\u001a:u\r&dW\rR1uC\u0016\u000bX/\u00197jif$R!SA)\u0003WBq!a\u0015\u001b\u0001\u0004\t)&A\u0007beRLg-Y2u\u0007\",hn\u001b\t\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\u0005TBAA.\u0015\u0011\ti&a\u0018\u0002\u000bA\u0014x\u000e^8\u000b\u0005\t*\u0013\u0002BA2\u00037\n1#\u00113e\u0003J$\u0018NZ1diN\u0014V-];fgRLA!a\u001a\u0002j\ti\u0011I\u001d;jM\u0006\u001cGo\u00115v].TA!a\u0019\u0002\\!9\u0011Q\u000e\u000eA\u0002\u0005E\u0011!\u00037pG\u0006d\u0007+\u0019;i\u0003]\u0019\u0018N\\4mK\u000eCWO\\6BeRLg-Y2u)\u0016\u001cH\u000fF\u0002J\u0003gBq!!\u001e\u001c\u0001\u0004\t9(\u0001\u0003qCRD\u0007\u0003BA=\u0003\u0003sA!a\u001f\u0002~A\u0019\u0011\u0011G&\n\u0007\u0005}4*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\u000b)I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007fZ\u0015!\u0004:fC\u0012tU\r\u001f;DQVt7\u000e\u0006\u0003\u0002\f\u0006}\u0005\u0003BAG\u00037k!!a$\u000b\t\u0005E\u00151S\u0001\taJ|Go\u001c2vM*!\u0011QSAL\u0003\u00199wn\\4mK*\u0011\u0011\u0011T\u0001\u0004G>l\u0017\u0002BAO\u0003\u001f\u0013!BQ=uKN#(/\u001b8h\u0011\u001d\t\t\u000b\ba\u0001\u0003G\u000b!!\u001b8\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS1AYA\u000f\u0013\u0011\tY+a*\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0016G\",7m[\"ik:\\7\u000fR1uC\u0006sGm\u0011:d)\u0015I\u0015\u0011WAZ\u0011\u001d\tY%\ba\u0001\u0003#Aq!!.\u001e\u0001\u0004\t9,\u0001\u0004dQVt7n\u001d\t\u0007\u0003[\ti$!\u0016")
public class ArtifactSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private ArtifactManager artifactManager;
    private ManagedChannel channel;
    private final int CHUNK_SIZE;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private ArtifactManager artifactManager() {
        return this.artifactManager;
    }

    private void artifactManager_$eq(ArtifactManager x$1) {
        this.artifactManager = x$1;
    }

    private ManagedChannel channel() {
        return this.channel;
    }

    private void channel_$eq(ManagedChannel x$1) {
        this.channel = x$1;
    }

    private void startDummyServer() {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)InProcessServerBuilder.forName((String)this.getClass().getName()).addService((BindableService)this.service())).build());
        this.server().start();
    }

    private void createArtifactManager() {
        this.channel_$eq(((AbstractManagedChannelImplBuilder)InProcessChannelBuilder.forName((String)this.getClass().getName()).directExecutor()).build());
        this.artifactManager_$eq(new ArtifactManager(UserContext.newBuilder().build(), this.channel()));
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.startDummyServer();
        this.createArtifactManager();
        this.client_$eq(null);
    }

    public void afterEach() {
        BoxedUnit boxedUnit;
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "ArtifactSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = this.channel() != null ? this.channel().shutdownNow() : BoxedUnit.UNIT;
        if (this.client() != null) {
            this.client().shutdown();
            return;
        }
    }

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public Path artifactFilePath() {
        return this.baseResourcePath().resolve("artifact-tests");
    }

    public Path artifactCrcPath() {
        return this.artifactFilePath().resolve("crc");
    }

    private Seq<Object> getCrcValues(Path filePath) {
        String fileName = ((Object)filePath.getFileName()).toString();
        String crcFileName = new StringBuilder(4).append((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fileName)).split('.'))).head()).append(".txt").toString();
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.artifactCrcPath().resolve(crcFileName))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ArtifactSuite.$anonfun$getCrcValues$1(x$1)), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    private void assertFileDataEquality(AddArtifactsRequest.ArtifactChunk artifactChunk, Path localPath) {
        ByteString localData = ByteString.readFrom((InputStream)Files.newInputStream(localPath, new OpenOption[0]));
        long expectedCrc = BoxesRunTime.unboxToLong((Object)this.getCrcValues(localPath).head());
        ByteString $org_scalatest_assert_macro_left = artifactChunk.getData();
        ByteString $org_scalatest_assert_macro_right = localData;
        ByteString byteString = $org_scalatest_assert_macro_left;
        ByteString byteString2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        long $org_scalatest_assert_macro_left2 = artifactChunk.getCrc();
        long $org_scalatest_assert_macro_right2 = expectedCrc;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }

    private void singleChunkArtifactTest(String path) {
        this.test(new StringBuilder(24).append("Single Chunk Artifact - ").append(path).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string;
            Seq<AddArtifactsRequest> receivedRequests;
            Path artifactPath = this.artifactFilePath().resolve(path);
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact = batch.getArtifacts(0);
            String string2 = ((Object)artifactPath.getFileName()).toString();
            if (string2.endsWith(".jar")) {
                string = "jars";
            } else if (string2.endsWith(".class")) {
                string = "classes";
            } else {
                throw new MatchError((Object)string2);
            }
            String namePrefix = string;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(singleChunkArtifact.getName().equals(new StringBuilder(1).append(namePrefix).append("/").append(path).toString()), "singleChunkArtifact.getName().equals(namePrefix.+(\"/\").+(path))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            this.assertFileDataEquality(singleChunkArtifact.getData(), artifactPath);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        if (bytesRead == 0) {
            return ByteString.empty();
        }
        return ByteString.copyFrom((byte[])buf, (int)0, (int)bytesRead);
    }

    private void checkChunksDataAndCrc(Path filePath, Seq<AddArtifactsRequest.ArtifactChunk> chunks) {
        InputStream in = Files.newInputStream(filePath, new OpenOption[0]);
        Seq<Object> crcs = this.getCrcValues(filePath);
        ((IterableLike)chunks.zip(crcs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactSuite.$anonfun$checkChunksDataAndCrc$1(this, in, x0$1)));
    }

    public static final /* synthetic */ long $anonfun$getCrcValues$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$checkChunksDataAndCrc$1(ArtifactSuite $this, InputStream in$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AddArtifactsRequest.ArtifactChunk chunk = (AddArtifactsRequest.ArtifactChunk)tuple2._1();
            long expectedCrc = tuple2._2$mcJ$sp();
            ByteString expectedData = $this.readNextChunk(in$1);
            ByteString byteString = chunk.getData();
            ByteString byteString2 = expectedData;
            return !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null) && chunk.getCrc() == expectedCrc;
        }
        throw new MatchError((Object)tuple2);
    }

    public ArtifactSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.CHUNK_SIZE = 32768;
        this.singleChunkArtifactTest("smallClassFile.class");
        this.singleChunkArtifactTest("smallJar.jar");
        this.test("Chunked Artifact - junitLargeJar.jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path artifactPath = this.artifactFilePath().resolve("junitLargeJar.jar");
            this.artifactManager().addArtifact(((Object)artifactPath).toString());
            int expectedChunks = (384581 + (this.CHUNK_SIZE() - 1)) / this.CHUNK_SIZE();
            Seq<AddArtifactsRequest> receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_left = 384581;
            long $org_scalatest_assert_macro_right = Files.size(artifactPath);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left2 = receivedRequests;
            int $org_scalatest_assert_macro_right2 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((AddArtifactsRequest)receivedRequests.head()).hasBeginChunk(), "receivedRequests.head.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = ((AddArtifactsRequest)receivedRequests.head()).getBeginChunk();
            String $org_scalatest_assert_macro_left3 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right3 = "jars/junitLargeJar.jar";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            long $org_scalatest_assert_macro_left4 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right4 = 384581;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right5 = expectedChunks;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            Seq dataChunks = (Seq)((TraversableLike)new .colon.colon((Object)beginChunkRequest.getInitialChunk(), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)((TraversableLike)receivedRequests.drop(1)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getChunk(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.checkChunksDataAndCrc(artifactPath, (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("Batched SingleChunkArtifacts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<AddArtifactsRequest> receivedRequests;
            URI file1 = this.artifactFilePath().resolve("smallClassFile.class").toUri();
            URI file2 = this.artifactFilePath().resolve("smallJar.jar").toUri();
            this.artifactManager().addArtifacts((Seq)new .colon.colon((Object)file1, (List)new .colon.colon((Object)file2, (List)Nil$.MODULE$)));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            AddArtifactsRequest request = (AddArtifactsRequest)receivedRequests.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(request.hasBatch(), "request.hasBatch()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            AddArtifactsRequest.Batch batch = request.getBatch();
            java.util.List $org_scalatest_assert_macro_left2 = batch.getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            java.util.List artifacts = batch.getArtifactsList();
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            String $org_scalatest_assert_macro_left4 = ((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right4 = "jars/smallJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(0)).getData(), Paths.get(file1));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)artifacts.get(1)).getData(), Paths.get(file2));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("Mix of SingleChunkArtifact and chunked artifact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            java.util.List firstReqBatch;
            Seq<AddArtifactsRequest> receivedRequests;
            URI file1 = this.artifactFilePath().resolve("smallClassFile.class").toUri();
            URI file2 = this.artifactFilePath().resolve("junitLargeJar.jar").toUri();
            URI file3 = this.artifactFilePath().resolve("smallClassFileDup.class").toUri();
            URI file4 = this.artifactFilePath().resolve("smallJar.jar").toUri();
            this.artifactManager().addArtifacts((Seq)new .colon.colon((Object)file1, (List)new .colon.colon((Object)file2, (List)new .colon.colon((Object)file3, (List)new .colon.colon((Object)file4, (List)Nil$.MODULE$)))));
            Seq<AddArtifactsRequest> $org_scalatest_assert_macro_left = receivedRequests = this.service().getAndClearLatestAddArtifactRequests();
            int $org_scalatest_assert_macro_right = 14;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            java.util.List $org_scalatest_assert_macro_left2 = firstReqBatch = ((AddArtifactsRequest)receivedRequests.head()).getBatch().getArtifactsList();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            String $org_scalatest_assert_macro_left3 = ((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "classes/smallClassFile.class";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)firstReqBatch.get(0)).getData(), Paths.get(file1));
            AddArtifactsRequest secondReq = (AddArtifactsRequest)receivedRequests.apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(secondReq.hasBeginChunk(), "secondReq.hasBeginChunk()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            AddArtifactsRequest.BeginChunkedArtifact beginChunkRequest = secondReq.getBeginChunk();
            String $org_scalatest_assert_macro_left4 = beginChunkRequest.getName();
            String $org_scalatest_assert_macro_right4 = "jars/junitLargeJar.jar";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            long $org_scalatest_assert_macro_left5 = beginChunkRequest.getTotalBytes();
            int $org_scalatest_assert_macro_right5 = 384581;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            long $org_scalatest_assert_macro_left6 = beginChunkRequest.getNumChunks();
            int $org_scalatest_assert_macro_right6 = 12;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Seq dataChunks = (Seq)((TraversableLike)new .colon.colon((Object)beginChunkRequest.getInitialChunk(), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)((TraversableLike)((IterableLike)receivedRequests.drop(2)).dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getChunk(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.checkChunksDataAndCrc(Paths.get(file2), (Seq<AddArtifactsRequest.ArtifactChunk>)dataChunks);
            AddArtifactsRequest.Batch lastBatch = ((AddArtifactsRequest)receivedRequests.last()).getBatch();
            int $org_scalatest_assert_macro_left7 = lastBatch.getArtifactsCount();
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            java.util.List remainingArtifacts = lastBatch.getArtifactsList();
            String $org_scalatest_assert_macro_left8 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getName();
            String $org_scalatest_assert_macro_right8 = "classes/smallClassFileDup.class";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            String $org_scalatest_assert_macro_left9 = ((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getName();
            String $org_scalatest_assert_macro_right9 = "jars/smallJar.jar";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(0)).getData(), Paths.get(file3));
            this.assertFileDataEquality(((AddArtifactsRequest.SingleChunkArtifact)remainingArtifacts.get(1)).getData(), Paths.get(file4));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }
}

