/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.typesafe.tools.mima.core.Problem;
import com.typesafe.tools.mima.core.ProblemFilters$;
import com.typesafe.tools.mima.lib.MiMaLib;
import com.typesafe.tools.mima.lib.MiMaLib$;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.spark.sql.connect.client.CheckConnectJvmClientCompatibility;
import org.apache.spark.sql.connect.client.util.IntegrationTestUtils$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class CheckConnectJvmClientCompatibility$ {
    public static CheckConnectJvmClientCompatibility$ MODULE$;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new CheckConnectJvmClientCompatibility$();
    }

    private String sparkHome$lzycompute() {
        CheckConnectJvmClientCompatibility$ checkConnectJvmClientCompatibility$ = this;
        synchronized (checkConnectJvmClientCompatibility$) {
            if (!this.bitmap$0) {
                if (!scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw new IllegalArgumentException("SPARK_HOME is not set.");
                }
                this.sparkHome = (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME");
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    private String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void main(String[] args) {
        try (Writer resultWriter = null;){
            try {
                Seq<String> incompatibleApis;
                resultWriter = Files.newBufferedWriter(Paths.get(new StringBuilder(27).append(this.sparkHome()).append("/.connect-mima-check-result").toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                File clientJar = IntegrationTestUtils$.MODULE$.findJar("connector/connect/client/jvm", "spark-connect-client-jvm-assembly", "spark-connect-client-jvm", IntegrationTestUtils$.MODULE$.findJar$default$4());
                File sqlJar = IntegrationTestUtils$.MODULE$.findJar("sql/core", "spark-sql", "spark-sql", IntegrationTestUtils$.MODULE$.findJar$default$4());
                List<Problem> problems = this.checkMiMaCompatibility(clientJar, sqlJar);
                if (problems.nonEmpty()) {
                    resultWriter.write(new StringBuilder(49).append("ERROR: Comparing client jar: ").append(clientJar).append(" and and sql jar: ").append(sqlJar).append(" \n").toString());
                    resultWriter.write("problems: \n");
                    resultWriter.write(String.valueOf(((TraversableOnce)problems.map((Function1 & Serializable & scala.Serializable)p -> (String)p.description().apply((Object)"client"), List$.MODULE$.canBuildFrom())).mkString("\n")));
                    resultWriter.write("\n");
                    resultWriter.write("Exceptions to binary compatibility can be added in 'CheckConnectJvmClientCompatibility#checkMiMaCompatibility'\n");
                }
                if ((incompatibleApis = this.checkDatasetApiCompatibility(clientJar, sqlJar)).nonEmpty()) {
                    resultWriter.write("ERROR: The Dataset apis only exist in the connect client module and not belong to the sql module include: \n");
                    resultWriter.write(incompatibleApis.mkString("\n"));
                    resultWriter.write("\n");
                    resultWriter.write("Exceptions can be added to exceptionMethods in 'CheckConnectJvmClientCompatibility#checkDatasetApiCompatibility'\n");
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)e.getMessage());
                resultWriter.write(new StringBuilder(7).append("ERROR: ").append(e.getMessage()).toString());
            }
        }
    }

    private List<Problem> checkMiMaCompatibility(File clientJar, File sqlJar) {
        MiMaLib mima = new MiMaLib((Seq)new .colon.colon((Object)clientJar, (List)new .colon.colon((Object)sqlJar, (List)Nil$.MODULE$)), MiMaLib$.MODULE$.$lessinit$greater$default$2());
        List allProblems = mima.collectProblems(sqlJar, clientJar, List$.MODULE$.empty());
        Seq includedRules = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CheckConnectJvmClientCompatibility.IncludeByName[]{new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.Column.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.ColumnName.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrame.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrameReader.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrameNaFunctions.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrameStatFunctions.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrameWriter.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DataFrameWriterV2.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.Dataset.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.functions.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.RelationalGroupedDataset.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.SparkSession.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.RuntimeConfig.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.TypedColumn.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.SQLImplicits.*"), new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.DatasetHolder.*")}));
        Seq excludeRules = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{ProblemFilters$.MODULE$.exclude("org.sparkproject.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.connect.proto.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameReader.json", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameNaFunctions.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameStatFunctions.bloomFilter", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameStatFunctions.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.ofRows", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.DATASET_ID_TAG", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.COL_POS_KEY", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.DATASET_ID_KEY", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.curId", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.observe", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.queryExecution", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.encoder", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.sqlContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.joinWith", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.select", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.selectUntyped", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.reduce", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.groupByKey", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.explode", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.filter", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.map", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.mapPartitions", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.flatMap", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.foreach", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.foreachPartition", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.rdd", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.toJavaRDD", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.javaRDD", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.writeStream", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.udf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.call_udf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.callUDF", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.unwrap_udt", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.udaf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.typedlit", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.typedLit", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset.apply", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset.as", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.clearDefaultSession", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.setDefaultSession", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sparkContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sharedState", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sessionState", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sqlContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.listenerManager", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.experimental", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.udf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.streams", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.createDataFrame", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.baseRelationToDataFrame", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.createDataset", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.catalog", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.executeCommand", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.readStream", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RuntimeConfig.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.TypedColumn.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits.rddToDatasetHolder", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits._sqlContext", ClassTag$.MODULE$.apply(Problem.class))}));
        List problems = (List)((TraversableLike)allProblems.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)includedRules.exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)rule.apply(p)))))).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)excludeRules.forall((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)CheckConnectJvmClientCompatibility$.$anonfun$checkMiMaCompatibility$4(p, rule)))));
        return problems;
    }

    private Seq<String> checkDatasetApiCompatibility(File clientJar, File sqlJar) {
        String className = "org.apache.spark.sql.Dataset";
        Seq clientMethods = this.methods$1(clientJar, className);
        Seq sqlMethods = this.methods$1(sqlJar, className);
        Seq exceptionMethods = (Seq)new .colon.colon((Object)"org.apache.spark.sql.Dataset.collectResult", (List)new .colon.colon((Object)"org.apache.spark.sql.Dataset.plan", (List)Nil$.MODULE$));
        return (Seq)((SeqLike)clientMethods.diff((GenSeq)sqlMethods)).diff((GenSeq)exceptionMethods);
    }

    public static final /* synthetic */ boolean $anonfun$checkMiMaCompatibility$4(Problem p$2, Function1 rule) {
        return BoxesRunTime.unboxToBoolean((Object)rule.apply((Object)p$2));
    }

    private final Seq methods$1(File jar, String className) {
        ChildFirstURLClassLoader classLoader = new ChildFirstURLClassLoader((URL[])((TraversableOnce)new .colon.colon((Object)jar.toURI().toURL(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(URL.class)), this.getClass().getClassLoader());
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror((ClassLoader)classLoader);
        Symbols.ClassSymbolApi classSymbol = mirror.classSymbol(Class.forName(className, false, (ClassLoader)classLoader));
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)classSymbol.typeSignature().members().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isMethod()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asMethod(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)m.isPublic()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.fullName(), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private CheckConnectJvmClientCompatibility$() {
        MODULE$ = this;
    }
}

