/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3A\u0001B\u0003\u0001%!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0005M!)\u0011\t\u0001C\u0005\u0005\n93\u000b]1sW\u000e{gN\\3di\u000ec\u0017.\u001a8u\u0005VLG\u000eZ3s!\u0006\u00148/\u001a+fgR\u001cV/\u001b;f\u0015\t1q!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0011%\tqaY8o]\u0016\u001cGO\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001'm\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\u0011\u0019,hn];ji\u0016T!\u0001G\b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u000e\u0016\u0005-\te.\u001f$v]N+\u0018\u000e^3\u0011\u0005qyR\"A\u000f\u000b\u0005y)\u0011\u0001B;uS2L!\u0001I\u000f\u0003\u001f\r{gN\\3di\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\u0003\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\u001dr\u0003C\u0001\u0015,\u001d\t!\u0013&\u0003\u0002+\u000b\u0005\u00112\u000b]1sW\u000e{gN\\3di\u000ec\u0017.\u001a8u\u0013\taSFA\u0004Ck&dG-\u001a:\u000b\u0005)*\u0001\"B\u0018\u0003\u0001\u0004\u0001\u0014\u0001B1sON\u00042!\r\u001b7\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$A\u0003\u001fsKB,\u0017\r^3e}A\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\u001a\u000e\u0003iR!aO\t\u0002\rq\u0012xn\u001c;?\u0013\ti$'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f3\u00031\t'oZ;nK:$H+Z:u)\u0011\u0019e\t\u0013&\u0011\u0005E\"\u0015BA#3\u0005\u0011)f.\u001b;\t\u000b\u001d\u001b\u0001\u0019\u0001\u001c\u0002\t9\fW.\u001a\u0005\u0006\u0013\u000e\u0001\rAN\u0001\u0006m\u0006dW/\u001a\u0005\u0006\u0017\u000e\u0001\r\u0001T\u0001\nKb$(/Y2u_J\u0004B!M'(m%\u0011aJ\r\u0002\n\rVt7\r^5p]F\u0002")
public class SparkConnectClientBuilderParseTestSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private SparkConnectClient.Builder build(Seq<String> args) {
        return SparkConnectClient$.MODULE$.builder().parse((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private void argumentTest(String name, String value, Function1<SparkConnectClient.Builder, String> extractor) {
        this.test(new StringBuilder(11).append("Argument - ").append(name).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConnectClient.Builder builder = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append("--").append(name).toString(), value}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(value);
            String $org_scalatest_assert_macro_right = (String)extractor.apply((Object)builder);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append("--").append(name).toString()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "option requires a value";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
    }

    public SparkConnectClientBuilderParseTestSuite() {
        ConnectFunSuite.$init$(this);
        this.argumentTest("host", "www.apache.org", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.host());
        this.argumentTest("port", "1506", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$2 -> Integer.toString(x$2.port()));
        this.argumentTest("token", "azbycxdwev1234567890", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.token().get());
        this.argumentTest("user_id", "U1238", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.userId().get());
        this.argumentTest("user_name", "alice", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.userName().get());
        this.argumentTest("user_agent", "MY APP", (Function1<SparkConnectClient.Builder, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.userAgent());
        this.test("Argument - remote", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConnectClient.Builder builder = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remote", "sc://srv.apache.org/;user_id=x127;user_name=Q;token=nahnah;param1=x"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(builder.host());
            String $org_scalatest_assert_macro_right = "srv.apache.org";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder.port()));
            int $org_scalatest_assert_macro_right2 = 15002;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Option $org_scalatest_assert_macro_left3 = builder.token();
            String $org_scalatest_assert_macro_right3 = "nahnah";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Option $org_scalatest_assert_macro_left4 = builder.userId();
            String $org_scalatest_assert_macro_right4 = "x127";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(builder.options());
            Map $org_scalatest_assert_macro_right5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"user_name", (Object)"Q"), new Tuple2((Object)"param1", (Object)"x")}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Argument - use_ssl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConnectClient.Builder builder = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--use_ssl"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(builder.sslEnabled(), "builder.sslEnabled", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Argument - option", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConnectClient.Builder builder = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--option", "foo=bar", "--option", "c1=s8", "--option", "ns.sns.setting=baz"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(builder.options());
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"foo", (Object)"bar"), new Tuple2((Object)"c1", (Object)"s8"), new Tuple2((Object)"ns.sns.setting", (Object)"baz")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            NoSuchElementException e1 = (NoSuchElementException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--option"})), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--option", "not_a_config"})), ClassTag$.MODULE$.apply(MatchError.class), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--option", "bar=baz=bak"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "should contain key=value";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Argument - unsupported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--unknown"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "is an unsupported argument";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("SparkSession - create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConnectClient.Builder builder = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remote", "sc://localhost:15033", "--port", "1507", "--user_agent", "U8912", "--user_id", "Q12"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(builder.host());
            String $org_scalatest_assert_macro_right = "localhost";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder.port()));
            int $org_scalatest_assert_macro_right2 = 1507;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(builder.userAgent());
            String $org_scalatest_assert_macro_right3 = "U8912";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builder.sslEnabled(), "builder.sslEnabled", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Option $org_scalatest_assert_macro_left4 = builder.token();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Option $org_scalatest_assert_macro_left5 = builder.userId();
            String $org_scalatest_assert_macro_right4 = "Q12";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Option $org_scalatest_assert_macro_left6 = builder.userName();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Map $org_scalatest_assert_macro_left7 = builder.options();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            SparkConnectClient.Builder builder2 = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--use_ssl", "--user_name", "Nico", "--option", "mode=turbo", "--option", "cluster=mycl"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(builder2.host());
            String $org_scalatest_assert_macro_right5 = "localhost";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder2.port()));
            int $org_scalatest_assert_macro_right6 = 15002;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            String $org_scalatest_assert_macro_left10 = builder2.userAgent();
            String $org_scalatest_assert_macro_right7 = "_SPARK_CONNECT_SCALA";
            String string = $org_scalatest_assert_macro_left10;
            String string2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right7, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(builder2.sslEnabled(), "builder.sslEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Option $org_scalatest_assert_macro_left11 = builder2.token();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            Option $org_scalatest_assert_macro_left12 = builder2.userId();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Option $org_scalatest_assert_macro_left13 = builder2.userName();
            String $org_scalatest_assert_macro_right8 = "Nico";
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(builder2.options());
            Map $org_scalatest_assert_macro_right9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mode", (Object)"turbo"), new Tuple2((Object)"cluster", (Object)"mycl")}));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            SparkConnectClient.Builder builder3 = this.build((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--token", "thisismysecret"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(builder3.host());
            String $org_scalatest_assert_macro_right10 = "localhost";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder3.port()));
            int $org_scalatest_assert_macro_right11 = 15002;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(builder3.userAgent());
            String $org_scalatest_assert_macro_right12 = "_SPARK_CONNECT_SCALA";
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(builder3.sslEnabled(), "builder.sslEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Option $org_scalatest_assert_macro_left18 = builder3.token();
            String $org_scalatest_assert_macro_right13 = "thisismysecret";
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "contains", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left18.contains((Object)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Option $org_scalatest_assert_macro_left19 = builder3.userId();
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left19, "isEmpty", $org_scalatest_assert_macro_left19.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            Option $org_scalatest_assert_macro_left20 = builder3.userName();
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left20, "isEmpty", $org_scalatest_assert_macro_left20.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Map $org_scalatest_assert_macro_left21 = builder3.options();
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left21, "isEmpty", $org_scalatest_assert_macro_left21.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("SparkConnectClientBuilderParseTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }
}

