/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.util;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.spark.package$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class IntegrationTestUtils$ {
    public static IntegrationTestUtils$ MODULE$;
    private String scalaVersion;
    private String scalaDir;
    private String sparkHome;
    private boolean isSparkHiveJarAvailable;
    private final String DEBUG_SC_JVM_CLIENT;
    private final boolean isDebug;
    private volatile byte bitmap$0;

    static {
        new IntegrationTestUtils$();
    }

    private String DEBUG_SC_JVM_CLIENT() {
        return this.DEBUG_SC_JVM_CLIENT;
    }

    private String scalaVersion$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String string;
                String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(Properties$.MODULE$.versionNumberString())).split('.');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) >= 0) {
                    String major = (String)((SeqLike)option.get()).apply(0);
                    String minor = (String)((SeqLike)option.get()).apply(1);
                    string = new StringBuilder(1).append(major).append(".").append(minor).toString();
                } else {
                    string = Properties$.MODULE$.versionNumberString();
                }
                this.scalaVersion = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.scalaVersion;
    }

    public String scalaVersion() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.scalaVersion$lzycompute();
        }
        return this.scalaVersion;
    }

    private String scalaDir$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.scalaDir = new StringBuilder(6).append("scala-").append(this.scalaVersion()).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.scalaDir;
    }

    public String scalaDir() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.scalaDir$lzycompute();
        }
        return this.scalaDir;
    }

    private String sparkHome$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                if (!scala.sys.package$.MODULE$.props().contains("spark.test.home") && !scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw Assertions$.MODULE$.fail("spark.test.home or SPARK_HOME is not set.", new Position("IntegrationTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
                }
                this.sparkHome = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable & scala.Serializable)() -> (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            Predef$.MODULE$.println((Object)msg);
            return;
        }
    }

    public void debug(Throwable error) {
        if (this.isDebug()) {
            error.printStackTrace();
            return;
        }
    }

    private boolean isSparkHiveJarAvailable$lzycompute() {
        IntegrationTestUtils$ integrationTestUtils$ = this;
        synchronized (integrationTestUtils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                String filePath = new StringBuilder(39).append(this.sparkHome()).append("/assembly/target/").append(this.scalaDir()).append("/jars/").append("spark-hive_").append(this.scalaVersion()).append("-").append(package$.MODULE$.SPARK_VERSION()).append(".jar").toString();
                this.isSparkHiveJarAvailable = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.isSparkHiveJarAvailable;
    }

    public boolean isSparkHiveJarAvailable() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.isSparkHiveJarAvailable$lzycompute();
        }
        return this.isSparkHiveJarAvailable;
    }

    public File findJar(String path, String sbtName, String mvnName, boolean test) {
        File targetDir = new File(new File(this.sparkHome(), path), "target");
        Predef$.MODULE$.assert(targetDir.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Fail to locate the target folder: '").append(targetDir.getCanonicalPath()).append("'. ").append("SPARK_HOME='").append(new File(MODULE$.sparkHome()).getCanonicalPath()).append("'. ").append("Make sure the spark project jars has been built (e.g. using build/sbt package)").append("and the env variable `SPARK_HOME` is set correctly.").toString());
        String suffix = test ? "-tests.jar" : ".jar";
        File[] jars = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.recursiveListFiles(targetDir))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IntegrationTestUtils$.$anonfun$findJar$2(sbtName, suffix, mvnName, f)));
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to find the jar inside folder: ").append(targetDir.getCanonicalPath()).toString());
        this.debug(new StringBuilder(11).append("Using jar: ").append(jars[0].getCanonicalPath()).toString());
        return jars[0];
    }

    public boolean findJar$default$4() {
        return false;
    }

    private File[] recursiveListFiles(File f2) {
        File[] these = f2.listFiles();
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])these)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])these)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).flatMap((Function1 & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IntegrationTestUtils$.MODULE$.recursiveListFiles(f))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findJar$2(String sbtName$1, String suffix$1, String mvnName$1, File f) {
        String string = f.getParentFile().getName();
        String string2 = MODULE$.scalaDir();
        if (!(string != null ? !string.equals(string2) : string2 != null) && f.getName().startsWith(sbtName$1)) {
            if (f.getName().endsWith(suffix$1)) return true;
        }
        if (!f.getParent().endsWith("target")) return false;
        if (!f.getName().startsWith(mvnName$1)) return false;
        if (!f.getName().endsWith(new StringBuilder(0).append(package$.MODULE$.SPARK_VERSION()).append(suffix$1).toString())) return false;
        return true;
    }

    private IntegrationTestUtils$() {
        MODULE$ = this;
        this.DEBUG_SC_JVM_CLIENT = "spark.debug.sc.jvm.client";
        this.isDebug = new StringOps(Predef$.MODULE$.augmentString(System.getProperty(this.DEBUG_SC_JVM_CLIENT(), "false"))).toBoolean();
    }
}

