/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.sql.connect.client.util.IntegrationTestUtils$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessIO;
import scala.util.Random$;

public final class SparkConnectServerUtils$ {
    public static SparkConnectServerUtils$ MODULE$;
    private Process sparkConnect;
    private final int port;
    private volatile boolean stopped;
    private BufferedOutputStream consoleOut;
    private final String serverStopCommand;
    private volatile boolean bitmap$0;

    static {
        new SparkConnectServerUtils$();
    }

    public int port() {
        return this.port;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private BufferedOutputStream consoleOut() {
        return this.consoleOut;
    }

    private void consoleOut_$eq(BufferedOutputStream x$1) {
        this.consoleOut = x$1;
    }

    private String serverStopCommand() {
        return this.serverStopCommand;
    }

    private Process sparkConnect$lzycompute() {
        SparkConnectServerUtils$ sparkConnectServerUtils$ = this;
        synchronized (sparkConnectServerUtils$) {
            if (!this.bitmap$0) {
                String string;
                IntegrationTestUtils$.MODULE$.debug("Starting the Spark Connect Server...");
                String connectJar = IntegrationTestUtils$.MODULE$.findJar("connector/connect/server", "spark-connect-assembly", "spark-connect", IntegrationTestUtils$.MODULE$.findJar$default$4()).getCanonicalPath();
                String driverClassPath = new StringBuilder(1).append(connectJar).append(":").append(IntegrationTestUtils$.MODULE$.findJar("sql/catalyst", "spark-catalyst", "spark-catalyst", true).getCanonicalPath()).toString();
                if (IntegrationTestUtils$.MODULE$.isSparkHiveJarAvailable()) {
                    string = "hive";
                } else {
                    Predef$.MODULE$.println((Object)"Will start Spark Connect server with `spark.sql.catalogImplementation=in-memory`, some tests that rely on Hive will be ignored. If you don't want to skip them:\n1. Test with maven: run `build/mvn install -DskipTests -Phive` before testing\n2. Test with sbt: run test with `-Phive` profile");
                    string = "in-memory";
                }
                String catalogImplementation = string;
                ProcessBuilder builder = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bin/spark-submit", "--driver-class-path", driverClassPath, "--conf", new StringBuilder(32).append("spark.connect.grpc.binding.port=").append(this.port()).toString(), "--conf", "spark.sql.catalog.testcat=org.apache.spark.sql.connector.catalog.InMemoryTableCatalog", "--conf", new StringBuilder(32).append("spark.sql.catalogImplementation=").append(catalogImplementation).toString(), "--class", "org.apache.spark.sql.connect.SimpleSparkConnectService", connectJar})), new File(IntegrationTestUtils$.MODULE$.sparkHome()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                ProcessIO io = new ProcessIO((Function1 & Serializable & scala.Serializable)in -> {
                    SparkConnectServerUtils$.MODULE$.consoleOut_$eq(new BufferedOutputStream(in));
                    return BoxedUnit.UNIT;
                }, (Function1 & Serializable & scala.Serializable)out -> {
                    SparkConnectServerUtils$.$anonfun$sparkConnect$2(out);
                    return BoxedUnit.UNIT;
                }, (Function1 & Serializable & scala.Serializable)err -> {
                    SparkConnectServerUtils$.$anonfun$sparkConnect$4(err);
                    return BoxedUnit.UNIT;
                });
                Process process = builder.run(io);
                package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.stop());
                this.sparkConnect = process;
                this.bitmap$0 = true;
            }
        }
        return this.sparkConnect;
    }

    private Process sparkConnect() {
        if (!this.bitmap$0) {
            return this.sparkConnect$lzycompute();
        }
        return this.sparkConnect;
    }

    public void start() {
        Predef$.MODULE$.assert(!this.stopped());
        this.sparkConnect();
    }

    public int stop() {
        this.stopped_$eq(true);
        IntegrationTestUtils$.MODULE$.debug("Stopping the Spark Connect Server...");
        try {
            this.consoleOut().write(this.serverStopCommand().getBytes());
            this.consoleOut().flush();
            this.consoleOut().close();
        }
        catch (Throwable e) {
            IntegrationTestUtils$.MODULE$.debug(e);
            this.sparkConnect().destroy();
        }
        int code = this.sparkConnect().exitValue();
        IntegrationTestUtils$.MODULE$.debug(new StringBuilder(48).append("Spark Connect Server is stopped with exit code: ").append(code).toString());
        return code;
    }

    public static final /* synthetic */ void $anonfun$sparkConnect$2(InputStream out) {
        Source$.MODULE$.fromInputStream(out, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)msg -> {
            IntegrationTestUtils$.MODULE$.debug(msg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sparkConnect$4(InputStream err) {
        Source$.MODULE$.fromInputStream(err, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)msg -> {
            IntegrationTestUtils$.MODULE$.debug(msg);
            return BoxedUnit.UNIT;
        });
    }

    private SparkConnectServerUtils$() {
        MODULE$ = this;
        this.port = ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000);
        this.stopped = false;
        this.serverStopCommand = "q";
    }
}

