/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import io.grpc.StatusRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.Sample;
import org.apache.spark.package$;
import org.apache.spark.sql.ClientE2ETestSuite$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.KV;
import org.apache.spark.sql.MyType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLHelper;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SimpleBean;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.apache.spark.sql.connect.client.util.IntegrationTestUtils$;
import org.apache.spark.sql.connect.client.util.RemoteSparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TolerantNumerics$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\u0007\u000e\u0001YAQ!\f\u0001\u0005\u00029BQ\u0001\r\u0001\u0005\nEBQ\u0001\u0013\u0001\u0005\n%CQa\u0016\u0001\u0005\naCQa\u0016\u0001\u0005\nyCq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u0019Y\b\u0001)A\u0005g\")A\u0010\u0001C\u0005{\"9\u00111\u0002\u0001\u0005\n\u00055!AE\"mS\u0016tG/\u0012\u001aF)\u0016\u001cHoU;ji\u0016T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\f SA\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\tMVt7/^5uK*\u0011AdE\u0001\ng\u000e\fG.\u0019;fgRL!AH\r\u0003\u0017\u0005s\u0017PR;o'VLG/\u001a\t\u0003A\u001dj\u0011!\t\u0006\u0003E\r\nA!\u001e;jY*\u0011A%J\u0001\u0007G2LWM\u001c;\u000b\u0005\u0019j\u0011aB2p]:,7\r^\u0005\u0003Q\u0005\u0012!CU3n_R,7\u000b]1sWN+7o]5p]B\u0011!fK\u0007\u0002\u001b%\u0011A&\u0004\u0002\n'Fc\u0005*\u001a7qKJ\fa\u0001P5oSRtD#A\u0018\u0011\u0005)\u0002\u0011!D2baR,(/Z*uI>+H\u000f\u0006\u00023\u007fA\u00111\u0007\u0010\b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR!aN\u000b\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mB\u0004B\u0002!\u0003\t\u0003\u0007\u0011)A\u0003cY>\u001c7\u000eE\u0002C\u0007\u0016k\u0011\u0001O\u0005\u0003\tb\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003\u0005\u001aK!a\u0012\u001d\u0003\tUs\u0017\u000e^\u0001\u000fG\",7m\u001b$sC\u001elWM\u001c;t)\r)%\n\u0014\u0005\u0006\u0017\u000e\u0001\rAM\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000b5\u001b\u0001\u0019\u0001(\u0002!\u0019\u0014\u0018mZ7f]R\u001cHk\\\"iK\u000e\\\u0007cA(Ue9\u0011\u0001K\u0015\b\u0003kEK\u0011!O\u0005\u0003'b\nq\u0001]1dW\u0006<W-\u0003\u0002V-\n\u00191+Z9\u000b\u0005MC\u0014A\u0005;fgR\u001c\u0015\r\u001d;ve\u0016$7\u000b\u001e3PkR$2!R-[\u0011\u0019\u0001E\u0001\"a\u0001\u0003\")Q\n\u0002a\u00017B\u0019!\t\u0018\u001a\n\u0005uC$A\u0003\u001fsKB,\u0017\r^3e}Q)Qi\u00181fO\"1\u0001)\u0002CA\u0002\u0005CQ!Y\u0003A\u0002\t\f\u0001#\u001a=qK\u000e$X\r\u001a(v[2Kg.Z:\u0011\u0005\t\u001b\u0017B\u000139\u0005\rIe\u000e\u001e\u0005\u0006M\u0016\u0001\rAY\u0001\u0011Kb\u0004Xm\u0019;fI6\u000b\u0007pV5ei\"DQ!T\u0003A\u0002m\u000bAb]5na2,7k\u00195f[\u0006,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[6\tQ\u0001^=qKNL!a\u001c7\u0003\u0015M#(/^2u)f\u0004X-A\u0007tS6\u0004H.Z*dQ\u0016l\u0017\rI\u0001\u0016O\u0016tWM]1uK6KH+\u001f9f\u0007>dW/\u001c8t+\u0005\u0019\bc\u0001;xq6\tQO\u0003\u0002wq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U+\bC\u0001\u0016z\u0013\tQXB\u0001\u0004D_2,XN\\\u0001\u0017O\u0016tWM]1uK6KH+\u001f9f\u0007>dW/\u001c8tA\u0005!b/\u00197jI\u0006$X-T=UsB,'+Z:vYR$\"!\u0012@\t\u000b-S\u0001\u0019A@\u0011\u000b\t\u000b\t!!\u0002\n\u0007\u0005\r\u0001HA\u0003BeJ\f\u0017\u0010E\u0002+\u0003\u000fI1!!\u0003\u000e\u0005\u0019i\u0015\u0010V=qK\u0006y1\r[3dWN\u000bW.\u001a*fgVdG/\u0006\u0003\u0002\u0010\u0005mA#B#\u0002\u0012\u00055\u0002bBA\n\u0017\u0001\u0007\u0011QC\u0001\tKb\u0004Xm\u0019;fIB!Ao^A\f!\u0011\tI\"a\u0007\r\u0001\u00119\u0011QD\u0006C\u0002\u0005}!!A#\u0012\t\u0005\u0005\u0012q\u0005\t\u0004\u0005\u0006\r\u0012bAA\u0013q\t9aj\u001c;iS:<\u0007c\u0001\"\u0002*%\u0019\u00111\u0006\u001d\u0003\u0007\u0005s\u0017\u0010C\u0004\u00020-\u0001\r!!\r\u0002\u000f\u0011\fG/Y:fiB)!&a\r\u0002\u0018%\u0019\u0011QG\u0007\u0003\u000f\u0011\u000bG/Y:fi\u0002")
public class ClientE2ETestSuite
extends AnyFunSuite
implements RemoteSparkSession,
SQLHelper {
    private final StructType simpleSchema;
    private final Seq<Column> generateMyTypeColumns;
    private SparkSession spark;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$client$util$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connect$client$util$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        RemoteSparkSession.withTable$(this, tableNames, f);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private String captureStdOut(Function0<BoxedUnit> block) {
        PrintStream currentOut = Console$.MODULE$.out();
        ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)currentOut, (OutputStream)capturedOut));
        Console$.MODULE$.withOut(newOut, block);
        return capturedOut.toString();
    }

    private void checkFragments(String result, Seq<String> fragmentsToCheck) {
        fragmentsToCheck.foreach((Function1 & Serializable & scala.Serializable)fragment -> {
            String $org_scalatest_assert_macro_left = result;
            String $org_scalatest_assert_macro_right = fragment;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        });
    }

    private void testCapturedStdOut(Function0<BoxedUnit> block, Seq<String> fragmentsToCheck) {
        this.checkFragments(this.captureStdOut(block), fragmentsToCheck);
    }

    private void testCapturedStdOut(Function0<BoxedUnit> block, int expectedNumLines, int expectedMaxWidth, Seq<String> fragmentsToCheck) {
        String result = this.captureStdOut(block);
        String[] lines = new StringOps(Predef$.MODULE$.augmentString(result)).split('\n');
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)lines.length));
        int $org_scalatest_assert_macro_right = expectedNumLines;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)s.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
        int $org_scalatest_assert_macro_right2 = expectedMaxWidth;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.checkFragments(result, fragmentsToCheck);
    }

    private StructType simpleSchema() {
        return this.simpleSchema;
    }

    private Seq<Column> generateMyTypeColumns() {
        return this.generateMyTypeColumns;
    }

    private void validateMyTypeResult(MyType[] result) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MyType myType = (MyType)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (myType != null) {
                    long id = myType.id();
                    double a = myType.a();
                    double b = myType.b();
                    long $org_scalatest_assert_macro_left = id;
                    int $org_scalatest_assert_macro_right = i;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
                    double $org_scalatest_assert_macro_left2 = a;
                    long $org_scalatest_assert_macro_right2 = id % 2L;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
                    double $org_scalatest_assert_macro_left3 = b;
                    double $org_scalatest_assert_macro_right3 = (double)id / 10.0;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private <E> void checkSameResult(Seq<E> expected, Dataset<E> dataset) {
        dataset.withResult((Function1 & Serializable & scala.Serializable)result -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Buffer $org_scalatest_assert_macro_right = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(result.iterator()).asScala()).toBuffer();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
        });
    }

    private static final int dummyUdf$1(int x) {
        return x + 5;
    }

    public static final /* synthetic */ boolean $anonfun$new$12(File file) {
        return file.getPath().endsWith(".csv");
    }

    public static final /* synthetic */ void $anonfun$new$37(ClientE2ETestSuite $this, Relation.Builder builder) {
        builder.getLocalRelationBuilder().setSchema($this.simpleSchema().catalogString());
    }

    private final void checkResult$1(TraversableOnce rows, Seq expectedValues) {
        rows.toIterator().zipAll(expectedValues.iterator(), null, null).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Long actual = (Long)tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final void checkSample$1(Dataset ds, double lower, double upper, long seed, Equality tolerance$1) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ds.plan().getRoot().hasSample(), "ds.plan.getRoot().hasSample()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        Sample sample = ds.plan().getRoot().getSample();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)sample.getSeed()));
        long $org_scalatest_assert_macro_right = seed;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sample.getLowerBound()));
        double $org_scalatest_assert_macro_right2 = lower;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), tolerance$1), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sample.getUpperBound()));
        double $org_scalatest_assert_macro_right3 = upper;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), tolerance$1), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
    }

    private static final SimpleBean bean$1(String v) {
        SimpleBean bean = new SimpleBean();
        bean.setValue(v);
        return bean;
    }

    public ClientE2ETestSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        SQLHelper.$init$(this);
        this.test("spark result schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().sql("select val from (values ('Hello'), ('World')) as t(val)");
            return (Assertion)df.withResult((Function1 & Serializable & scala.Serializable)result -> {
                StructType schema;
                StructType $org_scalatest_assert_macro_left = schema = result.schema();
                StructField structField = new StructField("val", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            });
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("spark result array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] result;
            Dataset df = this.spark().sql("select val from (values ('Hello'), ('World')) as t(val)");
            Row[] $org_scalatest_assert_macro_left = result = (Row[])df.collect();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String $org_scalatest_assert_macro_left2 = result[0].getString(0);
            String $org_scalatest_assert_macro_right2 = "Hello";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left3 = result[1].getString(0);
            String $org_scalatest_assert_macro_right3 = "World";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("eager execution of sql", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegrationTestUtils$.MODULE$.isSparkHiveJarAvailable(), "org.apache.spark.sql.connect.client.util.IntegrationTestUtils.isSparkHiveJarAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_martin"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row[] rows_new;
                Row[] rows;
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().sql("select * from test_martin").collect(), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
                this.spark().sql("create table test_martin (id int)");
                Row[] $org_scalatest_assert_macro_left = rows = (Row[])this.spark().sql("select * from test_martin").collect();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                this.spark().sql("insert into test_martin values (1), (2)");
                Row[] $org_scalatest_assert_macro_left2 = rows_new = (Row[])this.spark().sql("select * from test_martin").collect();
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            });
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("simple dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Long[] result;
            Dataset df = this.spark().range(10L).limit(3);
            Long[] $org_scalatest_assert_macro_left = result = (Long[])df.collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Long $org_scalatest_assert_macro_left2 = result[0];
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Long $org_scalatest_assert_macro_left3 = result[1];
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Long $org_scalatest_assert_macro_left4 = result[2];
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.ignore("SPARK-42665: Ignore simple udf test until the udf is fully implemented.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] result;
            UserDefinedFunction myUdf = functions$.MODULE$.udf((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> ClientE2ETestSuite.dummyUdf$1(x), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int());
            Dataset df = this.spark().range(5L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{myUdf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))}));
            Row[] $org_scalatest_assert_macro_left = result = (Row[])df.collect();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Row v = (Row)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    int $org_scalatest_assert_macro_left = v.getInt(0);
                    int $org_scalatest_assert_macro_right = idx + 5;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path testDataPath = Paths.get(IntegrationTestUtils$.MODULE$.sparkHome(), "connector", "connect", "common", "src", "test", "resources", "query-tests", "test-data", "people.csv").toAbsolutePath();
            StructField structField = new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("job", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Dataset df = this.spark().read().format("csv").option("path", ((Object)testDataPath).toString()).options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), (Object)";")}))).schema(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField))).load();
            Path outputFolderPath = Files.createTempDirectory("output", new FileAttribute[0]).toAbsolutePath();
            df.write().format("csv").mode("overwrite").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), (Object)";")}))).save(((Object)outputFolderPath).toString());
            File outputFile = ((File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputFolderPath.toFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ClientE2ETestSuite.$anonfun$new$12(file))))[0];
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(FileUtils.contentEquals((File)testDataPath.toFile(), (File)outputFile), "org.apache.commons.io.FileUtils.contentEquals(testDataPath.toFile(), outputFile)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("read path collision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path testDataPath = Paths.get(IntegrationTestUtils$.MODULE$.sparkHome(), "connector", "connect", "common", "src", "test", "resources", "query-tests", "test-data", "people.csv").toAbsolutePath();
            StructField structField = new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("job", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Dataset df = this.spark().read().format("csv").option("path", ((Object)testDataPath).toString()).options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), (Object)";")}))).schema(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField))).csv(((Object)testDataPath).toString());
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Row[])df.collect(), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("textFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path testDataPath = Paths.get(IntegrationTestUtils$.MODULE$.sparkHome(), "connector", "connect", "common", "src", "test", "resources", "query-tests", "test-data", "people.txt").toAbsolutePath();
            String[] result = (String[])this.spark().read().textFile(((Object)testDataPath).toString()).collect();
            String[] expected = (String[])((Object[])new String[]{"Michael, 29", "Andy, 30", "Justin, 19"});
            String[] $org_scalatest_assert_macro_left = result;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(result);
            String[] $org_scalatest_assert_macro_right2 = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("write table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] result;
            Dataset df = this.spark().range(10L).limit(3);
            df.write().mode(SaveMode.Overwrite).saveAsTable("myTable");
            this.spark().range(2L).write().insertInto("myTable");
            Row[] $org_scalatest_assert_macro_left = result = (Row[])this.spark().sql("select * from myTable").sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            long $org_scalatest_assert_macro_left2 = result[0].getLong(0);
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            long $org_scalatest_assert_macro_left3 = result[1].getLong(0);
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            long $org_scalatest_assert_macro_left4 = result[2].getLong(0);
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            long $org_scalatest_assert_macro_left5 = result[3].getLong(0);
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            long $org_scalatest_assert_macro_left6 = result[4].getLong(0);
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("write without table or path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().range(10L).write().format("noop").mode("append").save(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("write jdbc", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
                Assertion assertion;
                String url = "jdbc:derby:memory:1234";
                String table = "t1";
                try {
                    Row[] result;
                    this.spark().range(10L).write().jdbc(new StringBuilder(12).append(url).append(";create=true").toString(), table, new Properties());
                    Row[] $org_scalatest_assert_macro_left = result = (Row[])this.spark().read().jdbc(url, table, new Properties()).collect();
                    int $org_scalatest_assert_macro_right = 10;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
                }
                finally {
                    this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().jdbc(new StringBuilder(10).append(url).append(";drop=true").toString(), table, new Properties()).collect(), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
                }
                return assertion;
            }
            return BoxedUnit.UNIT;
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("writeTo with create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.myTableV2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] outputRows;
            Seq rows = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$)));
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(rows).asJava(), schema).writeTo("testcat.myTableV2").create();
            Row[] $org_scalatest_assert_macro_left = outputRows = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("writeTo with create and using", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.myTableV2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] columns;
            Row[] outputRows;
            Seq rows = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$)));
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(rows).asJava(), schema).writeTo("testcat.myTableV2").create();
            Row[] $org_scalatest_assert_macro_left = outputRows = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            String[] $org_scalatest_assert_macro_left2 = columns = this.spark().table("testcat.myTableV2").columns();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            Row[] sqlOutputRows = (Row[])this.spark().sql("select * from testcat.myTableV2").collect();
            Row[] $org_scalatest_assert_macro_left3 = outputRows;
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            StructType $org_scalatest_assert_macro_left4 = sqlOutputRows[0].schema();
            StructType $org_scalatest_assert_macro_right4 = schema;
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            String $org_scalatest_assert_macro_left5 = sqlOutputRows[1].getString(1);
            String $org_scalatest_assert_macro_right5 = "b";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("writeTo with create and append", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.myTableV2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] outputRows;
            Seq rows = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$)));
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.spark().sql("CREATE TABLE testcat.myTableV2 (id bigint, data string) USING foo");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().table("testcat.myTableV2").collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(rows).asJava(), schema).writeTo("testcat.myTableV2").append();
            Row[] $org_scalatest_assert_macro_left2 = outputRows = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("WriteTo with overwrite", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.myTableV2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] outputRows2;
            Row[] outputRows;
            IndexedSeq rows1 = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)3L)).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i)), String.valueOf(BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)i) - 1L + (long)97)))})), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq rows2 = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(4L)).to((Object)BoxesRunTime.boxToLong((long)7L)).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i)), String.valueOf(BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)i) - 1L + (long)97)))})), IndexedSeq$.MODULE$.canBuildFrom());
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.spark().sql("CREATE TABLE testcat.myTableV2 (id bigint, data string) USING foo PARTITIONED BY (id)");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().table("testcat.myTableV2").collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows1).asJava(), schema).writeTo("testcat.myTableV2").append();
            Row[] $org_scalatest_assert_macro_left2 = outputRows = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows2).asJava(), schema).writeTo("testcat.myTableV2").overwrite(functions$.MODULE$.expr("true"));
            Row[] $org_scalatest_assert_macro_left3 = outputRows2 = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("WriteTo with overwritePartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.myTableV2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] outputRows;
            IndexedSeq rows = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(4L)).to((Object)BoxesRunTime.boxToLong((long)7L)).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i)), String.valueOf(BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)i) - 1L + (long)97)))})), IndexedSeq$.MODULE$.canBuildFrom());
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.spark().sql("CREATE TABLE testcat.myTableV2 (id bigint, data string) USING foo PARTITIONED BY (id)");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().table("testcat.myTableV2").collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows).asJava(), schema).writeTo("testcat.myTableV2").overwritePartitions();
            Row[] $org_scalatest_assert_macro_left2 = outputRows = (Row[])this.spark().table("testcat.myTableV2").collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("write path collision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(10L);
            Path outputFolderPath = Files.createTempDirectory("output", new FileAttribute[0]).toAbsolutePath();
            return this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().option("path", ((Object)outputFolderPath).toString()).save(((Object)outputFolderPath).toString()), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.simpleSchema = new StructType().add("value", "long", true);
        this.test("Dataset inspection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(10L);
            Dataset local = this.spark().newDataFrame((Function1 & Serializable & scala.Serializable)builder -> {
                ClientE2ETestSuite.$anonfun$new$37(this, builder);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(df.isLocal(), "df.isLocal", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(local.isLocal(), "local.isLocal", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(df.isStreaming(), "df.isStreaming", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            String $org_scalatest_assert_macro_left = df.toString();
            String $org_scalatest_assert_macro_right = "[value: bigint]";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])df.inputFiles());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("Dataset schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(10L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = this.simpleSchema();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.dtypes());
            Tuple2[] $org_scalatest_assert_macro_right2 = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"value", (Object)"LongType")});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df.columns());
            String[] $org_scalatest_assert_macro_right3 = (String[])((Object[])new String[]{"value"});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.printSchema(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.simpleSchema().treeString()}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.printSchema(5), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.simpleSchema().treeString(5)}));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        this.test("Dataframe schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().sql("select * from range(10)");
            StructType expectedSchema = new StructType().add("id", "long", false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = expectedSchema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.dtypes());
            Tuple2[] $org_scalatest_assert_macro_right2 = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"id", (Object)"LongType")});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df.columns());
            String[] $org_scalatest_assert_macro_right3 = (String[])((Object[])new String[]{"id"});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.printSchema(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedSchema.treeString()}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.printSchema(5), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expectedSchema.treeString(5)}));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("Dataset explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(10L);
            Seq simpleExplainFragments = (Seq)new .colon.colon((Object)"== Physical Plan ==", (List)Nil$.MODULE$);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain(), (Seq<String>)simpleExplainFragments);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain(false), (Seq<String>)simpleExplainFragments);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain("simple"), (Seq<String>)simpleExplainFragments);
            Seq extendedExplainFragments = (Seq)((TraversableLike)new .colon.colon((Object)"== Parsed Logical Plan ==", (List)new .colon.colon((Object)"== Analyzed Logical Plan ==", (List)new .colon.colon((Object)"== Optimized Logical Plan ==", (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)simpleExplainFragments, Seq$.MODULE$.canBuildFrom());
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain(true), (Seq<String>)extendedExplainFragments);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain("extended"), (Seq<String>)extendedExplainFragments);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain("cost"), (Seq<String>)((Seq)simpleExplainFragments.$colon$plus((Object)"== Optimized Logical Plan ==", Seq$.MODULE$.canBuildFrom())));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain("codegen"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WholeStageCodegen subtrees."}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.explain("formatted"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Range", "Arguments: "}));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("Dataset result collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Dataset df = this.spark().range(10L);
            Long l = (Long)df.head();
            this.checkResult$1((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)l), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}));
            this.checkResult$1((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.head(5))), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L}));
            Long l2 = (Long)df.first();
            this.checkResult$1((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)l2), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}));
            Dataset $org_scalatest_assert_macro_left = df;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            Dataset $org_scalatest_assert_macro_left2 = df.filter("id > 100");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            this.checkResult$1((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.take(3))), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}));
            this.checkResult$1((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.tail(3))), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{7L, 8L, 9L}));
            this.checkResult$1((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(df.takeAsList(10)).asScala(), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}));
            this.checkResult$1((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.filter("id % 3 = 0").collect())), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 3L, 6L, 9L}));
            this.checkResult$1((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(df.filter("id < 3").collectAsList()).asScala(), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}));
            try (Iterator iterator = df.filter("id > 5 and id < 9").toLocalIterator();){
                this.checkResult$1((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(iterator).asScala(), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{6L, 7L, 8L}));
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("Dataset show", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(20L);
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.show(), 24, 5, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+---+", "| id|", "|  0|", "| 19|"}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.show(10), 15, 24, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+---+", "| id|", "|  0|", "|  9|", "only showing top 10 rows"}));
            Dataset wideDf = this.spark().range(4L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "concat('very_very_very_long_string', id) as val"}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wideDf.show(true), 8, 26, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+---+--------------------+", "| id|                 val|", "|  0|very_very_very_lo...|"}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wideDf.show(false), 8, 33, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+---+---------------------------+", "|id |val                        |", "|2  |very_very_very_long_string2|"}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wideDf.show(2, false), 7, 33, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+---+---------------------------+", "|id |val                        |", "|1  |very_very_very_long_string1|", "only showing top 2 rows"}));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.show(8, 10, true), 17, 23, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-RECORD 3--", "id  | 7", "only showing top 8 rows"}));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("Dataset randomSplit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Equality tolerance = TolerantNumerics$.MODULE$.tolerantDoubleEquality(0.01);
            Dataset df = this.spark().range(100L);
            Dataset[] datasetArray = df.randomSplit(new double[]{8.0, 9.0, 7.0}, 123L);
            Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)datasetArray);
            }
            Dataset ds1 = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset ds2 = (Dataset)((SeqLike)option.get()).apply(1);
            Dataset ds3 = (Dataset)((SeqLike)option.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)ds1, (Object)ds2, (Object)ds3);
            Dataset ds12 = (Dataset)tuple3._1();
            Dataset ds22 = (Dataset)tuple3._2();
            Dataset ds32 = (Dataset)tuple3._3();
            this.checkSample$1(ds12, 0.0, 0.3333333333333333, 123L, tolerance);
            this.checkSample$1(ds22, 0.3333333333333333, 0.7083333333333334, 123L, tolerance);
            this.checkSample$1(ds32, 0.7083333333333334, 1.0, 123L, tolerance);
            java.util.List datasets = df.randomSplitAsList(new double[]{1.0, 2.0, 3.0, 4.0}, 9L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)datasets.size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            this.checkSample$1((Dataset)datasets.get(0), 0.0, 0.1, 9L, tolerance);
            this.checkSample$1((Dataset)datasets.get(1), 0.1, 0.3, 9L, tolerance);
            this.checkSample$1((Dataset)datasets.get(2), 0.3, 0.6, 9L, tolerance);
            this.checkSample$1((Dataset)datasets.get(3), 0.6, 1.0, 9L, tolerance);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("Dataset count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().range(10L).count()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        this.test("Dataset collect tuple", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator5$1(ClientE2ETestSuite $outer) {
                }
            }
            Tuple3[] result = (Tuple3[])session.range(3L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)2)).cast("int").as("a"), functions$.MODULE$.col("id").$div((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)10.0))).as("b")})).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator5$1(null)))).collect();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple3 != null) {
                        long id = BoxesRunTime.unboxToLong((Object)tuple3._1());
                        int a = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        double b = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        long $org_scalatest_assert_macro_left = id;
                        int $org_scalatest_assert_macro_right = i;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
                        int $org_scalatest_assert_macro_left2 = a;
                        long $org_scalatest_assert_macro_right2 = id % 2L;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), (long)$org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
                        double $org_scalatest_assert_macro_left3 = b;
                        double $org_scalatest_assert_macro_right3 = (double)id / 10.0;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        this.generateMyTypeColumns = (Seq)new .colon.colon((Object)functions$.MODULE$.col("id").$div((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)10.0))).as("b"), (List)new .colon.colon((Object)functions$.MODULE$.col("id"), (List)new .colon.colon((Object)functions$.MODULE$.lit((Object)"world").as("d"), (List)new .colon.colon((Object)functions$.MODULE$.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)2)).cast("int").as("a"), (List)Nil$.MODULE$))));
        this.test("Dataset collect complex type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.MyType").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator10$1(ClientE2ETestSuite $outer) {
                }
            }
            MyType[] result = (MyType[])session.range(3L).select(this.generateMyTypeColumns()).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator10$1(null)))).collect();
            this.validateMyTypeResult(result);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        this.test("Dataset typed select - simple column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long numRows = BoxesRunTime.unboxToLong((Object)this.spark().range(1000L).select(functions$.MODULE$.count("id")).first());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)numRows));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        this.test("Dataset typed select - complex column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator15$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.MyType").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator15$1(ClientE2ETestSuite $outer) {
                }
            }
            Dataset ds = session.range(3L).select(functions$.MODULE$.struct(this.generateMyTypeColumns()).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator15$1(null)))));
            this.validateMyTypeResult((MyType[])ds.collect());
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.test("lambda functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] result = (Row[])this.spark().range(3L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sequence(functions$.MODULE$.col("id"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))), functions$.MODULE$.sequence(functions$.MODULE$.col("id").$times((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))})).as("data")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.transform(functions$.MODULE$.col("data"), (Function1 & Serializable & scala.Serializable)x2 -> functions$.MODULE$.transform(x2, (Function1 & Serializable & scala.Serializable)x -> x.$plus((Object)BoxesRunTime.boxToInteger((int)1)))).as("data")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.transform(functions$.MODULE$.col("data"), (Function1 & Serializable & scala.Serializable)x2 -> functions$.MODULE$.aggregate(x2, functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x, y) -> x.$plus(y))).as("summaries")})).collect();
            Row[] expected = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{66L, 66L}))})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{65L, 63L}))})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{63L, 56L}))}))});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            Row[] $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        this.test("shuffle array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq result = ((Row)this.spark().sql("select 1").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.shuffle(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)74))})))})).head()).getSeq(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result.toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 74}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        this.test("ambiguous joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset left = this.spark().range(100L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.rand(10L).as("a")}));
            Dataset right = this.spark().range(100L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.rand(12L).as("a")}));
            Dataset joined = left.join(right, left.apply("id").$eq$eq$eq((Object)right.apply("id"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{left.apply("id"), right.apply("a")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(joined.schema().catalogString());
            String $org_scalatest_assert_macro_right = "struct<id:bigint,a:double>";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
            Dataset joined2 = left.join(right, left.colRegex("id").$eq$eq$eq((Object)right.colRegex("id"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{left.apply("id"), right.apply("a")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(joined2.schema().catalogString());
            String $org_scalatest_assert_macro_right2 = "struct<id:bigint,a:double>";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        this.test("broadcast join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.autoBroadcastJoinThreshold"), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset left = this.spark().range(100L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.rand(10L).as("a")}));
            Dataset right = this.spark().range(100L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.rand(12L).as("a")}));
            Dataset joined = left.join(functions$.MODULE$.broadcast(right), left.apply("id").$eq$eq$eq((Object)right.apply("id"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{left.apply("id"), right.apply("a")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(joined.schema().catalogString());
            String $org_scalatest_assert_macro_right = "struct<id:bigint,a:double>";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> joined.explain(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BroadcastHashJoin"}));
        }), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test("test temp view", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                this.spark().range(100L).createTempView("test1");
                long $org_scalatest_assert_macro_left = this.spark().sql("SELECT * FROM test1").count();
                int $org_scalatest_assert_macro_right = 100;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
                this.spark().range(1000L).createOrReplaceTempView("test1");
                long $org_scalatest_assert_macro_left2 = this.spark().sql("SELECT * FROM test1").count();
                int $org_scalatest_assert_macro_right2 = 1000;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
                this.spark().range(100L).createGlobalTempView("view1");
                long $org_scalatest_assert_macro_left3 = this.spark().sql("SELECT * FROM global_temp.view1").count();
                int $org_scalatest_assert_macro_right3 = 100;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                this.spark().range(1000L).createOrReplaceGlobalTempView("view1");
                long $org_scalatest_assert_macro_left4 = this.spark().sql("SELECT * FROM global_temp.view1").count();
                int $org_scalatest_assert_macro_right4 = 1000;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            }
            finally {
                this.spark().sql("DROP VIEW IF EXISTS test1");
                this.spark().sql("DROP VIEW IF EXISTS global_temp.view1");
            }
            return assertion;
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        this.test("version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.spark().version();
            String $org_scalatest_assert_macro_right = package$.MODULE$.SPARK_VERSION();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq timeFragments = (Seq)new .colon.colon((Object)"Time taken: ", (List)new .colon.colon((Object)" ms", (List)Nil$.MODULE$));
            this.testCapturedStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().time((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().sql("select 1").collect()), (Seq<String>)timeFragments);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        this.test("RuntimeConfig", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().conf().get("foo.bar"), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
            Option $org_scalatest_assert_macro_left = this.spark().conf().getOption("foo.bar");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
            this.spark().conf().set("foo.bar", true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.spark().conf().getOption("foo.bar"));
            Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)"true");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            this.spark().conf().set("foo.bar.numBaz", 100L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.spark().conf().get("foo.bar.numBaz"));
            String $org_scalatest_assert_macro_right2 = "100";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
            this.spark().conf().set("foo.bar.name", "donkey");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.spark().conf().get("foo.bar.name"));
            String $org_scalatest_assert_macro_right3 = "donkey";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            this.spark().conf().unset("foo.bar.name");
            scala.collection.immutable.Map allKeyValues = this.spark().conf().getAll();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(allKeyValues.apply((Object)"foo.bar"));
            String $org_scalatest_assert_macro_right4 = "true";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(allKeyValues.apply((Object)"foo.bar.numBaz"));
            String $org_scalatest_assert_macro_right5 = "100";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().conf().isModifiable("foo.bar"), "ClientE2ETestSuite.this.spark.conf.isModifiable(\"foo.bar\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.spark().conf().isModifiable("spark.sql.ansi.enabled"), "ClientE2ETestSuite.this.spark.conf.isModifiable(\"spark.sql.ansi.enabled\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().conf().isModifiable("spark.sql.globalTempDatabase"), "ClientE2ETestSuite.this.spark.conf.isModifiable(\"spark.sql.globalTempDatabase\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            return (Exception)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().conf().set("spark.sql.globalTempDatabase", "/dev/null"), ClassTag$.MODULE$.apply(Exception.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("SparkVersion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.spark().version();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        this.test("Local Relation implicit conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            Seq simpleValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 24, 3}));
            this.checkSameResult(simpleValues, session.implicits().localSeqToDatasetHolder(simpleValues, session.implicits().newIntEncoder()).toDS());
            this.checkSameResult((Seq)simpleValues.map((Function1 & Serializable & scala.Serializable)v -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v))})), Seq$.MODULE$.canBuildFrom()), session.implicits().localSeqToDatasetHolder(simpleValues, session.implicits().newIntEncoder()).toDF());
            Seq complexValues = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)6), (Object)"b"), (List)Nil$.MODULE$));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator21$1(ClientE2ETestSuite $outer) {
                }
            }
            this.checkSameResult(complexValues, session.implicits().localSeqToDatasetHolder(complexValues, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator21$1(null)))).toDS());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator31$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator31$1(ClientE2ETestSuite $outer) {
                }
            }
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.KV").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator36$1(ClientE2ETestSuite $outer) {
                }
            }
            this.checkSameResult((Seq)complexValues.map((Function1 & Serializable & scala.Serializable)kv -> new KV((String)kv._2(), kv._1$mcI$sp()), Seq$.MODULE$.canBuildFrom()), session.implicits().localSeqToDatasetHolder(complexValues, session.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator31$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "key"})).as(session.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator36$1(null)))));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        this.test("SparkSession.createDataFrame - row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            java.util.List<Object> rows = Arrays.asList((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bob", BoxesRunTime.boxToInteger((int)99)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Club", BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bag", BoxesRunTime.boxToInteger((int)5)}))});
            StructType schema = new StructType().add("key", "string").add("value", "int");
            this.checkSameResult((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(rows).asScala(), this.spark().createDataFrame(rows, schema));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        this.test("SparkSession.createDataFrame - bean", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            java.util.List<Object> beans = Arrays.asList((Object[])new SimpleBean[]{ClientE2ETestSuite.bean$1("x"), ClientE2ETestSuite.bean$1("s"), ClientE2ETestSuite.bean$1("d")});
            this.checkSameResult((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(beans).asScala()).map((Function1 & Serializable & scala.Serializable)b -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{b.value()})), Buffer$.MODULE$.canBuildFrom()), this.spark().createDataFrame(beans, SimpleBean.class));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        this.test("SparkSession typed createDataSet/createDataframe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            java.util.List<Object> list = Arrays.asList((Object[])new KV[]{new KV("bob", 99), new KV("Club", 5), new KV("Bag", 5)});
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator45$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.KV").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator45$1(ClientE2ETestSuite $outer) {
                }
            }
            this.checkSameResult((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala(), session.createDataset(list, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator45$1(null)))));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.KV").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator46$1(ClientE2ETestSuite $outer) {
                }
            }
            this.checkSameResult((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kv.key(), BoxesRunTime.boxToInteger((int)kv.value())})), Buffer$.MODULE$.canBuildFrom()), session.createDataFrame(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toSeq(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator46$1(null))));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        this.test("SparkSession newSession", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String oldId = this.spark().sql("SELECT 1").analyze().getSessionId();
            String newId = this.spark().newSession().sql("SELECT 1").analyze().getSessionId();
            String $org_scalatest_assert_macro_left = oldId;
            String $org_scalatest_assert_macro_right = newId;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        this.test("createDataFrame from complex type schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("c1", (DataType)new StructType().add("c1-1", (DataType)StringType$.MODULE$).add("c1-2", (DataType)StringType$.MODULE$));
            Seq data = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "a2"}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b1", "b2"}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)));
            Row[] result = (Row[])this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(data).asJava(), schema).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            Seq $org_scalatest_assert_macro_right = data;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        this.test("SameSemantics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset plan = this.spark().sql("select 1");
            Dataset otherPlan = this.spark().sql("select 1");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(plan.sameSemantics(otherPlan), "plan.sameSemantics(otherPlan)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
        this.test("sameSemantics and semanticHash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator47$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator47$1(ClientE2ETestSuite $outer) {
                }
            }
            Dataset df1 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcII.sp(1, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(4, 5), (List)Nil$.MODULE$)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator47$1(null)));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator48$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator48$1(ClientE2ETestSuite $outer) {
                }
            }
            Dataset df2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcII.sp(1, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(4, 5), (List)Nil$.MODULE$)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator48$1(null)));
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator49$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator49$1(ClientE2ETestSuite $outer) {
                }
            }
            Dataset df3 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcII.sp(0, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(4, 5), (List)Nil$.MODULE$)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator49$1(null)));
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientE2ETestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_ClientE2ETestSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_ClientE2ETestSuite$$typecreator50$1(ClientE2ETestSuite $outer) {
                }
            }
            Dataset df4 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2.mcII.sp(0, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(4, 5), (List)Nil$.MODULE$)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_ClientE2ETestSuite$$typecreator50$1(null)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)df1.sameSemantics(df2)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)df1.sameSemantics(df3)));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)df3.sameSemantics(df4)));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df1.semanticHash()));
            int $org_scalatest_assert_macro_right4 = df2.semanticHash();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df1.semanticHash()));
            int $org_scalatest_assert_macro_right5 = df3.semanticHash();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "!==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$bang$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df3.semanticHash()));
            int $org_scalatest_assert_macro_right6 = df4.semanticHash();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        this.test("toJSON", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String[] expected = (String[])((Object[])new String[]{"{\"b\":0.0,\"id\":0,\"d\":\"world\",\"a\":0}", "{\"b\":0.1,\"id\":1,\"d\":\"world\",\"a\":1}", "{\"b\":0.2,\"id\":2,\"d\":\"world\",\"a\":0}"});
            String[] result = (String[])this.spark().range(3L).select(this.generateMyTypeColumns()).toJSON().collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expected)), "scala.Predef.refArrayOps[String](result).sameElements[String](scala.Predef.wrapRefArray[String](expected))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        this.test("json from Dataset[String] inferSchema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            Seq expected = (Seq)new .colon.colon((Object)new GenericRowWithSchema(new Object[]{BoxesRunTime.boxToInteger((int)73), "Shandong", "Kong"}, new StructType().add("age", (DataType)LongType$.MODULE$).add("city", (DataType)StringType$.MODULE$).add("name", (DataType)StringType$.MODULE$)), (List)Nil$.MODULE$);
            Dataset ds = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"{\"name\":\"Kong\",\"age\":73,\"city\":'Shandong'}", (List)Nil$.MODULE$), session.implicits().newStringEncoder()).toDS();
            Dataset result = this.spark().read().option("allowSingleQuotes", "true").json(ds);
            this.checkSameResult(expected, result);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.test("json from Dataset[String] with schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            StructType schema = new StructType().add("city", (DataType)StringType$.MODULE$).add("name", (DataType)StringType$.MODULE$);
            Seq expected = (Seq)new .colon.colon((Object)new GenericRowWithSchema(new Object[]{"Shandong", "Kong"}, schema), (List)Nil$.MODULE$);
            Dataset ds = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"{\"name\":\"Kong\",\"age\":73,\"city\":'Shandong'}", (List)Nil$.MODULE$), session.implicits().newStringEncoder()).toDS();
            Dataset result = this.spark().read().schema(schema).option("allowSingleQuotes", "true").json(ds);
            this.checkSameResult(expected, result);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        this.test("json from Dataset[String] with invalid schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String message;
            String $org_scalatest_assert_macro_left = message = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().schema("123").json(this.spark().createDataset((Seq)Nil$.MODULE$, (Encoder)AgnosticEncoders.StringEncoder$.MODULE$)), ClassTag$.MODULE$.apply(ParseException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803))).getMessage();
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
        this.test("csv from Dataset[String] inferSchema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            Seq expected = (Seq)new .colon.colon((Object)new GenericRowWithSchema(new Object[]{"Meng", BoxesRunTime.boxToInteger((int)84), "Shandong"}, new StructType().add("name", (DataType)StringType$.MODULE$).add("age", (DataType)LongType$.MODULE$).add("city", (DataType)StringType$.MODULE$)), (List)Nil$.MODULE$);
            Dataset ds = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"name,age,city", (List)new .colon.colon((Object)"\"Meng\",84,\"Shandong\"", (List)Nil$.MODULE$)), session.implicits().newStringEncoder()).toDS();
            Dataset result = this.spark().read().option("header", "true").option("inferSchema", "true").csv(ds);
            this.checkSameResult(expected, result);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
        this.test("csv from Dataset[String] with schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession session = this.spark();
            StructType schema = new StructType().add("name", (DataType)StringType$.MODULE$).add("age", (DataType)LongType$.MODULE$);
            Seq expected = (Seq)new .colon.colon((Object)new GenericRowWithSchema(new Object[]{"Meng", BoxesRunTime.boxToInteger((int)84)}, schema), (List)Nil$.MODULE$);
            Dataset ds = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"\"Meng\",84,\"Shandong\"", (List)Nil$.MODULE$), session.implicits().newStringEncoder()).toDS();
            Dataset result = this.spark().read().schema(schema).csv(ds);
            this.checkSameResult(expected, result);
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        this.test("csv from Dataset[String] with invalid schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String message;
            String $org_scalatest_assert_macro_left = message = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().schema("123").csv(this.spark().createDataset((Seq)Nil$.MODULE$, (Encoder)AgnosticEncoders.StringEncoder$.MODULE$)), ClassTag$.MODULE$.apply(ParseException.class), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835))).getMessage();
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        }, new Position("ClientE2ETestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
    }
}

