/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001U4Aa\u0003\u0007\u0001+!)\u0001\u0006\u0001C\u0001S!)A\u0006\u0001C\u0001[!)1\n\u0001C\u0005\u0019\")!\u000b\u0001C\u0005'\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00028\t\rI\u0004\u0001\u0015!\u0003p\u0011\u001d\u0019\bA1A\u0005\n9Da\u0001\u001e\u0001!\u0002\u0013y'aD\"pYVlg\u000eV3tiN+\u0018\u000e^3\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011b\u0004\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005Aa-\u001e8tk&$XM\u0003\u0002\u001c%\u0005I1oY1mCR,7\u000f^\u0005\u0003;a\u00111\"\u00118z\rVt7+^5uKB\u0011qDJ\u0007\u0002A)\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$I\u000511\r\\5f]RT!!\n\u0007\u0002\u000f\r|gN\\3di&\u0011q\u0005\t\u0002\u0010\u0007>tg.Z2u\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011\u0001D\u0001\ti\u0016\u001cHoU1nKR!a\u0006N!J!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0011)f.\u001b;\t\u000bU\u0012\u0001\u0019\u0001\u001c\u0002\t9\fW.\u001a\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005e\u0002T\"\u0001\u001e\u000b\u0005m\"\u0012A\u0002\u001fs_>$h(\u0003\u0002>a\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\ti\u0004\u0007C\u0003C\u0005\u0001\u00071)\u0001\u0002gcA)q\u0006\u0012$G\r&\u0011Q\t\r\u0002\n\rVt7\r^5p]J\u0002\"aK$\n\u0005!c!AB\"pYVlg\u000eC\u0003K\u0005\u0001\u00071)\u0001\u0002ge\u0005i1-\u00199ukJ,7\u000b\u001e3PkR$\"AN'\t\r9\u001bA\u00111\u0001P\u0003\u0015\u0011Gn\\2l!\ry\u0003KL\u0005\u0003#B\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\fi\u0016\u001cHoQ8m\u001d\u0006lW\rF\u0002/)rCQ!\u0016\u0003A\u0002Y\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0003/jk\u0011\u0001\u0017\u0006\u000332\tQ\u0001^=qKNL!a\u0017-\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0018\u0003A\u0002y\u000b\u0011A\u001a\t\u0005_}\u000bG-\u0003\u0002aa\tIa)\u001e8di&|g.\r\t\u0003W\tL!a\u0019\u0007\u0003\u0015\r{G.^7o\u001d\u0006lW\r\u0005\u0002XK&\u0011a\r\u0017\u0002\f'R\u0014Xo\u0019;GS\u0016dG-A\u0004nCB$\u0016\u0010]3\u0016\u0003%\u0004\"a\u00166\n\u0005-D&aB'baRK\b/Z\u0001\t[\u0006\u0004H+\u001f9fA\u0005Y1\u000f\u001e:vGR$\u0016\u0010]32+\u0005y\u0007CA,q\u0013\t\t\bL\u0001\u0006TiJ,8\r\u001e+za\u0016\fAb\u001d;sk\u000e$H+\u001f9fc\u0001\n1b\u001d;sk\u000e$H+\u001f9fe\u0005a1\u000f\u001e:vGR$\u0016\u0010]33A\u0001")
public class ColumnTestSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final MapType mapType;
    private final StructType structType1;
    private final StructType structType2;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    public void testSame(String name, Function2<Column, Column, Column> f1, Function2<Column, Column, Column> f2) {
        this.test(new StringBuilder(13).append(name).append(" are the same").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column b = functions$.MODULE$.col("b");
            Column $org_scalatest_assert_macro_left = (Column)f1.apply((Object)a, (Object)b);
            Column $org_scalatest_assert_macro_right = (Column)f2.apply((Object)a, (Object)b);
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }

    private String captureStdOut(Function0<BoxedUnit> block) {
        ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)capturedOut, block);
        return capturedOut.toString();
    }

    private void testColName(DataType dataType, Function1<ColumnName, StructField> f) {
        this.test(new StringBuilder(11).append("ColumnName ").append(dataType.catalogString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField actual = (StructField)f.apply((Object)new ColumnName("col"));
            StructField expected = new StructField("col", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
            StructField $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
    }

    private MapType mapType() {
        return this.mapType;
    }

    private StructType structType1() {
        return this.structType1;
    }

    private StructType structType2() {
        return this.structType2;
    }

    private static final Column expr$1() {
        return functions$.MODULE$.when(functions$.MODULE$.col("a").$less((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"a").otherwise((Object)"b");
    }

    public ColumnTestSuite() {
        ConnectFunSuite.$init$(this);
        this.test("equals & hashcode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = ColumnTestSuite.expr$1();
            Column b = ColumnTestSuite.expr$1();
            Column c = ColumnTestSuite.expr$1().as("nope");
            Column $org_scalatest_assert_macro_left = a;
            Column $org_scalatest_assert_macro_right = a;
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            Column $org_scalatest_assert_macro_left2 = b;
            Column $org_scalatest_assert_macro_right2 = b;
            Column column3 = $org_scalatest_assert_macro_left2;
            Column column4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(column3 != null ? !column3.equals(column4) : column4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Column $org_scalatest_assert_macro_left3 = c;
            Column $org_scalatest_assert_macro_right3 = c;
            Column column5 = $org_scalatest_assert_macro_left3;
            Column column6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(column5 != null ? !column5.equals(column6) : column6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            Column $org_scalatest_assert_macro_left4 = a;
            Column $org_scalatest_assert_macro_right4 = b;
            Column column7 = $org_scalatest_assert_macro_left4;
            Column column8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(column7 != null ? !column7.equals(column8) : column8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Column $org_scalatest_assert_macro_left5 = b;
            Column $org_scalatest_assert_macro_right5 = a;
            Column column9 = $org_scalatest_assert_macro_left5;
            Column column10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(column9 != null ? !column9.equals(column10) : column10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            Column $org_scalatest_assert_macro_left6 = a;
            Column $org_scalatest_assert_macro_right6 = c;
            Column column11 = $org_scalatest_assert_macro_left6;
            Column column12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!=", (Object)$org_scalatest_assert_macro_right6, column11 == null ? column12 != null : !column11.equals(column12), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Column $org_scalatest_assert_macro_left7 = c;
            Column $org_scalatest_assert_macro_right7 = a;
            Column column13 = $org_scalatest_assert_macro_left7;
            Column column14 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "!=", (Object)$org_scalatest_assert_macro_right7, column13 == null ? column14 != null : !column13.equals(column14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Column $org_scalatest_assert_macro_left8 = b;
            Column $org_scalatest_assert_macro_right8 = c;
            Column column15 = $org_scalatest_assert_macro_left8;
            Column column16 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "!=", (Object)$org_scalatest_assert_macro_right8, column15 == null ? column16 != null : !column15.equals(column16), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            Column $org_scalatest_assert_macro_left9 = c;
            Column $org_scalatest_assert_macro_right9 = b;
            Column column17 = $org_scalatest_assert_macro_left9;
            Column column18 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "!=", (Object)$org_scalatest_assert_macro_right9, column17 == null ? column18 != null : !column17.equals(column18), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            int $org_scalatest_assert_macro_left10 = a.hashCode();
            int $org_scalatest_assert_macro_right10 = b.hashCode();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            int $org_scalatest_assert_macro_left11 = a.hashCode();
            int $org_scalatest_assert_macro_right11 = c.hashCode();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 != $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("invalid when usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").when(functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)BoxesRunTime.boxToInteger((int)2)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").isNull().when(functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)BoxesRunTime.boxToInteger((int)2)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.when(functions$.MODULE$.col("a").$less((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)).otherwise((Object)BoxesRunTime.boxToInteger((int)2)).when(functions$.MODULE$.col("b").$greater((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("invalid otherwise usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").otherwise((Object)BoxesRunTime.boxToInteger((int)2)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("a").isNull().otherwise((Object)BoxesRunTime.boxToInteger((int)2)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.when(functions$.MODULE$.col("a").$less((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)).otherwise((Object)BoxesRunTime.boxToInteger((int)2)).otherwise((Object)BoxesRunTime.boxToInteger((int)3)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("invalid withField usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("c").withField(null, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col("c").withField("x", null), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.testSame("=== and equalTo", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.$eq$eq$eq(x$2), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.equalTo(x$4));
        this.testSame("=!= and notEqual", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$5, x$6) -> x$5.$eq$bang$eq(x$6), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$7, x$8) -> x$7.notEqual(x$8));
        this.testSame("> and gt", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$9, x$10) -> x$9.$greater(x$10), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$11, x$12) -> x$11.gt(x$12));
        this.testSame("< and lt", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$13, x$14) -> x$13.$less(x$14), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$15, x$16) -> x$15.lt(x$16));
        this.testSame(">= and geq", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$17, x$18) -> x$17.$greater$eq(x$18), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$19, x$20) -> x$19.geq(x$20));
        this.testSame("<= and leq", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$21, x$22) -> x$21.$less$eq(x$22), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$23, x$24) -> x$23.leq(x$24));
        this.testSame("<=> and eqNullSafe", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$25, x$26) -> x$25.$less$eq$greater(x$26), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$27, x$28) -> x$27.eqNullSafe(x$28));
        this.testSame("|| and or", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$29, x$30) -> x$29.$bar$bar(x$30), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$31, x$32) -> x$31.or(x$32));
        this.testSame("&& and and", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$33, x$34) -> x$33.$amp$amp(x$34), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$35, x$36) -> x$35.and(x$36));
        this.testSame("+ and plus", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$37, x$38) -> x$37.$plus(x$38), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$39, x$40) -> x$39.plus(x$40));
        this.testSame("- and minus", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$41, x$42) -> x$41.$minus(x$42), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$43, x$44) -> x$43.minus(x$44));
        this.testSame("* and multiply", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$45, x$46) -> x$45.$times(x$46), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$47, x$48) -> x$47.multiply(x$48));
        this.testSame("/ and divide", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$49, x$50) -> x$49.$div(x$50), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$51, x$52) -> x$51.divide(x$52));
        this.testSame("% and mod", (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$53, x$54) -> x$53.$percent(x$54), (Function2<Column, Column, Column>)(Function2 & Serializable & scala.Serializable)(x$55, x$56) -> x$55.mod(x$56));
        this.test("isIn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6}));
            Column $org_scalatest_assert_macro_left = a.isin(values);
            Column $org_scalatest_assert_macro_right = a.isInCollection((Iterable)values);
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            Column $org_scalatest_assert_macro_left2 = a.isin(values);
            Column $org_scalatest_assert_macro_right2 = a.isInCollection((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(values).asJava());
            Column column3 = $org_scalatest_assert_macro_left2;
            Column column4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(column3 != null ? !column3.equals(column4) : column4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("getItem/apply/getField are the same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.apply((Object)"x");
            Column $org_scalatest_assert_macro_right = a.getItem((Object)"x");
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Column $org_scalatest_assert_macro_left2 = a.apply((Object)"x");
            Column $org_scalatest_assert_macro_right2 = a.getField("x");
            Column column3 = $org_scalatest_assert_macro_left2;
            Column column4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(column3 != null ? !column3.equals(column4) : column4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("substr variations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.substr(2, 10);
            Column $org_scalatest_assert_macro_right = a.substr(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)));
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("startsWith variations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.endsWith("p_");
            Column $org_scalatest_assert_macro_right = a.endsWith(functions$.MODULE$.lit((Object)"p_"));
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("endsWith variations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.endsWith("world");
            Column $org_scalatest_assert_macro_right = a.endsWith(functions$.MODULE$.lit((Object)"world"));
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("alias/as/name are the same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.as("x");
            Column $org_scalatest_assert_macro_right = a.alias("x");
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Column $org_scalatest_assert_macro_left2 = a.as("x");
            Column $org_scalatest_assert_macro_right2 = a.name("x");
            Column column3 = $org_scalatest_assert_macro_left2;
            Column column4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(column3 != null ? !column3.equals(column4) : column4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("multi-alias variations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            String string = "x";
            String string2 = "y";
            Column $org_scalatest_assert_macro_left = a.as((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string));
            Column $org_scalatest_assert_macro_right = a.as((String[])((Object[])new String[]{"x", "y"}));
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("cast variations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.cast("string");
            Column $org_scalatest_assert_macro_right = a.cast((DataType)StringType$.MODULE$);
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("desc and desc_nulls_last are the same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.desc();
            Column $org_scalatest_assert_macro_right = a.desc_nulls_last();
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("asc and asc_nulls_first are the same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            Column $org_scalatest_assert_macro_left = a.asc();
            Column $org_scalatest_assert_macro_right = a.asc_nulls_first();
            Column column = $org_scalatest_assert_macro_left;
            Column column2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(column != null ? !column.equals(column2) : column2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Column x = functions$.MODULE$.col("a").$plus((Object)functions$.MODULE$.col("b"));
            String explain1 = this.captureStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> x.explain(false));
            String explain2 = this.captureStdOut((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> x.explain(true));
            String $org_scalatest_assert_macro_left = explain1;
            String $org_scalatest_assert_macro_right = explain2;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Seq expectedFragments = (Seq)new .colon.colon((Object)"unresolved_function", (List)new .colon.colon((Object)"function_name: \"+\"", (List)new .colon.colon((Object)"arguments", (List)Nil$.MODULE$)));
            expectedFragments.foreach((Function1 & Serializable & scala.Serializable)fragment -> {
                String $org_scalatest_assert_macro_left = explain1;
                String $org_scalatest_assert_macro_right = fragment;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            });
        }, new Position("ColumnTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.testColName((DataType)BooleanType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$59 -> x$59.boolean());
        this.testColName((DataType)ByteType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$60 -> x$60.byte());
        this.testColName((DataType)ShortType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$61 -> x$61.short());
        this.testColName((DataType)IntegerType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$62 -> x$62.int());
        this.testColName((DataType)LongType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$63 -> x$63.long());
        this.testColName((DataType)FloatType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$64 -> x$64.float());
        this.testColName((DataType)DoubleType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$65 -> x$65.double());
        this.testColName((DataType)DecimalType$.MODULE$.USER_DEFAULT(), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$66 -> x$66.decimal());
        this.testColName((DataType)new DecimalType(20, 10), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$67 -> x$67.decimal(20, 10));
        this.testColName((DataType)DateType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$68 -> x$68.date());
        this.testColName((DataType)TimestampType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$69 -> x$69.timestamp());
        this.testColName((DataType)StringType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$70 -> x$70.string());
        this.testColName((DataType)BinaryType$.MODULE$, (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$71 -> x$71.binary());
        this.testColName((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$72 -> x$72.array((DataType)IntegerType$.MODULE$));
        this.mapType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
        this.testColName((DataType)this.mapType(), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$73 -> x$73.map(this.mapType()));
        this.testColName((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$74 -> x$74.map((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$));
        this.structType1 = new StructType().add("a", "int").add("b", "string");
        this.structType2 = this.structType1().add("c", "binary");
        this.testColName((DataType)this.structType1(), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$75 -> x$75.struct(this.structType1()));
        this.testColName((DataType)this.structType2(), (Function1<ColumnName, StructField>)(Function1 & Serializable & scala.Serializable)x$76 -> x$76.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.structType2().fields())));
    }
}

