/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.StatusRuntimeException;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.netty.NettyServerBuilder;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$TestPackURI$;
import org.apache.spark.sql.connect.client.util.ConnectFunSuite;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u00181\u0001uBQ\u0001\u0015\u0001\u0005\u0002EC\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0002+\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0006\"\u00032\u0001\u0001\u0004\u0005\t\u0015)\u0003V\u0011%\u0019\u0007\u00011AA\u0002\u0013%A\rC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\"I1\u000e\u0001a\u0001\u0002\u0003\u0006K!\u001a\u0005\nY\u0002\u0001\r\u00111A\u0005\n5D\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\t\u0013e\u0004\u0001\u0019!A!B\u0013q\u0007\"\u0002>\u0001\t\u0013Y\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u000f\u0001A\u0011IA\u0003\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017A\u0011\"!\b\u0001#\u0003%I!a\b\u0007\r\u0005U\u0002\u0001RA\u001c\u0011)\tY\u0005\u0005BK\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003K\u0002\"\u0011#Q\u0001\n\u0005=\u0003BCA4!\tU\r\u0011\"\u0001\u0002j!Q\u0011\u0011\u000f\t\u0003\u0012\u0003\u0006I!a\u001b\t\u0015\u0005M\u0004C!f\u0001\n\u0003\t)\b\u0003\u0006\u0002zA\u0011\t\u0012)A\u0005\u0003oBa\u0001\u0015\t\u0005\u0002\u0005m\u0004\"CAD!\u0005\u0005I\u0011AAE\u0011%\t\t\nEI\u0001\n\u0003\t\u0019\nC\u0005\u0002\u0018B\t\n\u0011\"\u0001\u0002\u001a\"I\u0011Q\u0014\t\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003G\u0003\u0012\u0011!C!\u0003KC\u0011\"!.\u0011\u0003\u0003%\t!a.\t\u0013\u0005e\u0006#!A\u0005\u0002\u0005m\u0006\"CAc!\u0005\u0005I\u0011IAd\u0011%\t)\u000eEA\u0001\n\u0003\t9\u000eC\u0005\u0002\\B\t\t\u0011\"\u0011\u0002^\"I\u0011q\u001c\t\u0002\u0002\u0013\u0005\u0013\u0011\u001d\u0005\n\u0003G\u0004\u0012\u0011!C!\u0003K<\u0011\"!;\u0001\u0003\u0003EI!a;\u0007\u0013\u0005U\u0002!!A\t\n\u00055\bB\u0002)&\t\u0003\tY\u0010C\u0005\u0002`\u0016\n\t\u0011\"\u0012\u0002b\"I\u0011Q`\u0013\u0002\u0002\u0013\u0005\u0015q \u0005\n\u0005\u000f)\u0013\u0013!C\u0001\u0003?C\u0011B!\u0003&\u0003\u0003%\tIa\u0003\t\u0013\tuQ%%A\u0005\u0002\u0005}\u0005\"\u0003B\u0010\u0001\t\u0007I\u0011\u0002B\u0011\u0011!\u0011I\u0003\u0001Q\u0001\n\t\r\u0002b\u0002B\u0016\u0001\u0011%!Q\u0006\u0002\u0018'B\f'o[\"p]:,7\r^\"mS\u0016tGoU;ji\u0016T!!\r\u001a\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019D'A\u0004d_:tWm\u0019;\u000b\u0005U2\u0014aA:rY*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qd\t\u0014\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0001BZ;ogVLG/\u001a\u0006\u0003\u0007j\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0015\u0003%aC!os\u001a+hnU;ji\u0016\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003\u0017\"\u0013qbQ8o]\u0016\u001cGOR;o'VLG/\u001a\t\u0003\u001b:k\u0011AQ\u0005\u0003\u001f\n\u0013!CQ3g_J,\u0017I\u001c3BMR,'/R1dQ\u00061A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011\u0001M\u000b\u0002+B\u00111KV\u0005\u0003/B\u0012!c\u00159be.\u001cuN\u001c8fGR\u001cE.[3oi\u0006Q1\r\\5f]R|F%Z9\u0015\u0005i\u0003\u0007CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&\u0001B+oSRDq!Y\u0002\u0002\u0002\u0003\u0007Q+A\u0002yIE\nqa\u00197jK:$\b%A\u0004tKJ4\u0018nY3\u0016\u0003\u0015\u0004\"a\u00154\n\u0005\u001d\u0004$\u0001\u0007#v[6L8\u000b]1sW\u000e{gN\\3diN+'O^5dK\u0006Y1/\u001a:wS\u000e,w\fJ3r)\tQ&\u000eC\u0004b\r\u0005\u0005\t\u0019A3\u0002\u0011M,'O^5dK\u0002\naa]3sm\u0016\u0014X#\u00018\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018\u0001B4sa\u000eT\u0011a]\u0001\u0003S>L!!\u001e9\u0003\rM+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u00035bDq!Y\u0005\u0002\u0002\u0003\u0007a.A\u0004tKJ4XM\u001d\u0011\u0002!M$\u0018M\u001d;Ek6l\u0017pU3sm\u0016\u0014HC\u0001.}\u0011\u0015i8\u00021\u0001\u007f\u0003\u0011\u0001xN\u001d;\u0011\u0005m{\u0018bAA\u00019\n\u0019\u0011J\u001c;\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001[\u0003%\tg\r^3s\u000b\u0006\u001c\u0007.\u0001\u000buKN$8\t\\5f]R\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u0003\u001b\tI\u0002F\u0002[\u0003\u001fAq!!\u0005\u000f\u0001\u0004\t\u0019\"A\u0007dY&,g\u000e\u001e\"vS2$WM\u001d\t\u00067\u0006Ua0V\u0005\u0004\u0003/a&!\u0003$v]\u000e$\u0018n\u001c82\u0011!\tYB\u0004I\u0001\u0002\u0004q\u0018AC:feZ,'\u000fU8si\u0006qB/Z:u\u00072LWM\u001c;D_:tWm\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0003CQ3A`A\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00189\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,'a\u0003+fgR\u0004\u0016mY6V%&\u001br\u0001EA\u001d\u0003\u007f\t)\u0005E\u0002\\\u0003wI1!!\u0010]\u0005\u0019\te.\u001f*fMB\u00191,!\u0011\n\u0007\u0005\rCLA\u0004Qe>$Wo\u0019;\u0011\u0007m\u000b9%C\u0002\u0002Jq\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\u0016\u0005\u0005=\u0003\u0003BA)\u0003?rA!a\u0015\u0002\\A\u0019\u0011Q\u000b/\u000e\u0005\u0005]#bAA-y\u00051AH]8pizJ1!!\u0018]\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\f/\u0002#\r|gN\\3di&|gn\u0015;sS:<\u0007%A\u0005jg\u000e{'O]3diV\u0011\u00111\u000e\t\u00047\u00065\u0014bAA89\n9!i\\8mK\u0006t\u0017AC5t\u0007>\u0014(/Z2uA\u0005YQ\r\u001f;sC\u000eCWmY6t+\t\t9\bE\u0003\\\u0003+)&,\u0001\u0007fqR\u0014\u0018m\u00115fG.\u001c\b\u0005\u0006\u0005\u0002~\u0005\u0005\u00151QAC!\r\ty\bE\u0007\u0002\u0001!9\u00111J\fA\u0002\u0005=\u0003bBA4/\u0001\u0007\u00111\u000e\u0005\n\u0003g:\u0002\u0013!a\u0001\u0003o\nAaY8qsRA\u0011QPAF\u0003\u001b\u000by\tC\u0005\u0002La\u0001\n\u00111\u0001\u0002P!I\u0011q\r\r\u0011\u0002\u0003\u0007\u00111\u000e\u0005\n\u0003gB\u0002\u0013!a\u0001\u0003o\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0016*\"\u0011qJA\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a'+\t\u0005-\u00141E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tK\u000b\u0003\u0002x\u0005\r\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016\u0001\u00027b]\u001eT!!!-\u0002\t)\fg/Y\u0005\u0005\u0003C\nY+\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001\u007f\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!0\u0002DB\u00191,a0\n\u0007\u0005\u0005GLA\u0002B]fDq!\u0019\u0010\u0002\u0002\u0003\u0007a0A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\r\u0005\u0004\u0002L\u0006E\u0017QX\u0007\u0003\u0003\u001bT1!a4]\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\fiM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA6\u00033D\u0001\"\u0019\u0011\u0002\u0002\u0003\u0007\u0011QX\u0001\tQ\u0006\u001c\bnQ8eKR\ta0\u0001\u0005u_N#(/\u001b8h)\t\t9+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\n9\u000f\u0003\u0005bG\u0005\u0005\t\u0019AA_\u0003-!Vm\u001d;QC\u000e\\WKU%\u0011\u0007\u0005}TeE\u0003&\u0003_\f)\u0005\u0005\u0007\u0002r\u0006]\u0018qJA6\u0003o\ni(\u0004\u0002\u0002t*\u0019\u0011Q\u001f/\u0002\u000fI,h\u000e^5nK&!\u0011\u0011`Az\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003W\fQ!\u00199qYf$\u0002\"! \u0003\u0002\t\r!Q\u0001\u0005\b\u0003\u0017B\u0003\u0019AA(\u0011\u001d\t9\u0007\u000ba\u0001\u0003WB\u0011\"a\u001d)!\u0003\u0005\r!a\u001e\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u000e\te\u0001#B.\u0003\u0010\tM\u0011b\u0001B\t9\n1q\n\u001d;j_:\u0004\u0012b\u0017B\u000b\u0003\u001f\nY'a\u001e\n\u0007\t]AL\u0001\u0004UkBdWm\r\u0005\n\u00057Q\u0013\u0011!a\u0001\u0003{\n1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005!QKU%t+\t\u0011\u0019\u0003\u0005\u0004\u0002L\n\u0015\u0012QP\u0005\u0005\u0005O\tiMA\u0002TKF\fQ!\u0016*Jg\u0002\nQb\u00195fG.$Vm\u001d;QC\u000e\\Gc\u0001.\u00030!9!\u0011\u0007\u0018A\u0002\u0005u\u0014\u0001\u0003;fgR\u0004\u0016mY6")
public class SparkConnectClientSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private volatile SparkConnectClientSuite$TestPackURI$ TestPackURI$module;
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private final Seq<TestPackURI> URIs;
    private final Path baseResourcePath;
    private final Path commonResourcePath;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    private SparkConnectClientSuite$TestPackURI$ TestPackURI() {
        if (this.TestPackURI$module == null) {
            this.TestPackURI$lzycompute$1();
        }
        return this.TestPackURI$module;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$client$util$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private void startDummyServer(int port) {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.client_$eq(null);
        this.server_$eq(null);
        this.service_$eq(null);
    }

    public void afterEach() {
        BoxedUnit boxedUnit;
        if (this.server() != null) {
            this.server().shutdownNow();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "SparkConnectClientSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.client() != null) {
            this.client().shutdown();
            return;
        }
    }

    private void testClientConnection(int serverPort, Function1<Object, SparkConnectClient> clientBuilder) {
        this.startDummyServer(serverPort);
        this.client_$eq((SparkConnectClient)clientBuilder.apply((Object)BoxesRunTime.boxToInteger((int)this.server().getPort())));
        AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
        AnalyzePlanResponse response = this.client().analyze(request);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(response.getSessionId());
        String $org_scalatest_assert_macro_right = "abc123";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
    }

    private int testClientConnection$default$1() {
        return 0;
    }

    private Seq<TestPackURI> URIs() {
        return this.URIs;
    }

    private void checkTestPack(TestPackURI testPack) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().connectionString(testPack.connectionString()).build();
        testPack.extraChecks().apply((Object)client);
    }

    private final void TestPackURI$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.TestPackURI$module == null) {
                this.TestPackURI$module = new SparkConnectClientSuite$TestPackURI$(this);
            }
        }
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$3(int testPort) {
        return SparkConnectClient$.MODULE$.builder().port(testPort).build();
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$5(int testPort) {
        return SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(15).append("sc://localhost:").append(testPort).toString()).build();
    }

    public static final /* synthetic */ void $anonfun$URIs$7(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userId();
        String $org_scalatest_assert_macro_right = "a94";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }

    public static final /* synthetic */ void $anonfun$URIs$8(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "a945";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }

    public SparkConnectClientSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("Placeholder test: Create SparkConnectClient", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().userId("abc123").build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = "abc123";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("Test connection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable & scala.Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("Test connection string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable & scala.Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Test encryption", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(29).append("sc://localhost:").append(this.server().getPort()).append("/;use_ssl=true").toString()).build());
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.client().analyze(request), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("SparkSession initialisation with connection string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int testPort = 16002;
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(15).append("sc://localhost:").append(testPort).toString()).build());
            this.startDummyServer(testPort);
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).build();
            Dataset df = session.range(10L);
            df.analyze();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
            Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.URIs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestPackURI[]{new TestPackURI(this, "sc://host", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://localhost/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            this.testClientConnection(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable & scala.Serializable)x$2 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost:1234/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            this.testClientConnection(1234, (Function1<Object, SparkConnectClient>)(Function1 & Serializable & scala.Serializable)x$3 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost/;", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            this.testClientConnection(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable & scala.Serializable)x$4 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;user_id=a94", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$7(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123/;user_agent=a945", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$8(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "scc://host:12", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "http://host", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:/host:1234/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/;parm1;param2", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123;user_id=a94", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:///user_id=123", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:-4", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://:123/", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=false;token=mySecretToken", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=false", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;param1=value1;param2=value2", true, this.TestPackURI().apply$default$3())}));
        this.URIs().foreach((Function1 & Serializable & scala.Serializable)testPack -> {
            this.test(new StringBuilder(24).append("Check URI: ").append(testPack.connectionString()).append(", isCorrect: ").append(testPack.isCorrect()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                if (!testPack.isCorrect()) {
                    return $this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkTestPack(testPack), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                }
                $this.checkTestPack(testPack);
                return BoxedUnit.UNIT;
            }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            return BoxedUnit.UNIT;
        });
    }

    private class TestPackURI
    implements Product,
    scala.Serializable {
        private final String connectionString;
        private final boolean isCorrect;
        private final Function1<SparkConnectClient, BoxedUnit> extraChecks;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public String connectionString() {
            return this.connectionString;
        }

        public boolean isCorrect() {
            return this.isCorrect;
        }

        public Function1<SparkConnectClient, BoxedUnit> extraChecks() {
            return this.extraChecks;
        }

        public TestPackURI copy(String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            return new TestPackURI(this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer(), connectionString, isCorrect, extraChecks);
        }

        public String copy$default$1() {
            return this.connectionString();
        }

        public boolean copy$default$2() {
            return this.isCorrect();
        }

        public Function1<SparkConnectClient, BoxedUnit> copy$default$3() {
            return this.extraChecks();
        }

        public String productPrefix() {
            return "TestPackURI";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.connectionString();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isCorrect());
                }
                case 2: {
                    return this.extraChecks();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestPackURI;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connectionString()));
            n = Statics.mix((int)n, (int)(this.isCorrect() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.extraChecks()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestPackURI)) return false;
            if (((TestPackURI)object).org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() != this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestPackURI testPackURI = (TestPackURI)x$1;
            String string = this.connectionString();
            String string2 = testPackURI.connectionString();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.isCorrect() != testPackURI.isCorrect()) return false;
            Function1<SparkConnectClient, BoxedUnit> function1 = this.extraChecks();
            Function1<SparkConnectClient, BoxedUnit> function12 = testPackURI.extraChecks();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!testPackURI.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() {
            return this.$outer;
        }

        public TestPackURI(SparkConnectClientSuite $outer, String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            this.connectionString = connectionString;
            this.isCorrect = isCorrect;
            this.extraChecks = extraChecks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

