/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.StorageLevelProtoConverter$;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)3Q!\u0002\u0004\u0001\u0011IA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006\u0003\u0002!\tA\u0011\u0002\u001b'B\f'o[\"p]:,7\r^!oC2L(0\u001a%b]\u0012dWM\u001d\u0006\u0003\u000f!\tqa]3sm&\u001cWM\u0003\u0002\n\u0015\u000591m\u001c8oK\u000e$(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sON\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQR$D\u0001\u001c\u0015\taB\"\u0001\u0005j]R,'O\\1m\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\u0002!I,7\u000f]8og\u0016|%m]3sm\u0016\u00148\u0001\u0001\t\u0004E%ZS\"A\u0012\u000b\u0005\u0011*\u0013\u0001B:uk\nT!AJ\u0014\u0002\t\u001d\u0014\bo\u0019\u0006\u0002Q\u0005\u0011\u0011n\\\u0005\u0003U\r\u0012ab\u0015;sK\u0006lwJY:feZ,'\u000f\u0005\u0002-a5\tQF\u0003\u0002/_\u0005)\u0001O]8u_*\u0011\u0011\u0002D\u0005\u0003c5\u00121#\u00118bYfTX\r\u00157b]J+7\u000f]8og\u0016\fa\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u0007\u0011\u0015y\"\u00011\u0001\"\u0003\u0019A\u0017M\u001c3mKR\u0011\u0011\b\u0010\t\u0003)iJ!aO\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006{\r\u0001\rAP\u0001\be\u0016\fX/Z:u!\tas(\u0003\u0002A[\t\u0011\u0012I\\1msj,\u0007\u000b\\1o%\u0016\fX/Z:u\u0003\u001d\u0001(o\\2fgN$2aK\"E\u0011\u0015iD\u00011\u0001?\u0011\u0015)E\u00011\u0001G\u0003\u001d\u0019Xm]:j_:\u0004\"a\u0012%\u000e\u0003)I!!\u0013\u0006\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8")
public class SparkConnectAnalyzeHandler
implements Logging {
    private final StreamObserver<AnalyzePlanResponse> responseObserver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void handle(AnalyzePlanRequest request) {
        SparkSession session = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId()).session();
        session.withActive((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalyzePlanResponse response = this.process(request, session);
            $this.responseObserver.onNext(response);
            $this.responseObserver.onCompleted();
        });
    }

    public AnalyzePlanResponse process(AnalyzePlanRequest request, SparkSession session) {
        LazyRef planner$lzy = new LazyRef();
        AnalyzePlanResponse.Builder builder = AnalyzePlanResponse.newBuilder();
        AnalyzePlanRequest.AnalyzeCase analyzeCase = request.getAnalyzeCase();
        if (AnalyzePlanRequest.AnalyzeCase.SCHEMA.equals(analyzeCase)) {
            StructType schema = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getSchema().getPlan().getRoot())).schema();
            builder.setSchema(AnalyzePlanResponse.Schema.newBuilder().setSchema(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)schema)).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.EXPLAIN.equals(analyzeCase)) {
            String string;
            QueryExecution queryExecution = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getExplain().getPlan().getRoot())).queryExecution();
            AnalyzePlanRequest.Explain.ExplainMode explainMode = request.getExplain().getExplainMode();
            if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_SIMPLE.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)SimpleMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_EXTENDED.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)ExtendedMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_CODEGEN.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)CodegenMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_COST.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)CostMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_FORMATTED.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)FormattedMode$.MODULE$);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(22).append("Unknown Explain Mode ").append(explainMode).append("!").toString());
            }
            String explainString = string;
            builder.setExplain(AnalyzePlanResponse.Explain.newBuilder().setExplainString(explainString).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.TREE_STRING.equals(analyzeCase)) {
            String treeString = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getTreeString().getPlan().getRoot())).schema().treeString();
            builder.setTreeString(AnalyzePlanResponse.TreeString.newBuilder().setTreeString(treeString).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.IS_LOCAL.equals(analyzeCase)) {
            boolean isLocal = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getIsLocal().getPlan().getRoot())).isLocal();
            builder.setIsLocal(AnalyzePlanResponse.IsLocal.newBuilder().setIsLocal(isLocal).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.IS_STREAMING.equals(analyzeCase)) {
            boolean isStreaming = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getIsStreaming().getPlan().getRoot())).isStreaming();
            builder.setIsStreaming(AnalyzePlanResponse.IsStreaming.newBuilder().setIsStreaming(isStreaming).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.INPUT_FILES.equals(analyzeCase)) {
            String[] inputFiles = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getInputFiles().getPlan().getRoot())).inputFiles();
            builder.setInputFiles(AnalyzePlanResponse.InputFiles.newBuilder().addAllFiles((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputFiles)).toSeq()).asJava()).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.SPARK_VERSION.equals(analyzeCase)) {
            builder.setSparkVersion(AnalyzePlanResponse.SparkVersion.newBuilder().setVersion(session.version()).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.DDL_PARSE.equals(analyzeCase)) {
            DataType schema = SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).parseDatatypeString(request.getDdlParse().getDdlString());
            builder.setDdlParse(AnalyzePlanResponse.DDLParse.newBuilder().setParsed(DataTypeProtoConverter$.MODULE$.toConnectProtoType(schema)).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.SAME_SEMANTICS.equals(analyzeCase)) {
            Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getSameSemantics().getTargetPlan().getRoot()));
            Dataset other = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getSameSemantics().getOtherPlan().getRoot()));
            builder.setSameSemantics(AnalyzePlanResponse.SameSemantics.newBuilder().setResult(target.sameSemantics(other)));
        } else if (AnalyzePlanRequest.AnalyzeCase.SEMANTIC_HASH.equals(analyzeCase)) {
            int semanticHash = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getSemanticHash().getPlan().getRoot())).semanticHash();
            builder.setSemanticHash(AnalyzePlanResponse.SemanticHash.newBuilder().setResult(semanticHash));
        } else if (AnalyzePlanRequest.AnalyzeCase.PERSIST.equals(analyzeCase)) {
            Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getPersist().getRelation()));
            Dataset dataset = request.getPersist().hasStorageLevel() ? target.persist(StorageLevelProtoConverter$.MODULE$.toStorageLevel(request.getPersist().getStorageLevel())) : target.persist();
            builder.setPersist(AnalyzePlanResponse.Persist.newBuilder().build());
        } else if (AnalyzePlanRequest.AnalyzeCase.UNPERSIST.equals(analyzeCase)) {
            Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getUnpersist().getRelation()));
            Dataset dataset = request.getUnpersist().hasBlocking() ? target.unpersist(request.getUnpersist().getBlocking()) : target.unpersist();
            builder.setUnpersist(AnalyzePlanResponse.Unpersist.newBuilder().build());
        } else if (AnalyzePlanRequest.AnalyzeCase.GET_STORAGE_LEVEL.equals(analyzeCase)) {
            Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.planner$1(planner$lzy, session).transformRelation(request.getGetStorageLevel().getRelation()));
            StorageLevel storageLevel = target.storageLevel();
            builder.setGetStorageLevel(AnalyzePlanResponse.GetStorageLevel.newBuilder().setStorageLevel(StorageLevelProtoConverter$.MODULE$.toConnectProtoType(storageLevel)).build());
        } else {
            throw new InvalidPlanInput(new StringBuilder(24).append("Unknown Analyze Method ").append(analyzeCase).append("!").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        builder.setSessionId(request.getSessionId());
        return builder.build();
    }

    private static final /* synthetic */ SparkConnectPlanner planner$lzycompute$1(LazyRef planner$lzy$1, SparkSession session$2) {
        SparkConnectPlanner sparkConnectPlanner;
        LazyRef lazyRef = planner$lzy$1;
        synchronized (lazyRef) {
            sparkConnectPlanner = planner$lzy$1.initialized() ? (SparkConnectPlanner)planner$lzy$1.value() : (SparkConnectPlanner)planner$lzy$1.initialize((Object)new SparkConnectPlanner(session$2));
        }
        return sparkConnectPlanner;
    }

    private static final SparkConnectPlanner planner$1(LazyRef planner$lzy$1, SparkSession session$2) {
        if (planner$lzy$1.initialized()) {
            return (SparkConnectPlanner)planner$lzy$1.value();
        }
        return SparkConnectAnalyzeHandler.planner$lzycompute$1(planner$lzy$1, session$2);
    }

    public SparkConnectAnalyzeHandler(StreamObserver<AnalyzePlanResponse> responseObserver) {
        this.responseObserver = responseObserver;
        Logging.$init$((Logging)this);
    }
}

