/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.publicsuffix;

import org.sparkproject.connect.guava.annotations.Beta;
import org.sparkproject.connect.guava.annotations.GwtCompatible;

@Beta
@GwtCompatible
public enum PublicSuffixType {
    PRIVATE(':', ','),
    REGISTRY('!', '?');

    private final char innerNodeCode;
    private final char leafNodeCode;

    private PublicSuffixType(char innerNodeCode, char leafNodeCode) {
        this.innerNodeCode = innerNodeCode;
        this.leafNodeCode = leafNodeCode;
    }

    char getLeafNodeCode() {
        return this.leafNodeCode;
    }

    char getInnerNodeCode() {
        return this.innerNodeCode;
    }

    static PublicSuffixType fromCode(char code) {
        for (PublicSuffixType value : PublicSuffixType.values()) {
            if (value.getInnerNodeCode() != code && value.getLeafNodeCode() != code) continue;
            return value;
        }
        throw new IllegalArgumentException(new StringBuilder(38).append("No enum corresponding to given code: ").append(code).toString());
    }
}

